/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.IDeclaredExceptionTable;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;

final class DeclaredExceptionTable
implements IDeclaredExceptionTable {
    private IntVector m_exceptions;

    public int get(int n) {
        return this.m_exceptions.get(n);
    }

    public int size() {
        return this.m_exceptions.size();
    }

    public long length() {
        return 1 + this.m_exceptions.size() << 1;
    }

    public Object clone() {
        try {
            DeclaredExceptionTable declaredExceptionTable = (DeclaredExceptionTable)super.clone();
            declaredExceptionTable.m_exceptions = (IntVector)this.m_exceptions.clone();
            return declaredExceptionTable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        int n = this.m_exceptions.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            uDataOutputStream.writeU2(this.get(i));
        }
    }

    public int add(int n) {
        int n2 = this.m_exceptions.size();
        this.m_exceptions.add(n);
        return n2;
    }

    public int set(int n, int n2) {
        return this.m_exceptions.set(n, n2);
    }

    DeclaredExceptionTable(int n) {
        this.m_exceptions = n < 0 ? new IntVector() : new IntVector(n);
    }
}

