/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;

public class HardcodedValuesDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("HardcodedText", "Hardcoded text", "Looks for hardcoded text attributes which should be converted to resource lookup", "Hardcoding text attributes directly in layout files is bad for several reasons:\n\n* When creating configuration variations (for example for landscape or portrait)you have to repeat the actual text (and keep it up to date when making changes)\n\n* The application cannot be translated to other languages by just adding new translations for existing string resources.\n\nIn Eclipse there is a quickfix to automatically extract this hardcoded string into a resource lookup.", Category.I18N, 5, Severity.WARNING, new Implementation(HardcodedValuesDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("text", "contentDescription", "hint", "label", "prompt", "title");
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU;
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String value = attribute.getValue();
        if (!value.isEmpty() && value.charAt(0) != '@' && value.charAt(0) != '?') {
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
                return;
            }
            context.report(ISSUE, attribute, context.getLocation(attribute), String.format("[I18N] Hardcoded string \"%1$s\", should use @string resource", value), null);
        }
    }
}

