/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.trees;

import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.trees.MutableBinaryTreeNode;
import lombok.ast.libs.org.parboiled.trees.MutableTreeNode;
import lombok.ast.libs.org.parboiled.trees.TreeNode;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends TreeNode<T>> T getRoot(T node) {
        if (node == null) {
            return null;
        }
        if (node.getParent() != null) {
            return TreeUtils.getRoot(node.getParent());
        }
        return node;
    }

    public static <T extends MutableTreeNode<T>> void addChild(@NotNull T parent, T child) {
        if (parent == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.trees.TreeUtils.addChild(...) corresponds to @NotNull parameter and must not be null");
        }
        parent.addChild(parent.getChildren().size(), child);
    }

    public static <T extends MutableTreeNode<T>> void removeChild(@NotNull T parent, T child) {
        if (parent == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.trees.TreeUtils.removeChild(...) corresponds to @NotNull parameter and must not be null");
        }
        int index = parent.getChildren().indexOf(child);
        Preconditions.checkElementIndex(index, parent.getChildren().size());
        parent.removeChild(index);
    }

    public static <N extends MutableBinaryTreeNode<N>> N toLeftAssociativity(@NotNull N node) {
        if (node == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.trees.TreeUtils.toLeftAssociativity(...) corresponds to @NotNull parameter and must not be null");
        }
        MutableBinaryTreeNode right = (MutableBinaryTreeNode)node.right();
        if (right == null) {
            return node;
        }
        node.setRight((MutableBinaryTreeNode)((MutableBinaryTreeNode)right.left()));
        right.setLeft(node);
        return (N)right;
    }
}

