/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.FieldInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.FieldNode;
import lombok.ast.libs.org.parboiled.asm.tree.InsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.LdcInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.TypeInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.VarInsnNode;
import lombok.ast.libs.org.parboiled.support.Checks;
import lombok.ast.libs.org.parboiled.transform.AsmUtils;
import lombok.ast.libs.org.parboiled.transform.InstructionGraphNode;
import lombok.ast.libs.org.parboiled.transform.InstructionGroup;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleMethodRewriter
implements Opcodes,
RuleMethodProcessor,
Types {
    private RuleMethod method;
    private InstructionGroup group;
    private int actionNr;
    private int captureNr;
    private int varInitNr;
    private Map<InstructionGraphNode, Integer> captureVarIndices;

    RuleMethodRewriter() {
    }

    @Override
    public boolean appliesTo(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.RuleMethodRewriter.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.RuleMethodRewriter.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return method.containsExplicitActions() || method.containsCaptures() || method.containsVars();
    }

    @Override
    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) throws Exception {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.RuleMethodRewriter.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.RuleMethodRewriter.process(...) corresponds to @NotNull parameter and must not be null");
        }
        this.method = method;
        this.actionNr = 0;
        this.captureNr = 0;
        this.varInitNr = 0;
        this.captureVarIndices = null;
        Iterator<InstructionGroup> i$ = method.getGroups().iterator();
        while (i$.hasNext()) {
            InstructionGroup group;
            this.group = group = i$.next();
            this.createNewGroupClassInstance();
            this.initializeFields();
            InstructionGraphNode root = group.getRoot();
            if (root.isActionRoot()) {
                this.removeGroupRootInstruction();
                continue;
            }
            if (root.isCaptureRoot()) {
                this.insertStoreCapture();
                this.removeGroupRootInstruction();
                continue;
            }
            ((MethodInsnNode)root.getInstruction()).desc = "(Lorg/parboiled/common/Factory;)V";
        }
        if (method.containsCaptures()) {
            this.finalizeCaptureSetup();
        }
        method.setBodyRewritten();
    }

    private void createNewGroupClassInstance() {
        String internalName = this.group.getGroupClassType().getInternalName();
        InstructionGraphNode root = this.group.getRoot();
        this.insert(new TypeInsnNode(187, internalName));
        this.insert(new InsnNode(89));
        this.insert(new LdcInsnNode(this.method.name + (root.isActionRoot() ? "_Action" + ++this.actionNr : (root.isCaptureRoot() ? "_Capture" + ++this.captureNr : "_VarInit" + ++this.varInitNr))));
        this.insert(new MethodInsnNode(183, internalName, "<init>", "(Ljava/lang/String;)V"));
        if ((root.isActionRoot() || root.isCaptureRoot()) && this.method.hasSkipActionsInPredicatesAnnotation()) {
            this.insert(new InsnNode(89));
            this.insert(new MethodInsnNode(182, internalName, "setSkipInPredicates", "()V"));
        }
    }

    private void initializeFields() {
        String internalName = this.group.getGroupClassType().getInternalName();
        for (FieldNode field : this.group.getFields()) {
            this.insert(new InsnNode(89));
            this.insert(new VarInsnNode(AsmUtils.getLoadingOpcode((Type)field.value), field.access));
            this.insert(new FieldInsnNode(181, internalName, field.name, field.desc));
        }
    }

    private void insertStoreCapture() {
        if (this.captureVarIndices == null) {
            this.captureVarIndices = new HashMap<InstructionGraphNode, Integer>();
        }
        int index = this.method.maxLocals++;
        this.captureVarIndices.put(this.group.getRoot(), index);
        this.insert(new InsnNode(89));
        this.insert(new VarInsnNode(58, index));
    }

    private void insert(AbstractInsnNode insn) {
        this.method.instructions.insertBefore(this.group.getRoot().getInstruction(), insn);
    }

    private void removeGroupRootInstruction() {
        this.method.instructions.remove(this.group.getRoot().getInstruction());
    }

    private void finalizeCaptureSetup() {
        HashSet<InstructionGroup> hashSet = new HashSet<InstructionGroup>();
        for (InstructionGraphNode instructionGraphNode : this.method.getGraphNodes()) {
            if (!AsmUtils.isCallToRuleCreationMethod(instructionGraphNode.getInstruction())) continue;
            this.insertSetContextRuleOnCaptureArguments(instructionGraphNode, hashSet);
        }
        Checks.ensure(hashSet.size() == this.captureVarIndices.size(), "Method '%s' contains illegal CAPTURE(...) constructs that are not direct arguments to rule creating methods", this.method.name);
    }

    private void insertSetContextRuleOnCaptureArguments(InstructionGraphNode ruleCreationCall, Set<InstructionGroup> finalizedCaptureGroups) {
        for (InstructionGraphNode predecessor : ruleCreationCall.getPredecessors()) {
            if (!predecessor.isCaptureRoot()) continue;
            this.insertSetContextRule(ruleCreationCall, predecessor);
            finalizedCaptureGroups.add(predecessor.getGroup());
        }
    }

    private void insertSetContextRule(InstructionGraphNode instructionGraphNode, InstructionGraphNode instructionGraphNode2) {
        String string = instructionGraphNode2.getGroup().getGroupClassType().getInternalName();
        AbstractInsnNode abstractInsnNode = instructionGraphNode.getInstruction().getNext();
        this.method.instructions.insertBefore(abstractInsnNode, new InsnNode(89));
        this.method.instructions.insertBefore(abstractInsnNode, new VarInsnNode(25, this.captureVarIndices.get(instructionGraphNode2)));
        this.method.instructions.insertBefore(abstractInsnNode, new InsnNode(95));
        this.method.instructions.insertBefore(abstractInsnNode, new FieldInsnNode(181, string, "contextRule", RULE_DESC));
    }
}

