/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import lombok.ast.libs.org.parboiled.BasicParseRunner;
import lombok.ast.libs.org.parboiled.MatchHandler;
import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.Rule;

public class ProfilerParseRunner<V>
extends BasicParseRunner<V> {
    private ReportEntry<V> rootReport;

    public ProfilerParseRunner(Rule rule, String input) {
        super(rule, input);
    }

    @Override
    protected boolean runRootContext() {
        return this.runRootContext(new Handler());
    }

    @Override
    protected boolean runRootContext(MatchHandler<V> handler) {
        this.createRootContext(handler);
        return handler.matchRoot(this.rootContext);
    }

    protected void createRootContext(MatchHandler<V> matchHandler) {
        this.rootContext = new MatcherContext<V>(this.inputBuffer, this.parseErrors, matchHandler, this.rootMatcher);
    }

    public String getOverviewReport() {
        TreeSet<ReportEntry<V>> topLevelFailed = new TreeSet<ReportEntry<V>>();
        this.fillReport(topLevelFailed, this.rootReport);
        StringBuilder out = new StringBuilder();
        for (ReportEntry<V> entry : topLevelFailed) {
            if (entry.getSubSteps() < 100) break;
            out.append(ProfilerParseRunner.formatReport(entry, false));
        }
        return out.toString();
    }

    public List<String> getExtendedReport(int topEntries) {
        TreeSet<ReportEntry<V>> topLevelFailed = new TreeSet<ReportEntry<V>>();
        this.fillReport(topLevelFailed, this.rootReport);
        int count = topEntries;
        ArrayList result = Lists.newArrayList();
        StringBuilder out = new StringBuilder();
        for (ReportEntry<V> entry : topLevelFailed) {
            if (count-- == 0) {
                return result;
            }
            out.setLength(0);
            this.fillExtendedReport(out, 0, entry);
            result.add(out.toString());
        }
        return result;
    }

    private static int countInnerNodes(ReportEntry<?> entry) {
        int count = 1;
        for (ReportEntry<?> child : entry.getChildren()) {
            count += ProfilerParseRunner.countInnerNodes(child);
        }
        return count;
    }

    private void fillExtendedReport(StringBuilder out, int spaces, ReportEntry<V> report) {
        for (int i = 0; i < spaces; ++i) {
            out.append(" ");
        }
        out.append(ProfilerParseRunner.formatReport(report, true));
        for (ReportEntry<V> child : report.getChildren()) {
            this.fillExtendedReport(out, spaces + 1, child);
        }
    }

    private static String formatReport(ReportEntry<?> report, boolean withSuccess) {
        Object[] objectArray = new Object[3];
        objectArray[0] = withSuccess ? (report.isSucceeded() ? "!" : " ") : "";
        objectArray[1] = report.getSubSteps();
        objectArray[2] = report.getPath();
        return String.format("%s[%07d] %s\n", objectArray);
    }

    private void fillReport(Collection<ReportEntry<V>> failed, ReportEntry<V> report) {
        if (!report.isSucceeded()) {
            failed.add(report);
        } else {
            for (ReportEntry<V> child : report.getChildren()) {
                this.fillReport(failed, child);
            }
        }
    }

    public final class Handler
    implements MatchHandler<V> {
        private final List<ReportEntry<V>> stack = Lists.newArrayList();

        @Override
        public boolean matchRoot(MatcherContext<V> rootContext) {
            return rootContext.runMatcher();
        }

        @Override
        public boolean match(MatcherContext<V> context) {
            String path = this.stack.isEmpty() ? "" : this.stack.get(this.stack.size() - 1).getPath();
            path = path + String.format("/%s[%d]", context.getMatcher().getLabel(), context.getCurrentIndex());
            ReportEntry report = new ReportEntry(path);
            this.stack.add(report);
            boolean result = context.getMatcher().match(context);
            report.setSucceeded(result);
            this.stack.remove(this.stack.size() - 1);
            if (this.stack.isEmpty()) {
                ProfilerParseRunner.this.rootReport = report;
            } else {
                ReportEntry parent = this.stack.get(this.stack.size() - 1);
                parent.getChildren().add(report);
                parent.setSubSteps(parent.getSubSteps() + 1 + report.getSubSteps());
            }
            return result;
        }
    }

    private static class ReportEntry<V>
    implements Comparable<ReportEntry<V>> {
        private final String path;
        private boolean succeeded;
        private final List<ReportEntry<V>> children = Lists.newArrayList();
        private int subSteps = 0;

        @Override
        public int compareTo(ReportEntry<V> o) {
            if (o.getSubSteps() < this.getSubSteps()) {
                return -1;
            }
            if (o.getSubSteps() > this.getSubSteps()) {
                return 1;
            }
            if (System.identityHashCode(o) < System.identityHashCode(this)) {
                return -1;
            }
            if (System.identityHashCode(o) > System.identityHashCode(this)) {
                return 1;
            }
            return 0;
        }

        @ConstructorProperties(value={"path"})
        public ReportEntry(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isSucceeded() {
            return this.succeeded;
        }

        public List<ReportEntry<V>> getChildren() {
            return this.children;
        }

        public int getSubSteps() {
            return this.subSteps;
        }

        public void setSucceeded(boolean succeeded) {
            this.succeeded = succeeded;
        }

        public void setSubSteps(int subSteps) {
            this.subSteps = subSteps;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportEntry)) {
                return false;
            }
            ReportEntry other = (ReportEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPath() == null ? other.getPath() != null : !this.getPath().equals(other.getPath())) {
                return false;
            }
            if (this.isSucceeded() != other.isSucceeded()) {
                return false;
            }
            if (this.getChildren() == null ? other.getChildren() != null : !((Object)this.getChildren()).equals(other.getChildren())) {
                return false;
            }
            return this.getSubSteps() == other.getSubSteps();
        }

        public boolean canEqual(Object other) {
            return other instanceof ReportEntry;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = result * 31 + (this.getPath() == null ? 0 : this.getPath().hashCode());
            result = result * 31 + (this.isSucceeded() ? 1231 : 1237);
            result = result * 31 + (this.getChildren() == null ? 0 : ((Object)this.getChildren()).hashCode());
            result = result * 31 + this.getSubSteps();
            return result;
        }

        public String toString() {
            return "ProfilerParseRunner.ReportEntry(path=" + this.getPath() + ", succeeded=" + this.isSucceeded() + ", children=" + this.getChildren() + ", subSteps=" + this.getSubSteps() + ")";
        }
    }
}

