/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.SdkConstants;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdkuilib.internal.repository.AboutDialog;
import com.android.sdkuilib.internal.repository.MenuBarWrapper;
import com.android.sdkuilib.internal.repository.SettingsDialog;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.repository.ui.AvdManagerPage;
import com.android.sdkuilib.internal.repository.ui.DeviceManagerPage;
import com.android.sdkuilib.internal.repository.ui.SdkUpdaterWindowImpl2;
import com.android.sdkuilib.internal.repository.ui.ShellSizeAndPos;
import com.android.sdkuilib.repository.AvdManagerWindow;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.utils.ILogger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AvdManagerWindowImpl1 {
    private static final String APP_NAME = "Android Virtual Device Manager";
    private static final String APP_NAME_MAC_MENU = "AVD Manager";
    private static final String SIZE_POS_PREFIX = "avdman1";
    private final Shell mParentShell;
    private final AvdManagerWindow.AvdInvocationContext mContext;
    private final SwtUpdaterData mSwtUpdaterData;
    private final boolean mOwnUpdaterData;
    private final DeviceManager mDeviceManager;
    protected Shell mShell;
    private AvdManagerPage mAvdPage;
    private SettingsController mSettingsController;
    private TabFolder mTabFolder;

    public AvdManagerWindowImpl1(Shell parentShell, ILogger sdkLog, String osSdkRoot, AvdManagerWindow.AvdInvocationContext context) {
        this.mParentShell = parentShell;
        this.mContext = context;
        this.mSwtUpdaterData = new SwtUpdaterData(osSdkRoot, sdkLog);
        this.mOwnUpdaterData = true;
        this.mDeviceManager = DeviceManager.createInstance(osSdkRoot, sdkLog);
    }

    public AvdManagerWindowImpl1(Shell parentShell, SwtUpdaterData swtUpdaterData, AvdManagerWindow.AvdInvocationContext context) {
        this.mParentShell = parentShell;
        this.mContext = context;
        this.mSwtUpdaterData = swtUpdaterData;
        this.mOwnUpdaterData = false;
        this.mDeviceManager = DeviceManager.createInstance(this.mSwtUpdaterData.getOsSdkRoot(), this.mSwtUpdaterData.getSdkLog());
    }

    public void open() {
        if (this.mParentShell == null) {
            Display.setAppName((String)APP_NAME);
        }
        this.createShell();
        this.preCreateContent();
        this.createContents();
        this.createMenuBar();
        this.mShell.open();
        this.mShell.layout();
        boolean ok = this.postCreateContent();
        if (ok && this.mContext == AvdManagerWindow.AvdInvocationContext.STANDALONE) {
            Display display = Display.getDefault();
            while (!this.mShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            this.dispose();
        }
    }

    private void createShell() {
        int style = 1264;
        if (this.mContext != AvdManagerWindow.AvdInvocationContext.STANDALONE) {
            style |= 0x10000;
        }
        this.mShell = new Shell(this.mParentShell, style);
        this.mShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ShellSizeAndPos.saveSizeAndPos(AvdManagerWindowImpl1.this.mShell, AvdManagerWindowImpl1.SIZE_POS_PREFIX);
                AvdManagerWindowImpl1.this.onAndroidSdkUpdaterDispose();
                AvdManagerWindowImpl1.this.mAvdPage.dispose();
            }
        });
        GridLayout glShell = new GridLayout(2, false);
        this.mShell.setLayout((Layout)glShell);
        this.mShell.setMinimumSize(new Point(500, 300));
        this.mShell.setSize(700, 500);
        this.mShell.setText(APP_NAME);
        ShellSizeAndPos.loadSizeAndPos(this.mShell, SIZE_POS_PREFIX);
    }

    private void createContents() {
        this.mTabFolder = new TabFolder((Composite)this.mShell, 0);
        GridDataBuilder.create((Control)this.mTabFolder).fill().grab().hSpan(2);
        TabItem avdTabItem = new TabItem(this.mTabFolder, 0);
        avdTabItem.setText("Android Virtual Devices");
        this.createAvdTab(this.mTabFolder, avdTabItem);
        TabItem devTabItem = new TabItem(this.mTabFolder, 0);
        devTabItem.setText("Device Definitions");
        this.createDeviceTab(this.mTabFolder, devTabItem);
    }

    private void createAvdTab(TabFolder tabFolder, TabItem avdTabItem) {
        Composite root = new Composite((Composite)tabFolder, 0);
        avdTabItem.setControl((Control)root);
        GridLayoutBuilder.create(root).columns(1);
        this.mAvdPage = new AvdManagerPage(root, 0, this.mSwtUpdaterData, this.mDeviceManager);
        GridDataBuilder.create((Control)this.mAvdPage).fill().grab();
    }

    private void createDeviceTab(TabFolder tabFolder, TabItem devTabItem) {
        Composite root = new Composite((Composite)tabFolder, 0);
        devTabItem.setControl((Control)root);
        GridLayoutBuilder.create(root).columns(1);
        DeviceManagerPage devicePage = new DeviceManagerPage(root, 0, this.mSwtUpdaterData, this.mDeviceManager);
        GridDataBuilder.create((Control)devicePage).fill().grab();
        devicePage.setAvdCreatedListener(new DeviceManagerPage.IAvdCreatedListener(){

            @Override
            public void onAvdCreated(AvdInfo avdInfo) {
                if (avdInfo != null) {
                    AvdManagerWindowImpl1.this.mTabFolder.setSelection(0);
                    AvdManagerWindowImpl1.this.mAvdPage.selectAvd(avdInfo, true);
                }
            }
        });
    }

    private void createMenuBar() {
        Menu menuBar = new Menu((Decorations)this.mShell, 2);
        this.mShell.setMenuBar(menuBar);
        if (this.mContext == AvdManagerWindow.AvdInvocationContext.STANDALONE) {
            MenuItem menuBarTools = new MenuItem(menuBar, 64);
            menuBarTools.setText("Tools");
            Menu menuTools = new Menu(menuBarTools);
            menuBarTools.setMenu(menuTools);
            MenuItem manageSdk = new MenuItem(menuTools, 0);
            manageSdk.setText("Manage SDK...");
            manageSdk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    AvdManagerWindowImpl1.this.onSdkManager();
                }
            });
            try {
                new MenuBarWrapper(APP_NAME_MAC_MENU, menuTools){

                    @Override
                    public void onPreferencesMenuSelected() {
                        SettingsDialog sd = new SettingsDialog(AvdManagerWindowImpl1.this.mShell, AvdManagerWindowImpl1.this.mSwtUpdaterData);
                        sd.open();
                    }

                    @Override
                    public void onAboutMenuSelected() {
                        AboutDialog ad = new AboutDialog(AvdManagerWindowImpl1.this.mShell, AvdManagerWindowImpl1.this.mSwtUpdaterData);
                        ad.open();
                    }

                    @Override
                    public void printError(String format, Object ... args) {
                        if (AvdManagerWindowImpl1.this.mSwtUpdaterData != null) {
                            AvdManagerWindowImpl1.this.mSwtUpdaterData.getSdkLog().error(null, format, args);
                        }
                    }
                };
            }
            catch (Throwable e) {
                this.mSwtUpdaterData.getSdkLog().error(e, "Failed to setup menu bar", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void addListener(ISdkChangeListener listener) {
        this.mSwtUpdaterData.addListeners(listener);
    }

    public void removeListener(ISdkChangeListener listener) {
        this.mSwtUpdaterData.removeListener(listener);
    }

    private void preCreateContent() {
        this.mSwtUpdaterData.setWindowShell(this.mShell);
        this.mSwtUpdaterData.setImageFactory(new ImageFactory(this.mShell.getDisplay()));
    }

    private boolean postCreateContent() {
        this.setWindowImage(this.mShell);
        this.setupSources();
        this.initializeSettings();
        if (this.mSwtUpdaterData.checkIfInitFailed()) {
            return false;
        }
        this.mSwtUpdaterData.broadcastOnSdkLoaded();
        return true;
    }

    private void setWindowImage(Shell shell) {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mSwtUpdaterData != null && (imgFactory = this.mSwtUpdaterData.getImageFactory()) != null) {
            shell.setImage(imgFactory.getImageByName(imageName));
        }
    }

    private void dispose() {
        this.mSwtUpdaterData.getSources().saveUserAddons(this.mSwtUpdaterData.getSdkLog());
    }

    private void onAndroidSdkUpdaterDispose() {
        ImageFactory imgFactory;
        if (this.mOwnUpdaterData && this.mSwtUpdaterData != null && (imgFactory = this.mSwtUpdaterData.getImageFactory()) != null) {
            imgFactory.dispose();
        }
    }

    private void setupSources() {
        this.mSwtUpdaterData.setupDefaultSources();
    }

    private void initializeSettings() {
        this.mSettingsController = this.mSwtUpdaterData.getSettingsController();
        this.mSettingsController.loadSettings();
        this.mSettingsController.applySettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSdkManager() {
        ITaskFactory oldFactory = this.mSwtUpdaterData.getTaskFactory();
        try {
            SdkUpdaterWindowImpl2 win = new SdkUpdaterWindowImpl2(this.mShell, this.mSwtUpdaterData, SdkUpdaterWindow.SdkInvocationContext.AVD_MANAGER);
            win.open();
        }
        catch (Exception e) {
            this.mSwtUpdaterData.getSdkLog().error((Throwable)e, "SDK Manager window error", new Object[0]);
        }
        finally {
            this.mSwtUpdaterData.setTaskFactory(oldFactory);
        }
    }
}

