//
//  ShapedWindow.m
//  ShapedWindowz3
//
//  Created by John Schilling on 10/20/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "ShapedWindow.h"


@implementation ShapedWindow

//-------------------------------------------------------------
// set the transparency
//-------------------------------------------------------------
- (float)_transparency { return 0.99999; }


extern void _NSSetWindowOpacity(int windowNumber, BOOL isOpaque);


//-------------------------------------------------------------
// make the window transparent
//-------------------------------------------------------------
- initWithContentRect:(NSRect)contentRect styleMask:(unsigned int)aStyle backing:(NSBackingStoreType)bufferingType defer:(BOOL)flag
{
    if (self = [super initWithContentRect:contentRect styleMask:NSBorderlessWindowMask backing:bufferingType defer:NO])
        _NSSetWindowOpacity([self windowNumber], 0);
    [self setMovableByWindowBackground:YES];
    [self setBackgroundColor:[NSColor clearColor]];
    return self;
}


//-------------------------------------------------------------
// For displaying the tooltip
//-------------------------------------------------------------
- (BOOL)canBecomeKeyWindow
{
    return YES;
}

@end
