; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFMACRO synonyms (&REST S) `(process-synonyms (QUOTE ,S)))

(SETQ *synonyms* NIL)

(SETQ *allsynonyms* NIL)

(DEFUN process-synonyms (V1)
 (COND ((NULL V1) (compile-synonyms *synonyms*) 'synonyms)
  ((AND (CONSP V1) (CONSP (CDR V1)))
   (LET* ((V2 (CAR V1)) (V3 (CDR V1)) (V4 (CAR V3)))
    (SETQ *allsynonyms* (addnew (LIST V2 V4) *allsynonyms*))
    (SETQ *synonyms* (addnew (LIST V2 V4) *synonyms*))
    (process-synonyms (CDR V3))))
  (T (implementation_error 'process-synonyms))))

(DEFUN addnew (V9 V10)
 (COND ((NOT (wrapper (element? V9 V10))) (cons V9 V10)) (T V10)))

(DEFUN compile-synonyms (V11)
 (eval
  (CONS 'define
   (CONS 'user-synonyms
    (APPEND (mapcan 'compile-synonym V11) (LIST 'X '-> 'X))))))

(DEFUN compile-synonym (V12)
 (COND
  ((AND (CONSP V12) (CONSP (CDR V12)) (NULL (CDR (CDR V12))))
   (LIST (walk_cons_form (CAR V12)) '->
    (walk_cons_form (curry-type (CAR (CDR V12))))))
  (T (implementation_error_error 'compile-synonym))))

;(DEFUN normalise-type (V8)
 ;(COND
 ; ((CONSP V8)
   ;(LET ((Z (user-synonyms (MAPCAR 'user-synonyms V8))))
   ; (if (qi_= V8 Z) Z (normalise-type Z))))
  ;(T (LET ((Y (user-synonyms V8))) (if (qi_= V8 Y) V8 (normalise-type Y))))))

(DEFUN walk_cons_form (X)
  (IF (CONSP X) (LIST 'cons (walk_cons_form (CAR X)) (walk_cons_form (CDR X))) X))

(DEFUN normalise-type (V8) (IF (FBOUNDP 'user-synonyms)
                               (fix 'nt V8)
                               V8))

(DEFUN nt (X)
  (IF (CONSP X) (user-synonyms (MAPCAR 'nt X)) (user-synonyms X)))

(DEFUN fix (F X) (fix1 F X (apply F X)))

(DEFUN fix1 (F X Y) 
   (IF (ABSEQUAL X Y) X (fix1 F Y (apply F Y))))                 