function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (base.limit_backward > c1 || c1 > base.limit)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (0 > c1 || c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "appendix.dictionaries.html",
 "appendix.glossaries.html",
 "appendix.regexp.html",
 "appendix.shortcut.custom.html",
 "appendix.spellchecker.html",
 "chapter.installing.and.running.html",
 "howtos.html",
 "index.html",
 "menus.html",
 "panes.html",
 "project.folder.html",
 "windows.and.dialogs.html"
];
wh.search_titleList = [
 "Liite A. Sanakirjat",
 "Liite B. Sanastot",
 "Liite D. Säännölliset lausekkeet",
 "Liite E. Pikanäppäimien mukauttaminen",
 "Liite C. Kielentarkastin",
 "OmegaT:n asennus ja ajaminen",
 "Miten…",
 "OmegaT 4.2 – Käyttöopas",
 "Valikot",
 "Ruudut",
 "Projektikansio",
 "Ikkunat ja valintaikkunat"
];
wh.search_wordMap= {
"tulokset": [[8,11]],
"ksi": [11],
"jokaisen": [11,8,6],
"valmiiksi": [[6,8,11]],
"ilmestyvät": [11],
"peräkkäiset": [11],
"kieliparilla": [6],
"kirjataan": [5],
"tekstiä": [11,8,9,6,[2,4,10]],
"kopioi": [6,8,[5,11],[3,9,10]],
"säännöllisiä": [2],
"voimaan": [11],
"segmentissä": [[1,6],[8,9,11]],
"haku": [11,8,4],
"muokkaat": [5],
"tee": [11,10],
"lausekkeina": [11],
"liitetään": [11],
"koskevan": [1],
"sisällytetään": [6],
"kahteen": [2],
"etuna": [5],
"samalla": [9,8],
"kirjoituskelpoinen": [[1,3]],
"jre-ympäristön": [5],
"info.plist": [5],
"koskevat": [5,6],
"hake": [11],
"pysyttävä": [11],
"elementeistä": [11],
"täsmälleen": [11,[4,5,10]],
"content-attribuutteja": [11],
"eroavat": [[1,6,10]],
"uudempaa": [8],
"fuzzi": [10,11],
"avattuja": [9],
"o-kirjain": [6],
"neljä": [8],
"isäntänimi": [11],
"puolileveitä": [11],
"käännösyksikköjä": [[10,11]],
"aktivoi": [11,8],
"tyhjätila": [11],
"poweria": [11],
"artikkelin": [2],
"linkitetti": [10],
"ikkunoiden": [11],
"xhtml-suodattimen": [11],
"koskevien": [11],
"kun": [11,6,5,8,9,[1,10],4,[2,3]],
"yhden": [11,2,[5,8,9,10]],
"kielikoodi": [4],
"dgoogle.api.key": [5],
"edittagnextmissedmenuitem": [3],
"alhaalta": [5],
"lähdekans": [5],
"ladattu": [1],
"ykköstason": [6],
"sama": [11,8,[6,9],[2,3,4,5]],
"varma": [[10,11]],
"tavallisista": [5],
"dataa": [6],
"pystyykin": [11],
"quiet": [5],
"kohdekansioon": [11],
"luettelon": [[8,11]],
"huomioimatta": [11],
"muualla": [4],
"kääntäjiä": [6],
"välilyöntejä": [[2,11]],
"es_es.d": [4],
"ohjata": [[5,11]],
"pdf-tiedoston": [6,7],
"lähteen": [11],
"vietävien": [6],
"kirjoittamasi": [11],
"asennus": [5,7,8],
"pdf-tiedostot": [[6,11]],
"vahvistaa": [10],
"the": [5,[0,2,3]],
"segmentistä": [11,[8,10]],
"lähteet": [5],
"etäkansioiden": [[6,11]],
"pudotetaan": [9],
"sataprosenttisia": [9],
"tietueen": [11],
"projectimportmenuitem": [3],
"jokaisell": [11],
"löydetyt": [[2,11]],
"imag": [5],
"toistuvista": [11],
"oletusasetusta": [11],
"merkityn": [8],
"määrityksen": [11],
"säännöllisin": [6],
"sisältävien": [8],
"pidä": [11,10],
"välikappaleena": [6],
"käännösvaihtoehdon": [9],
"joissa": [11,[1,6],[3,8]],
"konekäännös": [7],
"kontekstista": [9,8],
"moodlephp": [5],
"currsegment.getsrctext": [11],
"sopivasti": [6],
"tekstit": [11],
"suoritat": [5],
"vaihdeta": [11],
"yksinkertaista": [11],
"tekstin": [11,8,9,6,7],
"tägejä": [11,9,[5,6]],
"termijo": [9],
"viimeinen": [[8,10]],
"transtip": [3,9],
"check": [6],
"suluissa": [11],
"xxxx9xxxx9xxxxxxxx9xxx99xxxxx9xx9xxxxxxxxxx": [5],
"sana": [11,[1,4]],
"käännösprojekteistasi": [9],
"kieltä": [5],
"tuunaamalla": [11],
"fr-fr": [4],
"yhdistämistä": [6],
"cat-työkalut": [10],
"erisnimiä": [11],
"kahdeksi": [11],
"primari": [5],
"yksi": [11,[6,8],5,[0,1,2,4,10]],
"käännettäviä": [11],
"jre-ympäristöä": [5],
"webster": [0,[7,9]],
"äskeisessä": [9],
"lausekkeita": [2,11],
"nippu": [5],
"kahden": [6],
"kohdakkain": [11],
"määrityskansioon": [3,[8,11]],
"dictionary-kansioon": [0],
"versiolla": [5],
"kohdekieleksi": [4],
"päivä": [6],
"huomioivat": [2],
"hidastua": [6],
"editori-ruudussa": [[1,11]],
"joista": [2],
"ctrl-näppäimen": [3],
"odf-tiedostoihin": [6],
"valintanappien": [11],
"kohdeasiakirjoissa": [11],
"attribuutit": [11],
"empti": [5],
"tiedosto.txt": [6],
"projektista": [[6,8],3],
"siirtää": [11],
"säännölliset": [11,2,[3,4,7]],
"kuukausi": [6],
"kaksinkertaiset": [5],
"kategoriat": [[2,7]],
"synkronoida": [5],
"viestejä": [[5,9]],
"käännöksissä": [[2,7]],
"git-asiakkaan": [5],
"tmx-tiedostoon": [10],
"huomaa": [5,6,[2,11],10,[4,9]],
"tms": [9,[10,11]],
"pysti": [[5,6,11]],
"yläosan": [[9,11]],
"tmx": [[6,11],[3,9]],
"tänä": [6],
"odt-muodossa": [6],
"tehtäväksi": [11],
"projektissa": [[6,11],1,[9,10]],
"todennäköisimmin": [6],
"antamia": [6],
"integ": [11],
"luoda": [[5,11],[1,6,8,10]],
"intel": [5,7],
"graafisen": [5],
"fr-ca": [11],
"käytetti": [[5,11],[6,9]],
"laskentatapaa": [11],
"yleensä": [9,2,[6,10,11]],
"mainmenushortcuts.properti": [3],
"rajaaminen": [[2,7]],
"julkaistua": [6],
"tiedostomuodosta": [11],
"osittain": [9],
"käännösprojekteja": [[6,11]],
"käännöksistä": [11],
"tekstitiedostoon": [8],
"muotoja": [11],
"cmd": [3,[6,11]],
"coach": [2],
"omegat-käännösprojekti": [1],
"tämä": [11,5,8,6,10,2,[7,9]],
"vastaavuusprosentit": [9],
"tekstinosia": [11],
"subtitl": [5],
"gotohistorybackmenuitem": [3],
"rakennetason": [11],
"save": [5],
"varmistusmekanismi": [8],
"parametri": [5],
"toisella": [11],
"rivinvaihtomerkki": [2],
"saadaksesi": [5],
"zip-kans": [5],
"project-save.tmx": [6],
"järjestelmiä": [5],
"eikä": [11,6,[5,8]],
"powerpc": [5],
"libreofficessa": [[4,11]],
"harvinaisissa": [11],
"arvoksi": [11],
"muistiinpanoja": [[8,9],3],
"haun": [11],
"luodaan": [[6,11],[1,8,10]],
"netistä": [4],
"lähdekielisinä": [10],
"kielentarkistustoimintoa": [4],
"yksinkertaisia": [1],
"tapahtuva": [11],
"versio": [5,6],
"erilaisell": [11],
"ylimääräisiä": [5],
"yksinkertaisin": [5],
"ongelmista": [1],
"avain": [5],
"lausekkeessa": [5],
"oletuskoodausta": [11],
"rastittanut": [4],
"tallnnetaan": [11],
"ranskaan": [5],
"versiontarkistuksessa": [6],
"avattuna": [9,11],
"kokoa": [9],
"ohjetekstejä": [6],
"käytetyn": [11],
"käännösehdotuksia": [11],
"avainsanat": [11],
"omegat.sourceforge.io": [5],
"luoja": [9],
"ylimääräiset": [2],
"perustuva": [8,[6,11]],
"ctlr": [11],
"minkä": [[9,11]],
"oikeinkirjoituksen": [4,[7,11],3],
"napsauttamalla": [11,5,9,6],
"linux-käyttöjärjestelmässä": [5],
"aiemmin": [[6,8]],
"vaihtoehtoisena": [9],
"mainittu": [5],
"parissa": [[6,10,11]],
"translat": [11,5,[4,6]],
"muotona": [11],
"ryhmäprojekti": [6,[3,8]],
"hakuasetukset": [11],
"havaitse": [8],
"valitsemalla": [11,5,[6,8,9],[1,3,10]],
"kuinkin": [5],
"yritä": [11],
"segmentointiasetukset": [11,8],
"säännöstölistalla": [11],
"termien": [1,[3,9]],
"yhdistämisistä": [6],
"omegat-käyttäjän": [8],
"liikutettua": [9],
"muistiinpanoon": [[3,8,9]],
"mainitut": [0],
"tsv-tiedosto": [1],
"tmx-tiedostoja": [6,10],
"näytetään": [[8,11],10],
"docs_devel": [5],
"joissakin": [[10,11]],
"tsv": [1],
"kokonaisuutena": [11],
"tiedostomuodossa": [11],
"tätä": [11,5,[6,10],[2,8]],
"kenti": [11],
"lausekohtaisia": [11],
"gnome": [5],
"muotoon": [6,4],
"hakuikkunassa": [11,6],
"tarkkoja": [1],
"oletusasetuksia": [5],
"vaihda": [3,8],
"kappaleen": [11],
"valinnainen": [8],
"hakuavaimia": [2],
"kopiot": [4],
"niminen": [5],
"käytettäviä": [11],
"lähdetiedostossa": [11],
"syystä": [[4,5]],
"sopivaan": [[5,6]],
"sanastoruutu": [8],
"esittäminen": [11],
"tunnistamassa": [11],
"liikaa": [11],
"varmista": [5],
"omegat-png": [5],
"kappaleet": [6],
"ominaisuuksien": [[1,6,11]],
"annettu": [5],
"esill": [11],
"merkkiin": [2],
"rtl-tilaan": [6],
"muokatut": [[6,8]],
"pudota": [5,7],
"tue": [6],
"csv": [[1,5]],
"n.n_linux.tar.bz2": [5],
"katkaisu": [11],
"lataamiseen": [6],
"tuo": [11,[4,6]],
"enhanc": [8],
"muuall": [5],
"tekstissä": [11,6],
"turvallisuusvaroituksia": [5],
"toisell": [5],
"press": [3],
"segmenteikseen": [11],
"manuaalisesti": [[1,6,11]],
"suodattaminen": [11],
"kirjanmerkit": [11],
"suojauksen": [11],
"kontekstitiedot": [11,3],
"paketissa": [5],
"tietojasi": [5],
"lisäohjelmat": [5],
"edelleen": [11,9],
"kutistettuja": [9],
"dmicrosoft.api.client_secret": [5],
"pist": [11,2,5],
"täys": [11],
"kohdemaa": [11],
"lisäasetukset": [11],
"taas-kokoelmia": [11],
"isännöityä": [11],
"kutsu": [6],
"muuttuu": [10,[8,11]],
"lähettää": [11,6],
"koodinpätkä": [11],
"ahneet": [2,7],
"siirri": [8,5,[3,11]],
"pudotat": [9],
"aihepiiri": [[6,11]],
"ctrl": [3,11,9,6,8,1,[0,10]],
"saraketta": [[1,11]],
"document": [11,5],
"omegat-objektimalliin": [11],
"vianmäärityksessä": [6],
"päätteenä": [8],
"sanastoruudussa": [1,[9,11]],
"kirjoittamastasi": [9],
"tapahtuma": [3],
"tehti": [11],
"resourc": [5,11],
"tekstitiedostoja": [11],
"languagetool-virheet": [8],
"koneesi": [5],
"sivulla": [[5,11]],
"team": [6],
"xx_yy": [[6,11]],
"tulleet": [8],
"docx": [[6,11],8],
"txt": [6,1,[9,11]],
"hän": [6,5],
"käynnistettävä": [11],
"näytetä": [[5,8]],
"sivunvaihdon": [2],
"käännöstyötä": [[6,9,11]],
"valintaa": [11,[5,8,9]],
"pakollista": [[5,11]],
"käytettävissäsi": [5],
"sulkeutuu": [[8,11]],
"järjestelmääsi": [5],
"tilassa": [5,11],
"projektipaketin": [8],
"erota": [11,6],
"source": [7],
"kopioimaan": [6],
"anna": [3],
"luomia": [10],
"trnsl": [5],
"toistojen": [8,11],
"viewdisplaymodificationinfoselectedradiobuttonmenuitem": [3],
"index.html": [5],
"omegat.tmx": [6],
"käännetyistä": [11],
"valitulla": [[6,8,9]],
"itsessään": [2],
"automaattisesti": [11,[5,8],[4,6],[1,3],9],
"sarakkeen": [11,8,9],
"hyväksytään": [11],
"alkukielinen": [11],
"kirjoittamaasi": [8],
"sarakkeet": [11],
"toiminnoista": [8],
"jäädä": [11],
"target-alikans": [10],
"sumea": [11,8],
"diffrevers": [11],
"siirry": [7],
"osumatilastot": [8,[3,10]],
"mukainen": [6,[5,11]],
"asetus": [11],
"muokkaaja": [11],
"kielitunnuksell": [11],
"kohdeosumien": [11],
"omegat-ohjelmassa": [5],
"käynnistää": [5,[8,11]],
"käännetyissä": [11],
"kenttiin": [11],
"kohdistusparametrejä": [11],
"tallentuu": [11,5],
"kontekstitietoja": [11],
"lähettämään": [11],
"projektiasetuksineen": [6],
"tekijän": [8],
"enää": [11,[5,6]],
"silloinkin": [[8,11]],
"muuttumattomina": [[5,11]],
"siirrä": [11],
"tekijät": [8],
"suoritettavan": [5],
"kielentarkistimen": [[10,11]],
"luodut": [6,8],
"oletusmuotoonsa": [11],
"ranskankielisen": [5],
"kääntämäsi": [[8,11]],
"tekstinvientitoiminto": [11],
"numeroita": [11,9],
"project.gettranslationinfo": [11],
"unionin": [6],
"ongelmiin": [6],
"konekäännöspalvelujen": [11],
"paikanmerkit": [6],
"lle": [5],
"start": [5],
"komentosaja": [11],
"johon": [[5,8,11]],
"yksinkertaiset": [11],
"muokattu": [8],
"ympäristö": [5],
"varmennussääntöjä": [11],
"pitkä": [5],
"lopettaa": [8],
"equal": [5],
"sopiviin": [5],
"projektivarastojen": [6],
"osumaruudulla": [9],
"esiintymisjärjestyksessä": [11],
"palveluntarjoajan": [11],
"konsolimuodossa": [5],
"viidettä": [9],
"sanakirjaan": [4],
"omegat-päivityksen": [11],
"ilmainen": [5],
"optionsalwaysconfirmquitcheckboxmenuitem": [3],
"lähettämää": [6],
"projektipolku": [5],
"ruudun": [9,[4,6]],
"luomiseen": [6],
"kokonaisten": [11],
"huomioi": [11,[4,5,6]],
"koskevia": [11],
"muistiinpanot": [9,[7,11]],
"jätettävien": [11],
"sanakirjaa": [4],
"tiedät": [11,10],
"omegat-ohjelmaa": [5],
"tehokasta": [11],
"mahdollista": [6,11,[2,5]],
"eroa": [6],
"viedään": [11,8],
"sijainneissa": [6],
"sijainti": [5,[4,11]],
"asetukset-ikkunassa": [8],
"käyttöjärjestelmästä": [8],
"enter": [11,[3,8]],
"omegat-ohjelman": [5,10],
"työkansioon": [5],
"ruudut": [9,[7,10,11]],
"vaikutuksen": [11],
"numeroitu": [1],
"projectteamnewmenuitem": [3],
"käynnistät": [5],
"muotoinen": [[0,6]],
"koske": [2,11,[5,8]],
"merkkinä": [11],
"memori": [5],
"submenu": [5],
"määrittämään": [11],
"kovalevyll": [8],
"koska": [6],
"ylin": [9],
"tiedostoon": [11,6,5,8,[3,9,10]],
"kieli–maa-paria": [11],
"säännöllistä": [11],
"samoihin": [6],
"koneell": [5],
"määritteineen": [5],
"taustaväri": [8,10],
"rastita": [11,8,1],
"palvelinten": [6],
"omegat.jnlp": [5],
"ongelmien": [5],
"tekstiosat": [6],
"muutamia": [[5,11]],
"muisteista": [10],
"n.n_windows_without_jre.ex": [5],
"jokaiseen": [11],
"käyttöliittymään": [11],
"tiedostokontekstia": [11],
"llä": [6],
"sellaisten": [11],
"konekäännöspalvelu": [8],
"numeropari": [9],
"hakuosumia": [11],
"sumeassa": [11],
"oletussäännöt": [11],
"oletussuodatinta": [6],
"näppäinpainallusta": [11],
"säännöllisenä": [11],
"prof": [11],
"synkronoidut": [6],
"graafista": [5],
"muutoksill": [10],
"toiseen": [6,[4,8,11]],
"käyttöjärjestelmässä": [5],
"käyttöjärjestelmäsi": [5],
"dmicrosoft.api.client_id": [5],
"olisikin": [8],
"erot": [11],
"projektikansioita": [11],
"selaamaan": [11],
"annettujen": [5],
"samaksi": [8],
"config-fil": [5],
"jre-ympäristöjä": [5],
"ltr-merkkijonoja": [6],
"näkymätön": [11],
"alkuun": [6,11,[0,1,2,3,4,5,8,9,10]],
"lähdetekstissä": [11,3],
"poisteta": [11],
"lataat": [6],
"syytä": [11],
"säännöt": [11],
"tuoto": [11,[3,6,8]],
"oletustasaus": [6],
"tyhjien": [11],
"lähdesegmenttien": [6],
"säännön": [11],
"lähinnä": [[9,11]],
"komentorivillä": [[5,6]],
"segmentointisäännöstö": [11],
"syntaksia": [11],
"system-user-nam": [11],
"format": [11],
"käsikirja": [8,3],
"pakotettuina": [10],
"datan": [11],
"viimeisimmät": [10],
"avamaan": [6],
"console.println": [11],
"säilytetään": [[6,11]],
"omegat-wikin": [0],
"täydennyksen": [[1,11]],
"käsittelemään": [[8,11]],
"avata": [5,11,[3,6,8,9]],
"kannattaa": [11,4,6],
"huomaat": [[4,6]],
"käännösdatasi": [6],
"termikokoelma": [9],
"haettaessa": [11],
"domainin": [11],
"lukita": [5],
"launcher": [5],
"omegat-ryhmaeprojektin_tietovarasto": [6],
"yksityinen": [5],
"standardin": [6],
"lataamaan": [11],
"lukisi": [11],
"peräkkäin": [2],
"vaihtaa": [11,6,[5,8,9]],
"para": [11],
"aloittanut": [11],
"valintaruudussa": [11],
"pari": [[5,11]],
"täydenni": [[3,11],8],
"ocr-luetut": [11],
"komentosarja": [[5,8,11]],
"yhdistetään": [6,11],
"tuottaa": [11,6],
"project_files_show_on_load": [11],
"editori": [11,[8,9],[6,7]],
"punaisella": [11],
"muotoilu": [2,11],
"ltr": [6],
"optionsexttmxmenuitem": [3],
"voivat": [11,6,[1,9,10]],
"edellä": [[2,11],[0,5,6,8]],
"oletuskäännö": [11],
"sanakirjat": [0,10,[4,9],[1,3,6,7,11]],
"verkkosivull": [11],
"sanakirjan": [4,0],
"dokumentaatioista": [6],
"marketplac": [5],
"huomioon": [11],
"macos-käyttöjärjestelmässä": [5,11],
"laskurit": [9,7],
"entries.s": [11],
"luo": [6,11,8,[3,5],10,1,[4,9]],
"dokumentit": [11],
"del": [[9,11]],
"tällaista": [11],
"oletuskäännöksenä": [[3,8]],
"gotonextuntranslatedmenuitem": [3],
"sisällytti": [9],
"targetlocal": [11],
"vasemmalla": [11],
"path": [5],
"metamerkill": [2],
"purkamalla": [5],
"meta-tägien": [11],
"julkais": [6],
"sallittuja": [11],
"tietovarastossa": [6],
"tmx-tiedoston": [6],
"aakkosjärjestykseen": [11],
"tmx-tiedostoa": [6,10],
"kappaleiden": [8],
"korjattava": [[6,11]],
"konekääntimiä": [8],
"otsikkorivillä": [11],
"kääntäjäsi": [6],
"helpcontentsmenuitem": [3],
"kieliparia": [6],
"sanakirjatiedostoja": [4],
"kyseistä": [11,5],
"ongelmakohdat": [8],
"omegat-org": [6],
"hieman": [[5,6,9]],
"erottel": [11],
"projektipäällikön": [6],
"tmx-tiedostot": [6,10,5],
"arkkien": [11],
"descript": [[3,5]],
"huomautuksen": [9],
"tm-kansion": [10],
"joihinkin": [9],
"alhaisin": [9],
"numeroiden": [11],
"lähempänä": [11],
"projectaccessdictionarymenuitem": [3],
"avoimen": [[6,9,11]],
"sitten": [11,8,[1,5,6,10]],
"lähes": [[3,6]],
"sanakirjatiedostot": [4],
"mikä": [2,[3,8,10,11]],
"työskentelemään": [6],
"monta": [10,[2,6,8,9,11]],
"nettisivujen": [11],
"kohdesegmenttiin": [[9,11],6],
"vaatimat": [[0,4]],
"paneelia": [5],
"haettavaa": [2],
"sanakirjatiedostoa": [4],
"projektikohtaiset": [11,10],
"teknisesti": [11],
"tilaa": [[5,10]],
"yhtey": [6],
"olevaa": [[5,11],[8,10]],
"libreofficen": [4],
"kuten": [5,[6,10],[0,3,11]],
"duden": [9],
"painettu": [[3,11]],
"omista": [6],
"minn": [9],
"olevan": [5,11,9,8,2],
"työskentelykansiota": [5],
"askelpalautin": [11],
"yllä": [6,5,11,[4,10],[1,2,9]],
"orposegmentit": [[9,11]],
"tiedostoluettelo": [11],
"komentosarjakielellä": [11],
"mina": [6],
"teksti": [11,9,8,6,1,[3,10]],
"puurakenteen": [10],
"macill": [3],
"kaksikielisen": [[0,11]],
"päätät": [11],
"taas-terminologiahaun": [11],
"projektikohtaisia": [11],
"dir": [5],
"riippumatta": [6],
"div": [11],
"komentoriviltä": [5,[6,7]],
"käyttöopa": [[5,7]],
"ilmaiseksi": [5],
"tekstiksi": [11],
"viewfilelistmenuitem": [3],
"päivittäminen": [5],
"alivalikko": [5],
"brows": [5],
"test": [5],
"komentosarjat-ikkunan": [11],
"kelpaa": [8],
"lähdetekstillä": [8,3],
"kohdistin": [8,11],
"omegat": [5,11,6,8,10,7,[3,4],9,1,[0,2]],
"seuraava": [11,8,[0,3,5,6],[1,2,4,7,9,10]],
"ilman": [[5,9],11],
"tarkistetaan": [4],
"kääntäjälle": [6,9],
"ulkonäkö": [11],
"kohdeki": [11],
"tuotetaan": [11],
"erottaa": [11,10],
"tiedostoksi": [6],
"alkanut": [6],
"etäkans": [6],
"lähdetiedosto": [6,[8,11]],
"muokkaaminen": [[9,11]],
"kielialueen": [11],
"sourceforgesta": [3,5],
"palata": [11,[8,9]],
"samankaltaisuus": [11],
"lohkon": [11],
"tulevaisuudessa": [6],
"käännettävään": [8,11],
"hyvälaatuiset": [10],
"kieliparin": [11],
"console-align": [5],
"heksadesimaaliarvo": [2],
"siinä": [11,[6,9]],
"projectopenrecentmenuitem": [3],
"lähdeteksti": [11,8,9,[3,6]],
"kohdetiedosto": [6],
"rtl-tilaa": [6],
"valikkonsa": [11],
"käännösmuistia": [6],
"kestävä": [6],
"kohdesegmenttien": [6],
"edestakaisin": [11],
"käännösmuistin": [6,[10,11],9,5],
"kommentteja": [9],
"työpöydäll": [5],
"käännösmuistit": [6,[5,8,10,11]],
"valikot": [8,[5,7,11]],
"rtl-tilan": [6],
"käyttämällä": [5,[6,10,11]],
"uudempaan": [5],
"valikon": [3,8,[5,9]],
"und": [4],
"täyttyy": [9],
"project_save.tmx.temporari": [6],
"alempi": [[9,11]],
"maan": [5,11],
"vahto": [3],
"kursivoitu": [11],
"editoverwritemachinetranslationmenuitem": [3],
"tilastotietojen": [6],
"näppäinyhdistelmä": [9,6,[3,8]],
"erätilassa": [5],
"ingreek": [2],
"artikkelina": [2],
"mahdollistaa": [5],
"sanastoruutuun": [9],
"tiedostosuodatinasetukset": [11],
"pakkauksen": [5],
"vasemmalta": [6],
"nuolinäppäimillä": [9],
"es_es.aff": [4],
"googlen": [5],
"yhdistetyn": [8],
"asennettuna": [8],
"sanakirjatiedostosi": [0],
"yymor": [9],
"projectexitmenuitem": [3],
"pikakuvakkeen": [5],
"komennot": [11,5],
"haettu": [11],
"tarjoaa": [5,11],
"text": [5],
"editregisteruntranslatedmenuitem": [3],
"init": [6],
"aikaa": [[8,11],4],
"tapahdu": [[8,11]],
"jotkut": [[0,6]],
"vartalonmuodostuksen": [[1,9,11]],
"komennon": [5,[3,11]],
"perustuu": [11,4],
"maco": [5],
"huomioidaan": [6],
"source-alikansiossa": [10],
"tarkemmin": [[5,11]],
"globaalisti": [11],
"kannata": [5],
"käännösosumilla": [11],
"kaikkineen": [5],
"jälkikäsittelykomento": [11],
"tekstikerrosta": [6],
"valittavaa": [9],
"tiliavain": [5],
"tukemaan": [6],
"käsiteltäväksi": [8],
"paramet": [5],
"alkavien": [2],
"maa": [5],
"minuutin": [[6,8],11],
"muunnettava": [6],
"kaksoisnapsauttamalla": [5,[8,9]],
"mac": [3],
"näet": [[9,11],[4,5]],
"tiedostosta": [10,[5,7]],
"puuttuvista": [8],
"oraclen": [5,3,11],
"keskellä": [[2,8]],
"hallitse": [6],
"tyhjennät": [11],
"muodoissa": [11],
"päävalikon": [[3,11]],
"näytöll": [8,[5,9]],
"asennusohjeet": [7],
"itsellesi": [11],
"man": [5],
"asennusohjeita": [5],
"tutkailla": [10],
"map": [6],
"samasta": [[6,11]],
"lähdetiedostojen": [11,6],
"kielen": [5,6,11],
"may": [11],
"tarkistaminen": [6],
"tilarivin": [9],
"kohdasta": [8,11,5,10,9],
"kaksimerkkistä": [5],
"mainitusta": [10],
"url": [6,[5,11]],
"valikko": [[5,6,11]],
"muokkauskomento": [8],
"uppercasemenuitem": [3],
"viewmarkuntranslatedsegmentscheckboxmenuitem": [3],
"luomaa": [6],
"kohdassa": [11,8,[4,6],[5,10]],
"samankaltaiset": [9],
"muutoksilla": [10],
"kääntämiseen": [11],
"kielet": [11],
"muodoista": [11],
"mekanismi": [8],
"päättää": [2],
"lukien": [[2,6]],
"lähdekansiosta": [11],
"samassa": [11,6,5],
"comment-kenttien": [5],
"napsautat": [11,9,8],
"myöhemmin": [[10,11],[5,6]],
"oletusasetuksiin": [11],
"hakutuloksissa": [11],
"use": [5],
"siitä": [[6,11],10,[5,8,9]],
"irrottanut": [11],
"ohjastaa": [4],
"johda": [9],
"koneelta": [4],
"kohdetiedostojen": [11,6,8],
"tilan": [[6,9]],
"tuoda": [[1,6,10,11]],
"omegat.jar": [5,[6,11]],
"omegat.app": [5],
"voisi": [11],
"usr": [5],
"tavallinenkin": [6],
"korvaamista": [11],
"tauko": [4],
"lista": [3],
"taulu": [2,3,9,[1,11]],
"kolmea": [6],
"puurakennetta": [10],
"hakutuloksista": [11],
"säästät": [11],
"alkua": [5],
"utf": [1],
"nähden": [8],
"hakutermi": [11],
"kolmen": [6,8],
"kohdistaa": [[5,8]],
"kääntämättömien": [8],
"sanastokansio": [1],
"toimepiteitä": [8],
"aluksi": [10,[6,11]],
"kohdistat": [11],
"pilkku": [2],
"dsl": [0],
"mitä": [11,5,[6,8]],
"tarvits": [6,11,[1,4,5,8,9,10]],
"jokerimerkkihaku": [11],
"tehdä": [11,6,[4,5]],
"korjaukset": [6],
"rivinvaihdon": [11],
"tallennat": [4],
"rivinvaihdot": [11],
"välityspalvelimen": [5,11],
"lisätyt": [1,8],
"tietovarastosta": [[5,6]],
"ellei": [6],
"n.n_windows_without_jre.zip": [5],
"rangaistusta": [10],
"valintaruudut": [11],
"en.wikipedia.org": [9],
"tarvita": [5],
"sellainen": [5],
"dtd": [5],
"syntyy": [10],
"tulostaulukko": [8],
"unicode-blokkien": [[2,7]],
"älä": [11,6,3],
"siirtymätapoja": [11],
"tapahtuneet": [6],
"komennossa": [5,11],
"paljon": [9,[6,11]],
"projectcompilemenuitem": [3],
"console-transl": [5],
"sopivatko": [11],
"näin": [11,6,[4,5,8],[9,10]],
"pidäthän": [11],
"jälkikäsittelykomennon": [11],
"tekstistä": [8,[5,9]],
"käytännöllisiä": [2],
"kaksoiskappaleet": [11],
"kohdekielinen": [1,8],
"vasemmalle": [7],
"nähdäksesi": [11],
"gotonextuniquemenuitem": [3],
"oletusasetus": [11],
"tekstieditorissa": [[1,5]],
"suojattu": [11],
"tarjoamin": [9],
"html-tiedostoissa": [11],
"optionsviewoptionsmenuitem": [3],
"yhteen": [1],
"käyttökelvottomia": [11],
"kirjoittamaan": [[6,11]],
"commit": [6],
"käymään": [10],
"targetlocalelcid": [11],
"sijainteihin": [5],
"kääntämättömistä": [11],
"työskent": [6],
"vähintään": [[10,11]],
"stringin": [11],
"uusista": [8],
"project_stats_match.txt": [10],
"sisäiset": [10],
"loki": [[3,8]],
"tarkalleen": [11],
"ini-tiedostoa": [5],
"täysin": [6,1],
"tallessa": [11],
"xmx2048m": [5],
"palvelimella": [6,11,5],
"vuosiluku": [6],
"jre-ympäristö": [5],
"useimmissa": [[5,11]],
"oletusselaimessa": [8],
"uniikkien": [11,9],
"xxxxxxxxxxxxxxxx.xxxxxxxxxxxxxxxx.xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx": [5],
"useimmill": [11],
"kirjaa": [[3,8]],
"kannalta": [10],
"esittämistapaa": [11],
"polku": [5],
"rahayksikön": [2],
"asetuskansiosta": [8],
"muuttujia": [11],
"kohdistuu": [11],
"kielill": [11],
"kohdistus": [11,8],
"päissä": [6],
"negaatio": [2],
"mukautetut": [[3,8,11]],
"oikoteitä": [5],
"kääntäjältä": [6],
"helppo": [6],
"varmuuskopio": [6],
"tekstinpätkää": [8],
"libreoffic": [6],
"halutulla": [[5,6]],
"väärä": [1],
"kategoria": [2],
"versiohallintaprojektiin": [6],
"valittu": [8,11,10],
"tukemiin": [6],
"nykyisen": [8,11,[3,5]],
"tällaiset": [11],
"pitkin": [11],
"avautuvat": [8],
"ensin": [11,8,[1,5,6,9]],
"kierrätä": [3],
"käännössegmenttejä": [9],
"kirjaimella": [11],
"url-osoit": [[4,8]],
"johdonmukaisempia": [11],
"poistuit": [8],
"websterin": [0],
"muokkaus": [11],
"ms-dos-ikkuna": [5],
"valitut": [11,[3,4,8]],
"pakotettujen": [10],
"aiemmista": [11,9],
"sanasto-ongelmia": [1,7],
"kolmesta": [10],
"valitun": [8,11,[3,9]],
"kieliä": [8],
"yksittäiseen": [11],
"viewdisplaysegmentsourcecheckboxmenuitem": [3],
"siirtymispainikkeen": [5],
"avaat": [6,11],
"editregisteremptymenuitem": [3],
"versioitaan": [6],
"tuotettujen": [11],
"esim": [11,6,5,[4,8],[0,1,9,10]],
"open": [11],
"monen": [[10,11]],
"www.oracle.com": [5],
"arvot": [1],
"rtl-tilassa": [6],
"omegat-yleisasetuksiin": [1],
"omegat-projektikansioon": [6],
"project": [11],
"tämän": [[5,6,11],8,9,4],
"xmx1024m": [5],
"helpointa": [6],
"noudatetaan": [11],
"omegat-ryhmaeprojektin_tietovarasto.git": [6],
"tekstuaalista": [6],
"avattuun": [9],
"erilaisia": [[9,11],8],
"valitse": [11,[8,9]],
"suodattimeen": [6],
"po-tiedostoja": [11],
"kerran": [2,[6,11]],
"asennettuja": [5],
"omegat-jakelun": [5],
"istuntoa": [11],
"kieli1": [6],
"penalty-xxx": [10],
"gotonextsegmentmenuitem": [3],
"käyttäminen": [6,[7,8]],
"jakelusta": [5],
"kieli2": [6],
"ulkoinen": [11],
"konekäännöksiä": [11],
"nnn.nnn.nnn.nnn": [5],
"löytyivät": [9],
"riippumattomat": [2],
"liittyviä": [[9,11]],
"tiedostossa": [6,5,11,3],
"muoto": [11,[1,6]],
"abort": [5],
"tiedoissa": [6],
"muokkauskenttä": [9],
"käännösmuistityökaluissa": [11],
"left-to-right": [6],
"taas-terminologia": [11],
"puretussa": [5],
"verran": [5],
"hakulausekkeeseen": [11],
"vastaus": [5],
"korvata": [11],
"virheellisiä": [[6,11]],
"synkronisointi": [11],
"tuntemusta": [6],
"etuliitteitä": [11],
"eroista": [11],
"versionhallintajärjestelmää": [6],
"pitkiä": [11],
"oliko": [11],
"kuuluu": [[6,8]],
"päävalikko": [9],
"html-tägiä": [11],
"ikonipainiketta": [5],
"pakettivaraston": [11],
"vahvuuksiin": [11],
"blokki": [2],
"versionumero": [6],
"kansioita": [[8,11]],
"kunhan": [10],
"es-mx": [4],
"nämä": [11,[5,8],[2,6]],
"hakuun": [11],
"stem": [9],
"kielien": [6,7],
"sitovat": [8,3],
"versionumerot": [6],
"varustetut": [10],
"muutoksia": [6,[5,11]],
"monia": [[2,4,11]],
"käännetyssä": [11],
"niihin": [[3,10]],
"konsolitilassa": [5],
"käynnistys-valikosta.ä": [5],
"sitovaa": [11],
"lisättävä": [[5,6]],
"saatu": [6],
"editoriruutu": [9],
"käytännöllistä": [6],
"poikkeus-ruutuun": [11],
"käyttämään": [5,6,4],
"vai": [[5,11]],
"palkkeina": [8],
"alleviivattua": [[1,4]],
"relevantteja": [11],
"asetuksesi": [5],
"kelvollinen": [5],
"samankaltaista": [2],
"yksittaisten": [5],
"käännetti": [11,[6,9,10],[3,8]],
"käytettävistä": [4],
"huolehdi": [11],
"erilaiset": [0],
"poistuttaessa": [11],
"tavoissa": [6],
"ryhmätyöprojekteja": [5],
"käännetystä": [11],
"omat_tiedostoni": [6],
"korvaus": [11,7],
"saatat": [5],
"lisäksi": [[0,5,6,8,9,11]],
"säännöstö": [11],
"kukin": [1],
"rastitat": [[5,11]],
"word": [6,11],
"ensimmäiseen": [8],
"oikeanlaisia": [6],
"avainsanahaussa": [11],
"lainauksen": [2],
"kohdistuksen": [11],
"tunnistaa": [11,[1,4,5,6]],
"käytettävissä": [5,[0,3,11]],
"käännösmuisteja": [6,10],
"hakea": [[5,8,11]],
"omassa": [[6,8]],
"kuvioita": [11,6],
"vimpaimet": [[7,9]],
"välilehteä": [8],
"piilottanut": [11],
"kieliyhdistelmää": [0],
"sanastosta": [1],
"ladata": [[4,5]],
"segmenttiin": [8,9,3,11,1],
"kirjoitussuunta": [6],
"tekstilaatikossa": [2],
"aikaisessa": [6],
"termeissä": [11],
"tiettyyn": [[5,6]],
"transtipsin": [9],
"käynnistäminen": [5,7],
"rtl-kielinen": [6],
"senhetkistä": [10],
"freebsd-käyttöjärjestelmill": [2],
"aloittavan": [5],
"liitännäisten": [11],
"erottamaan": [1],
"määrittelemään": [11],
"tekstisisältö": [6],
"windows-versioita": [5],
"lingvo": [0],
"sanastossa": [11],
"omasta": [[6,9]],
"ltr-kielten": [6],
"ajankohdan": [8],
"mrs": [11],
"miltä": [6],
"lopputulokset": [11],
"näppäinyhdstelmällä": [3],
"lopputuloksen": [11],
"jossakin": [10,6],
"asetusten": [[5,11]],
"dynaaminen": [11],
"palvelun": [11],
"languagetool-laajennus": [11],
"nimeävän": [11],
"käännetyn": [11,6,8],
"suodatinta": [6],
"tyylimuotoilut": [6],
"etätiedostoja": [10],
"kolmessa": [10],
"saakka": [[5,11]],
"käännetyt": [11,8,[3,6],[9,10]],
"pt_pt.aff": [4],
"komentorivimuotoinen": [5],
"tiedostotyypien": [11],
"oletusnäppäimenä": [11],
"jotkin": [[1,11]],
"näppäinyhdistelmää": [11,8,6,10],
"alusta": [11],
"muutokset": [6,5,[10,11],[1,8]],
"vaihtoehtoa": [8,[5,6]],
"rivillä": [9],
"muotoisten": [11],
"projektikohtaisissa": [11],
"html": [5,11],
"työskentelet": [[6,10,11]],
"kääntämässä": [11],
"lähdekielinen": [1,9,[8,10]],
"yhtenä": [[2,11]],
"prosentuaalisesti": [9],
"muutoksen": [[8,11]],
"ede": [1],
"tallentaminen": [11,[3,6,8]],
"lähde": [11,8,6,[0,9]],
"artund": [4],
"lähetä": [6],
"segmentill": [8],
"logiikkaa": [11],
"ruudull": [5],
"erotettuna": [1],
"sulke": [11,8],
"pikanäppäintä": [1],
"tällaisia": [6,11],
"valitsema": [8],
"käännösprojektin": [6],
"konekäännöksen": [9],
"huomiotta": [[5,6,11]],
"muuttaa": [11,6,[5,10],9,[1,3,8]],
"alussa": [11,10,5],
"prosenttiyksikön": [10],
"käännösprojektia": [5],
"konsolitilan": [5],
"kolmenkymmenen": [10],
"kopioida": [4,11],
"enforce-kansiossa": [10],
"paikallinen": [6,8],
"edellisen": [6,8],
"näkymättömät": [11],
"häiritä": [8],
"kopioidu": [11],
"kohdistusta": [11],
"visuaalisesti": [8],
"lihavoituina": [11],
"www.ibm.com": [5],
"muu": [2,[1,3,11]],
"olisi": [[5,6],11],
"lataamalla": [11],
"mukauttaminen": [3,7,2],
"tietyistä": [9],
"cjk-merkit": [11],
"tekemiäsi": [5],
"euroopan": [[6,8,11]],
"hakuikkunaan": [11],
"käsittele": [11,6,5],
"kenttään": [11,8],
"asennat": [4],
"seikat": [5],
"luetaan": [10,5],
"aloita": [11,[3,6]],
"tiettyä": [6,[4,11]],
"enforce-kansiosta": [10],
"lataa": [5,[3,8,11],[0,6]],
"ryhmänä": [2],
"lähdekoodista": [5,7],
"tyhjiksi": [5],
"muokkain": [11],
"pelkkä": [11,4],
"yhdistää": [11,[5,6]],
"command": [9,[3,5]],
"tietyissä": [11,6],
"oikeanlaisen": [5],
"n.n_without_jr": [5],
"laskettu": [[9,11]],
"muokkaustoimintoa": [8],
"lainkaan": [8,10],
"kappaleittainen": [11],
"englannin": [6],
"kohdeasiakirja": [6],
"vakiokäytäntö": [5],
"segmenteistä": [11,[5,8,9]],
"viewmarkbidicheckboxmenuitem": [3],
"tarkempia": [6],
"vaihtoehto": [3,11,1],
"venäjänkielisessä": [5],
"määritellyn": [5],
"arvioidaan": [11],
"automaattiset": [[8,11]],
"ohjeita": [6],
"vie": [6,11,8,[1,3]],
"määritellyt": [[2,7,10,11]],
"korvaaminen": [11],
"automaattisen": [11,1],
"muuttujissa": [11],
"muutat": [[5,6,11]],
"git-asiakasohjelmassa": [6],
"seuraavat": [11,[2,5,8],6],
"korvaa": [11,8,3,9],
"sanastotiedoston": [1],
"heikompi": [6],
"source-kans": [10],
"kääntämästäsi": [8],
"synkronoidaan": [6,11],
"versiot": [[2,5]],
"med-muotoisen": [8],
"merkitsemättä": [11],
"sanastotiedostoa": [1],
"version": [5,11],
"seuraavan": [[2,5,6,8,11]],
"kansioissa": [[5,6]],
"tekstitiedostoihin": [11],
"tyhjätilamerkit": [11,8,3],
"säännöllisten": [2,[7,11]],
"alaspäin": [11],
"sanastotiedostot": [1],
"esitysmuistiinpanot": [11],
"hakemisto": [6],
"merkistökoodausta": [11,1],
"osien": [9],
"kuin": [11,6,2,8,[5,9,10],4,1],
"seuraavaa": [2,[6,11],9],
"käyttöliittymä": [5],
"pelkkää": [6],
"avainsanahaku": [11],
"löytynyt": [[8,10]],
"tyhjätilamerkki": [2],
"projecteditmenuitem": [3],
"käännöshistoriassa": [8],
"vetää": [9],
"britannica": [0],
"päätyvät": [11],
"sopiva": [5,[4,6,11]],
"uniikin": [11],
"hakuikkunan": [[8,11]],
"kaltainen": [[5,6]],
"uniikit": [9],
"kauan": [[8,11]],
"yhteensä": [9],
"asentamasti": [5],
"muuntuu": [8],
"segmentoimatta": [11],
"kommenttiosia": [11],
"kohdista": [11,[5,8]],
"muuttujien": [11],
"pääkansioon": [6],
"lähdekieltä": [6],
"iceni": [6],
"editoriruutua": [9],
"tuottavan": [6],
"valvonnassa": [6],
"näkyvät": [11,8,1,[6,9],[2,3]],
"yleismerkkien": [6],
"valitsemasi": [8,11],
"project_save.tmx-tiedostoa": [6],
"muihin": [5,[1,6]],
"konsolimuotoista": [5],
"asiakirjojen": [6],
"määriteltäisi": [11],
"jossa": [11,[6,8],5,9,10],
"kunn": [[5,11]],
"dsun.java2d.noddraw": [5],
"kursorin": [[1,9]],
"ensimmäinen": [11,8,[3,5]],
"väreillä": [8],
"tutustu": [2],
"tilastoissa": [11],
"kielikuvion": [11],
"eli": [11,[5,6],8,10],
"muutetaan": [11,5],
"päätteinen": [5],
"parhaiten": [[9,11]],
"oletussijainti": [11],
"työkaluilla": [6],
"vapautettu": [3],
"x0b": [2],
"esimerkin": [[5,9,11]],
"rakennetta": [[2,10]],
"kirjain": [2,8,11],
"käännösmuistisi": [6],
"käytön": [[5,11]],
"josta": [11,5,8],
"oikeinkirjoitusvirheet": [8],
"merkitsemään": [11,8],
"osumilla": [10],
"tbx-tiedostoja": [1],
"http": [6,5,11],
"merkkijonon": [11],
"oikeampi": [10],
"merkkijonot": [11],
"käyttäjäryhmäll": [6],
"tällä": [11,5,[8,10]],
"kääntäminen": [6,7],
"kirjoita": [[5,11],6,[3,8,9]],
"siltä": [11],
"dockiin": [5],
"yhteydessä": [11,5],
"näkyvää": [8],
"myö": [11,5,6,9,4,10,[1,3]],
"kansioista": [11],
"voi": [6,11,5,9,[1,10],[3,8],4,2],
"kirjoittaa": [11,8,[1,5]],
"välityspalvelinkirjautuminen": [11,3],
"projectsinglecompilemenuitem": [3],
"muokkauskentään": [9],
"täytyy": [[5,6],[10,11]],
"suorittaa": [5,8,11],
"luomasi": [[4,6]],
"käsittelyyn": [11],
"ohraleipä": [11],
"jako": [6],
"tarkistuksen": [4,7,[5,11]],
"violetti": [8],
"toht": [11],
"lomakkeella": [5],
"kaikkisegmentit.tmx": [5],
"tarkistukset": [8],
"peruutettiin": [8],
"bat-tiedostoa": [5],
"tallennettuna": [10],
"kesken": [[6,11]],
"pisteen": [11,2],
"oletusmuotoisista": [3],
"lausekkeiden": [2,[7,11]],
"system-os-nam": [11],
"internetin": [11],
"ensimmäisestä": [11],
"optionstabadvancecheckboxmenuitem": [3],
"hakutoiminnoissa": [[2,11]],
"tekstinpätkä": [[8,10]],
"väli": [11],
"monimutkaisia": [2],
"mukaa": [11,[9,10]],
"optionsviewoptionsmenuloginitem": [3],
"asiakas-id": [5],
"offline-tilassa": [6,5],
"yllätys": [11],
"kyseinen": [11],
"tar.bz2": [0],
"script-alikansioon": [11],
"yksittäisiä": [11,3],
"muotoihin": [6],
"säilyvät": [[5,10,11]],
"ensimmäisessä": [[1,11]],
"bundle.properti": [6],
"toki": [4],
"rastitettu": [11,8],
"merkistökoodauksena": [11],
"annetussa": [5],
"pisteinä": [8],
"x64": [5],
"kirjautumiseen": [5],
"minuutteja": [6],
"pysyneet": [11],
"taulukoista": [3],
"tehoka": [11],
"hyväksynyt": [5],
"keyev": [3],
"aloittamaan": [11],
"tietokoneavusteista": [7],
"tarvitaan": [[2,5,6,11]],
"parametriä": [5],
"isn\'t": [2],
"luomissa": [11],
"ykkös": [6],
"sanastoa": [11],
"alatunnisteet": [11],
"täyden": [5],
"versionhallintaa": [6],
"tärkein": [[5,9,10]],
"eri": [11,6,[8,9]],
"merkistökoodaustiedon": [11],
"jokin": [[4,10,11]],
"kirjainnäppäintä": [11],
"ero": [11],
"optionsteammenuitem": [3],
"kuta": [5],
"tietueita": [11],
"tmx-tiedostoista": [8],
"etsiessäsi": [2],
"tietosuoja": [5],
"esc": [11],
"omegat-asennuskansiossa": [11],
"poisjätettäviksi": [6],
"x86": [5],
"oikeall": [6],
"nostemscor": [11],
"otsikkoa": [[8,11]],
"sanoilla": [11],
"vastaa": [11,2,[4,8,10]],
"kirjanmerkkiviitteet": [11],
"kieleksi": [5],
"määritettyä": [6],
"etäsijainti": [6],
"and-logiikka": [11],
"console-createpseudotranslatetmx": [5],
"edistymisen": [[6,9]],
"ulkoisella": [11],
"tapaa": [6,[5,11]],
"poistettava": [4],
"longman": [0],
"epäkäytännöllinen": [5],
"tietysti": [10,[5,6,11]],
"asiassa": [6],
"fuzzyflag": [11],
"puolipilkulla": [6],
"asiakirjoista": [11],
"asiakkaall": [6],
"työpöydällä": [5],
"terminologiaongelmat": [8],
"segmentointia": [11],
"gpl-lisenssillä": [0],
"merriam": [0,[7,9]],
"escap": [1],
"new": [5],
"kirjoitetuista": [11],
"antama": [6],
"segmenteiksi": [11],
"html-tiedostojen": [11],
"asennetun": [5],
"kuva": [4,[0,2]],
"tältä": [5],
"taulukot": [6],
"liukuluvut": [11],
"uniikkiin": [3],
"apusanastojen": [1],
"taulukon": [[8,11]],
"päivittyviä": [5],
"suljetaan": [6],
"hakukomentoja": [8],
"olivatpa": [10],
"sarkain": [3],
"jätät": [11],
"ambivalentin": [11],
"internetiä": [11],
"nimellä": [5,11],
"asiakirjoissa": [[9,11]],
"osaan": [11],
"vaaranna": [6],
"asennettu": [5,8],
"napsautukset": [5],
"muuteta": [11],
"napsautuksen": [11],
"näkyisi": [5],
"saadaan": [11],
"näkymään": [11],
"ominaisuutta": [11],
"tyypillinen": [6],
"yksikielisistä": [11],
"käännöstyön": [10,11,6,[8,9]],
"kyseisessä": [11],
"n.n_without_jre.zip": [5],
"onnistu": [6],
"seurata": [6],
"tämänhetkiseen": [8],
"parempia": [11],
"kuvaustiedosto": [3],
"erä": [9],
"vuorovaikutuksessa": [11],
"sanastokansioon": [11],
"töydennyksen": [11],
"name-kenttään": [5],
"lähteestä": [11],
"magento": [5],
"mene-valikko": [3,7],
"kuvioll": [11],
"keltaisella": [9],
"palveluntarjoaja": [11],
"uutta": [[5,8]],
"tallennettuun": [6],
"avaavat": [8],
"korean": [11],
"toistot": [11,9],
"otetaan": [11,[3,5,6,8,10]],
"koodin": [3],
"windowsin": [[0,5]],
"omegat-tiimi": [7],
"api-avainta": [5],
"toistoa": [11],
"perusteella": [11,[4,9]],
"siellä": [11],
"väliltä": [[2,10]],
"tuonti": [6],
"konetta": [11],
"shift": [[1,3]],
"projekteista": [11,1],
"kommenttirivit": [3],
"saatavilla": [5,8,11],
"tavoin": [11,9],
"käyttäjäsuodattimia": [11],
"joukko": [11],
"yksittäin": [11],
"käytt": [4],
"alikansioiden": [8],
"myöskään": [11],
"kirjoituskelpoisena": [1],
"java": [5,3,11,[6,7]],
"painettava": [3],
"jäsentää": [11],
"pieni": [10,4],
"vaikkapa": [6,11],
"sovelluksen": [[5,6]],
"project_save.tmx": [6,10,11],
"jättää": [11,6],
"dictionari": [[0,10]],
"liikkuvan": [11],
"koostuvat": [11],
"käytettävien": [1],
"tuonut": [9],
"ruuru": [11],
"omalla": [5],
"avaaminen": [5],
"aggressiivinen": [8],
"jollekin": [2],
"muokkaa-valikko": [3,7],
"aihepiiriä": [6],
"niill": [8],
"dictionary": [7],
"lisätä": [11,9,[3,5,10],[1,6,8]],
"normaalifontilla": [1],
"kuuluva": [8],
"luotettavista": [10],
"palautuu": [8],
"liikkua": [8],
"numero": [[2,5,9,11],[6,8]],
"regex-tapauksia": [2],
"tarvittaessa": [11,[4,6]],
"hyötyä": [11],
"näiden": [11,6,[4,8]],
"usein": [6,[4,5]],
"omegat-istunnossa": [5],
"täyttää": [8],
"omiksi": [[9,11]],
"lisäkäännösmuistia": [10],
"valintaruutuun": [11],
"default": [3],
"paikkaan": [6],
"tietoturvasyistä": [11],
"nnes": [8],
"lisäkäännösmuistit": [9],
"sumeiden": [[9,11],6,10],
"java-sovellukset": [5],
"tyyliin": [6],
"timestamp": [11],
"projectaccessrootmenuitem": [3],
"piilotetut": [10],
"lukemisessa": [1],
"dyandex.api.key": [5],
"joihin": [6],
"sisältöattribuuttia": [11],
"tiedostorajoituksista": [5],
"jää": [11],
"yhdellä": [[5,10,11]],
"vaiheeseen": [11],
"spellchek": [4],
"muistiinpano": [8,11],
"plugin": [11],
"pudottamalla": [5],
"lisättyjä": [6],
"käännetä": [11],
"edellistä": [[8,9]],
"kääntämättä": [11,9],
"määritelmässä": [3],
"jokerimerkkejä": [11],
"otsikkona": [8],
"editinsertsourcemenuitem": [3],
"oikeinkirjoitussanastoa": [4],
"tasausta": [6],
"määrästä": [11],
"viterbi": [11],
"microsoft": [11,6,5],
"poistaminen": [6],
"joukon": [2],
"projectnewmenuitem": [3],
"merkinnän": [9,[3,11]],
"enter-näppäintä": [5],
"kanadan": [11,5],
"optionstranstipsenablemenuitem": [3],
"käännä": [11,6],
"segment": [9],
"käytät": [11,[5,6]],
"vaikuttavat": [11],
"merkinnät": [[2,7]],
"näppäinyhdistelmällä": [6,[8,9,11]],
"glossari": [1,[6,10],[9,11]],
"pikanäppäimenä": [8],
"kertaan": [11,2],
"ignored_words.txt": [10],
"configuration.properti": [5],
"github.com": [6],
"ryhmä": [11,3],
"nimityksessä": [11],
"glossary": [7],
"uudella": [11],
"pääosaston": [8],
"suodatin": [11],
"fonttia": [11],
"wordissa": [11],
"tarkoitettu": [[2,6]],
"samaa": [6,10],
"oikeinkirjoitussanaston": [4],
"mukaisten": [11],
"sivuista": [6],
"palauttaa": [[9,11]],
"käännösmuistikansioksi": [6],
"toistuvia": [11],
"kohdesegmenttejä": [11],
"tarkisteta": [1],
"string": [5],
"vähemmän": [5,10],
"perinteisiä": [5],
"komennolla": [5,[6,8]],
"poisto": [11],
"tunnistetiedot": [11],
"kirjoittamalla": [11],
"määre": [11],
"valintakansioon": [3],
"parametrin": [6],
"merkkijonossa": [11],
"saman": [[5,10,11]],
"muokkaamalla": [5,[1,6]],
"samat": [[8,11],[1,5,9]],
"luomaan": [11,[5,6]],
"tunnist": [1,[6,10,11]],
"not": [[5,11]],
"automaattista": [[6,11]],
"valitsemaan": [11],
"apua": [2],
"viimeisessä": [[5,8]],
"komentorivitilassa": [5],
"valitsemassa": [8],
"omegat-pääikkunan": [11],
"esiintyy": [11,9],
"helposti": [[6,11],5],
"lähetettävä": [6],
"yhtään": [8],
"etkä": [[5,6,11]],
"u00a-merkkiä": [11],
"luokat": [[2,7]],
"oletuskäytö": [10],
"valikkoihisi": [5],
"käännettävänä": [9,[6,10,11]],
"selection.txt": [11,8],
"tyhjiä": [[3,11]],
"projekteissa": [[8,11],6],
"ruutu": [8],
"suljet": [8],
"xhtml": [11],
"erilaisten": [6],
"finder.xml": [11],
"poista": [11,[6,9],[1,3,4,5,8,10]],
"ennalta": [[2,5,7]],
"window": [5,2],
"paikalliset": [6],
"käytä": [11,6,3,8,5,[1,4,9]],
"paikallisen": [6,8],
"mennessä": [9],
"käynnistys-valikkoon": [5],
"kirjoituskelpoiseen": [1],
"ikonitiedostoja": [5],
"kommennon": [5],
"disable-project-lock": [5],
"välillä": [6,8,11],
"rinnakkain": [5],
"suoraan": [5,[8,10,11]],
"omegat.pref": [11],
"seuravaan": [9],
"kohdekielillä": [11],
"tmx-tiedostojen": [6,11],
"asentavat": [5],
"olisivat": [6],
"tärkeysjärjestyksessä": [11],
"erilliset": [[5,11]],
"ominaisuudet": [11,8,6,[0,3,4,7,10]],
"sieltä": [5],
"käännöksiin": [11],
"projektivalikko": [3,7],
"tyhjennetä": [8],
"rivi": [[3,10,11]],
"tehnyt": [[5,11]],
"nro": [3,[8,9]],
"käännöksen": [11,9,8,6],
"kirjainkoko": [8,3],
"valintaruutu": [11],
"pt_pt.dic": [4],
"todennetun": [11],
"mukaisiksi": [11],
"level1": [6],
"nsb": [11],
"oletusasetuksena": [11,[1,2,6,9]],
"tälle": [11],
"level2": [6],
"ollut": [[6,8,11]],
"korkeammalla": [11],
"niitä": [11,6,[1,3,8,10]],
"voidaan": [11,6,5,10,[1,9]],
"sisältävistä": [5],
"ohittavan": [10],
"tietovarastoon": [6],
"tähän": [11,6,[4,5,10]],
"mitenkään": [6],
"määritettävä": [6],
"tiettyjen": [[6,10,11]],
"sanakirjojen": [4,0,[7,8]],
"silti": [4],
"väritetti": [8],
"laittamalla": [11],
"vahinkoja": [11],
"ilmauksessa": [5],
"käännökset": [10,6,8,11,1],
"viimeiseen": [8],
"hanki": [[5,11]],
"web": [5,7],
"sulj": [11,[3,6,8]],
"muokkauskenttään": [11],
"japaninkielisen": [5],
"luomien": [11],
"dian": [11],
"oletusmuotoisten": [3],
"kirjautumistiedot": [11],
"lausek": [[2,11]],
"editselectfuzzy4menuitem": [3],
"editregisteridenticalmenuitem": [3],
"siihen": [6,5,[9,10,11]],
"etsi": [11,8,[3,5],[0,4,6]],
"ponnahdusvalikon": [9],
"löydät": [5,11,8,[6,9,10],[3,7]],
"lähdeasiakirja": [3],
"kääntämättömään": [11,[3,8]],
"pääkansiosta": [6],
"olevia": [11,6,[3,9],[1,5,10]],
"tekemät": [5],
"muotoilujen": [[6,11]],
"kielentarkastimen": [10],
"painamalla": [11,6,[1,9,10]],
"tuleva": [[9,10]],
"tarkempaa": [[2,11]],
"sijainnilla": [5],
"ilmauksesta": [2],
"sumeilla": [11],
"lukemaan": [6],
"fonttien": [8],
"määrä": [[9,11]],
"liiteti": [5],
"muistiinpanoista": [11],
"pt_br.dic": [4],
"ajaminen": [5,7,8],
"välttämättä": [[5,6]],
"unabridg": [0],
"kolmanteen": [1],
"valitset": [8,[5,11],9],
"omegat.app-sijainti": [5],
"olevat": [11,6,5,[1,8,9,10],4],
"välilyönnit": [11,8,[2,3]],
"kielentarkistimeen": [[4,11]],
"lisäämään": [[4,11]],
"kuulonkaan": [6],
"command-kenttään": [5],
"pääkansiossa": [6],
"joukkoon": [11],
"optionsglossaryexactmatchcheckboxmenuitem": [3],
"aloitat": [6],
"svn-asiakasta": [10],
"ohjelmointitapaa": [11],
"huom": [11,[6,8],10,9],
"vaihtoehdon": [3,8,[9,11]],
"attribuuttien": [11],
"hakuikkunaa": [8],
"windows-koneiden": [8],
"lähdesegmenteistä": [11],
"kirjainkoon": [[2,11]],
"polkua": [5],
"vaihtoehdot": [11],
"poistaa": [11,6,[4,5,8,10]],
"kirjainkoot": [11],
"useampaan": [11],
"viimeisintä": [11],
"takaisin": [9,[6,11]],
"nnnn": [9,5],
"halutun": [5],
"url-osoitteen": [[6,11]],
"osumalla": [8,[3,9]],
"poistat": [11],
"java-ympäristö": [5],
"sumean": [[8,9],11],
"oletuksena": [11,8],
"merkkijonoja": [11],
"pika-aloitusopa": [5],
"tilisivullasi": [5],
"luokka": [2],
"sillä": [5,11,[6,9],8],
"sumeat": [[8,9],[6,7,11]],
"päivittyy": [11],
"aikaleima": [11],
"täytetti": [11,8],
"sopiviksi": [11],
"komentosarjan": [11,8,5],
"suorita": [11],
"samankaltaisuuskynnyksen": [11],
"zh_cn.tmx": [6],
"komentosarjat": [11,8,7],
"vedä": [5,7],
"lainausmerkit": [[2,7]],
"ohjeet-valikko": [3,7],
"uuten": [11],
"pikanäppäin": [3,11],
"sääntöjä": [11],
"kopioimalla": [6],
"komentosarjaa": [5],
"terminologiatiedostoja": [1],
"paikalliseen": [6],
"ponnahdusvalikko": [9],
"paikalliseet": [6],
"lähdetägit": [[3,8]],
"rasti": [11,8,[1,4]],
"säilyttävä": [10],
"että": [11,6,5,9,[4,10],8,[0,1,2]],
"sarakkeeseen": [1],
"archiv": [5],
"thunderbirdissä": [[4,11]],
"tuotemerkit": [6],
"mukautettuja": [11],
"user": [[5,9]],
"tar-paketti": [5],
"järkevää": [[10,11]],
"extens": [11],
"onneka": [11],
"nyt": [[3,11]],
"vastaanotetun": [11],
"aiheuta": [11],
"oikeinkirjoitus": [4],
"portin": [5],
"täällä": [11],
"käynnistyy": [5],
"aktiivisen": [10],
"kansio": [5,4,[10,11],6],
"aa": [5],
"ajaksi": [11],
"lauseelta": [11],
"käsitellään": [11,5],
"välissä": [11],
"diff": [11],
"käännettävissä": [11],
"an": [2],
"editmultiplealtern": [3],
"git.code.sf.net": [5],
"kokoelmat": [11],
"siirtyä": [9],
"manuaalisia": [11],
"käännöksiä": [11,9,6,8,7],
"käyttämää": [11],
"kielentarkistinta": [11],
"be": [11],
"kielentarkastin": [4,[1,2,7]],
"filters.xml": [6,[10,11]],
"käännettävistä": [11],
"suositeltavaa": [11],
"br": [11,5],
"vahvistusikkunassa": [11],
"asiakkaaltasi": [9],
"suurimpaan": [[9,11]],
"normaaliksi": [10],
"html-tiedostot": [[5,11]],
"hakutulokset": [11],
"segmentation.conf": [6,[5,10,11]],
"järjestää": [11],
"kielivariantin": [11],
"näyttää": [11,[8,9],[0,5]],
"ca": [5],
"hakutuloksen": [11],
"oikea": [[1,4,5,6,11]],
"cd": [5,6],
"käyttäjä": [11,[5,8,9]],
"ce": [5],
"öäüqwß": [11],
"po-otsaketta": [11],
"yhteyksiä": [11],
"kuvio": [11],
"ex_mx.dic": [4],
"senhetkinen": [8,9],
"cn": [5],
"osumanäytön": [11],
"alkuperäisen": [[6,11]],
"xhtml-päätteisten": [11],
"varmuuskopioi": [6],
"aivan": [6],
"cx": [2],
"tiedostoihin": [6,11,5],
"käännöspalvelut": [5],
"apach": [[4,11],6],
"oikeinkirjoitussanastoja": [4,11],
"luulet": [6],
"kuvia": [6],
"adjustedscor": [11],
"siten": [6],
"vahvistetaan": [9],
"viimeksi": [8,3],
"esitellyn": [11],
"ikkunat": [11,[7,8,9]],
"f1": [3],
"algoritmit": [11],
"uusia": [3],
"f2": [9,[5,11]],
"tekstiin": [11],
"f3": [[3,8]],
"algoritmin": [[3,8]],
"käydä": [[5,6]],
"katsellaan": [6],
"olemassa": [11,5,6,[1,2,3]],
"f5": [3],
"merkistökoodauksensa": [11],
"ikkunan": [11,8,9],
"kunnossa": [6],
"laehd": [6],
"säännöllisistä": [2],
"dz": [0],
"editundomenuitem": [3],
"omegat-ryhmaeprojektin_kaikkien_laehteiden_tietovarasto": [6],
"historiassa": [8,3],
"ikkunaa": [11],
"käynnistetään": [5],
"uusin": [[5,6]],
"komentoa": [5,8],
"u000a": [2],
"riittää": [5],
"siirtyy": [8,11,6],
"ei": [11,[5,8],6,1,9,[4,10],2],
"sarkainmerkeillä": [1],
"perii": [6],
"käyttämän": [5],
"en": [5,11],
"yhteisiä": [6],
"ylittää": [11],
"u000d": [2],
"käyttämät": [[1,9,11]],
"u000c": [2],
"et": [11,6,[5,8,9]],
"riittävän": [[10,11]],
"kuolleiksi": [6],
"termiä": [1],
"tauluista": [7],
"riittävät": [11],
"tiedostoja": [11,6,10,[1,8],[3,4,5,9]],
"tiedostonimien": [11],
"kappaleesta": [[9,11]],
"säännöllisissä": [11],
"mainitaan": [11],
"enforce-kansiosa": [10],
"u001b": [2],
"stats.txt": [10],
"projektilla": [5],
"lähteeseen": [[3,8]],
"foo": [11],
"for": [11,[3,8]],
"exclud": [6],
"yksityisten": [11],
"tuotuja": [6],
"välistä": [[2,9]],
"fr": [5,[4,11]],
"jolloin": [11,[5,8],[6,10]],
"onnistui": [6],
"content": [5],
"segmentointisäännöissä": [2],
"sisällytä": [11],
"gb": [5],
"luontihetkellä": [11],
"sovellusten": [[4,6,11]],
"class": [11],
"helplogmenuitem": [3],
"elementtejä": [6],
"tiedostoll": [6],
"koneellesi": [5,6,8],
"kielellä": [6,5,9],
"ikkunoikseen": [9],
"alueell": [11],
"editoverwritetranslationmenuitem": [3],
"valintasi": [8],
"prosenttiosuutta": [10],
"säännöistä": [11],
"kirjaimellisempia": [11],
"aeiou": [2],
"kirjainmerkit": [8],
"form": [5],
"segmentointisäännöistä": [11],
"täytettyjen": [8],
"kaksi": [11,5,[4,6],[8,9]],
"he": [6],
"vaihtoehtoisesti": [11],
"täältä": [11],
"duser.languag": [5],
"kanssa": [[3,6],[5,8,11]],
"käynnistävä": [5],
"punaiseksi": [10],
"latauksen": [11],
"kolma": [1],
"toisinaan": [[6,10,11]],
"välisiä": [5],
"etsimäsi": [6],
"vanhoista": [11],
"file-target-encod": [11],
"context": [9],
"https": [6,5,[9,11]],
"id": [11],
"fyysisesti": [4],
"if": [11],
"tietovarastokansioon": [6],
"project_stats.txt": [11],
"siirtämällä": [11],
"ocr": [6],
"termit": [1,9],
"projectaccesscurrenttargetdocumentmenuitem": [3],
"osoittava": [11],
"sanasto": [11,[3,9],[1,6,7,8]],
"selvää": [9],
"valittua": [8],
"aktivoimalla": [10],
"in": [11],
"lokalisointitiedostojen": [6],
"termin": [[1,8],11],
"is": [2],
"sanastotiedosto": [1,9],
"merkki": [2,11,[1,7]],
"asettelu": [11],
"lokalisoitu": [5],
"säilyy": [11],
"odf": [6,11],
"doc-tiedostoja": [6],
"alhaisempi": [9],
"ja": [11,6,5,8,9,4,1,10,2,7,3,0],
"ainoastaan": [11,5,6,[1,8,9]],
"odt": [11],
"sarkainmerkki": [11,[1,2]],
"sanoista": [[1,8]],
"gotonexttranslatedmenuitem": [3],
"ryhmäprojektia": [[6,11]],
"jo": [11,5,10,6,[1,4,9],[2,3,8]],
"poistamaan": [11],
"l3": [5],
"nplural": [11],
"linux-koneissa": [5],
"js": [11],
"ryhmäprojektin": [6,7,[8,10,11]],
"kuvataan": [[6,11]],
"learned_words.txt": [10],
"esiintyvät": [11],
"tägien": [11,5,6,3],
"käyttävät": [11],
"ollen": [[4,11]],
"omegat-projektitiedoston": [9],
"nimessä": [11],
"huonosti": [11],
"kerännyt": [10],
"samanlaiset": [4],
"useat": [11],
"tiedostopäätteestä": [1],
"ftl": [5],
"kk": [6],
"tarkoittavat": [11],
"näppäimillä": [11],
"käytettyyn": [[4,11]],
"ks": [6,11,5,[2,4,10]],
"viewdisplaymodificationinfoallradiobuttonmenuitem": [3],
"draw": [6],
"toistuvaan": [9],
"dipl": [11],
"poistot": [11],
"merkin": [11,[2,5,9]],
"xhtml-tiedostoihin": [11],
"sarkaimilla": [1],
"reagoi": [9],
"lyhyitä": [11],
"merkit": [[1,11],[2,5]],
"online-sanakirjojen": [4],
"omegat-ryhmäprojektin": [6],
"dswing.aatext": [5],
"omegat-ryhmäprojektit": [6],
"säilö": [11],
"ruudulla": [9],
"windows-käyttöjärjestelmässä": [5],
"lu": [2],
"työkaluissa": [[6,11]],
"vaihdettava": [6],
"asuunsa": [6],
"toisesta": [4],
"kirjoitettua": [6],
"kokoelma": [2],
"cycleswitchcasemenuitem": [3],
"mb": [5],
"windows-koneissa": [5],
"määritystiedostojen": [5],
"tieto": [11],
"tärkeysjärjesti": [11],
"omegat.png": [5],
"mm": [6],
"estäminen": [6,7],
"entri": [11],
"kohdetiedostoja": [11],
"mr": [11],
"ms": [11],
"klikkaamalla": [11],
"mt": [10],
"joidenkin": [6],
"toistuvat": [11,8,3],
"työpöytääsi": [11],
"oletuskielentarkistin": [[4,11]],
"my": [5],
"aktivoitu": [8],
"ohj": [6],
"elementit": [[6,11]],
"käi": [[5,6,11]],
"tarvitset": [5,[4,6,11]],
"hakukenttään": [11],
"tiedosto": [5,6,11,[1,3,8],[7,10],[0,9]],
"ne": [11,6,4,5,[8,10],[2,3]],
"vvvv": [6],
"doc-tiedostona": [6],
"täydelliset": [8],
"halua": [11],
"kovalevyä": [5],
"paneeleihin": [5],
"hollantia": [6],
"nl": [6],
"esimerkkitapaus": [6],
"no": [11],
"muotoiluja": [11],
"ongelmia": [0,[6,7]],
"code": [5],
"nr": [9],
"selaimesi": [5],
"gotohistoryforwardmenuitem": [3],
"yhdeksi": [11,6],
"projektisi": [11],
"desimaalierottimena": [11],
"antaa": [[5,11],8,9],
"kohdennus": [5],
"eivätkä": [[5,6]],
"toivottua": [11],
"toistuvan": [11],
"kokoelmia": [11],
"of": [0],
"yksinkertaisesti": [[4,5]],
"osiosta": [5],
"lisenssillä": [6],
"ok": [[5,8]],
"ottaa": [11,8,[2,5,6]],
"käännöstoimen": [8],
"on": [11,6,5,8,9,10,1,2,4,3,0,7],
"vaihtumisen": [8],
"rastin": [11],
"muuntaa": [11],
"otsakkeen": [11],
"nopeasti": [11],
"kohdekieltä": [6],
"sloveniankielinen": [9],
"editinserttranslationmenuitem": [3],
"löytyneen": [10],
"pilkkua": [1],
"näkymä-valikko": [3,7],
"löytyneet": [8],
"ikkuna": [11,8,9],
"paketin": [5],
"rastia": [11,8],
"po": [[5,9]],
"hakumenetelmistä": [11],
"pp": [6],
"optionsglossarystemmingcheckboxmenuitem": [3],
"pt": [5],
"molemmissa": [6,11],
"xml-pohjaisissa": [11],
"koodaus": [1],
"lähdetekstiä": [11,[8,9]],
"selata": [9],
"mielessä": [11],
"ltr-lähdekielisiksi": [6],
"lisäystoiminto": [8],
"vaihtamaan": [6],
"henkilöiden": [9],
"säännöstön": [11],
"edit": [8],
"editselectfuzzy5menuitem": [3],
"yrittää": [11,[5,6]],
"ole": [11,8,5,1,6,9,[3,4,10]],
"suodata": [11],
"poistut": [[6,10,11]],
"pakettivarastojen": [11],
"dvd-levyll": [6],
"oli": [8,[9,11]],
"oll": [[0,11]],
"tuotetuntiedostonnimi": [5],
"molemmat": [11],
"rc": [5],
"palauttamaan": [11],
"vasemmall": [6],
"includ": [6],
"kysyttävä": [9],
"hälytyksen": [2],
"lataaminen": [5,6],
"oma": [11],
"aikavälejä": [11],
"sisältäviä": [11,6],
"sumealla": [8],
"kappalejaot": [8],
"pysyy": [11],
"samoina": [11],
"valintaikkuna": [11,8],
"joill": [11],
"valinnat-valikko": [3,7],
"sc": [2],
"kielten": [[4,11]],
"etsittävä": [11,8],
"se": [11,5,6,8,9,[4,10],0],
"kääntämääsi": [11],
"aktiivisessa": [1],
"oletusarvoisesti": [11,5,[6,8],10],
"kohdalla": [11,8,9],
"minun": [6],
"isojen": [11],
"paikkamerkit": [11],
"vastaavuus": [9],
"yhdistämisesimerkkejä": [6],
"täysleveiden": [11],
"koskemaan": [11],
"liittämäsi": [10],
"toisessa": [[1,5,6]],
"koottu": [6],
"editoverwritesourcemenuitem": [3],
"katoavat": [4],
"taulukossa": [11],
"normaalisti": [5],
"tallentamisessa": [11],
"lähetät": [6],
"enforc": [10],
"pakotetut": [10],
"merkintä": [8],
"varmaan": [6],
"remov": [5],
"tm": [10,6,[8,11],[5,7,9]],
"to": [[5,11]],
"v2": [5],
"etävarastossa": [6],
"syitä": [[1,5]],
"lähdetekstin": [11,[6,8]],
"tt": [6],
"document.xx": [11],
"tw": [5],
"aputyökalujen": [6],
"tietovälineeseen": [6],
"osoiterivill": [5],
"viewmarkautopopulatedcheckboxmenuitem": [3],
"määriteltyä": [5],
"projectwikiimportmenuitem": [3],
"komentosarjatoimintoa": [11],
"countri": [5],
"laittaa": [11],
"tyhjätilamerkkejä": [11],
"paitsi": [2,[6,11]],
"noin": [11],
"mitään": [8,[5,11]],
"pysähtyy": [11,5],
"suotta": [6],
"projektiin": [6,11,[8,9,10]],
"sanakirjalinkeistä": [0],
"tarkista": [[4,6],8,0,3,[5,11]],
"suositus": [5],
"versioita": [5],
"erillisinä": [11],
"työtilastasi": [6],
"oltava": [5,4,[1,11],2],
"this": [2],
"käännösmuistissa": [10,[6,9]],
"palvelutyyppi": [11],
"paketti": [5],
"päin": [[5,6,11]],
"tapauksessa": [[5,6],[8,11]],
"syöttöhistoriaan": [8],
"kutsuttaessa": [8],
"vi": [5],
"ulkoisessa": [11],
"vm": [11],
"html-kommentit": [11],
"muutoksista": [11],
"palvelimell": [6],
"nl–en-käännösmuistitiedosto": [6],
"parametrien": [5],
"merkistökoodauskenttien": [11],
"po-suodatin": [11],
"pura": [5,0],
"avain-arvo-parit": [11],
"url-osoitteseen": [6],
"tyylillisiin": [11],
"samanlaisia": [[1,6,11]],
"nimeksi": [[3,5,6]],
"käännösmuistista": [[8,9,10],[2,11]],
"pystyä": [11,6],
"tunnistamista": [11],
"ongelmaa": [8],
"kansioiden": [[6,11]],
"argumenteilla": [5],
"sanasta": [11],
"merkeillä": [11],
"groovy.codehaus.org": [11],
"rajoittaa": [11],
"suosittu": [11],
"ongelmat": [6],
"emac": [5],
"org": [6],
"määrittää": [11,[5,8]],
"näyttö": [11],
"prosenttiosuus": [11],
"englannista": [5],
"oletusmuotoinen": [3,6],
"xf": [5],
"tä": [5,[6,11],[4,10]],
"tarkistukseen": [11],
"tilastotiedot": [[6,10]],
"pysyä": [10],
"windowsiin": [5],
"esiintymää": [11],
"käyttöjärjestelmä": [11],
"osa": [8,11,[5,9,10]],
"projektill": [5],
"kiinan": [[5,11]],
"xx": [5,11],
"xy": [2],
"sourc": [6,11,10,[5,8],9],
"tiedä": [5],
"joutua": [11,6],
"seuraavia": [[5,10,11]],
"käynnistämiseen": [5],
"monikielinen": [6],
"kahtena": [9],
"lähdekielellesi": [11],
"muotoilemattomia": [11],
"type": [6,3],
"automatoria": [5],
"luomisessa": [6],
"toolssinglevalidatetagsmenuitem": [3],
"pakata": [10],
"korvautuu": [8],
"ym": [11],
"järjestelmäsi": [5],
"lausekkeissa": [11],
"projectaccesssourcemenuitem": [3],
"ota": [[3,4,11]],
"ruutua": [[6,11]],
"oikeinkirjoitussanasto": [8],
"yy": [[9,11]],
"yhdenmukainen": [8],
"valinnaisesti": [5],
"kirjoitettava": [5],
"osoittaa": [[6,9,11]],
"yhdestä": [8],
"edistyneill": [2],
"push": [6],
"luotu": [8,[10,11]],
"vaihtaminen": [11],
"readme_tr.txt": [6],
"maalaama": [11],
"uuteen": [5,[4,6,9,11]],
"erityisen": [11,6],
"penalti": [10],
"muassa": [11],
"muill": [6],
"tehdään": [6],
"pystyy": [[6,9]],
"joita": [11,9,[5,6],[4,10]],
"po-tiedostoissa": [11],
"lausekkeista": [2],
"erityiset": [6],
"omimmaksesi": [6],
"hakutermiä": [11],
"tallentaa": [8,6],
"segmentointisäännöstön": [11],
"saamasi": [11],
"pudottaa": [9],
"hakukomennot": [8],
"pituus": [9],
"utf8": [1,[8,11]],
"ranskaa": [11],
"kohtaan": [11],
"tavallinen": [6],
"yhdessä": [6,[1,11]],
"tällaisiin": [6],
"kumoa": [[3,8]],
"out": [6],
"hakusanat": [11],
"tarvittava": [[1,5]],
"tässä": [11,8,5,6,[1,9,10]],
"salli": [11],
"liit": [[1,2,4],[0,3],6],
"komentosarjojen": [11,8],
"packag": [5],
"pienennetään": [10],
"power": [11],
"lauseittaisen": [11],
"vaihtoehdoista": [11],
"hiiren": [[9,11],5,8,[1,4]],
"kuvan": [9],
"esiintymän": [11],
"palveluista": [5],
"luotuja": [6],
"tag-valid": [5],
"esiintymät": [[4,11]],
"seuraavanlaiset": [11],
"nimetä": [4,6],
"esitysjärjesti": [8],
"määriteltyjen": [11],
"siksi": [6,[10,11]],
"termikantoina": [11],
"esimerkki": [6,2,[0,5]],
"kohtaat": [6],
"ranskan": [11,5],
"näkyvillä": [10],
"api-avaimen": [5],
"kuvaa": [10],
"kiinaksi": [6],
"päätymerkit": [2],
"vastaavuusprosenttien": [9],
"u0009": [2],
"xhh": [2],
"jakelun": [8],
"revis": [0],
"u0007": [2],
"automatisoivat": [5],
"repositori": [6,10],
"etuliitteellä": [10],
"vasen": [11],
"tästä": [[5,10],[6,11],4],
"windows-käyttäjät": [5,7],
"suorittanut": [6],
"halutessasi": [6],
"tukevissa": [6],
"data": [[6,11]],
"lowercasemenuitem": [3],
"nimesi": [11],
"wiki": [9],
"valintana": [5],
"separ": [1],
"ilmaista": [5],
"huolta": [10],
"segmentiksi": [11],
"avattu": [[6,11]],
"tmx-tiedostossa": [6],
"sekä": [[6,11],5,8,[3,9]],
"javaan": [11],
"huolellinen": [6],
"segmentointisäännöstöä": [11],
"kansioonsa": [6],
"lisävariantteja": [11],
"kohdekielen": [4,11],
"resurssit": [6],
"kohdekielet": [11],
"tietovarastokansio": [6],
"putkimerkkejä": [11],
"yhteiset": [8],
"aktivoida": [8],
"määrittelemän": [8],
"sijaintia": [11,[1,4,6,8,9]],
"näkemiäsi": [5],
"järjeä": [11],
"pysyvät": [[5,11]],
"rtl-segmenteissä": [6],
"avaimen": [5],
"prosessia": [[6,11]],
"mahdollisimman": [[2,6]],
"piireissä": [11],
"avaimet": [3],
"laajentaa": [11],
"ratkaistaan": [6],
"sanoja": [11,[8,9],10],
"kokonaisen": [11],
"optionsautocompletechartablemenuitem": [3],
"lähdekielellä": [9],
"rajana": [11],
"prosessin": [11],
"kenttä": [11],
"ohjausmerkit": [8],
"ylöspäin": [11],
"krunnerin": [5],
"vilkaisemalla": [11],
"git": [6,10],
"ylimääräistä": [[5,10]],
"muita": [6,11],
"muotoisina": [6],
"senhetkisestä": [9],
"komentojen": [[5,11]],
"käyttöjärjestelmän": [[1,5,11],8],
"kymmenestä": [8],
"omegat-pikanäppäimistä": [3],
"xx-yy": [11],
"paikkaansa": [9],
"luotetuista": [11],
"prosenttisena": [10],
"tekstilaatikko": [2],
"rivejä": [3],
"jostakin": [1],
"konekääntimeen": [11],
"löytää": [11,2,[1,5]],
"omegat-tägit": [6],
"startin": [5,7],
"tiedostopäätteineen": [11],
"termi": [1,8,3,[9,11]],
"asiakirjoja": [8],
"optionsspellcheckmenuitem": [3],
"lähdetiedostoihin": [[5,8]],
"määriteltävä": [5],
"komennoissa": [5],
"avatun": [8],
"aina": [11,6,1,[3,8,9,10]],
"macissa": [[1,3,5,6]],
"tiedostosuodatin": [11],
"täytettävä": [11],
"bugeista": [8],
"optionssetupfilefiltersmenuitem": [3],
"seliti": [5],
"altgraph": [3],
"heti": [8,11],
"asiasisällön": [10],
"näyttötilojen": [6],
"vääriä": [11],
"omegat-pikanäppäimet": [3],
"osaksi": [11,9],
"muissakin": [6],
"microsoftin": [[9,11]],
"muokkaamaan": [[9,11]],
"without": [5],
"tulevia": [6],
"epäkelpoisia": [5],
"etuliitteen": [11],
"paikallisella": [5],
"xml": [11],
"niissä": [[3,5,6,11]],
"kommentti": [[1,8]],
"päättyy": [9],
"tapauksia": [6],
"xmx": [5],
"määritellä": [11,[2,4,5,6,9,10]],
"erityisiä": [6],
"käyttöliittymän": [5],
"lisensoitu": [0],
"listaan": [11],
"ponnahdusikkunan": [[8,11]],
"näppäinyhdistelmillä": [9],
"befor": [5],
"katkaisusäännöksi": [11],
"avulla": [11,5,6,[1,9]],
"tar.bz": [0],
"navigoida": [11],
"ruudusta": [[8,11]],
"oletussääntöjä": [11],
"määritelmä": [11],
"kaikki": [11,6,5,8,[4,9,10],3],
"kohtiin": [[3,11]],
"merkkimäärät": [9],
"muuttaminen": [11,6],
"käännössegmenteistä": [11],
"käyttäjät": [5,7],
"yhdistämismääritykset": [6],
"xlsx": [11],
"muotoisia": [[0,6,11]],
"erityisesti": [[9,10]],
"käyttäjän": [5,[8,11]],
"esikääntämiseen": [6],
"korjatuista": [8],
"ennallaan": [[10,11]],
"thunderbirdin": [4],
"hyödyllistä": [11,5,6],
"assembledist": [5],
"ohjelmistotiedostoja": [11],
"säännöllisinä": [11],
"pohjalla": [9],
"vierellä": [3],
"niistä": [1,[4,5,8,9,11]],
"target.txt": [11],
"kohdeasiakirjassa": [8],
"luettelo": [[7,11],[5,8]],
"kerro": [11],
"jäänyt": [2],
"käännöksessä": [6,11],
"edelliseen": [8,3,9],
"tärkeitä": [11],
"kieli": [11,5],
"tallennettu": [[1,5,8,10]],
"iso-standardin": [1],
"nameon": [11],
"asetuksissa": [11],
"hyvin": [11,[6,10]],
"lisenssistä": [8],
"varmuuskopioita": [10],
"optionsglossarytbxdisplaycontextcheckboxmenuitem": [3],
"kirjoitat": [11,[5,6,8]],
"kuinka": [11,[6,9],0,[7,8,10]],
"tietovarastoa": [6],
"gotonextnotemenuitem": [3],
"java-ajoympäristö": [5],
"osumassa": [11],
"epäkelpoisen": [5],
"ruudussa": [11,[6,8,9]],
"tar.gz": [5],
"komentosarjakieliä": [11],
"kappal": [[2,11]],
"tietovaraston": [6],
"määritelti": [[5,6,8,11]],
"kiertää": [8],
"synkronoitavana": [6],
"järjestelmissä": [5],
"aktivoituu": [8],
"asetuksista": [[6,11]],
"tehdyn": [8],
"komentoikkunan": [5],
"käyttääksesi": [[4,5]],
"sisälli": [6],
"tietokonetta": [11],
"omegat-kotisivulta": [6],
"tiedostosuodatinsetti": [11],
"käyttöliittymää": [5],
"tehdyt": [[5,6],8],
"muotoa": [11],
"azur": [5],
"vihjeitä": [4,[6,7]],
"tasaisin": [6],
"loppuun": [11],
"kohdistaminen": [11],
"po-otsakkeessa": [11],
"tavallista": [5,[6,11]],
"tietoja": [[6,8],3],
"vapaita": [[4,11]],
"segmenttiä": [11,6],
"rtl-tekstiin": [6],
"sijoitetut": [8],
"tavanomaiset": [8],
"tunteja": [6],
"muuta": [11,[4,6,9]],
"käytettäväksi": [[5,11]],
"paljolti": [2],
"lopuksi": [[1,5,6,10,11]],
"kerta": [6,11],
"kääntämättömäksi": [8],
"väliajan": [[6,8]],
"esimerkissä": [9,[4,6,11]],
"myös": [7],
"uudelleennimettävä": [4],
"ehdotus": [11],
"haettava": [11],
"käyttää": [5,6,11,4,8,[1,3],[0,9,10]],
"olevilla": [6],
"merkistökoodaus": [11,1,7],
"etävarastoihin": [6],
"omegat-käsikirja": [7],
"with": [[5,6]],
"jättämällä": [11],
"pdf": [6,8],
"käännettyjen": [11,[6,8],[5,9]],
"käyttäjäryhmältä": [6],
"tiedostoiksi": [4],
"oppinut": [5],
"välilyönti": [11,2,1],
"toolsshowstatisticsmatchesmenuitem": [3],
"viewdisplaymodificationinfononeradiobuttonmenuitem": [3],
"käännettäväksi": [11],
"välittömästi": [1],
"kohdetiedoston": [11],
"lausekkeen": [11],
"avaintoiminnot": [3],
"csv-tiedostoja": [1],
"kohdetiedostot": [[3,6,8]],
"per": [[3,8]],
"lähtökohtaisesti": [10],
"tiedostopäätteet": [0],
"osat": [6],
"osan": [11],
"tiedostopäätteen": [[1,11]],
"immuniteetista": [10],
"kielell": [5],
"kyllä": [5,6],
"hakupainiketta": [11],
"siirretään": [9],
"haluta": [6],
"osaa": [11],
"tarkastustilan": [10],
"taustalla": [11],
"projectaccesswriteableglossarymenuitem": [3],
"lukittu": [[5,9]],
"java-ominaisuudet": [11],
"kohdetiedostoissa": [11],
"muutu": [[6,11]],
"sanottuna": [[5,11]],
"lauseketta": [11],
"muuto": [10,11],
"tapahtuvan": [5],
"korvataan": [[6,8,10,11]],
"kokonaan": [11],
"docx-tiedostoja": [6],
"regexp": [5],
"tilarivillä": [[5,9]],
"numeroon": [8],
"mediawiki-sivu": [[3,8]],
"sentencecasemenuitem": [3],
"komentoikkunaa": [5],
"käyttämäsi": [5,10],
"omall": [[3,5]],
"kaikilla": [[5,11]],
"todennäköisesti": [[5,11]],
"tuttu": [11],
"tiedot": [5,11,8],
"valittavanasi": [11],
"määritetyt": [5],
"määrää": [11,5],
"kokonaismäärä": [9],
"uhhhh": [2],
"näitä": [6],
"optionssentsegmenuitem": [3],
"arvoja": [1],
"vaihtelevat": [5],
"jättämiseksi": [8],
"helpompaa": [4],
"komentosarja-ikkuna": [8],
"tarkistus": [4,[5,11],3],
"merkintää": [5],
"lausekkeet": [11,2,[3,4,7]],
"optionsaccessconfigdirmenuitem": [3],
"vanhaan": [6],
"charact": [6],
"test.html": [5],
"tiedosto2": [6],
"sanastoruudun": [8],
"vaaleanharmaalla": [8],
"päältä": [[6,8]],
"yksityiskohtaiset": [5],
"xxx": [10],
"valmiita": [11],
"erityistä": [11],
"analysoi": [2],
"myöhempien": [11],
"taivutettu": [1],
"ohjelmointityökalu": [11],
"tiedostot": [6,11,5,8,10,4,[3,9],[0,7]],
"lähimpiä": [11],
"kenttää": [4,11],
"ryhmäprojekteihin": [8],
"osuvat": [11],
"kohdekentän": [9],
"onkohan": [2],
"syntaksi": [[3,11]],
"voit": [11,5,6,9,8,4,10,3,0],
"yleisiin": [11],
"macos-herkut": [5],
"pseudotranslatetmx": [5],
"parantaa": [11],
"ennakointi": [8],
"koonnut": [9],
"neuvoja": [6],
"tällöin": [11,[4,5,6,9,10]],
"käyttöjärjestelmään": [5],
"harmaina": [11,8],
"varmistaa": [[5,8]],
"tarkistuksessa": [11],
"siirtänyt": [11],
"targetlanguagecod": [11],
"tiedostoa": [5,6,[8,10],[0,3,11],[1,4]],
"konsolissa": [5],
"vaihtoehtoisella": [6],
"projektikohtainen": [11],
"tunniste": [7],
"sopivia": [[3,4,8,11]],
"käytettävästä": [1],
"tiedoston": [11,8,6,5,[0,1,9,10]],
"pääsalasanan": [11],
"sijaintiin": [[6,11]],
"toinen": [[3,4,5,9]],
"painettuja": [9],
"ohitetaan": [11,3],
"haluamasi": [[4,5,6,8,9]],
"erityistapaus": [6],
"alikans": [[10,11]],
"poistetaan": [11,10,8],
"välilehdill": [9],
"kauppapaikall": [5],
"sisältää": [10],
"oikoteiden": [5],
"merkkeinä": [8],
"määrät": [8],
"ant-syntaksin": [11],
"osia": [[9,11]],
"laatija": [11],
"oikeassa": [9,0],
"uudessa": [8],
"pikavalikon": [11,1],
"pienten": [11],
"kolm": [0,[1,6]],
"määrän": [11,4],
"etsitään": [11],
"kääntänyt": [6,[4,9,11]],
"haluttua": [0],
"sanastoihin": [1],
"vihreällä": [9],
"tallennu": [10],
"mieleiseksesi": [5],
"jätettävä": [6],
"vanha": [6],
"tulaa": [5],
"identtisen": [10],
"encyclopedia": [0],
"löydöksiä": [11],
"tallenna": [[6,11],[3,5,8]],
"identtiset": [6],
"koko": [[5,11],[8,9],[3,6,10]],
"kokoelmien": [11],
"muotoiset": [1],
"segmentteinä": [11,8],
"nelinumeroinen": [6],
"työkäännösmuisti": [10],
"projekti": [6,8,11,5,10,3,[0,1,4,7,9]],
"muissa": [5,[1,6]],
"optionstagvalidationmenuitem": [3],
"avataan": [6,11,[1,5]],
"mahdollisesti": [5,[6,10,11]],
"väliset": [11],
"käyttöjärjestelmiin": [5],
"osassa": [[6,9]],
"pt_br": [4,5],
"tilassaan": [6],
"gitistä": [6],
"käännösmuistiosumat": [11],
"a-z": [2],
"käännetään": [11,5],
"segmentti": [11,8,9,10],
"vierität": [11],
"käsin": [11,[1,4,6]],
"vaihtoehtoisia": [11,8],
"selitykset": [1],
"oletettu": [[1,7]],
"vaununpalautusmerkki": [2],
"tavalliset": [[8,11]],
"kuvattuun": [8],
"muista": [[1,8,9]],
"eivät": [11,10,[1,3,5]],
"ajaa": [5],
"käännösmuistitiedoston": [11],
"tieltä": [11],
"uudell": [11],
"erikseen": [6,[4,8]],
"imperatiivista": [11],
"tiedostonimiä": [11],
"lähdetiedoston": [11,6],
"javascript": [11],
"gitissä": [6],
"sisältö": [3,[8,11],[0,5,6,10]],
"työkalut": [[8,10,11],[3,7]],
"lokalisointi-insinööri": [6],
"jatka": [11],
"input": [11,6],
"kuitenkin": [11,5,6,4],
"kohdekielisen": [[0,8,11]],
"lähdetiedostot": [6,[3,8]],
"vastoin": [[6,11]],
"projektikansio": [[6,10],[7,9]],
"muokannut": [3],
"komentorivivaihtoehto": [5],
"kirjainmerkkejä": [8],
"projektia": [11,[6,10],[1,5,8]],
"api-avain": [11],
"tekstihaku": [11,7],
"poi": [11,6,8],
"sisällön": [11,[5,8,10]],
"uusien": [6],
"found": [5],
"virheilmoitus": [[5,6]],
"erilainen": [9],
"projektin": [6,11,8,5,[3,9,10],1,4,7,0],
"lähdetiedostoja": [11,6],
"tiedostomuodoissa": [11,6],
"yläpuolella": [11],
"osumia": [11,[2,8],[6,9]],
"ltr-tekstiä": [6],
"joudu": [11],
"yhdistämällä": [11],
"korjata": [11],
"lisäkriteerejä": [11],
"koon": [11],
"muun": [11],
"googl": [5,11],
"muut": [6,11,5,[7,9,10]],
"sisällöt": [6,11],
"näkyviin": [8,11,[5,10],[1,9]],
"tuetaanko": [5],
"omien": [3],
"download.html": [5],
"tallennusta": [6],
"olosuhteissa": [6],
"ylemmän": [11],
"sopivat": [6],
"kohdistimen": [8,11,9],
"konekäännö": [[8,9,11]],
"tekstitiedostojen": [11],
"arvo": [11],
"joskus": [11,6],
"tavanomaista": [11],
"erittäin": [11,6],
"lueminut-tiedoston": [5],
"menetyksen": [6,7],
"hae": [11,8],
"kosk": [11,5],
"saksalaisen": [11],
"sopivaa": [4],
"vokaalilla": [2],
"tila": [11,[8,9]],
"sopivan": [11],
"viittaavat": [9],
"käännös": [8,11,9,3,1,[5,6,10]],
"tekstiekstielementit": [6],
"editmultipledefault": [3],
"tiedostonimeä": [11],
"mozilla": [5],
"kohdeteksti": [[6,8,11]],
"editfindinprojectmenuitem": [3],
"suodattimissa": [11],
"avain–arvo-tekstipareja": [11],
"warn": [5],
"sanakirja": [4,[9,11],[7,8]],
"etätiedosto": [6],
"luettavissa": [6],
"segmentoi": [11],
"technetwork": [5],
"lainsäädäntö": [6],
"välilyöntiä": [11],
"korjaus": [4],
"kulkuun": [9],
"plural": [11],
"suodattimista": [11],
"windowsissa": [5],
"yhdistettävä": [6],
"asiakirjasta": [8],
"vapaata": [8],
"tarpeen": [6],
"asiakirjassa": [11,6],
"näkyvill": [[8,11]],
"täsmällisessä": [11],
"tarkistettava": [9],
"laus": [[6,11]],
"käännösten": [[6,11],9],
"sinull": [[2,5,9,11]],
"kokotekstin": [9],
"unohtanut": [0],
"tarkistaa": [11,6,10],
"koti": [6],
"varoitus": [11,6],
"identtisiä": [10],
"alaosassa": [11,[3,9]],
"firefoxin": [[4,11]],
"hollanninkielisten": [6],
"yhtäläiset": [4],
"colour": [11],
"n.n_windows.ex": [5],
"tiedostonhallintaohjelmaa": [4],
"paikalliseksi": [6],
"käytännöllisten": [5],
"windows-käyttöjärjestelmän": [5],
"vastaavassa": [11],
"kaikkien_omegat-ryhmaeprojektien_tietovarasto": [6],
"nimetään": [[6,11]],
"samanaikaisesti": [11],
"omiin": [9],
"numeroa": [[8,11]],
"listan": [11,[4,6]],
"tallentamaan": [9],
"luoviin": [11],
"lähdetiedostoon": [6],
"vähenni": [2],
"tulevaa": [11],
"sisällä": [[6,9]],
"program": [5],
"merkkiä": [11,5,2],
"yhteensopiva": [5],
"hen": [[6,8]],
"neuvoa": [6],
"tiedostosijainnit": [11],
"määrität": [1],
"englanti": [6],
"löytyneiden": [10],
"lausekkeena": [11],
"käytetään": [11,6,1,5,[2,3,4,10]],
"saanut": [[8,11]],
"numerot": [11,9,6],
"elektroniset": [9],
"tiedostonimen": [11],
"pdf-tiedostoja": [6],
"tiedostosuodattimien": [11],
"projektikielien": [11],
"lisääminen": [5,[6,11]],
"käännösyksikköä": [10],
"lainaa": [2],
"asettuu": [5],
"lähdekoodin": [[5,6]],
"pitkistä": [11],
"tulevat": [11,10,[2,8]],
"n.n_mac.zip": [5],
"koodauksia": [11],
"laisiksi": [11],
"kirjainta": [11],
"tiivistelmä": [7],
"sopii": [11],
"odf-asiakirjat": [11],
"jokainen": [3],
"käyttäjäll": [[9,11]],
"koodi": [3,11],
"omegat-asennuksesi": [5],
"sanastotermejä": [1],
"erikoistermejä": [9],
"päästäksesi": [[6,11]],
"näkymä": [[8,11],[1,3,7]],
"paikallisten": [6,11],
"tiedostopäätteenä": [9],
"pudotettu": [9],
"sinisinä": [11],
"tekstimuotoilutägit": [11],
"esimerkiksi": [11,5,9,[2,4,6],10,[0,3,8]],
"osumat": [8,11,[2,9],6,[7,10]],
"theme": [11],
"osuman": [9,11,8,[3,10]],
"näyttävän": [8],
"muutettujen": [11],
"exe-tiedosto": [5],
"lausetasolta": [11],
"käytettävät": [[0,11]],
"pseudotranslatetyp": [5],
"tiedostopäät": [[0,1],11],
"tyhjätilamerkkiä": [11],
"näyttävät": [[6,9,11]],
"editoriin": [11],
"osumaa": [9,[2,10,11]],
"lähtevän": [11],
"kirjainten": [11],
"huomioida": [11,8],
"aavistuksen": [11],
"pudotetut": [9],
"listaa": [11],
"lyhennetti": [11],
"projektikansioista": [6],
"asennetaan": [0,[7,11]],
"tällainen": [[6,11]],
"käytettävän": [4,[1,5,11]],
"tänne": [10],
"tulevill": [10],
"vaihtoehtoisen": [11],
"ilmaus": [11],
"vapaana": [9],
"monikkoon": [1],
"alkukirjaimen": [8],
"vihreä": [8],
"projectclosemenuitem": [3],
"yhdistelmiä": [5],
"kohdekieliseen": [1],
"vaihtoehtoiset": [11],
"useampia": [[2,4,8,10,11]],
"tavallisin": [11],
"viewmarknonuniquesegmentscheckboxmenuitem": [3],
"alkukirjaimet": [8],
"tekninen": [11],
"tiedostomuotojen": [8],
"monista": [6],
"ulkoisia": [8],
"nykyiunen": [6],
"sumeita": [11,[8,10]],
"group": [9],
"kopioivat": [6],
"findinprojectreuselastwindow": [3],
"ylätunnisteessa": [11],
"käytettyjen": [[2,6,7]],
"tm-kansio": [6],
"readme.txt": [6,11],
"puuttuva": [[3,8]],
"samankaltainen": [9],
"argumenteista": [5],
"aiemminkin": [6],
"tavallisia": [1,[7,11]],
"source.txt": [11],
"väärin": [[1,4,8,11]],
"monissa": [6],
"kentässä": [11],
"files.s": [11],
"merkkejä": [11,[2,9]],
"yli": [11],
"exchang": [1],
"kommenteista": [11],
"hyväksytyn": [11],
"request": [[5,8]],
"todennäköisimmän": [9],
"currseg": [11],
"pienemmistä": [11],
"haluavat": [[2,6]],
"muihinkin": [6],
"lisäkäännösmuistista": [10],
"kohdall": [8,9,[1,5]],
"espanja": [4],
"tuettujen": [8],
"point": [11],
"sisältöä": [11,6,[5,10]],
"apuna": [6],
"segmentointisääntöihin": [11],
"ilmaisu": [11],
"lisäkäännösmuistissa": [10],
"ohjeet": [8,[6,7]],
"tiedostoilla": [6],
"käyttäviä": [11],
"järjestelmät": [5,[7,11]],
"numerosarjoista": [9],
"ulkoisen": [11],
"mainituista": [1],
"sinua": [11],
"järjestelmän": [11,3],
"hyödyntäminen": [6,7],
"alikansioita": [[10,11]],
"downloaded_file.tar.gz": [5],
"ikoni": [5],
"poikkeussääntö": [11],
"varmistusta": [8],
"sinun": [5,6,4,10,11],
"käännösehdotuksineen": [9],
"kopioitava": [5],
"oletusarvoihinsa": [11],
"ulkoiset": [11,[3,8]],
"asennettiin": [5],
"näppäimistön": [[3,11]],
"account": [[5,11]],
"en-us_de-projekti": [6],
"omaan": [6],
"hakuikkuna": [8,11],
"hakukriteerejä": [11],
"tägeineen": [11],
"esikatselussa": [11],
"bak-tiedostot": [6],
"dhttp.proxyhost": [5],
"kokonaisista": [6],
"käännösmuisteihin": [11],
"asteriski": [11],
"kakkospainikkeella": [9,[5,11],[4,8]],
"näkyvissä": [11,8],
"auto-kansioon": [6],
"valikkoineen": [5],
"tallennetaan": [[6,11],[1,8,9]],
"jätettävissä": [6],
"oletusarvoisen": [11],
"lihavoitu": [[9,11],1],
"pääikkunan": [9,7],
"rivilleen": [3],
"toimiva": [6],
"varmistus": [8],
"useista": [1],
"kaksisuuntaisiksi": [6],
"ftp-palvelimell": [11],
"ainostaan": [5],
"loppu": [2],
"configur": [5],
"näkyvistä": [8],
"sijainnista": [11],
"hiljaisessa": [5],
"siirryt": [9],
"enforce-kans": [10],
"alikansioissa": [1],
"kutsutaan": [[5,6,11]],
"yksinkertainen": [2],
"simpledateformat-muodoista": [11],
"sanakirjoja": [0,[4,6,7,9]],
"lähdetiedostoissa": [11],
"säännöllinen": [2],
"erillinen": [6],
"lähdeasiakirjasta": [6],
"optionsworkflowmenuitem": [3],
"kakkostasolla": [6],
"käännössegmenttien": [8],
"lisäykset": [11],
"sijainnissa": [5],
"releas": [6,3],
"atiivisen": [11],
"pääsyä": [[5,6]],
"maist": [11],
"tuettuja": [5],
"sparc": [5],
"annat": [5],
"alikansio": [10,11],
"pyytää": [6,[5,11]],
"muutettu": [[3,8,11]],
"kaikkiin": [11,[3,6,10]],
"projektipäällikkö": [6],
"lähdeasiakirjassa": [8],
"sijasta": [[3,5]],
"interaktiivisia": [2],
"jotta": [6,11,5,10],
"käännät": [6,[8,9,11]],
"sidottujen": [11],
"editoriruudun": [[8,11]],
"salasana": [6],
"useampaa": [11],
"muuntonäppäin": [3],
"versiohallintaan": [6],
"muodot": [11],
"valintaikkunassa": [10,[1,6]],
"vartaloltaan": [11],
"tarvitsemasi": [5],
"tunnetaan": [11],
"sanojen": [2],
"ensi": [6],
"subdir": [6],
"projektikansioiden": [6],
"japanin": [11],
"yandex-tili": [5],
"asiakasta": [6],
"oleva": [5,[8,9],[2,11],6,[3,10]],
"tiedostopäätteell": [11],
"koodinvaihtomerkki": [2],
"näistä": [9],
"samall": [6,11],
"ylös": [11],
"sekuntia": [11],
"tiivistä": [11],
"olleen": [9],
"täytetyt": [[3,8,11]],
"komentorivill": [5],
"muodon": [11],
"kysyy": [[5,11]],
"vaihtamista": [11],
"windows-käyttöjärjestelmiin": [5],
"varotoimista": [6],
"suosittujen": [11],
"file-source-encod": [11],
"vahvista": [8],
"uusi": [11,6,8,4,[1,3,5]],
"kuitenkaan": [6,11],
"näissä": [6],
"toistuva": [[9,11]],
"valittuna": [8,11],
"nuolikuviota": [11],
"virheen": [[5,6,8]],
"ei-ahneet": [2,7],
"poistamalla": [11,5],
"tuottanut": [8],
"asennustoimintoa": [4],
"mihinkään": [9],
"kaikkien": [11,9,[5,8]],
"haluaa": [11],
"käännösmuistitiedostoon": [6],
"editexportselectionmenuitem": [3],
"käännettyyn": [8,[3,11]],
"tietokoneellesi": [6],
"näyttötilan": [6],
"oikealla": [[1,5,8,11]],
"laadunvarmistustyökalu": [8],
"käännettäessä": [11],
"haluat": [11,6,5,3,[1,2,4,9],[8,10]],
"projectaccesstargetmenuitem": [3],
"resursseja": [6],
"näyttötilaa": [6],
"kaksikieliseen": [6],
"pitää": [11,[6,10],[4,5]],
"opendocument-tiedostoja": [11],
"sanaraja": [2],
"merkkitaulukon": [11],
"yläosassa": [11,9],
"mukaan": [6,11,[2,5,9]],
"kysyä": [6],
"edellinen": [8,[3,6,11],[0,1,2,4,5,9,10]],
"moneen": [11],
"mutta": [6,11,1,2,[4,9],[5,8]],
"aligndir": [5],
"muodossa": [10],
"regex-työkalut": [2,7],
"system-host-nam": [11],
"syötetään": [5],
"action": [8],
"nopeuttaa": [6],
"oletuskoodaus": [1],
"progressiivisesti": [11],
"creat": [11],
"mukauttaa": [11],
"es_mx.dic": [4],
"sisäinen": [[8,10,11]],
"käännösmuistiosuma": [10],
"sataprosenttinen": [[9,10]],
"tapa": [5,11],
"infix": [6],
"muistin": [5],
"lyhenteiden": [11],
"pisteellisen": [11],
"painat": [[8,11]],
"tarbal": [0],
"saneistimet": [11],
"kunkin": [11],
"välityspalvelinyhteyteen": [5],
"docx-tiedostot": [11],
"koostuu": [10],
"target-kansioon": [[10,11]],
"pikänäppäinten": [3],
"alivalintoja": [8],
"näytä": [3,11,8,[5,10]],
"hakumenetelmä": [11],
"asetuksiin": [8],
"ehdotuksia": [[8,11],3],
"oletuskäännökseksi": [[8,9]],
"koostua": [1],
"määritä": [6,[7,11]],
"rajoittimet": [2,7],
"file": [11,5,6],
"ladataan": [[6,8],11,0,7],
"segmentin": [11,9,10,[3,5,8]],
"tekstisuodatin": [11],
"kääntämättömän": [9],
"segmentit": [11,8,3,[9,10],[5,6]],
"menu": [9],
"omaprojekti": [6],
"merkkiluokat": [[2,7]],
"muutamatta": [11],
"sanavartaloita": [3],
"rivinvaihtojen": [11],
"jolla": [6,11],
"päätä": [10],
"muodosta": [6],
"ylimmän": [[10,11]],
"vierityspalkki": [11],
"a-za-z": [2,11],
"muuttujilla": [11],
"mene": [[9,11],[1,3],[6,8]],
"kääntämättömät": [11,8,[3,6]],
"tekemäsi": [5],
"paljastaa": [5],
"nykyinen": [[3,8]],
"muodostuu": [5],
"merkkitaulukko": [[3,11]],
"käyttäytymistä": [5],
"salasanat": [11],
"tunnistetaan": [[1,11]],
"ennen": [11,6,5,[8,10],[4,9]],
"ltr-tilojen": [6],
"source-pattern": [5],
"kaikista": [[8,11]],
"salasanan": [11],
"versionhallintajärjestelmään": [6],
"avain–arvo-pareja": [11],
"lähdekielenä": [6],
"vieressä": [11,[8,9]],
"muokkauskentän": [[9,11]],
"suodattimien": [11],
"samantapaisia": [11],
"sivunvaihto": [11],
"lähdesegmentti": [9,8],
"näppäinkomennoilla": [9],
"salasanaa": [11],
"yhdistävät": [6],
"alleviivata": [1],
"gitin": [6],
"lähdekansio": [5],
"tägiksi": [11],
"kokoamaan": [6],
"tiedostoasetusten": [11],
"true": [5],
"haluatko": [5,8],
"lähdeasiakirjoissa": [11],
"käännösmuistitiedostoja": [6],
"numeroihin": [9],
"writeriin": [6],
"määriti": [[5,6,11]],
"groovi": [11],
"pääteikkunan": [5],
"värit": [11,[3,8]],
"tallentanut": [[5,8]],
"vaikka": [11,[5,6,8,10]],
"samaan": [[6,11],5],
"useissa": [[5,11]],
"kohdedatan": [5],
"muistia": [5],
"painaa": [11],
"steri": [11],
"loppuviitteet": [11],
"pääsi": [[6,11]],
"kyseessä": [6],
"tiukkoja": [6],
"pääse": [10],
"sanakirja-toimintoa": [0],
"yhdistämisparametrit": [6],
"kirjainkoosta": [2],
"asennuksen": [5,9],
"piirrokset": [11],
"tsv-tiedostoja": [1],
"ladattava": [11],
"luominen": [6,[5,11]],
"sotk": [6],
"olevalla": [[6,9]],
"vahvistusta": [11],
"poikkeussäntöjä": [11],
"kohdekielenä": [[4,6]],
"fontin": [8,11],
"käynnistysohjelmaa": [5],
"rakenteellisiksi": [11],
"master": [6],
"kmenuedit": [5],
"pääte": [[5,11]],
"huomaathan": [[5,11]],
"xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx": [5],
"asetettu": [4,11],
"toimi": [4],
"käännöstyö": [6],
"väriteemoja": [11],
"sivun": [[3,8]],
"kohdekielenäsi": [4],
"toimii": [11,8,5,[6,9,10]],
"laajuisesti": [8],
"toiminnot": [9,5],
"kenoviivamerkki": [5],
"tiedostomuotoihin": [9],
"meta-tägejä": [11],
"astuvat": [11],
"konteksti": [11],
"komentoja": [11],
"yhtä": [11,8],
"tausta": [8],
"asti": [2],
"pakollinen": [[1,11]],
"windows-käyttöjärjestelmissä": [5],
"kieliasetuksia": [4],
"polkunimessä": [6],
"katkaisusääntö": [11],
"java-ohjelmointikielen": [2],
"muutettuja": [5],
"rtl-asiakirjojen": [6],
"löydi": [8],
"tiedostonimi": [[6,11]],
"jätä": [11],
"komentosarjaympäristössä": [5],
"tbx-muotoisina": [11],
"applescriptiä": [5],
"segmentoituu": [11],
"tekstimuotoiluja": [6],
"kirjaimia": [11],
"alkuvaiheessa": [5],
"omegat-sivuston": [6],
"muistaa": [8],
"sekalaista-osassa": [11],
"kovin": [11],
"user.languag": [5],
"regex": [2,7],
"pois-jätettävä-kansio": [6],
"lausekekuviota": [11],
"meta": [3],
"keystrok": [3],
"juuressa": [5],
"sovi": [9],
"esiintymä": [11],
"sanasto-osumat": [[1,11]],
"oletussanasto": [1,7],
"tekstinvientitoiminnon": [11],
"segmentointisäännöt": [11,10],
"mihin": [[5,9]],
"tavallisessa": [5],
"loppumerkki": [9],
"täsmähaku": [11],
"regex-testeri": [[2,7]],
"erityistoiminto": [8],
"riippuen": [5,[8,9],11],
"juuri": [[3,4,8,11]],
"ohita": [11],
"sijainniksi": [5],
"syaani": [8],
"segmentointisääntöjä": [11,[2,6]],
"tiedostosuodattimia": [11],
"purkaa": [0],
"oikotiet": [5],
"omegat-ikoniin": [5],
"välilyöntinäppäintä": [11],
"groovy-kielinen": [11],
"segmentteihin": [11,9],
"kaikissa": [8,[3,6,10,11]],
"oikeita": [10],
"lähdekansioista": [6],
"ibm": [5],
"pt_br-sanakirjoja": [4],
"suodattimia": [[5,6,11]],
"muutoin": [6],
"lausetason": [11],
"komentojonossa": [5],
"käännösmuistiin": [6,[9,10,11]],
"työhösi": [5],
"suojaa": [11],
"sanaa": [8,[2,4,9]],
"jälken": [5],
"sisäisellä": [11],
"alkava": [11],
"valikkoon": [11,[1,5]],
"alkuperöiseen": [6],
"rakentaminen": [5,7],
"toistuisivat": [11],
"palveluja": [5],
"kirjainkokoa": [3,8],
"löydä": [6],
"nl–zh-käännöksen": [6],
"kerrallaan": [11,8],
"käännettävässä": [[1,9]],
"sanan": [11,[2,5,8],4],
"sanat": [11,9,2],
"niiden": [11,[6,10],2,[1,5,7,8]],
"poisjätöt": [6],
"omegat-editorissa": [11],
"näyttämään": [5],
"tiedostoista": [11,[4,10]],
"test.html-tiedostot": [5],
"käyttäjänimeä": [11],
"oletusarvona": [[6,11]],
"asiakirja": [6],
"tiedostosuodattimen": [11,6],
"sanastot": [1,[0,3,4,7,10]],
"nuolinäppäin": [11],
"sanaston": [11,1,[3,8,9]],
"project_save.tmx.vvvvkkppttmm.bak": [6],
"sellaisen": [11],
"asettaa": [[3,8,9,11]],
"tietenkään": [9],
"tiedostosuodattimet": [11,8,[3,10]],
"joten": [11,6,5],
"mediawikistä": [11],
"kirjaimet": [3,5],
"auto-kans": [[8,10]],
"haluamassasi": [5],
"idx": [0],
"ryhdyt": [6],
"kmenueditor-ikkunassa": [5],
"yläkulmassa": [9],
"seuraa": [[2,6],5],
"valmi": [11],
"palautuvat": [6,[9,11]],
"projectaccesscurrentsourcedocumentmenuitem": [3],
"lopussa": [11,2],
"linux": [5,[2,7,9]],
"pätkän": [8],
"segmenttejä": [11,[8,9],10],
"onkin": [11],
"käynnistyksen": [5],
"editoriruudull": [11],
"seuraavaan": [8,[3,11],9],
"odt-tiedostoja": [6],
"suodattimen": [11],
"suodattimet": [11],
"versiota": [[5,8]],
"segmentointisäännöstösi": [11],
"käännösmuistien": [6,[5,7,10,11]],
"ifo": [0],
"kehittämiseen": [2],
"muutettua": [5],
"käännösvaihtoehtoja": [8],
"vanhvista": [5],
"rohkeasti": [6],
"tiedostoissa": [11,10],
"väh": [11],
"kenoviiva": [2],
"sanasto-osumia": [1],
"kääntäjää": [6],
"alaviitteet": [11],
"nähdä": [6],
"käännettynä": [9],
"xx.docx": [11],
"suodatinsääntöjä": [11],
"käännöstoimistolta": [9],
"avutuu": [11],
"tehokkaita": [2],
"vahingossa": [6],
"hakuresurssit": [11],
"kaksisuuntaisen": [8,3],
"optionsautocompleteautotextmenuitem": [3],
"ohittaa": [11],
"erikoisia": [6],
"versioon": [5,8],
"hakutulosten": [11],
"kirjoituskelpoisen": [8],
"järjestystä": [11,9],
"osana": [[4,9]],
"muilla": [6],
"sekoittaa": [11],
"sattavilla": [8],
"valinnalla": [8,3],
"otti": [11],
"löytämänsä": [11],
"joitakin": [[5,6,8,11]],
"concis": [0],
"customer-id": [5],
"haetaan": [11],
"jakaa": [11,6],
"täydessä": [0],
"objektimääritteet": [11],
"yksityiskohtaista": [11],
"fuzzy-merkkiä": [11],
"konekäännöksellä": [8,3],
"puuttuvien": [9],
"term.tilde.com": [11],
"samankokoiseksi": [9],
"sisällössä": [6],
"annettuja": [6],
"asettelua": [11],
"mikäli": [[5,8],11,6],
"saatuja": [11],
"liitännäiset": [11],
"ltr-merkkijonojen": [6],
"nettisivuilla": [10],
"muuttunut": [[6,11]],
"monilla": [11],
"samannimistä": [[0,4]],
"viewmarknotedsegmentscheckboxmenuitem": [3],
"vaatia": [[8,9]],
"asettelut": [11],
"fontti": [[3,8,11]],
"kirjoitetaan": [8,[5,6,9,11]],
"pitkät": [11],
"vaatii": [5,6],
"löydö": [11],
"ryhmäprojektitoiminto": [6],
"käyttöliittymäasetukset": [10],
"kolmosvaihetta": [10],
"julkaistava": [6],
"gotomatchsourceseg": [3],
"jotka": [11,5,[1,6,8,10],[2,4,9]],
"kielikuvio": [11],
"lisätietoa": [10,[5,9,11]],
"lähdesegmentin": [9,11,[1,8]],
"optionssaveoptionsmenuitem": [3],
"excel": [11],
"oltavat": [11],
"comma": [1],
"writerissä": [6],
"olen": [11],
"lisättäessä": [11],
"runn": [11],
"teeman": [11],
"olet": [11,5,[6,9],4,10,[0,3,8]],
"lähdesegmentit": [[3,5,8]],
"stardict": [0],
"omegat.l4j.ini": [5],
"upottaa": [6],
"span": [11],
"ongelma": [1],
"näytetyt": [9],
"pitäisi": [11,[0,5]],
"nykyisestä": [11],
"käännettyjä": [[6,11],10],
"mukana": [11,5,[6,8]],
"tuotenimiä": [9],
"valitaan": [9],
"valikosta": [11],
"tavallisesti": [5,11,6],
"omegat-projektiin": [6],
"kielikoodia": [[4,5]],
"toivotun": [11],
"lisätietoja": [9,5],
"seraavaa": [2],
"kielikoodit": [4],
"editselectfuzzy3menuitem": [3],
"omegat-etäprojektista": [8],
"käynnistyskomentoa": [5],
"olevista": [11,10,[3,5,6,8,9]],
"vapaasti": [0],
"doc-tiedosto": [6],
"kielikoodin": [4,11],
"lisäämällä": [[5,10,11]],
"fals": [[5,11]],
"project.projectfil": [11],
"lisää": [11,6,8,[3,5,9],1,2],
"java-ympäristöihin": [5],
"tilaan": [9],
"rakenteen": [11],
"git-tietovarasto": [6],
"kaiken": [[9,10]],
"järkevämpää": [4],
"nolla": [2],
"poikkeus": [11],
"ikoniksi": [5],
"ulkonäöll": [11],
"uuden": [11,6,5,8,[1,2,3]],
"järjestyksessä": [11,[9,10]],
"komentosarjakielet": [11],
"käännösluonno": [11],
"uudeksi": [6],
"shortcut": [3],
"tarvitse": [6],
"uudet": [1,[3,8],11],
"termejä": [1,[3,11]],
"sanoina": [8],
"toisistaan": [[1,10]],
"pikakäynnistyspalkkiin": [5],
"ilmoittaa": [6,[5,11]],
"pt_br.aff": [4],
"tmx2sourc": [6],
"kokeilla": [[6,11]],
"päälle": [5,[8,9]],
"oikealta": [6,7],
"funktionaalista": [11],
"tietokoneell": [5],
"kääntäjät": [6],
"asiantuntijoilta": [9],
"muotoilutägit": [11],
"kääntäjän": [6],
"dhttp.proxyport": [5],
"valikossa": [11],
"versioll": [5],
"tilastot": [3,[6,8,10]],
"mitkä": [11],
"etsii": [11,[2,9,10]],
"oletustilaan": [9],
"projektinnimi-omegat.tmx": [6],
"maininta": [11],
"subrip": [5],
"huolehtia": [6],
"edistyessä": [10],
"etsit": [11],
"kohdistinta": [9],
"sijainnin": [6,[5,8]],
"muiden": [11],
"omegat-istuntoa": [8],
"score": [11],
"niin": [11,[6,8],9,5,1,[2,3,4]],
"termivastaavuuksia": [1],
"kerralla": [8],
"valinnat": [11,8,[4,9],[2,3,6,7,10]],
"valinnan": [11,[8,10]],
"vientikäännösmuisteista": [6],
"lyhyesti": [2],
"olla": [11,6,[1,3],9,[5,8,10],2],
"tiedostopäätettä": [11],
"sallii": [5],
"raw": [6],
"käyttöön": [5,11,8,[3,4],[2,6,9,10]],
"värisenä": [11],
"huolehtii": [6],
"muistathan": [11],
"pikanäppäimien": [3,7,2],
"lauseittain": [11],
"komento": [5,6,[3,11]],
"varustettuina": [11],
"lähdekansioon": [[3,6,8]],
"tapauksissa": [11,6],
"poikkeukset": [11],
"aaa": [2],
"vetämällä": [[5,9]],
"segmentointiin": [11],
"tyhjiltä": [11],
"contemporari": [0],
"solari": [5],
"toimivat": [[6,11]],
"painikkeita": [11],
"alkaa": [11],
"projektiasetuksia": [6],
"samoin": [11],
"osumina": [10],
"omegat.project-tiedostosta": [6],
"prosenttiset": [10],
"tyhjät": [11],
"tyhjän": [[6,8,11]],
"liitä": [9],
"samoja": [11,5,[4,6,9]],
"abc": [2],
"rcs": [6],
"toimintonäppäimen": [3],
"muokkaustavasta": [9],
"pieniä": [11],
"osumaruudun": [[7,8,9,11]],
"kansiosta": [[1,6,8,10,11]],
"vientikäännösmuisteina": [6],
"smalltalkista": [11],
"käsitetään": [11],
"lauseista": [11],
"kyse": [11],
"kansiossa": [5,10,[0,1],11,6,8],
"oletussanastoon": [1],
"svg-tiedostoja": [5],
"parempi": [11],
"merkistökoodaukset": [11],
"katkaisusääntöä": [11],
"merkistökoodauksen": [11],
"törmäät": [6],
"oikean": [6],
"iso": [2],
"oikeat": [[4,6]],
"olevassa": [11,[4,9],6],
"ponnahdusvalikossa": [[9,11]],
"kansion": [5,6,[8,10],11],
"komentoriviä": [5],
"lihavoitua": [9],
"kuukaudessa": [5],
"dictionaryn": [[0,7]],
"riviltä": [10],
"päivityksistä": [11],
"glossary.txt": [6,1],
"omegat-kansiossa": [11],
"seuraavasta": [5],
"kansiot": [6,[10,11]],
"jokerimerkkien": [11],
"boolen": [11],
"sääntöä": [11],
"tiedostosijainnilla": [5],
"pdf-tiedostoiksi": [6],
"seuraavasti": [3,11],
"add": [[5,6]],
"editorissa": [11,[5,8]],
"näkyy": [11,9,6,1,8,10],
"nimi": [11,[6,8,9],5],
"kohdeasiakirjan": [[6,8]],
"olevasta": [[10,11]],
"oleviin": [9],
"alimpana": [11],
"its": [6],
"vapaa": [7],
"etävarastoon": [8,6],
"kasvattaa": [11],
"määritettyjä": [11],
"päivittää": [11,[1,5]],
"kohdeasiakirjat": [8,[6,11]],
"rfe": [8],
"seuraavassa": [[3,5,9,11]],
"optionsautocompleteshowautomaticallyitem": [3],
"lopetusvahvistusta": [[3,11]],
"juoksevat": [6],
"isot": [[3,5,8]],
"orposegmenttejä": [11],
"päivitetti": [11],
"tekstiyksikköjä": [11],
"tarkkailla": [11],
"asennuskansiosta": [11],
"tiedostomuoto": [1,7],
"larouss": [9],
"mielestäsi": [11],
"ladattaessa": [11],
"tarkistavat": [[5,11]],
"untar": [0],
"pisteellisten": [11],
"sisältävät": [11,6],
"nl–en-käännösmuistia": [6],
"tietojen": [6,7],
"konekäännöspalvelua": [8],
"firefoxissa": [[4,11]],
"sisältävän": [[5,9]],
"filters.conf": [5],
"segmenttien": [11,[8,9],10],
"avaamaan": [3],
"hakemiston": [11],
"editorin": [11],
"erinomaisesti": [6],
"koneen": [11],
"palauta": [9,[3,11]],
"linkit": [11],
"leikkaa": [9],
"osumiin": [10],
"id-vertailu": [11],
"työkaluja": [2],
"näe": [9],
"jätetäänkö": [5],
"mieluummin": [6],
"näi": [11,[1,9,10]],
"clone": [6],
"konekäännöspalvelut": [8],
"targetlanguag": [11],
"komenntosarjaki": [11],
"ykköspainikkeella": [11],
"teknologia": [5],
"liimaa": [8],
"ajamiseen": [5],
"editselectfuzzyprevmenuitem": [3],
"esimerksiksi": [11],
"number": [11],
"saada": [[5,11]],
"pieninä": [8],
"sovelluksessa": [6],
"aloittaman": [2],
"määritellään": [[3,11]],
"sanakirjatietueiden": [[8,11]],
"asetteluun": [9],
"käynnistyskomennon": [5],
"olevien": [11,5],
"määrittäminen": [6],
"pakko": [5],
"commentit": [11],
"alareunassa": [9,[8,11]],
"script": [11],
"soveltuvuus": [11],
"kohdekielialuetunnus": [11],
"system": [11],
"kansioon": [5,10,11,[4,6,8,9],1],
"käännösapuna": [6],
"valinta": [11,8,5,3],
"valikkoihin": [5],
"kadottanut": [6],
"other": [5],
"häviävät": [6],
"palvelimen": [6,11],
"kello": [2],
"tägivirheet": [[6,8]],
"lyhenteen": [11],
"koodausmaininnan": [11],
"local": [6,5],
"toisinpäin": [11],
"meksikon": [4],
"tulosten": [2],
"kohdesegmenteistä": [11],
"segmentointisääntöjen": [11,6],
"jonkin": [[4,9]],
"senhetkisistä": [11],
"vierittämään": [11],
"kotikansiosta": [5],
"kiertoteits": [6],
"dokumenteissa": [11],
"vastaavien": [11],
"pääikkuna": [9,[3,11]],
"muunnetut": [11],
"espanjan": [4],
"pääset": [11,[8,9],[3,5,6]],
"kertyy": [6],
"source-kansiossa": [[10,11]],
"sovellusta": [6],
"esitetään": [11,10],
"virallinen": [7],
"kohdan": [11,3,5],
"projektitilastot": [8],
"kohdat": [8,[6,11]],
"kaikkia": [11,[2,6,9]],
"muokata": [11,[5,6],[8,10]],
"pääsee": [6],
"kuviot": [6],
"sisältävä": [[5,10]],
"pienet": [[3,5,8]],
"asiakirjaan": [11],
"es_mx.aff": [4],
"kielissä": [6],
"isolla": [11],
"senhetkisell": [8],
"suositaan": [11],
"perusmuotoinen": [4],
"kolmeksi": [6],
"lauseiksi": [11],
"sarakkeessa": [[1,8,11]],
"mode": [5],
"kohdistettavaa": [[8,11]],
"xhtml-tiedostoja": [11],
"käännösmuistitiedostosta": [11],
"avainsanataulukosta": [11],
"muistissa": [11],
"avoinna": [8,[5,11]],
"kielistä": [6],
"ala": [11],
"kääntämättömänä": [11],
"toolsshowstatisticsstandardmenuitem": [3],
"valintaikkunan": [11,8],
"all": [6],
"lisäyksestä": [11],
"read": [11],
"muotoilut": [6],
"sanaryhmiä": [11],
"xx_yyy.tmx-tiedostoksi": [6],
"alt": [[3,5,11]],
"käynnistääksesi": [5],
"alu": [2],
"yhteismäärä": [11],
"istä": [11],
"omegat-käyttöliittymästä": [1],
"ikkunassa": [[5,11],[4,6,8]],
"kahta": [11],
"omegat-istunnoissa": [5],
"tekemässä": [11,6],
"muistista": [11],
"aiheesta": [[10,11]],
"odg-tiedostona": [6],
"lopeta": [11,[3,8]],
"täydennystä": [11],
"ryhmäprojektiksi": [6],
"huomoioimatta": [8],
"kelpo": [11],
"luotava": [5],
"varoitukset": [5],
"käännösistunnon": [10],
"näihin": [11],
"syöttämään": [11],
"tyhjää": [11],
"rubysta": [11],
"omegat-käyttöliittymässä": [6],
"estät": [6],
"valmistunut": [9],
"and": [[5,6]],
"yksityiskohdat": [11],
"kerrottiin": [6],
"käyttöoikeus": [5],
"sanastotiedostoihisi": [9],
"virheilmoituksen": [5],
"tiedostojen": [11,6,5,4],
"päivitetyn": [6],
"valintaikkunat": [11,[7,8,9]],
"ant": [6],
"moniparadigmainen": [11],
"rastittamatta": [11],
"suoritetaan": [11,5],
"kokoonsa": [9],
"rastittu": [11],
"kuvista": [7],
"kielitunnuksen": [11],
"saisi": [6],
"käännettävänäsi": [6],
"sovelluksesta": [4],
"ristiriidassa": [3],
"helplastchangesmenuitem": [3],
"ikkunaan": [[9,11]],
"omegat.ex": [5],
"tärkeää": [6],
"tulisi": [11,6],
"käännöstyökalujen": [11],
"tarvittavaa": [5],
"käsiteltävä": [11],
"sourcetext": [11],
"kappaleittaisia": [11],
"samanlainen": [[2,10]],
"yleismerkkejä": [11],
"pääikkunasta": [9],
"lähdesegmentissä": [[8,11]],
"odottaa": [5],
"pienentää": [9],
"ohjelmointimuuttujat": [11],
"sekunnin": [11],
"english": [0],
"tiedostonhallinnassa": [4],
"tarkistaja": [11],
"jar": [5,6],
"api": [5],
"editselectfuzzy2menuitem": [3],
"muistuttaa": [11],
"käyttöoikeussopimuksen": [5],
"skannatuista": [6],
"näkee": [6],
"vaaditut": [6],
"tasaus": [6],
"kohdetekstin": [11,6],
"lähdesegmentistä": [9],
"järjestelmänvalvojalta": [11],
"nimien": [4,10],
"pilkuilla": [11],
"opettelet": [6],
"osuma": [3,8,9,11,10],
"kuukauden": [6],
"talleta": [11],
"kastilian": [4],
"välit": [8],
"objektikeskeistä": [11],
"hiirellä": [9],
"rsc": [6],
"todella": [8],
"näppäintä": [11,3,9],
"editselectfuzzynextmenuitem": [3],
"ensimmäisen": [5,[1,2,9,11]],
"uudelleen": [6,11,[3,4,8],9,1],
"lähdekieliset": [11],
"read.m": [11],
"kopioidaan": [9,11,[6,8]],
"lähellä": [6],
"ikkunoissa": [6],
"lähdekielisen": [[6,10,11]],
"readme.bak": [6],
"parannuksista": [8],
"nimettävä": [6],
"art": [4],
"vanhaa": [11],
"asennustapaa": [5],
"tallennettiin": [6],
"oletusmuotoista": [8],
"välilehtipalkki": [9],
"tarvittavat": [6,5],
"rtl-kielistä": [6],
"rtl": [6],
"vähän": [[2,6]],
"jdk": [5],
"omegat-määritystiedostot": [8],
"taas-terminologiahaku": [8],
"korjauksia": [11],
"saattaa": [11,8],
"kyseiset": [4],
"vanhan": [5],
"ladannut": [5],
"kyseisen": [11,5],
"vanhat": [11],
"kaksisuuntaisella": [6],
"toolsshowstatisticsmatchesperfilemenuitem": [3],
"vartalonmuodostusta": [9],
"käännösmuisteissa": [[6,10]],
"kaksoisnapsauta": [5,11],
"vaarantaa": [11],
"run": [11,5],
"löytyy": [6,11,[1,3]],
"päivitykset": [11,[5,8]],
"tavalla": [[5,8,11],[0,3,4,6,9]],
"testaamiseen": [2],
"käynnistysvaihtoehdot": [5],
"sisältämät": [5],
"yleistä": [11],
"viet": [9],
"tason": [[10,11]],
"tbx-sanastojen": [[3,11]],
"senhetkisen": [9,[8,11],[6,10]],
"käännökseen": [11],
"titlecasemenuitem": [3],
"tilarivi": [9,7],
"senhetkiset": [10],
"käyttöopas": [7],
"käytännössä": [[5,9]],
"sanakirjoista": [8,4],
"kestää": [4],
"editcreateglossaryentrymenuitem": [3],
"käyttöjärjestelmissä": [[1,5,10]],
"omat": [[6,11]],
"määritetään": [6],
"tiedostomuodot": [6,11],
"siirtävät": [11],
"käännettävä": [[9,10,11]],
"tärkeät": [5],
"kontrollimerkit": [[3,8]],
"mukaiseksi": [[5,8]],
"tekstialueell": [11],
"sijaitse": [11],
"puolella": [6,11,[5,8]],
"tapaan": [11,6,8],
"name": [[5,11]],
"kansiota": [10,5],
"edelleenkään": [6],
"oman": [11],
"kuvassa": [[4,9]],
"vihj": [11,6],
"lisätyssä": [11],
"linkiksi": [5],
"tukemia": [2],
"show": [5],
"valikoiva": [6],
"käytetä": [11],
"alla": [5,[2,6,11],[3,4,9]],
"pakomerkin": [5],
"vartaloita": [[1,11]],
"internetistä": [6],
"kysymysmerkki": [11],
"suhteessa": [6],
"ohjelmall": [5],
"vartalonmuodostus": [11],
"käyttöliittymässä": [5],
"synkronoidakseen": [6],
"kappaletason": [11],
"lopputulo": [11],
"sovelluskans": [5],
"sellaisena": [10],
"sanakirjoissa": [11],
"joiden": [11,6,0,[8,10]],
"kohta": [11,6,8,[0,1,2,5,9]],
"kansiohierarkian": [10],
"avain–arvo-tiedostoiksi": [11],
"url-osoitteeseen": [6],
"järjestelmässä": [11],
"sellaisell": [6],
"kohti": [6],
"target": [8,[10,11],7],
"pyydä": [[3,11]],
"käyttöliittymästä": [6],
"osittainen": [11],
"käynnistä": [3,[5,11]],
"vastaavan": [[9,11]],
"alku": [2],
"tmx-tiedosto": [10,5,6],
"malli": [11],
"hakukentän": [11],
"käsitellessäsi": [11],
"openofficessa": [[4,11]],
"peruskomento": [5],
"config-dir": [5],
"vastaavat": [[9,11],[1,10]],
"silloin": [11,8,[2,5,9,10]],
"tarkistamaan": [11,5],
"suurentaa": [9],
"tiedostomuotoon": [6],
"termbas": [1],
"laatu": [6],
"luettelosta": [[8,11]],
"mediawiki-muotoisia": [11],
"täytettyjä": [11],
"vaiheessa": [6],
"käynnissä": [[5,8,9]],
"konekäännösruutu": [9],
"vaiheen": [6],
"riippuu": [6,[1,5,8]],
"ei-käännettyinä": [11],
"kiinankielisen": [6],
"viim": [8,3],
"item": [5],
"lähdekielisiä": [[9,10]],
"jätetään": [[5,6,11]],
"merkistökoodauksella": [1],
"viit": [6],
"alkuperäinen": [11,6],
"väliajoin": [6],
"miten": [6,11,[0,7,10]],
"muokkaustapa": [[3,10]],
"targettext": [11],
"muokataan": [[6,9]],
"muuttumatonta": [11],
"tallennus": [6],
"vihreitä": [9],
"pakettia": [5],
"rakentamisesta": [5],
"omia": [[2,6,11]],
"asenna": [[4,5],0],
"annetaan": [6],
"työkalujen": [6],
"aaabbb": [2],
"ei-toivotulla": [8],
"inline-muotoilut": [10],
"päättävät": [2],
"edittagpaintermenuitem": [3],
"numeroineen": [11],
"argumentteja": [5],
"tumman": [11],
"sisäisestä": [9],
"pojektiasetukset": [10],
"optionscolorsselectionmenuitem": [3],
"milloin": [[9,11]],
"osumien": [[9,11],[6,10]],
"sisäisessä": [9],
"dockissa": [5],
"tiedostokoodaus": [1],
"pikanäppäinmääritelmä": [3],
"käännösmuisteista": [[6,9,10,11]],
"kirjoitetut": [2],
"lisätiedot": [6],
"luoduissa": [10],
"kaaviot": [11],
"viewmarknbspcheckboxmenuitem": [3],
"käynnistysohjelmaan": [5],
"kirjoitetun": [[4,11]],
"käynnisti": [5],
"työkalu": [[7,8]],
"halutusta": [9],
"kohdistettua": [11],
"käännösmuisti": [10,6,[8,11]],
"hyödyllinen": [[9,11]],
"pudotusvalikosta": [11,4],
"kohdeasiakirjoja": [6],
"kursori": [9],
"tyyppi": [11],
"kirjoitettu": [11,6,3],
"edellytykset": [5],
"tiedostokohtaisesti": [11],
"kielentarkistinikkunassa": [4],
"msgstr": [11],
"valintoja": [11,[5,9]],
"editori-ikkunassa": [11],
"erotettu": [1],
"etätyöpöytäistuntojen": [5],
"venäjäksi": [5],
"leikepöydän": [8],
"jne": [11,6,[0,2,5]],
"valintoihin": [8],
"yläpuolell": [8],
"olevaan": [[5,8,9]],
"käännettävien": [[6,11]],
"säilyviä": [5],
"listattu": [3],
"yhdistämisparametrissa": [6],
"seuraavista": [11,[0,5]],
"omegat-ryhmaeprojektin_varasto": [6],
"joilla": [[6,8]],
"omegat.project": [6,5,10,[7,9,11]],
"targetcountrycod": [11],
"aloittaa": [11,1],
"oletusmuotoisesti": [1],
"ryhmäprojektissa": [6],
"oransseja": [8],
"taaksepäin": [8,3],
"webstart": [5],
"tiedostoarkisto": [0],
"kääntäjillä": [6],
"etusijalla": [8],
"kuvaus": [6],
"syöttöjärjestelmä": [11],
"pääsyn": [11],
"hyvä": [[2,6,10]],
"haluamaksesi": [[5,10]],
"jos": [11,8,[5,6],10,4,9,[1,3],0,2],
"pääteohjelma": [5],
"saa": [11,5,8,6],
"syöttöä": [6],
"molempia": [5],
"virheestä": [6],
"sanastotiedostossa": [1],
"pääteikkunaan": [5],
"asetetaan": [6],
"käytössäsi": [[4,6]],
"vastaavia": [[9,11]],
"voimassa": [8,11],
"väliä": [5],
"napsautuksella": [[5,11]],
"vahvistettu": [8],
"kääntämättömiä": [[8,11]],
"yandex": [5],
"käsitt": [11,3],
"sääntöihin": [11],
"etsiä": [[2,11]],
"ilmoitetaan": [8],
"kuvata": [6],
"a123456789b123456789c123456789d12345678": [5],
"po-otsak": [11],
"viewmarkwhitespacecheckboxmenuitem": [3],
"oletuskäännökset": [10],
"nimen": [11,10],
"kokonainen": [11],
"viimeisimpään": [6],
"kuvaustiedostoll": [3],
"johtaja": [6],
"med-paketiksi": [8],
"lisäkomentosarjoja": [11],
"sanastotiedostoja": [1],
"bak": [[6,10]],
"valinnassa": [[8,11]],
"wikipediaan": [8],
"perustuvan": [5],
"tietyn": [11,10],
"bat": [5],
"istunnon": [[8,11]],
"korjaamiseksi": [8],
"poikkeus-ruudusta": [11],
"tietyt": [[6,11]],
"tägin": [11,[6,8]],
"ryhmäprojekteissa": [6],
"tekijänoikeustiedot": [8],
"jre": [5],
"virh": [[5,6]],
"optionsfontselectionmenuitem": [3],
"lisäparametri": [5],
"lataamaasi": [5],
"lukua": [11],
"montako": [11],
"alun": [2],
"tägit": [11,6,[3,8],9],
"yleisiä": [11],
"käännöspäivämäärä": [11],
"vaan": [[6,11],9],
"vaihtoehtojen": [3],
"käytäntö": [8],
"työkalut-valikko": [3,7],
"ini-tiedosto": [5],
"sijoita": [[3,10]],
"suurennusta": [9],
"koskaan": [11],
"hyväksyvät": [10],
"vanhojen": [6,7],
"pythonista": [11],
"keltainen": [8],
"listalla": [11,[2,10]],
"icon": [5],
"sanastotiedostojen": [1],
"sääntöjen": [11],
"komentosarjaluettelossa": [11],
"delet": [11],
"painiketta": [11],
"projectaccessglossarymenuitem": [3],
"ylimpänä": [2],
"seuraavalla": [[0,2,3]],
"pikanäppäimiä": [3],
"alikansiosta": [6],
"sen": [11,5,6,[8,9],1,[0,3,4],2],
"developerwork": [5],
"merkkijono": [11],
"valinnasta": [1],
"käsiksi": [[5,11]],
"set": [5],
"kolmannella": [9],
"sanakirjahaku": [11],
"asentaa": [4],
"luvusta": [6],
"teknisiä": [8],
"toiset": [0],
"avautuu": [8,[4,5,9,11]],
"ovat": [11,6,[5,8,9],[0,10],1,4],
"optionsrestoreguimenuitem": [3],
"projektitiedostokohtaiset": [8],
"en-us_de_projekti": [6],
"erityinen": [11],
"jakelu": [5],
"vuoksi": [[5,8,11]],
"toisen": [[6,9,11]],
"gzip-muotoon": [10],
"hakeaksesi": [0],
"segmentointiprosessissa": [11],
"kohdesegmentti": [11],
"omegat-pikanäppäinten": [3],
"luotiin": [6],
"javaa": [5],
"microsoft-tili": [5],
"pinota": [9],
"nimet": [11],
"alikansiossa": [10,[0,4]],
"riven": [11],
"ää": [[2,11]],
"luku": [9,[6,10]],
"toiminto": [11,8,3,[4,9,10]],
"komiss": [8],
"offic": [11],
"kutsua": [6],
"macia": [3],
"toimintoa": [11,4],
"riviä": [8],
"po-kohdetiedoston": [11],
"nimeä": [11,6,9,[1,4]],
"javan": [[2,11]],
"parametrejä": [[5,11]],
"käsittelemien": [11],
"syktaksia": [11],
"luke": [[8,11]],
"tiedostoina": [6],
"repositories": [7],
"käsitellä": [[6,11]],
"projectsavemenuitem": [3],
"macin": [5,7],
"oikeinkirjoitussanastojen": [4,7],
"xmx6g": [5],
"ruutujen": [9,[7,11]],
"git-versionhallintajärjestelmien": [6],
"hakumenetelmät": [11],
"operaattorit": [[2,7]],
"varoittaa": [11],
"pääkäännösmuisti": [6],
"tietti": [9],
"segmentointitapa": [11],
"segmentoitu": [11],
"mukaisessa": [10],
"vieti": [6],
"yhdistelmää": [6],
"suljettuaan": [9],
"hakumenetelmän": [11],
"laatikon": [11],
"ohittamaan": [[4,6]],
"kohdesegmentissä": [8,11],
"auki": [11],
"vastaava": [11,[0,5,8,9]],
"ohjelmasta": [[2,5]],
"löytyvään": [8],
"näppäin": [3],
"progressiivisen": [11],
"sii": [11,6,5,9,8],
"terminologiaa": [6],
"toisissa": [6],
"mukaisesta": [11],
"yleiset": [11,7],
"jonka": [11,2,8,6,[1,4,5,9]],
"tm-kansiossa": [6],
"paikallisesti": [8,6],
"mukaisesti": [11,[4,5,9,10]],
"sis": [9],
"erilaisiksi": [11],
"sanakirjatiedostojen": [4],
"menettelytapoja": [6],
"ohjetekstit": [11],
"jokaisessa": [11],
"nollaa": [11],
"ohjelmassa": [6,8],
"tunnet": [6],
"kentät": [8],
"vaikuta": [[5,11],6],
"käynnistävät": [5],
"täyttämiseen": [6],
"pikkutoimia": [6],
"tyhjätilamerkiksi": [11],
"pakentin": [5],
"rivin": [2,[8,11],[1,3,5]],
"merkinnällä": [[3,10,11]],
"kentän": [[4,11]],
"xhtml-tiedostot": [11],
"itseään": [11],
"sarkaimella": [1],
"valimta": [5],
"palauttaaksesi": [6],
"näppäimellä": [[1,9]],
"luotaessa": [6],
"lopulta": [[4,5]],
"rivit": [11],
"konekäännösehdotuksella": [9],
"pitäisikö": [11],
"bis": [2],
"hollanti": [6],
"sanastoina": [1],
"nimiä": [11,9],
"käyttämiä": [10],
"projectopenmenuitem": [3],
"käsitelti": [8],
"rivikorkeutta": [8],
"puuttumaan": [2],
"luot": [6,11],
"tuetut": [11],
"laita": [11,10,[4,6]],
"toolsvalidatetagsmenuitem": [3],
"vain": [11,6,8,[1,10],[4,5],[0,2]],
"kotikans": [5],
"käännöksenä": [[9,11]],
"kreikan": [2],
"käynnistystavat": [5],
"varsinkaan": [11],
"asetukset": [11,8,[5,6],7,4],
"sellaiseksi": [8],
"test.html-tiedosto": [5],
"synkronoitaviin": [6],
"käynnistystavan": [5],
"asetuksen": [11],
"vaih": [6,11],
"viewmarktranslatedsegmentscheckboxmenuitem": [3],
"osumaprosentti": [9],
"mahdolliset": [10,6,[3,5]],
"ikonitiedostojen": [5],
"vienti": [6],
"löytyvät": [10,[1,3,6,8,9,11]],
"valu": [1,5],
"projektissakin": [11],
"hetkellä": [[8,11]],
"neljän": [8],
"ilia": [5],
"käännöksesi": [9],
"automaattinen": [11,3,8,6],
"mahdollisen": [11],
"listalta": [[1,8,11]],
"kääntäjä": [6,[10,11]],
"muodostuneesta": [11],
"blokissa": [2],
"tietokoneen": [5,[8,11]],
"sotkemassa": [11],
"sisällys": [7],
"jakaminen": [6],
"vaihtuu": [[8,11]],
"lauseen": [[2,3,8,11]],
"joko": [11,[5,6],[0,2,8]],
"missä": [5,11,[6,9]],
"osoittamaan": [6],
"tekstintunnistusohjelmaa": [6],
"optic": [6],
"joku": [6],
"ehdotettuja": [8],
"tietoa": [5,11,9,6,[0,2,8]],
"käännösosumia": [10],
"alaosaan": [11],
"rajoittamaton": [5],
"kirjoituskelpoisessa": [1],
"toiminnassa": [10],
"työstettäviä": [11],
"tyhjennetään": [11],
"editselectfuzzy1menuitem": [3],
"joka": [11,6,5,[8,9,10],[1,2]],
"komentosarjoja": [[5,8,11]],
"luettavien": [6,7],
"tapansa": [6],
"mukaiset": [11],
"dokumentteja": [6],
"merkitä": [8],
"oktaaliarvo": [2],
"hide": [11],
"kohtaa": [11,10,4],
"reunan": [6],
"pääteikkunaksi": [5],
"esimerkkitapauksessa": [6],
"immuuneina": [10],
"tarkoittaa": [11,5,[6,9]],
"varten": [11,[6,7,9,10]],
"isoja": [11],
"auto": [10,[6,8,11]],
"tarkastaa": [10],
"kohdekielellä": [[5,9]],
"asennuskansio": [11],
"document.xx.docx": [11],
"merkkien": [11],
"kommenttimerkit": [5],
"ilmoitukset": [11],
"lauseiden": [11],
"esiintymiä": [11,5],
"tekemättä": [11],
"oracl": [5],
"bat-tiedosto": [5],
"ensimmäistä": [11,[5,6]],
"segmentoidaan": [11],
"tägiä": [11],
"kokeneill": [5],
"liian": [11],
"gradlew": [5],
"wikipedia-sivun": [8],
"eteenpäin": [8,3,11],
"tiedostonimeen": [11],
"omegat.project-tiedosto": [6],
"pikanäppäimen": [3,8],
"regex-dokumentaatioon": [2],
"aseta": [11,[3,8,10]],
"kahdella": [5,[4,6,11]],
"internetyhteyden": [4],
"asiakirjat": [6,[5,8]],
"asiakirjan": [[6,8,11],[1,9]],
"sovellus": [5,[4,6]],
"yhdistä": [[8,11]],
"näytön": [11],
"joll": [[1,8,11]],
"käyttäjill": [[2,5]],
"määriteltyyn": [[5,9]],
"ensiluokkaiset": [11],
"pikanäppäimet": [3,11],
"mistä": [8,5],
"menetellä": [6],
"oletusnäyttötilaa": [6],
"oletusmuotoiset": [[3,6]],
"puuttuvat": [8,3],
"asiakirjaa": [6],
"vaihtoehtoja": [6],
"dokumentaatiossa": [3],
"kohdesegmentin": [11,9,8],
"läpi": [[5,6,11]],
"spotlightin": [5],
"jopa": [9],
"suurta": [11],
"käyttöympäristöjen": [5],
"kappaleittain": [11],
"asetuksia": [5,11,6],
"oletuksiksi": [6],
"tavasta": [10],
"kohdesegmentit": [5],
"switch": [11],
"verkkoyhtey": [6],
"mahdollisia": [1],
"bundl": [[5,11]],
"kääntämistä": [7],
"ruutuja": [9],
"kätevä": [11],
"hakuikkunoita": [11],
"komentorivipohjaisessa": [5],
"src": [6],
"kakkospainikkeen": [11],
"tyhjä": [11,6,[2,10],8,[1,3,9]],
"dokumentaatiosta": [[6,11]],
"control": [3],
"käyttöönsä": [5],
"korjattu": [1],
"merkits": [8,3,11,1],
"no-team": [[5,6]],
"numerolistat": [11],
"hakukoneiden": [11],
"jonn": [5,[4,6,8]],
"merkiti": [11],
"tyhjäksi": [11,8],
"esimerkkjä": [11],
"mukaisia": [[1,11]],
"syöttää": [6],
"lataamasi": [5],
"parhaimmat": [11],
"esimerkkejä": [2,[7,11]],
"ilmestyy": [11],
"koneellasi": [5,11],
"käännöstä": [11,[8,9]],
"objekti": [11],
"asentaminen": [5,4,7],
"nykyiseen": [8],
"keskiarvotulo": [11],
"segmentoinnin": [11],
"napsauta": [11,5,8,4,[1,9]],
"sanastoja": [[4,6]],
"erotettua": [1],
"environ": [5],
"optionsautocompleteglossarymenuitem": [3],
"tiedetään": [6],
"perustyylit": [11],
"esimerkkiä": [[5,11]],
"prosenttisina": [10],
"paina": [11,5,[8,9]],
"useampi": [[1,3,6,11]],
"viedä": [[6,10]],
"tägeill": [11],
"sanasto-osumien": [9],
"valittujen": [6,[4,11]],
"editoriruudussa": [11,[8,9]],
"kiertotiemuunnoksiin": [6],
"viitteinä": [6],
"git-tietovarastoon": [6],
"lasketaan": [11],
"toista": [[3,8]],
"kde": [5],
"hallintaan": [6],
"tietoihisi": [5],
"näyttösuunnan": [6],
"lukea": [6],
"readme-tiedostoja": [11],
"muokkaa": [11,8,[6,9],[1,3,7]],
"tuodaan": [6],
"säännöllisessä": [5],
"jota": [[2,11],[1,3,4,5,6]],
"löytävät": [2],
"useammin": [2],
"languag": [5],
"tiedostosuodatinta": [5],
"näyttötila": [6],
"alueen": [[2,7]],
"argumentit": [5],
"sellaisenaan": [11],
"laatia": [[2,11]],
"kaua": [6],
"rajoituksia": [11],
"saatava": [5],
"oletukset": [11],
"etäpalvelimell": [10],
"laatii": [4],
"tulla": [5],
"tcl-pohjaisella": [11],
"key": [5,11],
"lähteistä": [11],
"kokonaisluvut": [11],
"ip-osoit": [5],
"sill": [6],
"ulkopuolelta": [9],
"vaihdon": [11],
"ilmestyä": [10],
"kertaa": [2,[5,6,9,11]],
"tuontikäännösmuisteina": [6],
"kielillä": [11],
"svn": [6],
"merkistökoodauksesta": [11],
"osumana": [10],
"loogiset": [[2,7]],
"tietoverkon": [5],
"auto-kansiosta": [10],
"viitekäännöksinä": [6],
"kansioksi": [5],
"vaihtoehtoisten": [[9,11]],
"yksiköiksi": [11],
"vartalo": [8],
"puolileveät": [11],
"linuxissa": [5],
"segmentoinnissa": [11],
"irrottaa": [9],
"asiakkaan": [[10,11]],
"muokkaustiedot": [3,8,11],
"editreplaceinprojectmenuitem": [3],
"lähdekielisiin": [6],
"säännöllisesti": [6],
"ssä": [6,[0,2,3,5,11]],
"ohjelmat": [5],
"englantia": [2,5],
"määrittel": [5,[3,11]],
"express": [[2,11]],
"valinnut": [[4,11]],
"huomioitava": [[6,11]],
"ohjelman": [5,8,[6,7]],
"määritystiedostoa": [5],
"vasemman": [6,9],
"sanastona": [1],
"sanakirjaversiot": [4],
"ikkunassaan": [8],
"kohdistaja": [11,7],
"translator-palvelun": [5],
"tahansa": [11,9,2,[5,8],[3,6,10]],
"välein": [[6,8,11]],
"odottavat": [11],
"käyttäessäsi": [6],
"määritystiedostot": [5],
"gotoprevioussegmentmenuitem": [3],
"mainituilla": [5],
"sanastoon": [1,11],
"stä": [6,8],
"sinn": [10,[3,4,5]],
"arkistoi": [6],
"prototyyppinen": [11],
"po-tiedostot": [11],
"gnome-käyttäjät": [5],
"api-avaimesi": [5],
"gotopreviousnotemenuitem": [3],
"makrot": [11],
"editredomenuitem": [3],
"rivill": [11],
"uilayout.xml": [10],
"minuuttia": [[6,11]],
"tuotemerkkejä": [11],
"ensisijainen": [5],
"sääntölistan": [11],
"tuottavuuttasi": [11],
"segmentoida": [11],
"asennusohjelma": [5],
"kappaleittaiseksi": [11],
"ruutuun": [11,9,4],
"po-tiedoston": [[9,11]],
"japanill": [11],
"teksteissä": [11],
"täydellinen": [5],
"vaihtoehtoinen": [[8,9,11],3],
"tunnus": [[2,4]],
"kommentin": [1],
"aikana": [5,6,[8,9,10]],
"kuvattu": [[5,11]],
"vasemmanpuoleisessa": [11],
"kuvatut": [5],
"tiedostomuotoa": [1],
"tallennettuaan": [9],
"kommentit": [11,9,[1,7]],
"alkuperäisessä": [6],
"maalattuna": [8],
"otsikon": [[3,8,11]],
"recognit": [6],
"rastittamalla": [11],
"määrittele": [[5,11]],
"sanastotoiminto": [1],
"tarkoitus": [11],
"vasemmanpuoleisesta": [8],
"tägeinä": [11],
"parasta": [10],
"senkin": [11],
"ohjelmaa": [5,6],
"tekstejä": [11],
"tekstitiedostot": [11],
"jälkeen": [11,3,[2,5,6,8],9],
"ohjelma": [11,5,6,8,[2,9]],
"muotoilutietoja": [6],
"nimeäminen": [6],
"erotinta": [9],
"hiuksenhieno": [11],
"runtim": [5],
"epäröi": [6],
"valits": [11,8,[3,5],[4,6,9],1],
"konsonantteja": [2],
"tarkastus": [2],
"sarkainnäppäimellä": [[8,11],3],
"lukemat": [8],
"tester": [2],
"hitaasti": [[5,11]],
"argumentti": [5],
"ryhmätyöohjelmiston": [6],
"vastaavatko": [11],
"openofficen": [4],
"ohjeiden": [5],
"filenam": [11],
"toimenpiteistä": [9],
"tapahtuu": [11,6,5],
"käännettävän": [[1,5,6,8,9]],
"hiljainen": [5],
"äsken": [6],
"gotosegmentmenuitem": [3],
"ovatko": [[5,10]],
"käännettävät": [6,10,11],
"peräisin": [9],
"käyttäjätunnus": [6],
"ominaisuus": [6],
"mukaista": [[1,4]],
"wordartit": [11],
"hallinta": [6,7],
"valita": [11,[5,9],[4,6]],
"lokitiedosto": [8],
"odt-tiedosto": [6],
"alkuperäiseen": [[6,9]],
"unl-merkkinä": [9],
"suuria": [11],
"saat": [11,8,5,[6,9],[1,4,10]],
"avaa": [8,3,11,5,[4,6,10],9],
"macos-palveluita": [5],
"sinä": [11],
"vielä": [[1,2,8,10,11]],
"xx_yy.tmx": [6],
"ottamalla": [11],
"kmenueditor-ikkuna": [5],
"hyppää": [11],
"helpaboutmenuitem": [3],
"työn": [6],
"segmentointi": [11,[2,3,8]],
"ilmaisevat": [6],
"jaettu": [11,9],
"ulkopuolisten": [11],
"osoitteessa": [5,11],
"sanastoista": [11,9],
"med-projekti": [8],
"käytettävä": [6,5],
"luotettavia": [11],
"regular": [2],
"toimivia": [6],
"oikeudet": [5],
"rtl-muotoisena": [6],
"asetustiedostot": [5],
"stardict-muodon": [0],
"sanastotiedostoon": [8],
"kertaakaan": [2],
"lisätään": [8,[1,5,6,9,10,11]],
"löytyviin": [6],
"vieminen": [8],
"seuraavilla": [11],
"asennusikkuna": [4],
"ottanut": [[5,9]],
"luonti": [6],
"kakkostason": [6],
"pdf-tiedosto": [6],
"loppumerkkiin": [9],
"alikansioon": [6,[5,10]],
"manuaalinen": [8],
"perusmuotoisimmillaan": [5],
"right-to-left": [6],
"asennettava": [4],
"megatavuina": [5],
"yhdistämismäärityksiä": [6],
"kääntää": [6,[5,11],9],
"selaa": [11],
"tmx-tietokantojaan": [6],
"pikanäppäinten": [3],
"sanakirjakansioon": [4],
"useita": [[9,11],[5,6],[1,7,8]],
"kautta": [5,11],
"liittyvien": [3],
"tarvi": [10],
"avain–arvo-parit": [11],
"tule": [11,8,5,[1,6,9]],
"suuren": [4],
"kopioitujen": [6],
"attribuutilla": [11],
"tab": [1,9],
"järjestelyperust": [11],
"taa": [11],
"pikanäppäimellä": [1],
"tai": [11,6,5,2,8,3,1,[4,9],0,10],
"ymmärrä": [6],
"merkitään": [8,[3,10]],
"tar": [5],
"ohjelmien": [11],
"kopio": [[6,8,10,11]],
"välttää": [11],
"kertoo": [5,9],
"onli": [11],
"brasilianportugali": [[4,5]],
"harmaana": [8],
"tuke": [[6,11]],
"lataamisessa": [11],
"projectreloadmenuitem": [3],
"tektiin": [11],
"poikkeussääntöjä": [11],
"omegat-projektin": [[5,6]],
"kiertotietä": [6],
"onko": [5,[0,8,11]],
"käännettävää": [9,11],
"safe": [11],
"oikein": [6,5,10,[1,8,11]],
"käyttäjätilin": [11],
"useamman": [11,2],
"etävaraston": [6],
"kymmenen": [11],
"vanhoja": [6],
"ajatella": [11],
"tehtäviin": [6],
"vastahakoiset": [[2,7]],
"kohteen": [5],
"hakulauseketta": [11],
"winrar": [0],
"tbx": [1],
"csv-tiedosto": [1],
"maaritystiedostojen": [5],
"englanninkieliset": [6],
"yhdistäminen": [6],
"lisäät": [[5,11],[1,10]],
"käytöstä": [[2,11],[7,8]],
"konekäännöspalveluun": [11],
"asennettavaksi": [5],
"duser.countri": [5],
"viimeistä": [11],
"tck": [11],
"vauhdissa": [0],
"molempien": [11],
"vaihto": [3,11,[6,8]],
"readm": [[5,11]],
"käyttö": [11,7,[4,5],1,0],
"tägi": [11,8,3],
"katoamasta": [6],
"sääntö": [11],
"poikkeussäännöksi": [11],
"ensiksi": [5],
"sitä": [11,5,6,9,[1,8,10]],
"alanurkassa": [9],
"löytyvien": [9],
"align.tmx": [5],
"prosessissa": [11],
"sinulla": [5,[1,4]],
"käytössä": [[5,11],[0,6],7],
"omegat-projekti": [6,10],
"ohjelmissa": [6],
"pdf-tiedostoksi": [6],
"editoriruutuun": [[9,10]]
};
