/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.gui.scripting.ScriptingWindow;
import org.omegat.util.DirectoryMonitor;

public class ScriptsMonitor
implements DirectoryMonitor.DirectoryCallback,
DirectoryMonitor.Callback {
    private static final boolean SCRIPTING_EVENTS = true;
    private static boolean applicationStartupEventScriptsExecuted = false;
    private static final FilenameFilter FILTER;
    private File m_scriptDir;
    protected DirectoryMonitor m_monitor;
    private ScriptingWindow m_scriptingWindow;
    private IEntryEventListener m_entryEventListener;
    private IProjectEventListener m_projectEventListener;
    private IApplicationEventListener m_applicationEventListener;
    private IEditorEventListener m_editorEventListener;
    private HashMap<EventType, ArrayList<ScriptItem>> m_eventsScript = new HashMap();

    public ScriptsMonitor(ScriptingWindow scriptingWindow) {
        this.m_scriptingWindow = scriptingWindow;
        for (EventType t : EventType.values()) {
            this.m_eventsScript.put(t, new ArrayList());
        }
    }

    public void start(File scriptDir) {
        this.m_scriptDir = scriptDir;
        this.m_monitor = new DirectoryMonitor(scriptDir, this, this);
        this.m_monitor.start();
        if (!applicationStartupEventScriptsExecuted) {
            applicationStartupEventScriptsExecuted = true;
            this.addEventScripts(EventType.APPLICATION_STARTUP);
            ArrayList<ScriptItem> scripts = this.m_eventsScript.get((Object)EventType.APPLICATION_STARTUP);
            this.m_scriptingWindow.executeScripts(scripts, Collections.emptyMap());
            scripts.clear();
        }
    }

    public void stop() {
        if (this.m_monitor != null) {
            this.m_monitor.fin();
        }
    }

    @Override
    public void fileChanged(File file) {
    }

    @Override
    public void directoryChanged(File file) {
        if (!this.m_scriptDir.isDirectory()) {
            return;
        }
        ArrayList<ScriptItem> scriptsList = new ArrayList<ScriptItem>();
        for (File script : this.m_scriptDir.listFiles(FILTER)) {
            scriptsList.add(new ScriptItem(script));
        }
        Collections.sort(scriptsList);
        this.m_scriptingWindow.setScriptItems(scriptsList);
        this.hookApplicationEvent();
        this.hookEntryEvent();
        this.hookProjectEvent();
        this.hookEditorEvent();
    }

    private void hookEntryEvent() {
        if (this.m_entryEventListener != null) {
            CoreEvents.unregisterEntryEventListener(this.m_entryEventListener);
        }
        this.addEventScripts(EventType.ENTRY_ACTIVATED);
        this.addEventScripts(EventType.NEW_FILE);
        this.m_entryEventListener = new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("activeFileName", activeFileName);
                ScriptsMonitor.this.m_scriptingWindow.executeScripts((List)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.NEW_FILE), binding);
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("newEntry", newEntry);
                ScriptsMonitor.this.m_scriptingWindow.executeScripts((List)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.ENTRY_ACTIVATED), binding);
            }
        };
        CoreEvents.registerEntryEventListener(this.m_entryEventListener);
    }

    private void hookProjectEvent() {
        if (this.m_projectEventListener != null) {
            CoreEvents.unregisterProjectChangeListener(this.m_projectEventListener);
        }
        this.addEventScripts(EventType.PROJECT_CHANGED);
        this.m_projectEventListener = new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("eventType", (Object)eventType);
                ArrayList scripts = (ArrayList)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.PROJECT_CHANGED);
                ScriptsMonitor.this.m_scriptingWindow.executeScripts(scripts, binding);
            }
        };
        CoreEvents.registerProjectChangeListener(this.m_projectEventListener);
    }

    private void hookApplicationEvent() {
        if (this.m_applicationEventListener != null) {
            CoreEvents.unregisterApplicationEventListener(this.m_applicationEventListener);
        }
        this.addEventScripts(EventType.APPLICATION_SHUTDOWN);
        this.m_applicationEventListener = new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
            }

            @Override
            public void onApplicationShutdown() {
                ArrayList scriptItems = (ArrayList)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.APPLICATION_SHUTDOWN);
                ScriptsMonitor.this.m_scriptingWindow.executeScripts(scriptItems, new HashMap<String, Object>());
            }
        };
        CoreEvents.registerApplicationEventListener(this.m_applicationEventListener);
    }

    private void hookEditorEvent() {
        if (this.m_editorEventListener != null) {
            CoreEvents.unregisterEditorEventListener(this.m_editorEventListener);
        }
        this.addEventScripts(EventType.NEW_WORD);
        this.m_editorEventListener = new IEditorEventListener(){

            @Override
            public void onNewWord(String newWord) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("newWord", newWord);
                ScriptsMonitor.this.m_scriptingWindow.executeScripts((List)ScriptsMonitor.this.m_eventsScript.get((Object)EventType.NEW_WORD), binding);
            }
        };
        CoreEvents.registerEditorEventListener(this.m_editorEventListener);
    }

    private void addEventScripts(EventType eventType) {
        String entryDirName = eventType.name().toLowerCase(Locale.ENGLISH);
        File entryActivatedDir = new File(this.m_scriptDir, entryDirName);
        if (!entryActivatedDir.isDirectory()) {
            return;
        }
        ArrayList<ScriptItem> eventScripts = this.m_eventsScript.get((Object)eventType);
        eventScripts.clear();
        Object[] listFiles = entryActivatedDir.listFiles(FILTER);
        Arrays.sort(listFiles);
        for (Object script : listFiles) {
            ScriptItem scriptItem = new ScriptItem((File)script);
            if (eventScripts.contains(scriptItem)) continue;
            eventScripts.add(scriptItem);
        }
    }

    static {
        List<String> extensions = ScriptRunner.getAvailableScriptExtensions();
        FILTER = (dir, name) -> extensions.contains(FilenameUtils.getExtension((String)name).toLowerCase(Locale.ENGLISH));
    }

    private static enum EventType {
        APPLICATION_STARTUP,
        APPLICATION_SHUTDOWN,
        NEW_WORD,
        PROJECT_CHANGED,
        ENTRY_ACTIVATED,
        NEW_FILE;

    }
}

