/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Window;
import java.util.Collections;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class MicrosoftTranslatorAzure
extends BaseTranslate {
    private static final Logger LOGGER = Logger.getLogger(MicrosoftTranslatorAzure.class.getName());
    protected static final String PROPERTY_NEURAL = "microsoft.neural";
    protected static final String PROPERTY_SUBSCRIPTION_KEY = "microsoft.api.subscription_key";
    protected static final String URL_TOKEN = "https://api.cognitive.microsoft.com/sts/v1.0/issueToken";
    protected static final String URL_TRANSLATE = "https://api.microsofttranslator.com/v2/http.svc/Translate";
    protected static final Pattern RE_RESPONSE = Pattern.compile("<string[^>]*>(.+)</string>");
    protected String accessToken;

    @Override
    protected String getPreferenceName() {
        return "allow_microsoft_translator_azure";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_MICROSOFT_AZURE");
    }

    @Override
    protected synchronized String translate(Language sLang, Language tLang, String text) throws Exception {
        String prev = this.getFromCache(sLang, tLang, text = text.length() > 10000 ? text.substring(0, 9997) + "..." : text);
        if (prev != null) {
            return prev;
        }
        String langFrom = this.checkMSLang(sLang);
        String langTo = this.checkMSLang(tLang);
        try {
            String translation;
            if (this.accessToken == null) {
                this.requestToken();
                translation = this.requestTranslate(langFrom, langTo, text);
            } else {
                try {
                    translation = this.requestTranslate(langFrom, langTo, text);
                }
                catch (HttpConnectionUtils.ResponseError ex) {
                    if (ex.code == 400) {
                        LOGGER.finer("Re-fetching Microsoft Translator API token due to 400 response");
                        this.requestToken();
                        translation = this.requestTranslate(langFrom, langTo, text);
                    }
                    throw ex;
                }
            }
            if (translation != null) {
                this.putToCache(sLang, tLang, text, translation);
            }
            return translation;
        }
        catch (HttpConnectionUtils.ResponseError ex) {
            return ex.getLocalizedMessage();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, ex.getLocalizedMessage(), ex);
            return ex.getLocalizedMessage();
        }
    }

    private String checkMSLang(Language language) {
        String lang = language.getLanguage();
        if (lang.equalsIgnoreCase("zh-cn")) {
            return "zh-CHS";
        }
        if (lang.equalsIgnoreCase("zh-tw") || lang.equalsIgnoreCase("zh-hk")) {
            return "zh-CHT";
        }
        return language.getLanguageCode();
    }

    private void requestToken() throws Exception {
        String key = this.getCredential(PROPERTY_SUBSCRIPTION_KEY);
        if (StringUtil.isEmpty(key)) {
            throw new Exception(OStrings.getString("MT_ENGINE_MICROSOFT_SUBSCRIPTION_KEY_NOTFOUND"));
        }
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Ocp-Apim-Subscription-Key", key);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/jwt");
        this.accessToken = HttpConnectionUtils.post(URL_TOKEN, Collections.emptyMap(), headers);
    }

    private String requestTranslate(String langFrom, String langTo, String text) throws Exception {
        String r;
        Matcher m;
        TreeMap<String, String> p = new TreeMap<String, String>();
        p.put("appid", "Bearer " + this.accessToken);
        p.put("text", text);
        p.put("from", langFrom);
        p.put("to", langTo);
        p.put("contentType", "text/plain");
        if (this.isNeural()) {
            p.put("category", "generalnn");
        }
        if ((m = RE_RESPONSE.matcher(r = HttpConnectionUtils.get(URL_TRANSLATE, p, null))).matches()) {
            String translatedText = m.group(1);
            translatedText = translatedText.replace("&lt;", "<");
            translatedText = translatedText.replace("&gt;", ">");
            return translatedText;
        }
        LOGGER.warning(OStrings.getString("MT_ENGINE_MICROSOFT_WRONG_RESPONSE"));
        return null;
    }

    private boolean isNeural() {
        String value = System.getProperty(PROPERTY_NEURAL, Preferences.getPreference(PROPERTY_NEURAL));
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        final JCheckBox neuralCheckBox = new JCheckBox(OStrings.getString("MT_ENGINE_MICROSOFT_NEURAL_LABEL"));
        neuralCheckBox.setSelected(this.isNeural());
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                String key = this.panel.valueField1.getText().trim();
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                MicrosoftTranslatorAzure.this.setCredential(MicrosoftTranslatorAzure.PROPERTY_SUBSCRIPTION_KEY, key, temporary);
                System.setProperty(MicrosoftTranslatorAzure.PROPERTY_NEURAL, Boolean.toString(neuralCheckBox.isSelected()));
                Preferences.setPreference(MicrosoftTranslatorAzure.PROPERTY_NEURAL, neuralCheckBox.isSelected());
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_MICROSOFT_SUBSCRIPTION_KEY_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_SUBSCRIPTION_KEY));
        dialog.panel.valueLabel2.setVisible(false);
        dialog.panel.valueField2.setVisible(false);
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_SUBSCRIPTION_KEY));
        dialog.panel.itemsPanel.add(neuralCheckBox);
        dialog.show();
    }
}

