/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.input.BOMInputStream;
import org.omegat.core.dictionaries.DictionaryData;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.util.Language;

public class LingvoDSL
implements IDictionaryFactory {
    private static final TreeMap<Pattern, String> TAG_REPLACEMENTS;
    private static final String DICT_DIR_TAG = "@dir@";
    private static final int BLOCKSIZE = 8192;

    @Override
    public final boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".dsl") || file.getPath().endsWith(".dsl.dz");
    }

    @Override
    public final IDictionary loadDict(File file) throws Exception {
        return this.loadDict(file, new Language(Locale.getDefault()));
    }

    @Override
    public final IDictionary loadDict(File file, Language language) throws Exception {
        return new LingvoDSLDict(file, language);
    }

    private static String replaceTag(String line) {
        String result = line;
        for (Map.Entry<Pattern, String> entry : TAG_REPLACEMENTS.entrySet()) {
            result = entry.getKey().matcher(result).replaceAll(entry.getValue());
        }
        return result;
    }

    static {
        String[] ignoreTags;
        TAG_REPLACEMENTS = new TreeMap(Comparator.comparing(Pattern::pattern));
        TAG_REPLACEMENTS.put(Pattern.compile("\\[\\[(?<content>.+?)]]"), "&#91;${content}&#93;");
        TAG_REPLACEMENTS.put(Pattern.compile(Pattern.quote("\\[")), "&#91;");
        TAG_REPLACEMENTS.put(Pattern.compile(Pattern.quote("\\]")), "&#93;");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[b](?<content>.+?)\\[/b]"), "<strong>${content}</strong>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[i](?<content>.+?)\\[/i]"), "<span style='font-style: italic'>${content}</span>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[t](?<content>.+?)\\[/t]"), "${content}&nbsp;");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[c](?<content>.+?)\\[/c]"), "<span style='color:green'>${content}</span>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[u](?<content>.+?)\\[/u]"), "<span style='text-decoration:underline'>${content}</span>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[c\\s(?<color>[a-z]+?)](?<content>.+?)\\[/c]"), "<span style='color:${color}'>${content}</span>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[sub](?<content>.+?)\\[/sub]"), "<sub>${content}</sub>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[sup](?<content>.+?)\\[/sup]"), "<sup>${content}</sup>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[s](?<media>.+?\\.wav)\\[/s]"), "<a href=\"file://@dir@/${media}\">${media}</a>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[s](?<media>.+?\\.jpg)\\[/s]"), "<img src=\"file://@dir@/${media}\"/>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[s](?<media>.+?\\.png)\\[/s]"), "<img src=\"file://@dir@/${media}\"/>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[video](?<media>.+?)\\[/video]"), "<a href=\"file://@dir@/${media}\">${media}</a>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[s](?<media>.+?)\\[/s]"), "<a href=\"file://@dir@/${media}\">${media}</a>");
        TAG_REPLACEMENTS.put(Pattern.compile(Pattern.quote("[br]")), "<br/>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[m1](?<content>.+?)\\[/m]"), "<p style=\"text-indent: 30px\">${content}</p>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[m2](?<content>.+?)\\[/m]"), "<p style=\"text-indent: 60px\">${content}</p>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[(m3|m4|m5|m6|m7|m8|m9)](?<content>.+?)\\[/m]"), "<p style=\"text-indent: 90px\">${content}</p>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\[url](?<link>.+?)\\[/url]"), "<a href=\"${link}\">${link}</a>");
        TAG_REPLACEMENTS.put(Pattern.compile("\\['](?<content>.+?)\\[/']"), "<span style='color:red'>${content}</span>");
        for (String tag : ignoreTags = new String[]{"\\*", "m", "com", "ex", "lang", "p", "preview", "ref", "s", "trn", "trn1", "trs", "!trs", "video"}) {
            TAG_REPLACEMENTS.put(Pattern.compile("\\[(?<tag>" + tag + ")](?<content>.+?)\\[/\\k<tag>]"), "${content}");
        }
    }

    static class LingvoDSLDict
    implements IDictionary {
        protected final DictionaryData<String> data;
        private final String dictionaryDir;

        LingvoDSLDict(File file, Language language) throws Exception {
            this.data = new DictionaryData(language);
            this.readDslFile(file);
            this.dictionaryDir = file.getParent();
        }

        private void readDslFile(File file) throws IOException {
            try (FileInputStream fis = new FileInputStream(file);){
                InputStream is = file.getName().endsWith(".dz") ? new GZIPInputStream((InputStream)fis, 8192) : fis;
                try (BOMInputStream bis = new BOMInputStream(is);){
                    Charset charset = bis.hasBOM() ? StandardCharsets.UTF_8 : StandardCharsets.UTF_16;
                    try (InputStreamReader isr = new InputStreamReader((InputStream)bis, charset);
                         BufferedReader reader = new BufferedReader(isr);){
                        this.loadData(reader.lines());
                    }
                }
            }
        }

        private void loadData(Stream<String> stream) {
            StringBuilder word = new StringBuilder();
            StringBuilder trans = new StringBuilder();
            stream.filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#")).map(x$0 -> LingvoDSL.replaceTag(x$0)).forEach(line -> {
                if (Character.isWhitespace(line.codePointAt(0))) {
                    trans.append(line.trim().replaceAll(LingvoDSL.DICT_DIR_TAG, this.dictionaryDir)).append('\n');
                } else {
                    if (word.length() > 0) {
                        this.data.add(word.toString(), trans.toString());
                        word.setLength(0);
                        trans.setLength(0);
                    }
                    word.append((String)line);
                }
            });
            if (word.length() > 0) {
                this.data.add(word.toString(), trans.toString());
            }
            this.data.done();
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) {
            return this.data.lookUp(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) {
            return this.data.lookUpPredictive(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
    }
}

