/*
 * Decompiled with CFR 0.152.
 */
package morfologik.speller;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import morfologik.fsa.ByteSequenceIterator;
import morfologik.fsa.FSA;
import morfologik.fsa.FSATraversal;
import morfologik.fsa.MatchResult;
import morfologik.speller.HMatrix;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.UnmappableInputException;

public class Speller {
    public static final int MAX_WORD_LENGTH = 120;
    static final int FREQ_RANGES = 26;
    static final int FIRST_RANGE_CODE = 65;
    static final int UPPER_SEARCH_LIMIT = 15;
    private static final int MIN_WORD_LENGTH = 4;
    private static final int MAX_RECURSION_LEVEL = 6;
    private final int editDistance;
    private int effectEditDistance;
    private final HMatrix hMatrix;
    private char[] candidate;
    private int candLen;
    private int wordLen;
    private char[] wordProcessed;
    private Map<Character, List<char[]>> replacementsAnyToOne = new HashMap<Character, List<char[]>>();
    private Map<String, List<char[]>> replacementsAnyToTwo = new HashMap<String, List<char[]>>();
    private Map<String, List<String>> replacementsTheRest = new HashMap<String, List<String>>();
    private final List<CandidateData> candidates = new ArrayList<CandidateData>();
    private boolean containsSeparators = true;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(120);
    private CharBuffer charBuffer = CharBuffer.allocate(120);
    private final MatchResult matchResult = new MatchResult();
    private final DictionaryMetadata dictionaryMetadata;
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;
    private final FSATraversal matcher;
    private final int rootNode;
    private final FSA fsa;
    private final ByteSequenceIterator finalStatesIterator;

    public Speller(Dictionary dictionary) {
        this(dictionary, 1);
    }

    public Speller(Dictionary dictionary, int editDistance) {
        this.editDistance = editDistance;
        this.hMatrix = new HMatrix(editDistance, 120);
        this.dictionaryMetadata = dictionary.metadata;
        this.rootNode = dictionary.fsa.getRootNode();
        this.fsa = dictionary.fsa;
        this.matcher = new FSATraversal(this.fsa);
        this.finalStatesIterator = new ByteSequenceIterator(this.fsa, this.rootNode);
        if (this.rootNode == 0) {
            throw new IllegalArgumentException("Dictionary must have at least the root node.");
        }
        if (this.dictionaryMetadata == null) {
            throw new IllegalArgumentException("Dictionary metadata must not be null.");
        }
        this.encoder = this.dictionaryMetadata.getEncoder();
        this.decoder = this.dictionaryMetadata.getDecoder();
        this.dictionaryMetadata.getSeparatorAsChar();
        this.createReplacementsMaps();
    }

    private void createReplacementsMaps() {
        for (Map.Entry entry : this.dictionaryMetadata.getReplacementPairs().entrySet()) {
            for (String s : (List)entry.getValue()) {
                ArrayList<Object> charList;
                if (s.length() == 1) {
                    if (!this.replacementsAnyToOne.containsKey(Character.valueOf(s.charAt(0)))) {
                        charList = new ArrayList<Object>();
                        charList.add(((String)entry.getKey()).toCharArray());
                        this.replacementsAnyToOne.put(Character.valueOf(s.charAt(0)), charList);
                        continue;
                    }
                    this.replacementsAnyToOne.get(Character.valueOf(s.charAt(0))).add(((String)entry.getKey()).toCharArray());
                    continue;
                }
                if (s.length() == 2) {
                    if (!this.replacementsAnyToTwo.containsKey(s)) {
                        charList = new ArrayList();
                        charList.add(((String)entry.getKey()).toCharArray());
                        this.replacementsAnyToTwo.put(s, charList);
                        continue;
                    }
                    this.replacementsAnyToTwo.get(s).add(((String)entry.getKey()).toCharArray());
                    continue;
                }
                if (!this.replacementsTheRest.containsKey(entry.getKey())) {
                    charList = new ArrayList();
                    charList.add(s);
                    this.replacementsTheRest.put((String)entry.getKey(), (List<String>)charList);
                    continue;
                }
                this.replacementsTheRest.get(entry.getKey()).add(s);
            }
        }
    }

    private ByteBuffer charSequenceToBytes(CharSequence word) throws UnmappableInputException {
        this.charBuffer = BufferUtils.clearAndEnsureCapacity((CharBuffer)this.charBuffer, (int)word.length());
        for (int i = 0; i < word.length(); ++i) {
            char chr = word.charAt(i);
            this.charBuffer.put(chr);
        }
        this.charBuffer.flip();
        return BufferUtils.charsToBytes((CharsetEncoder)this.encoder, (CharBuffer)this.charBuffer, (ByteBuffer)this.byteBuffer);
    }

    public boolean isMisspelled(String word) {
        String wordToCheck = word;
        if (!this.dictionaryMetadata.getInputConversionPairs().isEmpty()) {
            wordToCheck = DictionaryLookup.applyReplacements((CharSequence)word, (LinkedHashMap)this.dictionaryMetadata.getInputConversionPairs());
        }
        boolean isAlphabetic = wordToCheck.length() != 1 || Speller.isAlphabetic(wordToCheck.charAt(0));
        return !(wordToCheck.length() <= 0 || this.dictionaryMetadata.isIgnoringPunctuation() && !isAlphabetic || this.dictionaryMetadata.isIgnoringNumbers() && !Speller.containsNoDigit(wordToCheck) || this.dictionaryMetadata.isIgnoringCamelCase() && this.isCamelCase(wordToCheck) || this.dictionaryMetadata.isIgnoringAllUppercase() && isAlphabetic && this.isAllUppercase(wordToCheck) || this.isInDictionary(wordToCheck) || this.dictionaryMetadata.isConvertingCase() && !this.isMixedCase(wordToCheck) && (this.isInDictionary(wordToCheck.toLowerCase(this.dictionaryMetadata.getLocale())) || this.isAllUppercase(wordToCheck) && this.isInDictionary(this.initialUppercase(wordToCheck))));
    }

    private CharSequence initialUppercase(String wordToCheck) {
        return wordToCheck.substring(0, 1) + wordToCheck.substring(1).toLowerCase(this.dictionaryMetadata.getLocale());
    }

    public boolean isInDictionary(CharSequence word) {
        try {
            this.byteBuffer = this.charSequenceToBytes(word);
        }
        catch (UnmappableInputException e) {
            return false;
        }
        MatchResult match = this.matcher.match(this.matchResult, this.byteBuffer.array(), 0, this.byteBuffer.remaining(), this.rootNode);
        if (match.kind == 0) {
            this.containsSeparators = false;
            return true;
        }
        return this.containsSeparators && match.kind == -4 && this.byteBuffer.remaining() > 0 && this.fsa.getArc(match.node, this.dictionaryMetadata.getSeparator()) != 0;
    }

    public int getFrequency(CharSequence word) {
        int arc;
        if (!this.dictionaryMetadata.isFrequencyIncluded()) {
            return 0;
        }
        byte separator = this.dictionaryMetadata.getSeparator();
        try {
            this.byteBuffer = this.charSequenceToBytes(word);
        }
        catch (UnmappableInputException e) {
            return 0;
        }
        MatchResult match = this.matcher.match(this.matchResult, this.byteBuffer.array(), 0, this.byteBuffer.remaining(), this.rootNode);
        if (match.kind == -4 && (arc = this.fsa.getArc(match.node, separator)) != 0 && !this.fsa.isArcFinal(arc)) {
            this.finalStatesIterator.restartFrom(this.fsa.getEndNode(arc));
            if (this.finalStatesIterator.hasNext()) {
                ByteBuffer bb = this.finalStatesIterator.next();
                byte[] ba = bb.array();
                int bbSize = bb.remaining();
                return ba[bbSize - 1] - 65;
            }
        }
        return 0;
    }

    public List<String> replaceRunOnWords(String original) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (!this.isInDictionary(DictionaryLookup.applyReplacements((CharSequence)original, (LinkedHashMap)this.dictionaryMetadata.getInputConversionPairs())) && this.dictionaryMetadata.isSupportingRunOnWords()) {
            for (int i = 1; i < original.length(); ++i) {
                CharSequence firstCh = original.subSequence(0, i);
                if (!this.isInDictionary(firstCh) || !this.isInDictionary(original.subSequence(i, original.length()))) continue;
                if (!this.dictionaryMetadata.getOutputConversionPairs().isEmpty()) {
                    candidates.add(firstCh + " " + original.subSequence(i, original.length()));
                    continue;
                }
                candidates.add(DictionaryLookup.applyReplacements((CharSequence)(firstCh + " " + original.subSequence(i, original.length())), (LinkedHashMap)this.dictionaryMetadata.getOutputConversionPairs()).toString());
            }
        }
        return candidates;
    }

    public List<String> findReplacements(String w) {
        String word = w;
        if (!this.dictionaryMetadata.getInputConversionPairs().isEmpty()) {
            word = DictionaryLookup.applyReplacements((CharSequence)w, (LinkedHashMap)this.dictionaryMetadata.getInputConversionPairs());
        }
        this.candidates.clear();
        if (word.length() > 0 && word.length() < 120 && !this.isInDictionary(word)) {
            ArrayList<String> wordsToCheck = new ArrayList<String>();
            if (this.replacementsTheRest != null && word.length() > 4) {
                for (String string : this.getAllReplacements(word, 0, 0)) {
                    boolean bl = false;
                    if (this.isInDictionary(string)) {
                        this.candidates.add(new CandidateData(string, 0));
                        bl = true;
                    } else if (this.dictionaryMetadata.isConvertingCase()) {
                        String firstupperWord;
                        String lowerWord = string.toLowerCase(this.dictionaryMetadata.getLocale());
                        String upperWord = string.toUpperCase(this.dictionaryMetadata.getLocale());
                        if (this.isInDictionary(lowerWord)) {
                            this.candidates.add(new CandidateData(lowerWord, 0));
                            bl = true;
                        }
                        if (this.isInDictionary(upperWord)) {
                            this.candidates.add(new CandidateData(upperWord, 0));
                            bl = true;
                        }
                        if (lowerWord.length() > 1 && this.isInDictionary(firstupperWord = Character.toUpperCase(lowerWord.charAt(0)) + lowerWord.substring(1))) {
                            this.candidates.add(new CandidateData(firstupperWord, 0));
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    wordsToCheck.add(string);
                }
            } else {
                wordsToCheck.add(word);
            }
            if (this.candidates.isEmpty()) {
                int i = 1;
                for (String string : wordsToCheck) {
                    if (++i > 15) break;
                    this.wordProcessed = string.toCharArray();
                    this.wordLen = this.wordProcessed.length;
                    if (this.wordLen < 4 && i > 2) break;
                    this.candidate = new char[120];
                    this.candLen = this.candidate.length;
                    this.effectEditDistance = this.wordLen <= this.editDistance ? this.wordLen - 1 : this.editDistance;
                    this.charBuffer = BufferUtils.clearAndEnsureCapacity((CharBuffer)this.charBuffer, (int)120);
                    this.byteBuffer = BufferUtils.clearAndEnsureCapacity((ByteBuffer)this.byteBuffer, (int)120);
                    byte[] prevBytes = new byte[]{};
                    this.findRepl(0, this.fsa.getRootNode(), prevBytes, 0, 0);
                }
            }
        }
        Collections.sort(this.candidates);
        LinkedHashSet<String> candStringSet = new LinkedHashSet<String>();
        for (CandidateData candidateData : this.candidates) {
            candStringSet.add(DictionaryLookup.applyReplacements((CharSequence)candidateData.getWord(), (LinkedHashMap)this.dictionaryMetadata.getOutputConversionPairs()).toString());
        }
        ArrayList<String> candStringList = new ArrayList<String>(candStringSet.size());
        candStringList.addAll(candStringSet);
        return candStringList;
    }

    private void findRepl(int depth, int node, byte[] prevBytes, int wordIndex, int candIndex) {
        int dist = 0;
        int arc = this.fsa.getFirstArc(node);
        while (arc != 0) {
            this.byteBuffer = BufferUtils.clearAndEnsureCapacity((ByteBuffer)this.byteBuffer, (int)(prevBytes.length + 1));
            this.byteBuffer.put(prevBytes);
            this.byteBuffer.put(this.fsa.getArcLabel(arc));
            int bufPos = this.byteBuffer.position();
            this.byteBuffer.flip();
            this.decoder.reset();
            CoderResult c = this.decoder.decode(this.byteBuffer, this.charBuffer, true);
            if (c.isMalformed()) {
                byte[] prev = new byte[bufPos];
                this.byteBuffer.position(0);
                this.byteBuffer.get(prev);
                if (!this.fsa.isArcTerminal(arc)) {
                    this.findRepl(depth, this.fsa.getEndNode(arc), prev, wordIndex, candIndex);
                }
                this.byteBuffer.clear();
            } else if (!c.isError()) {
                this.charBuffer.flip();
                this.candidate[candIndex] = this.charBuffer.get();
                this.charBuffer.clear();
                this.byteBuffer.clear();
                int lengthReplacement = this.matchAnyToTwo(wordIndex, candIndex);
                if (lengthReplacement > 0) {
                    if (this.isEndOfCandidate(arc, wordIndex) && (dist = this.hMatrix.get(depth - 1, depth - 1)) <= this.effectEditDistance) {
                        if (Math.abs(this.wordLen - 1 - (wordIndex + lengthReplacement - 2)) > 0) {
                            dist += Math.abs(this.wordLen - 1 - (wordIndex + lengthReplacement - 2));
                        }
                        if (dist <= this.effectEditDistance) {
                            this.addCandidate(candIndex, dist);
                        }
                    }
                    if (this.isArcNotTerminal(arc, candIndex)) {
                        int x = this.hMatrix.get(depth, depth);
                        this.hMatrix.set(depth, depth, this.hMatrix.get(depth - 1, depth - 1));
                        this.findRepl(Math.max(0, depth), this.fsa.getEndNode(arc), new byte[0], wordIndex + lengthReplacement - 1, candIndex + 1);
                        this.hMatrix.set(depth, depth, x);
                    }
                }
                if ((lengthReplacement = this.matchAnyToOne(wordIndex, candIndex)) > 0) {
                    if (this.isEndOfCandidate(arc, wordIndex) && (dist = this.hMatrix.get(depth, depth)) <= this.effectEditDistance) {
                        if (Math.abs(this.wordLen - 1 - (wordIndex + lengthReplacement - 1)) > 0) {
                            dist += Math.abs(this.wordLen - 1 - (wordIndex + lengthReplacement - 1));
                        }
                        if (dist <= this.effectEditDistance) {
                            this.addCandidate(candIndex, dist);
                        }
                    }
                    if (this.isArcNotTerminal(arc, candIndex)) {
                        this.findRepl(depth, this.fsa.getEndNode(arc), new byte[0], wordIndex + lengthReplacement, candIndex + 1);
                    }
                }
                if (this.cuted(depth, wordIndex, candIndex) <= this.effectEditDistance) {
                    if (this.isEndOfCandidate(arc, wordIndex) && (dist = this.ed(this.wordLen - 1 - (wordIndex - depth), depth, this.wordLen - 1, candIndex)) <= this.effectEditDistance) {
                        this.addCandidate(candIndex, dist);
                    }
                    if (this.isArcNotTerminal(arc, candIndex)) {
                        this.findRepl(depth + 1, this.fsa.getEndNode(arc), new byte[0], wordIndex + 1, candIndex + 1);
                    }
                }
            }
            arc = this.fsa.getNextArc(arc);
        }
    }

    private boolean isArcNotTerminal(int arc, int candIndex) {
        return !this.fsa.isArcTerminal(arc) && (!this.containsSeparators || this.candidate[candIndex] != this.dictionaryMetadata.getSeparatorAsChar());
    }

    private boolean isEndOfCandidate(int arc, int wordIndex) {
        return (this.fsa.isArcFinal(arc) || this.isBeforeSeparator(arc)) && Math.abs(this.wordLen - 1 - wordIndex) <= this.effectEditDistance;
    }

    private boolean isBeforeSeparator(int arc) {
        if (this.containsSeparators) {
            int arc1 = this.fsa.getArc(this.fsa.getEndNode(arc), this.dictionaryMetadata.getSeparator());
            return arc1 != 0 && !this.fsa.isArcTerminal(arc1);
        }
        return false;
    }

    private void addCandidate(int depth, int dist) {
        this.candidates.add(new CandidateData(String.valueOf(this.candidate, 0, depth + 1), dist));
    }

    public int ed(int i, int j, int wordIndex, int candIndex) {
        int result;
        if (this.areEqual(this.wordProcessed[wordIndex], this.candidate[candIndex])) {
            result = this.hMatrix.get(i, j);
        } else if (wordIndex > 0 && candIndex > 0 && this.wordProcessed[wordIndex] == this.candidate[candIndex - 1] && this.wordProcessed[wordIndex - 1] == this.candidate[candIndex]) {
            int a = this.hMatrix.get(i - 1, j - 1);
            int b = this.hMatrix.get(i + 1, j);
            int c = this.hMatrix.get(i, j + 1);
            result = 1 + Speller.min(a, b, c);
        } else {
            int a = this.hMatrix.get(i, j);
            int b = this.hMatrix.get(i + 1, j);
            int c = this.hMatrix.get(i, j + 1);
            result = 1 + Speller.min(a, b, c);
        }
        this.hMatrix.set(i + 1, j + 1, result);
        return result;
    }

    private boolean areEqual(char x, char y) {
        if (x == y) {
            return true;
        }
        if (this.dictionaryMetadata.getEquivalentChars() != null && this.dictionaryMetadata.getEquivalentChars().containsKey(Character.valueOf(x)) && ((List)this.dictionaryMetadata.getEquivalentChars().get(Character.valueOf(x))).contains(Character.valueOf(y))) {
            return true;
        }
        if (this.dictionaryMetadata.isIgnoringDiacritics()) {
            String xn = Normalizer.normalize(Character.toString(x), Normalizer.Form.NFD);
            String yn = Normalizer.normalize(Character.toString(y), Normalizer.Form.NFD);
            if (xn.charAt(0) == yn.charAt(0)) {
                return true;
            }
            if (this.dictionaryMetadata.isConvertingCase() && Character.isLetter(xn.charAt(0))) {
                boolean testNeeded;
                boolean bl = testNeeded = Character.isLowerCase(xn.charAt(0)) != Character.isLowerCase(yn.charAt(0));
                if (testNeeded) {
                    return Character.toLowerCase(xn.charAt(0)) == Character.toLowerCase(yn.charAt(0));
                }
            }
            return xn.charAt(0) == yn.charAt(0);
        }
        return false;
    }

    public int cuted(int depth, int wordIndex, int candIndex) {
        int l = Math.max(0, depth - this.effectEditDistance);
        int u = Math.min(this.wordLen - 1 - (wordIndex - depth), depth + this.effectEditDistance);
        int minEd = this.effectEditDistance + 1;
        int wi = wordIndex + l - depth;
        int i = l;
        while (i <= u) {
            int d = this.ed(i, depth, wi, candIndex);
            if (d < minEd) {
                minEd = d;
            }
            ++i;
            ++wi;
        }
        return minEd;
    }

    private int matchAnyToOne(int wordIndex, int candIndex) {
        if (this.replacementsAnyToOne.containsKey(Character.valueOf(this.candidate[candIndex]))) {
            for (char[] rep : this.replacementsAnyToOne.get(Character.valueOf(this.candidate[candIndex]))) {
                int i;
                for (i = 0; i < rep.length && wordIndex + i < this.wordLen && rep[i] == this.wordProcessed[wordIndex + i]; ++i) {
                }
                if (i != rep.length) continue;
                return i;
            }
        }
        return 0;
    }

    private int matchAnyToTwo(int wordIndex, int candIndex) {
        char[] twoChar;
        String sTwoChar;
        if (candIndex > 0 && candIndex < this.candidate.length && wordIndex > 0 && this.replacementsAnyToTwo.containsKey(sTwoChar = new String(twoChar = new char[]{this.candidate[candIndex - 1], this.candidate[candIndex]}))) {
            for (char[] rep : this.replacementsAnyToTwo.get(sTwoChar)) {
                int i;
                if (rep.length == 2 && wordIndex < this.wordLen && this.candidate[candIndex - 1] == this.wordProcessed[wordIndex - 1] && this.candidate[candIndex] == this.wordProcessed[wordIndex]) {
                    return 0;
                }
                for (i = 0; i < rep.length && wordIndex - 1 + i < this.wordLen && rep[i] == this.wordProcessed[wordIndex - 1 + i]; ++i) {
                }
                if (i != rep.length) continue;
                return i;
            }
        }
        return 0;
    }

    private static int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    static boolean isAlphabetic(int codePoint) {
        return (1086 >> Character.getType(codePoint) & 1) != 0;
    }

    static boolean containsNoDigit(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (!Character.isDigit(s.charAt(k))) continue;
            return false;
        }
        return true;
    }

    boolean isAllUppercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    boolean isNotAllLowercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    boolean isNotCapitalizedWord(String str) {
        if (Speller.isNotEmpty(str) && Character.isUpperCase(str.charAt(0))) {
            for (int i = 1; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static boolean isNotEmpty(String str) {
        return str != null && str.length() != 0;
    }

    boolean isMixedCase(String str) {
        return !this.isAllUppercase(str) && this.isNotCapitalizedWord(str) && this.isNotAllLowercase(str);
    }

    public boolean isCamelCase(String str) {
        return Speller.isNotEmpty(str) && !this.isAllUppercase(str) && this.isNotCapitalizedWord(str) && Character.isUpperCase(str.charAt(0)) && (str.length() <= 1 || Character.isLowerCase(str.charAt(1))) && this.isNotAllLowercase(str);
    }

    public boolean convertsCase() {
        return this.dictionaryMetadata.isConvertingCase();
    }

    public List<String> getAllReplacements(String str, int fromIndex, int level) {
        ArrayList<String> replaced = new ArrayList<String>();
        if (level > 6) {
            replaced.add(str);
            return replaced;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        int index = 120;
        String key = "";
        int keyLength = 0;
        boolean found = false;
        for (String auxKey : this.replacementsTheRest.keySet()) {
            int auxIndex = sb.indexOf(auxKey, fromIndex);
            if (auxIndex <= -1 || auxIndex >= index && (auxIndex != index || auxKey.length() < keyLength)) continue;
            index = auxIndex;
            key = auxKey;
            keyLength = auxKey.length();
        }
        if (index < 120) {
            for (String rep : this.replacementsTheRest.get(key)) {
                if (!found) {
                    replaced.addAll(this.getAllReplacements(str, index + key.length(), level + 1));
                    found = true;
                }
                int ind = sb.indexOf(rep, fromIndex - rep.length() + 1);
                if (rep.length() > key.length() && ind > -1 && (ind == index || ind == index - rep.length() + 1)) continue;
                sb.replace(index, index + key.length(), rep);
                replaced.addAll(this.getAllReplacements(sb.toString(), index + rep.length(), level + 1));
                sb.setLength(0);
                sb.append(str);
            }
        }
        if (!found) {
            replaced.add(sb.toString());
        }
        return replaced;
    }

    void setWordAndCandidate(String word, String candidate) {
        this.wordProcessed = word.toCharArray();
        this.wordLen = this.wordProcessed.length;
        this.candidate = candidate.toCharArray();
        this.candLen = this.candidate.length;
        this.effectEditDistance = this.wordLen <= this.editDistance ? this.wordLen - 1 : this.editDistance;
    }

    public final int getWordLen() {
        return this.wordLen;
    }

    public final int getCandLen() {
        return this.candLen;
    }

    public final int getEffectiveED() {
        return this.effectEditDistance;
    }

    private class CandidateData
    implements Comparable<CandidateData> {
        private final String word;
        private final int distance;

        CandidateData(String word, int distance) {
            this.word = word;
            this.distance = distance * 26 + 26 - Speller.this.getFrequency(word) - 1;
        }

        final String getWord() {
            return this.word;
        }

        final int getDistance() {
            return this.distance;
        }

        @Override
        public int compareTo(CandidateData cd) {
            return cd.getDistance() > this.distance ? -1 : (cd.getDistance() == this.distance ? 0 : 1);
        }
    }
}

