/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.patricia;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.trie4j.AbstractTrie;
import org.trie4j.NodeVisitor;
import org.trie4j.Trie;
import org.trie4j.patricia.PatriciaTrieNode;
import org.trie4j.util.Pair;

public class PatriciaTrie
extends AbstractTrie
implements Serializable,
Trie {
    private int size;
    private int nodeSize;
    private PatriciaTrieNode root = this.newNode();
    private static final long serialVersionUID = -7611399538600722195L;

    public PatriciaTrie() {
    }

    public PatriciaTrie(String ... words) {
        for (String s : words) {
            this.insert(s);
        }
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(String text) {
        PatriciaTrieNode node = this.root;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((node = node.getChild(text.charAt(i))) == null) {
                return false;
            }
            char[] letters = node.getLetters();
            int lettersLen = letters.length;
            for (int j = 1; j < lettersLen; ++j) {
                if (++i == n) {
                    return false;
                }
                if (text.charAt(i) == letters[j]) continue;
                return false;
            }
        }
        return node.isTerminate();
    }

    public PatriciaTrieNode getNode(String text) {
        PatriciaTrieNode node = this.root;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((node = node.getChild(text.charAt(i))) == null) {
                return null;
            }
            char[] letters = node.getLetters();
            int lettersLen = letters.length;
            for (int j = 1; j < lettersLen; ++j) {
                if (++i == n) {
                    return null;
                }
                if (text.charAt(i) == letters[j]) continue;
                return null;
            }
        }
        if (node.isTerminate()) {
            return node;
        }
        return null;
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] queryChars = query.toCharArray();
        int cur = 0;
        for (PatriciaTrieNode node = this.root; node != null; node = node.getChild(queryChars[cur])) {
            char[] letters = node.getLetters();
            if (letters.length > queryChars.length - cur) {
                return ret;
            }
            for (int i = 0; i < letters.length; ++i) {
                if (letters[i] == queryChars[cur + i]) continue;
                return ret;
            }
            if (node.isTerminate()) {
                ret.add(new String(queryChars, 0, cur + letters.length));
            }
            if (queryChars.length != (cur += letters.length)) continue;
            return ret;
        }
        return ret;
    }

    public Iterable<Pair<String, PatriciaTrieNode>> commonPrefixSearchWithNode(String query) {
        ArrayList<Pair<String, PatriciaTrieNode>> ret = new ArrayList<Pair<String, PatriciaTrieNode>>();
        char[] queryChars = query.toCharArray();
        int cur = 0;
        for (PatriciaTrieNode node = this.root; node != null; node = node.getChild(queryChars[cur])) {
            char[] letters = node.getLetters();
            if (letters.length > queryChars.length - cur) {
                return ret;
            }
            for (int i = 0; i < letters.length; ++i) {
                if (letters[i] == queryChars[cur + i]) continue;
                return ret;
            }
            if (node.isTerminate()) {
                ret.add(Pair.create(new String(queryChars, 0, cur + letters.length), node));
            }
            if (queryChars.length != (cur += letters.length)) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        char[] queryChars = prefix.toCharArray();
        int cur = 0;
        for (PatriciaTrieNode node = this.root; node != null; node = node.getChild(queryChars[cur])) {
            char[] letters = node.getLetters();
            int n = Math.min(letters.length, queryChars.length - cur);
            for (int i = 0; i < n; ++i) {
                if (letters[i] == queryChars[cur + i]) continue;
                return Collections.emptyList();
            }
            if (queryChars.length != (cur += n)) continue;
            ArrayList<String> ret = new ArrayList<String>();
            int rest = letters.length - n;
            if (rest > 0) {
                prefix = prefix + new String(letters, n, rest);
            }
            if (node.isTerminate()) {
                ret.add(prefix);
            }
            PatriciaTrie.enumLetters(node, prefix, ret);
            return ret;
        }
        return Collections.emptyList();
    }

    public Iterable<Pair<String, PatriciaTrieNode>> predictiveSearchWithNode(String prefix) {
        char[] queryChars = prefix.toCharArray();
        int cur = 0;
        for (PatriciaTrieNode node = this.root; node != null; node = node.getChild(queryChars[cur])) {
            char[] letters = node.getLetters();
            int n = Math.min(letters.length, queryChars.length - cur);
            for (int i = 0; i < n; ++i) {
                if (letters[i] == queryChars[cur + i]) continue;
                return Collections.emptyList();
            }
            if (queryChars.length != (cur += n)) continue;
            ArrayList<Pair<String, PatriciaTrieNode>> ret = new ArrayList<Pair<String, PatriciaTrieNode>>();
            int rest = letters.length - n;
            if (rest > 0) {
                prefix = prefix + new String(letters, n, rest);
            }
            if (node.isTerminate()) {
                ret.add(Pair.create(prefix, node));
            }
            PatriciaTrie.enumLettersWithNode(node, prefix, ret);
            return ret;
        }
        return Collections.emptyList();
    }

    @Override
    public void insert(String text) {
        this.insert(this.root, text, 0);
    }

    protected PatriciaTrieNode insert(PatriciaTrieNode node, String letters, int offset) {
        int index;
        int i;
        boolean cont;
        int lettersRest = letters.length() - offset;
        block0: do {
            int thisLettersLength = node.getLetters().length;
            int n = Math.min(lettersRest, thisLettersLength);
            for (i = 0; i < n && letters.charAt(i + offset) - node.getLetters()[i] == 0; ++i) {
            }
            if (i != n) {
                PatriciaTrieNode child1 = this.newNode(Arrays.copyOfRange(node.getLetters(), i, node.getLetters().length), node);
                PatriciaTrieNode child2 = this.newNode(letters.substring(i + offset).toCharArray(), true);
                node.setLetters(Arrays.copyOfRange(node.getLetters(), 0, i));
                node.setTerminate(false);
                node.setChildren(child1.getLetters()[0] < child2.getLetters()[0] ? this.newNodeArray(child1, child2) : this.newNodeArray(child2, child1));
                ++this.size;
                this.nodeSize += 2;
                return child2;
            }
            if (lettersRest == thisLettersLength) {
                if (!node.isTerminate()) {
                    node.setTerminate(true);
                    ++this.size;
                }
                return node;
            }
            if (lettersRest < thisLettersLength) {
                PatriciaTrieNode newChild = this.newNode(Arrays.copyOfRange(node.getLetters(), lettersRest, thisLettersLength), node);
                node.setLetters(Arrays.copyOfRange(node.getLetters(), 0, i));
                node.setTerminate(true);
                node.setChildren(this.newNodeArray(newChild));
                ++this.size;
                ++this.nodeSize;
                return node;
            }
            int end = node.getChildren().length;
            cont = false;
            if (end > 16) {
                int start = 0;
                while (start < end) {
                    index = (start + end) / 2;
                    PatriciaTrieNode child = node.getChildren()[index];
                    int c = letters.charAt(i + offset) - child.getLetters()[0];
                    if (c == 0) {
                        node = child;
                        offset += i;
                        lettersRest -= i;
                        cont = true;
                        continue block0;
                    }
                    if (c < 0) {
                        end = index;
                        continue;
                    }
                    if (start == index) {
                        index = end;
                        continue block0;
                    }
                    start = index;
                }
            } else {
                for (index = 0; index < end; ++index) {
                    PatriciaTrieNode child = node.getChildren()[index];
                    int c = letters.charAt(i + offset) - child.getLetters()[0];
                    if (c < 0) continue block0;
                    if (c != 0) continue;
                    node = child;
                    offset += i;
                    lettersRest -= i;
                    cont = true;
                    continue block0;
                }
            }
        } while (cont);
        PatriciaTrieNode child = this.newNode(letters.substring(i + offset).toCharArray(), true);
        node.addChild(index, child);
        ++this.size;
        ++this.nodeSize;
        return child;
    }

    public void visit(NodeVisitor visitor) {
        this.root.visit(visitor, 0);
    }

    @Override
    public PatriciaTrieNode getRoot() {
        return this.root;
    }

    protected PatriciaTrieNode newNode() {
        return new PatriciaTrieNode();
    }

    protected PatriciaTrieNode newNode(char[] letters, PatriciaTrieNode source) {
        return new PatriciaTrieNode(letters, source.isTerminate(), source.getChildren());
    }

    protected PatriciaTrieNode newNode(char[] letters, boolean terminated) {
        return new PatriciaTrieNode(letters, terminated);
    }

    protected PatriciaTrieNode[] newNodeArray(PatriciaTrieNode ... nodes) {
        return nodes;
    }

    private static void enumLetters(PatriciaTrieNode node, String prefix, List<String> letters) {
        for (PatriciaTrieNode child : node.getChildren()) {
            String text = prefix + new String(child.getLetters());
            if (child.isTerminate()) {
                letters.add(text);
            }
            PatriciaTrie.enumLetters(child, text, letters);
        }
    }

    private static void enumLettersWithNode(PatriciaTrieNode node, String prefix, List<Pair<String, PatriciaTrieNode>> letters) {
        for (PatriciaTrieNode child : node.getChildren()) {
            String text = prefix + new String(child.getLetters());
            if (child.isTerminate()) {
                letters.add(Pair.create(text, child));
            }
            PatriciaTrie.enumLettersWithNode(child, text, letters);
        }
    }
}

