/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.WikiGet;

public class ApertiumTranslate
extends BaseTranslate {
    protected static final String PROPERTY_APERTIUM_MARKUNKNOWN = "apertium.server.markunknown";
    protected static final String PROPERTY_APERTIUM_SERVER_CUSTOM = "apertium.server.custom";
    protected static final String PROPERTY_APERTIUM_SERVER_URL = "apertium.server.url";
    protected static final String PROPERTY_APERTIUM_SERVER_KEY = "apertium.server.key";
    protected static final String APERTIUM_SERVER_URL_DEFAULT = "https://www.apertium.org/apy";
    protected static final String APERTIUM_SERVER_URL_FORMAT = "%s/translate?q=%s&markUnknown=%s&langpair=%s|%s&key=%s";
    protected static final String APERTIUM_SERVER_KEY_DEFAULT = "bwuxb5jS+VwSJ8mLz1qMfmMrDGA";

    @Override
    protected String getPreferenceName() {
        return "allow_apertium_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_APERTIUM");
    }

    private String apertiumCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase(Locale.ENGLISH);
        String locale = language.getLocaleCode();
        if (!StringUtil.isEmpty(language.getCountryCode())) {
            if (locale.equalsIgnoreCase("en_us") || locale.equalsIgnoreCase("pt_br")) {
                return locale;
            }
            if (locale.equalsIgnoreCase("oc_ar")) {
                return "oc_aran";
            }
            if (locale.equalsIgnoreCase("ca_va")) {
                return "ca_valencia";
            }
        }
        return lCode;
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String v;
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        String trText = text;
        String sourceLang = this.apertiumCode(sLang);
        String targetLang = this.apertiumCode(tLang);
        String server = this.getCustomServerUrl();
        String apiKey = this.getCredential(PROPERTY_APERTIUM_SERVER_KEY);
        if (!this.useCustomServer()) {
            server = APERTIUM_SERVER_URL_DEFAULT;
            apiKey = APERTIUM_SERVER_KEY_DEFAULT;
        }
        String markUnknownVal = this.useMarkUnknown() ? "yes" : "no";
        String url = String.format(APERTIUM_SERVER_URL_FORMAT, server, URLEncoder.encode(trText, "UTF-8"), markUnknownVal, sourceLang, targetLang, apiKey);
        try {
            v = WikiGet.getURL(url);
        }
        catch (IOException e) {
            Log.logErrorRB(e, "APERTIUM_CUSTOM_SERVER_NOTFOUND", new Object[0]);
            return OStrings.getString("APERTIUM_CUSTOM_SERVER_NOTFOUND");
        }
        String tr = this.getJsonResults(v);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }

    protected String getJsonResults(String json) {
        Map rootNode;
        try {
            rootNode = (Map)JsonParser.parse(json);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_JSON_ERROR");
        }
        Integer code = 0;
        String tr = null;
        if (!rootNode.containsKey("responseStatus")) {
            return OStrings.getString("APERTIUM_CUSTOM_SERVER_INVALID");
        }
        code = (Integer)rootNode.get("responseStatus");
        if (rootNode.containsKey("responseData")) {
            Map data = (Map)rootNode.get("responseData");
            tr = (String)data.get("translatedText");
        }
        if (tr == null || code != 200) {
            String details = (String)rootNode.get("responseDetails");
            return StringUtil.format(OStrings.getString("APERTIUM_ERROR"), code, details);
        }
        return tr;
    }

    private boolean useMarkUnknown() {
        String value = System.getProperty(PROPERTY_APERTIUM_MARKUNKNOWN, Preferences.getPreference(PROPERTY_APERTIUM_MARKUNKNOWN));
        return Boolean.parseBoolean(value);
    }

    private boolean useCustomServer() {
        String value = System.getProperty(PROPERTY_APERTIUM_SERVER_CUSTOM, Preferences.getPreference(PROPERTY_APERTIUM_SERVER_CUSTOM));
        return Boolean.parseBoolean(value);
    }

    private String getCustomServerUrl() {
        String value = System.getProperty(PROPERTY_APERTIUM_SERVER_URL, Preferences.getPreference(PROPERTY_APERTIUM_SERVER_URL));
        return value;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        final JCheckBox unkCheckBox = new JCheckBox(OStrings.getString("APERTIUM_MARKUNKNOWN_LABEL"));
        unkCheckBox.setSelected(this.useMarkUnknown());
        final JCheckBox apiCheckBox = new JCheckBox(OStrings.getString("APERTIUM_CUSTOM_SERVER_LABEL"));
        apiCheckBox.setSelected(this.useCustomServer());
        final MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                System.setProperty(ApertiumTranslate.PROPERTY_APERTIUM_MARKUNKNOWN, Boolean.toString(unkCheckBox.isSelected()));
                Preferences.setPreference(ApertiumTranslate.PROPERTY_APERTIUM_MARKUNKNOWN, unkCheckBox.isSelected());
                System.setProperty(ApertiumTranslate.PROPERTY_APERTIUM_SERVER_CUSTOM, Boolean.toString(apiCheckBox.isSelected()));
                Preferences.setPreference(ApertiumTranslate.PROPERTY_APERTIUM_SERVER_CUSTOM, apiCheckBox.isSelected());
                String server = this.panel.valueField1.getText().trim();
                String apiKey = this.panel.valueField2.getText().trim();
                if (!ApertiumTranslate.this.getCustomServerUrl().equals(server)) {
                    ApertiumTranslate.this.clearCache();
                }
                System.setProperty(ApertiumTranslate.PROPERTY_APERTIUM_SERVER_URL, server);
                Preferences.setPreference(ApertiumTranslate.PROPERTY_APERTIUM_SERVER_URL, server);
                ApertiumTranslate.this.setCredential(ApertiumTranslate.PROPERTY_APERTIUM_SERVER_KEY, apiKey, temporary);
            }
        };
        final Runnable updateOk = () -> {
            boolean needsFields = apiCheckBox.isSelected();
            boolean hasFields = !dialog.panel.valueField1.getText().trim().isEmpty();
            boolean canConfirm = !needsFields || hasFields;
            dialog.panel.okButton.setEnabled(canConfirm);
        };
        DocumentListener toggleOkButton = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                updateOk.run();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                updateOk.run();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                updateOk.run();
            }
        };
        ItemListener toggleInterface = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                dialog.panel.valueLabel1.setEnabled(apiCheckBox.isSelected());
                dialog.panel.valueLabel2.setEnabled(apiCheckBox.isSelected());
                dialog.panel.valueField1.setEnabled(apiCheckBox.isSelected());
                dialog.panel.valueField2.setEnabled(apiCheckBox.isSelected());
                dialog.panel.temporaryCheckBox.setEnabled(apiCheckBox.isSelected());
                updateOk.run();
            }
        };
        apiCheckBox.addItemListener(toggleInterface);
        dialog.panel.valueField1.getDocument().addDocumentListener(toggleOkButton);
        dialog.panel.itemsPanel.add(unkCheckBox);
        dialog.panel.itemsPanel.add((Component)apiCheckBox, 1);
        dialog.panel.valueLabel1.setText(OStrings.getString("APERTIUM_CUSTOM_SERVER_URL_LABEL"));
        dialog.panel.valueField1.setText(this.getCustomServerUrl());
        dialog.panel.valueField1.setColumns(20);
        dialog.panel.valueLabel2.setText(OStrings.getString("APERTIUM_CUSTOM_SERVER_KEY_LABEL"));
        dialog.panel.valueField2.setText(this.getCredential(PROPERTY_APERTIUM_SERVER_KEY));
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_APERTIUM_SERVER_KEY));
        toggleInterface.itemStateChanged(null);
        dialog.show();
    }
}

