/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.IGlossaryRenderer;
import org.omegat.util.gui.TooltipAttribute;

public class DefaultGlossaryRenderer
implements IGlossaryRenderer {
    @Override
    public void render(GlossaryEntry entry, StyledDocument doc) {
        DocTarget trg = new DocTarget(doc);
        this.render(entry, trg);
        trg.append("\n\n");
    }

    protected void render(GlossaryEntry entry, IRenderTarget<?> trg) {
        trg.append(entry.getSrcText());
        trg.append(" = ");
        String[] targets = entry.getLocTerms(false);
        String[] comments = entry.getComments();
        boolean[] priorities = entry.getPriorities();
        String[] origins = entry.getOrigins(false);
        StringBuilder commentsBuf = new StringBuilder();
        int commentIndex = 0;
        for (int i = 0; i < targets.length; ++i) {
            if (i > 0 && targets[i].equals(targets[i - 1])) {
                if (comments[i].equals("")) continue;
                commentsBuf.append("\n");
                commentsBuf.append(String.valueOf(commentIndex));
                commentsBuf.append(". ");
                commentsBuf.append(comments[i]);
                continue;
            }
            if (i > 0) {
                trg.append(", ");
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet(priorities[i] ? PRIORITY_ATTRIBUTES : NO_ATTRIBUTES);
            attrs.addAttribute("tooltip_payload", new TooltipAttribute(origins[i]));
            trg.append(this.bracketEntry(targets[i]), attrs);
            ++commentIndex;
            if (comments[i].equals("")) continue;
            commentsBuf.append("\n");
            commentsBuf.append(String.valueOf(commentIndex));
            commentsBuf.append(". ");
            commentsBuf.append(comments[i]);
        }
        trg.append(commentsBuf.toString());
    }

    public String renderToHtml(GlossaryEntry entry) {
        HtmlTarget trg = new HtmlTarget();
        this.render(entry, trg);
        return trg.get();
    }

    private String bracketEntry(String entry) {
        if (entry.contains(",") && !entry.contains(";") && !entry.contains("\"")) {
            entry = '\"' + entry + '\"';
        }
        return entry;
    }

    protected static class HtmlTarget
    implements IRenderTarget<String> {
        private final StringBuilder buf = new StringBuilder();

        protected HtmlTarget() {
        }

        @Override
        public void append(String str) {
            this.append(str, null);
        }

        @Override
        public void append(String str, AttributeSet attr) {
            if (attr != null) {
                if (StyleConstants.isBold(attr)) {
                    this.buf.append("<b>");
                }
                if (StyleConstants.isItalic(attr)) {
                    this.buf.append("<i>");
                }
            }
            this.buf.append(str);
            if (attr != null) {
                if (StyleConstants.isItalic(attr)) {
                    this.buf.append("</i>");
                }
                if (StyleConstants.isBold(attr)) {
                    this.buf.append("</b>");
                }
            }
        }

        @Override
        public String get() {
            return "<html><p>" + this.buf.toString().replace("\n", "<br>") + "</p></html>";
        }
    }

    protected static class DocTarget
    implements IRenderTarget<Void> {
        private final StyledDocument doc;

        DocTarget(StyledDocument doc) {
            this.doc = doc;
        }

        @Override
        public void append(String str) {
            this.append(str, null);
        }

        @Override
        public void append(String str, AttributeSet attr) {
            try {
                this.doc.insertString(this.doc.getLength(), str, attr);
            }
            catch (BadLocationException e) {
                Logger.getLogger(DefaultGlossaryRenderer.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }

        @Override
        public Void get() {
            return null;
        }
    }

    protected static interface IRenderTarget<T> {
        public void append(String var1);

        public void append(String var1, AttributeSet var2);

        public T get();
    }
}

