/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.util.StringUtil;
import org.omegat.util.VarExpansion;

public class CommandVarExpansion
extends VarExpansion<ProjectProperties> {
    public static final String PROJECT_NAME = "${projectName}";
    public static final String PROJECT_ROOT = "${projectRoot}";
    public static final String SOURCE_ROOT = "${sourceRoot}";
    public static final String TARGET_ROOT = "${targetRoot}";
    public static final String GLOSSARY_ROOT = "${glossaryRoot}";
    public static final String WRITABLE_GLOSSARY_FILE = "${glossaryFile}";
    public static final String TM_ROOT = "${tmRoot}";
    public static final String TM_AUTO_ROOT = "${tmAutoRoot}";
    public static final String DICT_ROOT = "${dictRoot}";
    public static final String TM_OTHER_LANG_ROOT = "${tmOtherLangRoot}";
    public static final String SOURCE_LANGUAGE = "${sourceLang}";
    public static final String TARGET_LANGUAGE = "${targetLang}";
    private static final String[] COMMAND_VARIABLES;

    public static List<String> getCommandVariables() {
        return Collections.unmodifiableList(Arrays.asList(COMMAND_VARIABLES));
    }

    public CommandVarExpansion(String template) {
        super(template);
    }

    @Override
    public String expandVariables(ProjectProperties props) {
        String localTemplate = this.template;
        localTemplate = localTemplate.replace(PROJECT_NAME, props.getProjectName());
        localTemplate = localTemplate.replace(PROJECT_ROOT, CommandVarExpansion.fixSeparatorChar(props.getProjectRoot()));
        localTemplate = localTemplate.replace(SOURCE_ROOT, CommandVarExpansion.fixSeparatorChar(props.getSourceRoot()));
        localTemplate = localTemplate.replace(TARGET_ROOT, CommandVarExpansion.fixSeparatorChar(props.getTargetRoot()));
        localTemplate = localTemplate.replace(GLOSSARY_ROOT, CommandVarExpansion.fixSeparatorChar(props.getGlossaryRoot()));
        localTemplate = localTemplate.replace(WRITABLE_GLOSSARY_FILE, CommandVarExpansion.fixSeparatorChar(props.getWriteableGlossary()));
        localTemplate = localTemplate.replace(TM_ROOT, CommandVarExpansion.fixSeparatorChar(props.getTMRoot()));
        localTemplate = localTemplate.replace(TM_AUTO_ROOT, CommandVarExpansion.fixSeparatorChar(props.getTMAutoRoot()));
        localTemplate = localTemplate.replace(DICT_ROOT, CommandVarExpansion.fixSeparatorChar(props.getDictRoot()));
        localTemplate = localTemplate.replace(TM_OTHER_LANG_ROOT, CommandVarExpansion.fixSeparatorChar(props.getTMOtherLangRoot()));
        localTemplate = localTemplate.replace(SOURCE_LANGUAGE, props.getSourceLanguage().getLanguage());
        localTemplate = localTemplate.replace(TARGET_LANGUAGE, props.getTargetLanguage().getLanguage());
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            localTemplate = localTemplate.replace(CommandVarExpansion.fixEnvarName(e.getKey()), e.getValue());
        }
        String currentFile = Core.getEditor().getCurrentFile();
        if (!StringUtil.isEmpty(currentFile)) {
            String sourceRoot = props.getSourceRoot();
            localTemplate = this.expandFileName(localTemplate, sourceRoot + currentFile, sourceRoot);
        }
        return localTemplate;
    }

    public static String fixSeparatorChar(String path) {
        return path.replace('/', File.separatorChar);
    }

    private static String fixEnvarName(String varname) {
        return String.format("${%s}", varname);
    }

    static {
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(PROJECT_NAME);
        vars.add(PROJECT_ROOT);
        vars.add(SOURCE_ROOT);
        vars.add(TARGET_ROOT);
        vars.add(GLOSSARY_ROOT);
        vars.add(WRITABLE_GLOSSARY_FILE);
        vars.add(TM_ROOT);
        vars.add(TM_AUTO_ROOT);
        vars.add(DICT_ROOT);
        vars.add(TM_OTHER_LANG_ROOT);
        vars.add(SOURCE_LANGUAGE);
        vars.add(TARGET_LANGUAGE);
        vars.add("${filePath}");
        vars.add("${fileShortPath}");
        vars.add("${fileName}");
        vars.add("${fileNameOnly}");
        vars.add("${fileExtension}");
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            vars.add(CommandVarExpansion.fixEnvarName(e.getKey()));
        }
        COMMAND_VARIABLES = vars.toArray(new String[vars.size()]);
    }
}

