/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.formatter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.coretypes.Category;
import net.loomchild.maligna.formatter.Formatter;

public class InfoFormatter
implements Formatter {
    private PrintWriter writer;

    public InfoFormatter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    @Override
    public void format(List<Alignment> alignmentList) {
        int alignmentCount = alignmentList.size();
        TreeMap<Category, Integer> categoryMap = new TreeMap<Category, Integer>(new CategoryComparator());
        for (Alignment alignment : alignmentList) {
            Category category = alignment.getCategory();
            Integer occurenceCount = (Integer)categoryMap.get(category);
            occurenceCount = occurenceCount == null ? Integer.valueOf(1) : Integer.valueOf(occurenceCount + 1);
            categoryMap.put(category, occurenceCount);
        }
        for (Map.Entry entry : categoryMap.entrySet()) {
            this.writer.println(((Category)entry.getKey()).toString() + "\t" + entry.getValue());
        }
        this.writer.println("Total\t" + alignmentCount);
        this.writer.flush();
    }

    private static class CategoryComparator
    implements Comparator<Category>,
    Serializable {
        private static final long serialVersionUID = 2369430623799175503L;

        private CategoryComparator() {
        }

        @Override
        public int compare(Category leftCategory, Category rightCategory) {
            int result = this.getMinimumSegmentCount(leftCategory) - this.getMinimumSegmentCount(rightCategory);
            if (result == 0 && (result = this.getMaximumSegmentCount(leftCategory) - this.getMaximumSegmentCount(rightCategory)) == 0) {
                result = leftCategory.getSourceSegmentCount() - rightCategory.getSourceSegmentCount();
            }
            return result;
        }

        private int getMinimumSegmentCount(Category category) {
            return Math.min(category.getSourceSegmentCount(), category.getTargetSegmentCount());
        }

        private int getMaximumSegmentCount(Category category) {
            return Math.max(category.getSourceSegmentCount(), category.getTargetSegmentCount());
        }
    }
}

