/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.aligner.align.hmm.adaptive;

import java.util.List;
import java.util.Map;
import net.loomchild.maligna.calculator.Calculator;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.coretypes.Category;
import net.loomchild.maligna.coretypes.CategoryDefaults;
import net.loomchild.maligna.filter.aligner.align.AlignAlgorithm;
import net.loomchild.maligna.filter.aligner.align.hmm.HmmAlignAlgorithmFactory;
import net.loomchild.maligna.matrix.BandMatrixFactory;

public class AdaptiveBandAlgorithm
implements AlignAlgorithm {
    public static final float DEFAULT_BAND_INCREMENT_RATIO = 1.5f;
    public static final int DEFAULT_INITIAL_BAND_RADIUS = 20;
    public static final int DEFAULT_MIN_BAND_MARGIN = 5;
    private Map<Category, Float> categoryMap;
    private Calculator calculator;
    private int initialBandRadius;
    private float bandIncrementRatio;
    private int minBandMargin;
    private HmmAlignAlgorithmFactory algorithmFactory;

    public AdaptiveBandAlgorithm(HmmAlignAlgorithmFactory algorithmFactory, Calculator calculator, int initialBandRadius, float bandIncrementRatio, int minBandMargin, Map<Category, Float> categoryMap) {
        this.categoryMap = categoryMap;
        this.calculator = calculator;
        this.initialBandRadius = initialBandRadius;
        this.bandIncrementRatio = bandIncrementRatio;
        this.minBandMargin = minBandMargin;
        this.algorithmFactory = algorithmFactory;
    }

    public AdaptiveBandAlgorithm(HmmAlignAlgorithmFactory algorithmFactory, Calculator calculator, int initialBandRadius, float bandIncrementRatio, int minBandMargin) {
        this(algorithmFactory, calculator, initialBandRadius, bandIncrementRatio, minBandMargin, CategoryDefaults.BEST_CATEGORY_MAP);
    }

    public AdaptiveBandAlgorithm(HmmAlignAlgorithmFactory algorithmFactory, Calculator calculator) {
        this(algorithmFactory, calculator, 20, 1.5f, 5);
    }

    @Override
    public List<Alignment> align(List<String> sourceSegmentList, List<String> targetSegmentList) {
        float bandRadius = (float)this.initialBandRadius / this.bandIncrementRatio;
        int maxAlignmentRadius = (int)bandRadius + 1;
        List<Alignment> alignmentList = null;
        while ((float)(maxAlignmentRadius + this.minBandMargin) > bandRadius) {
            BandMatrixFactory matrixFactory = new BandMatrixFactory((int)(bandRadius *= this.bandIncrementRatio));
            AlignAlgorithm algorithm = this.algorithmFactory.createAlignAlgorithm(this.calculator, this.categoryMap, matrixFactory);
            alignmentList = algorithm.align(sourceSegmentList, targetSegmentList);
            maxAlignmentRadius = this.calculateMaxAlignmentRadius(alignmentList, sourceSegmentList.size(), targetSegmentList.size());
        }
        assert (alignmentList != null);
        return alignmentList;
    }

    private int calculateMaxAlignmentRadius(List<Alignment> alignmentList, int sourceCount, int targetCount) {
        int maxRadius = 0;
        int sourceNr = 0;
        int targetNr = 0;
        float targetSourceRatio = (float)targetCount / (float)sourceCount;
        for (Alignment alignment : alignmentList) {
            int diagonalTargetNr;
            int radius = Math.abs((targetNr += alignment.getTargetSegmentList().size()) - (diagonalTargetNr = (int)((float)(sourceNr += alignment.getSourceSegmentList().size()) * targetSourceRatio)));
            if (radius <= maxRadius) continue;
            maxRadius = radius;
        }
        return maxRadius;
    }
}

