/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

@Tokenizer(languages={"discoverAtRuntime"})
public class HunspellTokenizer
extends BaseTokenizer {
    private static Map<Language, File> affixFiles;
    private static Map<Language, File> dictionaryFiles;
    private static String[] availableDictLangs;
    private volatile Dictionary dict;
    private volatile boolean failedToLoadDict;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary getDict() {
        if (this.failedToLoadDict) {
            return null;
        }
        Dictionary result = this.dict;
        if (result == null) {
            HunspellTokenizer hunspellTokenizer = this;
            synchronized (hunspellTokenizer) {
                result = this.dict;
                if (result == null && (result = (this.dict = HunspellTokenizer.initDict(this.getEffectiveLanguage()))) == null) {
                    this.failedToLoadDict = true;
                }
            }
        }
        return result;
    }

    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) throws IOException {
        StandardTokenizer tokenizer = new StandardTokenizer();
        tokenizer.setReader((Reader)new StringReader(strOrig));
        if (stemsAllowed) {
            Dictionary dictionary = this.getDict();
            if (dictionary == null) {
                return tokenizer;
            }
            return new HunspellStemFilter((TokenStream)tokenizer, dictionary);
        }
        return tokenizer;
    }

    @Override
    public String[] getSupportedLanguages() {
        HunspellTokenizer.populateInstalledDicts();
        return availableDictLangs == null ? new String[]{} : availableDictLangs;
    }

    private static synchronized void populateInstalledDicts() {
        if (affixFiles != null && dictionaryFiles != null) {
            return;
        }
        affixFiles = new HashMap<Language, File>();
        dictionaryFiles = new HashMap<Language, File>();
        String dictionaryDirPath = Preferences.getPreference("spellcheker_dir");
        if (dictionaryDirPath.isEmpty()) {
            return;
        }
        File dictionaryDir = new File(dictionaryDirPath);
        if (!dictionaryDir.isDirectory()) {
            return;
        }
        for (File file : dictionaryDir.listFiles()) {
            Language lang;
            String name = file.getName();
            if (name.endsWith(".aff")) {
                lang = new Language(name.substring(0, name.lastIndexOf(".aff")));
                affixFiles.put(lang, file);
                affixFiles.put(new Language(lang.getLanguageCode()), file);
                continue;
            }
            if (!name.endsWith(".dic")) continue;
            lang = new Language(name.substring(0, name.lastIndexOf(".dic")));
            dictionaryFiles.put(lang, file);
            dictionaryFiles.put(new Language(lang.getLanguageCode()), file);
        }
        HashSet<Language> commonLangs = new HashSet<Language>(affixFiles.keySet());
        commonLangs.retainAll(dictionaryFiles.keySet());
        availableDictLangs = HunspellTokenizer.langsToStrings(commonLangs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dictionary initDict(Language language) {
        HunspellTokenizer.populateInstalledDicts();
        Class<HunspellTokenizer> clazz = HunspellTokenizer.class;
        synchronized (HunspellTokenizer.class) {
            File affixFile = affixFiles.get(language);
            File dictionaryFile = dictionaryFiles.get(language);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (affixFile == null || dictionaryFile == null || !affixFile.exists() || !dictionaryFile.exists()) {
                Log.logErrorRB("HUNSPELL_TOKENIZER_DICT_NOT_INSTALLED", language.getLocale());
                return null;
            }
            try {
                return new Dictionary((InputStream)new FileInputStream(affixFile), (InputStream)new FileInputStream(dictionaryFile));
            }
            catch (Throwable t) {
                Log.log(t);
                return null;
            }
        }
    }

    private static String[] langsToStrings(Set<Language> langs) {
        ArrayList<String> result = new ArrayList<String>(langs.size() * 2);
        for (Language lang : langs) {
            result.add(lang.getLanguage().toLowerCase(Locale.ENGLISH));
            result.add(lang.getLanguageCode().toLowerCase(Locale.ENGLISH));
        }
        return result.toArray(new String[result.size()]);
    }

    private static synchronized void reset() {
        affixFiles = null;
        dictionaryFiles = null;
        availableDictLangs = null;
    }

    public static void loadPlugins() {
        Core.registerTokenizerClass(HunspellTokenizer.class);
        CoreEvents.registerProjectChangeListener(e -> {
            if (e == IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD) {
                HunspellTokenizer.reset();
            }
        });
    }

    public static void unloadPlugins() {
    }
}

