/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.madlonkay.supertmxmerge.DiffIOController;
import org.madlonkay.supertmxmerge.FileLoaderWorker;
import org.madlonkay.supertmxmerge.MergeController;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.util.FileUtil;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class MergeIOController
extends DiffIOController {
    private static final Logger LOGGER = Logger.getLogger(MergeIOController.class.getName());
    public static final String PROP_MERGEBASEFILE = "mergeBaseFile";
    private File baseFile;
    private boolean isDone;

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(File baseFile) {
        File oldBaseFile = this.baseFile;
        this.baseFile = baseFile;
        this.propertySupport.firePropertyChange(PROP_MERGEBASEFILE, oldBaseFile, baseFile);
        this.propertySupport.firePropertyChange("inputIsValid", null, null);
    }

    @Override
    public boolean getInputIsValid() {
        return !(!FileUtil.validateFile(this.getFile1()) || !FileUtil.validateFile(this.getFile2()) || this.getBaseFile() != null && this.getBaseFile().equals(this.getFile1()) || this.getBaseFile() != null && this.getBaseFile().equals(this.getFile2()) || this.getFile1().equals(this.getFile2()));
    }

    @Override
    public void go() {
        this.isDone = false;
        GuiUtil.safelyRunBlockingRoutine(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MergeIOController.this.getBaseFile() == null || MergeIOController.this.getBaseFile().length() == 0L) {
                    new MergeWorker(MergeIOController.this.getFile1(), MergeIOController.this.getFile2()).run();
                } else {
                    new MergeWorker(MergeIOController.this.getBaseFile(), MergeIOController.this.getFile1(), MergeIOController.this.getFile2()).run();
                }
                try {
                    MergeIOController mergeIOController = MergeIOController.this;
                    synchronized (mergeIOController) {
                        while (!MergeIOController.this.isDone) {
                            MergeIOController.this.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void writeOutputFile(ITmx merged) throws WriteFailedException {
        if (merged == null) {
            return;
        }
        while (this.getOutputFile() == null) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showSaveDialog(null) == 0) {
                this.setOutputFile(chooser.getSelectedFile());
                continue;
            }
            int response = JOptionPane.showConfirmDialog(null, LocString.get("STM_CONFIRM_CANCEL_SAVE_MESSAGE"), LocString.get("STM_MERGE_WINDOW_TITLE"), 0, 2);
            if (response != 0) continue;
            return;
        }
        merged.writeTo(this.getOutputFile());
    }

    private class MergeWorker
    extends FileLoaderWorker {
        public MergeWorker(File ... files) {
            super(files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processLoadedTmxs(List<ITmx> tmxs) {
            try {
                MergeController merger = new MergeController();
                if (MergeIOController.this.getOutputFile() != null) {
                    merger.setQuiet(true);
                }
                ITmx merged = tmxs.size() == 2 ? merger.merge(tmxs.get(0), tmxs.get(1)) : merger.merge(tmxs.get(0), tmxs.get(1), tmxs.get(2));
                MergeIOController.this.writeOutputFile(merged);
            }
            catch (WriteFailedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            finally {
                MergeIOController mergeIOController = MergeIOController.this;
                synchronized (mergeIOController) {
                    MergeIOController.this.isDone = true;
                    MergeIOController.this.notify();
                }
            }
        }
    }
}

