/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksTableModel;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class BookmarkNodeRenderer
extends DefaultTableCellRenderer {
    private boolean forHistoryPopup;

    BookmarkNodeRenderer(boolean forHistoryPopup) {
        this.forHistoryPopup = forHistoryPopup;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Icon icon = null;
        BookmarksTableModel model = (BookmarksTableModel)table.getModel();
        BookmarkNode bNode = model.getEntry(row);
        BookmarkInfo bookmark = bNode.getBookmarkInfo();
        Node fNode = bNode.getParentNode();
        if (fNode != null) {
            Image image;
            String text;
            if (!isSelected && (text = fNode.getHtmlDisplayName()) != null) {
                text = bookmark.getDescription(text, this.forHistoryPopup, this.forHistoryPopup, true);
                this.setText("<html>" + text + "</html>");
            }
            if ((image = fNode.getIcon(1)) != null) {
                icon = ImageUtilities.image2Icon((Image)image);
            }
        }
        this.setIcon(icon);
        return this;
    }
}

