/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.sources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javascript2.debug.sources.Bundle;
import org.netbeans.modules.javascript2.debug.sources.SourceContent;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.util.io.ReaderInputStream;

final class SourceFS
extends AbstractFileSystem {
    private static final AtomicLong COUNT = new AtomicLong();
    private final long id = COUNT.incrementAndGet();
    private final Map<String, Item> items = new LinkedHashMap<String, Item>();

    SourceFS() {
        this.list = new SourceList();
        this.info = new SourceInfo();
        this.attr = new SourceAttributes();
    }

    public String getDisplayName() {
        return Bundle.SourceFSDisplayName();
    }

    public boolean isReadOnly() {
        return true;
    }

    public AbstractFileSystem.List getList() {
        return this.list;
    }

    public long getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFile(String path, SourceContent content) {
        FileObject parent;
        int pl;
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        do {
            pl = path.length();
        } while ((path = path.replace("//", "/")).length() < pl);
        int i = path.lastIndexOf(47);
        String name = i >= 0 ? path.substring(i + 1) : path;
        Item item = new Item(name, content);
        Map<String, Item> map = this.items;
        synchronized (map) {
            this.items.put(path, item);
            parent = this.getExistingParent(path);
        }
        parent.refresh(true);
        FileObject fo = this.findResource(path);
        if (fo == null && i > 0) {
            String pp = parent.getPath();
            String parentPath = path.substring(0, i);
            while (parentPath.startsWith(pp) && pp.length() < parentPath.length() && (i = path.indexOf(47, pp.length() + 1)) >= 0 && (parent = this.findResource(pp = path.substring(0, i))) != null) {
                parent.refresh();
            }
            fo = this.findResource(path);
        }
        if (fo == null) {
            throw new IllegalStateException("Can not create file '" + path + "' parent = " + parent);
        }
        return fo;
    }

    private FileObject getExistingParent(String path) {
        int i;
        FileObject parent = this.findResource(path);
        if (parent != null) {
            return parent.getParent();
        }
        while (parent == null && !path.isEmpty() && (i = path.lastIndexOf(47)) > 0) {
            path = path.substring(0, i);
            parent = this.findResource(path);
        }
        if (parent == null) {
            parent = this.getRoot();
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item getItem(String path) {
        Map<String, Item> map = this.items;
        synchronized (map) {
            return this.items.get(path);
        }
    }

    private static class Item {
        public final String name;
        public final SourceContent content;
        public final Date date;
        private final Map<String, Object> attrs = new HashMap<String, Object>();

        public Item(String name, SourceContent content) {
            this.name = name;
            this.content = content;
            this.date = new Date();
        }

        private long getSize() {
            if (this.content != null) {
                return this.content.getLength();
            }
            return 0L;
        }

        private InputStream getInputStream() throws FileNotFoundException {
            try {
                return new ReaderInputStream((Reader)new StringReader(this.content.getContent()));
            }
            catch (IOException ex) {
                throw new FileNotFoundException(ex.getLocalizedMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAttribute(String attrName) {
            Map<String, Object> map = this.attrs;
            synchronized (map) {
                return this.attrs.get(attrName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(String attrName, Object value) {
            Map<String, Object> map = this.attrs;
            synchronized (map) {
                this.attrs.put(attrName, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration<String> getAttributes() {
            Map<String, Object> map = this.attrs;
            synchronized (map) {
                return Collections.enumeration(this.attrs.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteAttributes() {
            Map<String, Object> map = this.attrs;
            synchronized (map) {
                this.attrs.clear();
            }
        }
    }

    private final class SourceList
    implements AbstractFileSystem.List,
    ChangeListener {
        SourceList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] children(String f) {
            while (f.startsWith("/")) {
                f = f.substring(1);
            }
            if (!f.isEmpty() && !f.endsWith("/")) {
                f = f + '/';
            }
            ArrayList<String> children = new ArrayList<String>();
            int fl = f.length();
            Map map = SourceFS.this.items;
            synchronized (map) {
                for (String name : SourceFS.this.items.keySet()) {
                    if (!name.startsWith(f)) continue;
                    int end = name.indexOf(47, fl);
                    String ch = end > 0 ? name.substring(fl, end) : name.substring(fl);
                    children.add(ch);
                }
            }
            return children.toArray(new String[0]);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SourceFS.this.refreshResource("", false);
        }
    }

    private class SourceInfo
    implements AbstractFileSystem.Info {
        SourceInfo() {
        }

        public Date lastModified(String name) {
            Item item = SourceFS.this.getItem(name);
            if (item != null) {
                return item.date;
            }
            return new Date(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean folder(String name) {
            if (name.isEmpty()) {
                return true;
            }
            Map map = SourceFS.this.items;
            synchronized (map) {
                for (String namePath : SourceFS.this.items.keySet()) {
                    if (!namePath.startsWith(name)) continue;
                    return name.length() < namePath.length();
                }
            }
            return false;
        }

        public boolean readOnly(String name) {
            return true;
        }

        public String mimeType(String name) {
            return null;
        }

        public long size(String name) {
            Item item = SourceFS.this.getItem(name);
            if (item != null) {
                return item.getSize();
            }
            return 0L;
        }

        public InputStream inputStream(String name) throws FileNotFoundException {
            Item item = SourceFS.this.getItem(name);
            if (item != null) {
                return item.getInputStream();
            }
            throw new FileNotFoundException("Did not find '" + name + "'");
        }

        public OutputStream outputStream(String name) throws IOException {
            throw new IOException("Can not write to source files");
        }

        public void lock(String name) throws IOException {
            throw new IOException("Can not write to source files");
        }

        public void unlock(String name) {
        }

        public void markUnimportant(String name) {
        }
    }

    private class SourceAttributes
    implements AbstractFileSystem.Attr {
        SourceAttributes() {
        }

        public Object readAttribute(String name, String attrName) {
            if ("java.io.File".equals(attrName)) {
                return null;
            }
            Item item = SourceFS.this.getItem(name);
            if (item != null) {
                return item.getAttribute(attrName);
            }
            return null;
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            Item item = SourceFS.this.getItem(name);
            if (item == null) {
                throw new IOException("Did not find '" + name + "'");
            }
            item.setAttribute(attrName, value);
        }

        public Enumeration<String> attributes(String name) {
            Item item = SourceFS.this.getItem(name);
            if (item != null) {
                return item.getAttributes();
            }
            return Collections.emptyEnumeration();
        }

        public void renameAttributes(String oldName, String newName) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void deleteAttributes(String name) {
            Item item = SourceFS.this.getItem(name);
            if (item != null) {
                item.deleteAttributes();
            }
        }
    }
}

