/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.modules.javascript2.debug.spi.SourceElementsQuery;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class NamesTranslator {
    private static final boolean USE_SOURCE_MAPS = Boolean.parseBoolean(System.getProperty("javascript.debugger.useSourceMaps", "true"));
    private final SourceMapsTranslator smt;
    private final FileObject fileObject;
    private final Source source;
    private final int offset;
    private String declarationNodeName;
    private final Map<String, String> directMap = new HashMap<String, String>();
    private final Map<String, String> reverseMap = new HashMap<String, String>();
    private boolean varTranslationsRegistered;

    public static NamesTranslator create(SourceMapsTranslator smt, FileObject fileObject, int lineNumber, int columnNumber) {
        if (!USE_SOURCE_MAPS) {
            return null;
        }
        Source source = Source.create((FileObject)fileObject);
        if (source == null) {
            return null;
        }
        Document doc = source.getDocument(true);
        if (doc == null) {
            return null;
        }
        try {
            int lastLine = LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)(doc.getLength() - 1));
            if (lineNumber > lastLine) {
                lineNumber = lastLine;
            }
        }
        catch (BadLocationException lastLine) {
            // empty catch block
        }
        int offset = LineDocumentUtils.getLineStartFromIndex((LineDocument)((LineDocument)doc), (int)lineNumber) + columnNumber;
        return new NamesTranslator(smt, fileObject, source, offset);
    }

    private NamesTranslator(SourceMapsTranslator smt, FileObject fileObject, Source source, int offset) {
        this.smt = smt;
        this.fileObject = fileObject;
        this.source = source;
        this.offset = offset;
    }

    public synchronized String translate(String name) {
        this.registerVarTranslations();
        String tname = this.directMap.get(name);
        if (tname != null) {
            return tname;
        }
        return name;
    }

    public synchronized String reverseTranslate(String name) {
        this.registerVarTranslations();
        String tname = this.reverseMap.get(name);
        if (tname != null) {
            return tname;
        }
        return name;
    }

    private void registerVarTranslations() {
        assert (Thread.holdsLock(this));
        if (this.varTranslationsRegistered) {
            return;
        }
        this.varTranslationsRegistered = true;
        SourceElementsQuery seq = (SourceElementsQuery)Lookup.getDefault().lookup(SourceElementsQuery.class);
        if (seq != null) {
            Collection<SourceElementsQuery.Var> vars = seq.getVarsAt(this.source, this.offset);
            for (SourceElementsQuery.Var var : vars) {
                int line;
                int voffset = var.getOffset();
                Document doc = this.source.getDocument(true);
                try {
                    line = LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)voffset);
                }
                catch (BadLocationException blex) {
                    continue;
                }
                int column = voffset - LineDocumentUtils.getLineStart((LineDocument)((LineDocument)doc), (int)voffset);
                SourceMapsTranslator.Location loc = new SourceMapsTranslator.Location(this.fileObject, line, column);
                String tname = (loc = this.smt.getSourceLocation(loc)).getName();
                if (tname == null) continue;
                String name = var.getName();
                this.directMap.put(name, tname);
                this.reverseMap.put(tname, name);
            }
        }
    }

    public synchronized String translateDeclarationNodeName(String defaultName) {
        if (this.declarationNodeName == null) {
            String nodeName;
            SourceElementsQuery seq = (SourceElementsQuery)Lookup.getDefault().lookup(SourceElementsQuery.class);
            if (seq != null) {
                int doffset = seq.getObjectOffsetAt(this.source, this.offset);
                if (doffset >= 0) {
                    Document doc = this.source.getDocument(true);
                    try {
                        int line = LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)doffset);
                        int column = doffset - LineDocumentUtils.getLineStart((LineDocument)((LineDocument)doc), (int)doffset);
                        SourceMapsTranslator.Location loc = new SourceMapsTranslator.Location(this.fileObject, line, column);
                        loc = this.smt.getSourceLocation(loc);
                        nodeName = loc.getName();
                        if (nodeName == null) {
                            nodeName = defaultName;
                        }
                    }
                    catch (BadLocationException blex) {
                        nodeName = defaultName;
                    }
                } else {
                    nodeName = defaultName;
                }
            } else {
                nodeName = defaultName;
            }
            this.declarationNodeName = nodeName;
        }
        return this.declarationNodeName;
    }
}

