/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.browser;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.BrowserPickerPopup;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;
import org.netbeans.modules.web.clientproject.browser.Bundle;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.DropDownButtonFactory;
import org.openide.awt.ToolbarPool;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class ActiveBrowserAction
extends CallableSystemAction
implements LookupListener {
    private final Lookup lookup;
    @NullAllowed
    private Project currentProject;
    @NullAllowed
    private ProjectBrowserProvider currentBrowserProvider;
    private final PropertyChangeListener currentBrowserProviderListener;
    private JButton toolbarButton;
    private JMenu menuAction;
    private Lookup.Result<Project> resultPrj;
    private Lookup.Result<DataObject> resultDO;
    private Lookup.Result<FileObject> resultFO;
    private Lookup.Result<ProjectBrowserProvider> resultPBP;
    private LookupListener lookupListener;
    private WebBrowser lastWebBrowser = null;
    private ChangeListener ideBrowserChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Project p = ActiveBrowserAction.this.getCurrentProject();
            ProjectBrowserProvider pbp = null;
            if (p != null) {
                pbp = (ProjectBrowserProvider)p.getLookup().lookup(ProjectBrowserProvider.class);
            }
            ActiveBrowserAction.this.updateButton(pbp);
        }
    };
    private static final RequestProcessor RP = new RequestProcessor(ActiveBrowserAction.class);
    private static final String GENERIC_SMALL = "org/netbeans/modules/web/clientproject/browser/browser_generic_16x.png";
    private static final String GENERIC_LARGE = "org/netbeans/modules/web/clientproject/browser/browser_generic_24x.png";
    private static final String DISABLED_SMALL = "org/netbeans/modules/web/clientproject/browser/browser_disabled_16x.png";
    private static final String DISABLED_LARGE = "org/netbeans/modules/web/clientproject/browser/browser_disabled_24x.png";

    public ActiveBrowserAction() {
        this.lookup = LastActivatedWindowLookup.INSTANCE;
        this.resultPrj = this.lookup.lookupResult(Project.class);
        this.resultDO = this.lookup.lookupResult(DataObject.class);
        this.resultFO = this.lookup.lookupResult(FileObject.class);
        this.resultPrj.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.resultPrj));
        this.resultDO.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.resultDO));
        this.resultFO.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.resultFO));
        this.currentBrowserProviderListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("activeConfiguration".equals(evt.getPropertyName())) {
                    ActiveBrowserAction.this.updateButton(ActiveBrowserAction.this.getBrowserProvider());
                }
            }
        };
        this.lookupListener = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                ActiveBrowserAction.this.refreshViewLater(true);
            }
        };
        this.refreshView(false);
    }

    public void performAction() {
        Toolkit.getDefaultToolkit().beep();
    }

    public String getName() {
        return Bundle.ActiveBrowserAction_name();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.browser.ActiveBrowserAction");
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshViewLater(false);
    }

    public JMenuItem getMenuPresenter() {
        JMenu m = new JMenu(Bundle.ActiveBrowserAction_name());
        m.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JMenu m = (JMenu)e.getSource();
                m.removeAll();
                ProjectBrowserProvider pbp = ActiveBrowserAction.this.getBrowserProvider();
                for (Component mi : ActiveBrowserAction.this.createMenuItems(pbp != null ? pbp.getActiveBrowser() : null)) {
                    if (mi instanceof JSeparator) {
                        m.addSeparator();
                        continue;
                    }
                    m.add(mi);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.menuAction = m;
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBrowserProvider getBrowserProvider() {
        ActiveBrowserAction activeBrowserAction = this;
        synchronized (activeBrowserAction) {
            return this.currentBrowserProvider;
        }
    }

    private List<Component> createMenuItems(WebBrowser selectedWebBrowser) {
        ArrayList<Component> l = new ArrayList<Component>();
        final ProjectBrowserProvider pbp = this.getBrowserProvider();
        if (pbp != null) {
            ButtonGroup group = new ButtonGroup();
            for (WebBrowser wb : pbp.getBrowsers()) {
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(new SelectBrowserAction(pbp, wb));
                group.add(mi);
                if (selectedWebBrowser != null && wb.getId().equals(selectedWebBrowser.getId())) {
                    mi.setSelected(true);
                }
                l.add(mi);
            }
            if (pbp.hasCustomizer()) {
                l.add(new JSeparator());
                AbstractAction customizeAction = new AbstractAction(Bundle.ActiveBrowserAction_customize()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pbp.customize();
                    }
                };
                JMenuItem mi = new JMenuItem(customizeAction);
                l.add(mi);
            }
        }
        return l;
    }

    private static boolean isSmallToolbarIcon() {
        return 16 == ToolbarPool.getDefault().getPreferredIconSize();
    }

    public JMenuItem getPopupPresenter() {
        return super.getPopupPresenter();
    }

    public Component getToolbarPresenter() {
        final JButton button = new JButton();
        button.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActiveBrowserAction.this.showBrowserPickerPopup(button);
            }
        });
        button.setDisabledIcon(this.badgeWithArrowIcon(ImageUtilities.loadImage((String)(ActiveBrowserAction.isSmallToolbarIcon() ? DISABLED_SMALL : DISABLED_LARGE))));
        button.setEnabled(false);
        button.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("PreferredIconSize".equals(evt.getPropertyName())) {
                    ActiveBrowserAction.this.refreshViewLater(true);
                }
            }
        });
        ProjectBrowserProvider pbp = this.getBrowserProvider();
        this.toolbarButton = button;
        this.updateButton(pbp);
        return button;
    }

    private void refreshViewLater(final boolean projectLookupChange) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ActiveBrowserAction.this.refreshView(projectLookupChange);
            }
        });
    }

    private void refreshView(boolean projectLookupChange) {
        Project[] selected = ActiveBrowserAction.getProjectsFromLookup(this.lookup, null);
        if (selected.length == 1) {
            this.activeProjectChanged(selected[0], projectLookupChange);
        } else {
            this.activeProjectChanged(null, projectLookupChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeProjectChanged(Project p, boolean projectLookupChange) {
        ProjectBrowserProvider pbp = null;
        ActiveBrowserAction activeBrowserAction = this;
        synchronized (activeBrowserAction) {
            if (this.currentProject == p && !projectLookupChange) {
                return;
            }
            if (this.resultPBP != null) {
                this.resultPBP.removeLookupListener(this.lookupListener);
                this.resultPBP = null;
            }
            if (this.currentBrowserProvider != null) {
                this.currentBrowserProvider.removePropertyChangeListener(this.currentBrowserProviderListener);
                this.currentBrowserProvider = null;
            }
            this.currentProject = p;
            if (this.currentProject != null) {
                this.resultPBP = this.currentProject.getLookup().lookupResult(ProjectBrowserProvider.class);
                this.resultPBP.addLookupListener(this.lookupListener);
                Collection c = this.resultPBP.allInstances();
                pbp = this.currentBrowserProvider = c.isEmpty() ? null : (ProjectBrowserProvider)c.iterator().next();
                if (this.currentBrowserProvider != null) {
                    this.currentBrowserProvider.addPropertyChangeListener(this.currentBrowserProviderListener);
                }
            }
        }
        this.updateButton(pbp);
    }

    private synchronized Project getCurrentProject() {
        return this.currentProject;
    }

    private void updateButton(ProjectBrowserProvider pbp) {
        JMenu ma;
        JButton tb = this.toolbarButton;
        if (tb != null) {
            if (this.lastWebBrowser != null) {
                this.lastWebBrowser.removeChangeListener(this.ideBrowserChangeListener);
                this.lastWebBrowser = null;
            }
            if (pbp == null) {
                tb.setIcon(this.badgeWithArrowIcon(ImageUtilities.loadImage((String)(ActiveBrowserAction.isSmallToolbarIcon() ? DISABLED_SMALL : DISABLED_LARGE))));
                tb.setDisabledIcon(this.badgeWithArrowIcon(ImageUtilities.loadImage((String)(ActiveBrowserAction.isSmallToolbarIcon() ? DISABLED_SMALL : DISABLED_LARGE))));
                tb.setToolTipText(null);
            } else {
                Image im;
                WebBrowser wb = pbp.getActiveBrowser();
                if (wb != null) {
                    im = wb.getIconImage(ActiveBrowserAction.isSmallToolbarIcon());
                    tb.setToolTipText(BrowserUISupport.getLongDisplayName((WebBrowser)wb));
                    wb.addChangeListener(this.ideBrowserChangeListener);
                } else {
                    im = ImageUtilities.loadImage((String)(ActiveBrowserAction.isSmallToolbarIcon() ? GENERIC_SMALL : GENERIC_LARGE));
                    tb.setToolTipText(Bundle.ActiveBrowserAction_missingProject());
                }
                tb.setIcon(this.badgeWithArrowIcon(im));
                this.lastWebBrowser = wb;
            }
            tb.setEnabled(pbp != null);
        }
        if ((ma = this.menuAction) != null) {
            ma.setEnabled(pbp != null);
        }
    }

    private Icon badgeWithArrowIcon(Image im) {
        assert (im != null) : "Image must be provided";
        return ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)im, (Image)ImageUtilities.icon2Image((Icon)DropDownButtonFactory.getArrowIcon((boolean)false)), (int)(ActiveBrowserAction.isSmallToolbarIcon() ? 20 : 28), (int)(ActiveBrowserAction.isSmallToolbarIcon() ? 6 : 10)));
    }

    private void showBrowserPickerPopup(JButton invoker) {
        final ProjectBrowserProvider provider = this.getBrowserProvider();
        if (null == provider) {
            return;
        }
        final BrowserPickerPopup popup = BrowserPickerPopup.create((ProjectBrowserProvider)provider);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                popup.removeChangeListener((ChangeListener)this);
                WebBrowser selBrowser = popup.getSelectedBrowser();
                if (null != selBrowser) {
                    try {
                        provider.setActiveBrowser(selBrowser);
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        };
        popup.addChangeListener(changeListener);
        popup.show((JComponent)invoker, 0, invoker.getHeight());
    }

    @NonNull
    public static Project[] getProjectsFromLookup(Lookup lookup, String command) {
        LinkedHashSet<Project> result = new LinkedHashSet<Project>();
        for (Project p : lookup.lookupAll(Project.class)) {
            result.add(p);
        }
        for (FileObject fObj : lookup.lookupAll(FileObject.class)) {
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            result.add(p);
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            result.add(p);
        }
        Project[] projectsArray = result.toArray(new Project[0]);
        if (command != null) {
            for (Project p : projectsArray) {
                if (ActiveBrowserAction.commandSupported(p, command, lookup)) continue;
                return new Project[0];
            }
        }
        return projectsArray;
    }

    public static boolean commandSupported(Project project, String command, Lookup context) {
        List<String> commands;
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap != null && (commands = Arrays.asList(ap.getSupportedActions())).contains(command)) {
            try {
                if (context == null || ap.isActionEnabled(command, context)) {
                    return true;
                }
            }
            catch (IllegalArgumentException x) {
                Logger.getLogger(ActiveBrowserAction.class.getName()).log(Level.INFO, "#213589: possible race condition in MergedActionProvider", x);
            }
        }
        return false;
    }

    static final class LastActivatedWindowLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        static final Lookup INSTANCE = new LastActivatedWindowLookup();
        private final TopComponent.Registry reg = TopComponent.getRegistry();

        LastActivatedWindowLookup() {
            this.reg.addPropertyChangeListener((PropertyChangeListener)this);
            this.updateLookups();
        }

        private void updateLookups() {
            TopComponent activeTc;
            Node[] nodes = this.reg.getActivatedNodes();
            if (nodes.length == 0 && null != (activeTc = this.reg.getActivated())) {
                Collection nodesFromLookup = activeTc.getLookup().lookupAll(Node.class);
                nodes = nodesFromLookup.toArray(new Node[0]);
            }
            Lookup[] delegates = new Lookup[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                delegates[i] = nodes[i].getLookup();
            }
            this.setLookups(delegates);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("activatedNodes".equals(ev.getPropertyName())) {
                this.updateLookups();
            }
        }
    }

    private static class SelectBrowserAction
    extends AbstractAction {
        private ProjectBrowserProvider pbp;
        private WebBrowser wb;

        public SelectBrowserAction(ProjectBrowserProvider pbp, WebBrowser wb) {
            super(BrowserUISupport.getLongDisplayName((WebBrowser)wb), ImageUtilities.image2Icon((Image)wb.getIconImage(ActiveBrowserAction.isSmallToolbarIcon())));
            this.pbp = pbp;
            this.wb = wb;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.pbp.setActiveBrowser(this.wb);
            }
            catch (IOException | IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

