/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sysopen;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class SystemOpenAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor PROC = new RequestProcessor(SystemOpenAction.class);
    private final Lookup.Result<DataObject> result;
    private final LookupListener resultListener;
    private final Set<File> files;

    public SystemOpenAction() {
        this(Utilities.actionsGlobalContext());
    }

    private SystemOpenAction(Lookup context) {
        super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
        this.putValue("hideWhenDisabled", true);
        this.result = context.lookupResult(DataObject.class);
        this.resultListener = e -> this.updateFileSet();
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.resultListener, this.result));
        this.files = new HashSet<File>();
        this.updateFileSet();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PROC.post(() -> {
            Desktop desktop = Desktop.getDesktop();
            for (File f : this.files) {
                try {
                    desktop.open(f);
                }
                catch (IOException x) {
                    Logger.getLogger(SystemOpenAction.class.getName()).log(Level.INFO, null, x);
                }
            }
        });
    }

    public Action createContextAwareInstance(Lookup context) {
        return new SystemOpenAction(context);
    }

    @Override
    public boolean isEnabled() {
        return !this.files.isEmpty() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    private void updateFileSet() {
        this.files.clear();
        for (DataObject d : this.result.allInstances()) {
            File f = FileUtil.toFile((FileObject)d.getPrimaryFile());
            if (f == null || this.isIgnoredFile(f)) continue;
            this.files.add(f);
        }
    }

    private boolean isIgnoredFile(File f) {
        if (Utilities.isWindows() && f.isFile() && !f.getName().contains(".")) {
            return true;
        }
        return f.getName().endsWith(".shadow");
    }
}

