/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.atoum.Bundle;
import org.netbeans.modules.php.atoum.commands.Atoum;
import org.netbeans.modules.php.atoum.coverage.CoverageProvider;
import org.netbeans.modules.php.atoum.create.TestCreator;
import org.netbeans.modules.php.atoum.locate.AtoumTestLocator;
import org.netbeans.modules.php.atoum.run.TestRunner;
import org.netbeans.modules.php.atoum.ui.customizer.AtoumCustomizer;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.locate.TestLocator;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AtoumTestingProvider
implements PhpTestingProvider {
    public static final String IDENTIFIER = "atoum";
    private static final AtoumTestingProvider INSTANCE = new AtoumTestingProvider();

    private AtoumTestingProvider() {
    }

    public static AtoumTestingProvider getInstance() {
        return INSTANCE;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.AtoumTestingProvider_name();
    }

    public boolean isTestFile(PhpModule phpModule, FileObject fileObj) {
        if (!FileUtils.isPhpFile((FileObject)fileObj)) {
            return false;
        }
        for (FileObject testDirectory : phpModule.getTestDirectories()) {
            if (!FileUtil.isParentOf((FileObject)testDirectory, (FileObject)fileObj)) continue;
            return true;
        }
        return false;
    }

    public boolean isTestCase(PhpModule phpModule, PhpType.Method method) {
        return Atoum.isTestMethod(method);
    }

    public void runTests(PhpModule phpModule, TestRunInfo runInfo, TestSession testSession) throws TestRunException {
        new TestRunner(phpModule).runTests(runInfo, testSession);
        if (runInfo.isCoverageEnabled()) {
            testSession.setCoverage(new CoverageProvider(phpModule).getCoverage(runInfo));
        }
    }

    public TestLocator getTestLocator(PhpModule phpModule) {
        return new AtoumTestLocator(phpModule);
    }

    public CreateTestsResult createTests(PhpModule phpModule, List<FileObject> files, Map<String, Object> configurationPanelProperties) {
        return new TestCreator(phpModule).createTests(files);
    }

    public boolean isCoverageSupported(PhpModule phpModule) {
        return true;
    }

    public Locations.Line parseFileFromOutput(String line) {
        File file;
        Matcher matcher = Atoum.LINE_PATTERN.matcher(line);
        if (matcher.find() && (file = new File(matcher.group(1))).isFile()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            assert (fo != null);
            return new Locations.Line(fo, Integer.parseInt(matcher.group(2)));
        }
        return null;
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer(PhpModule phpModule) {
        return new AtoumCustomizer(phpModule);
    }
}

