/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.search.api.MAVEN;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.backend.smo.SmoSearchBackend;
import org.apache.maven.search.backend.smo.SmoSearchResponse;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;

final class SMORequestResult
implements ResultImplementation<NBVersionInfo> {
    private static final Logger LOG = Logger.getLogger(SMORequestResult.class.getName());
    private static final int MAX_PAGES = 10;
    private static final long TIMEOUT = 20000L;
    private final SmoSearchBackend smo;
    private SmoSearchResponse response;
    private List<NBVersionInfo> list;

    public SMORequestResult(SmoSearchBackend smo, SearchRequest request) {
        this.smo = smo;
        try {
            this.response = this.search(request);
            this.list = null;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "SMO " + request + " failed", ex);
            this.response = null;
            this.list = Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> getResults() {
        if (this.list == null) {
            this.list = this.response.getPage().stream().map(rec -> new NBVersionInfo(this.smo.getRepositoryId(), rec.getValue(MAVEN.GROUP_ID), rec.getValue(MAVEN.ARTIFACT_ID), rec.getValue(MAVEN.VERSION), rec.getValue(MAVEN.PACKAGING), rec.getValue(MAVEN.PACKAGING), null, null, rec.getValue(MAVEN.CLASSIFIER))).collect(Collectors.toList());
        }
        return this.list;
    }

    @Override
    public void waitForSkipped() {
        if (!this.isPartial()) {
            return;
        }
        ArrayList<NBVersionInfo> fullList = new ArrayList<NBVersionInfo>(this.getResults());
        long start = System.currentTimeMillis();
        int page = 0;
        while (this.isPartial() && page++ < 10 && System.currentTimeMillis() - start < 20000L) {
            this.list = null;
            try {
                this.response = this.search(this.response.getSearchRequest().nextPage());
                fullList.addAll(this.getResults());
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "SMO request failed during pagination", ex);
                break;
            }
        }
        this.list = Collections.unmodifiableList(fullList);
    }

    private SmoSearchResponse search(SearchRequest request) throws IOException {
        long delta = System.currentTimeMillis();
        SmoSearchResponse resp = this.smo.search(request);
        LOG.log(Level.INFO, "SMO {0} finished in {1} ms", new Object[]{request, System.currentTimeMillis() - delta});
        return resp;
    }

    @Override
    public boolean isPartial() {
        return this.response != null && this.response.getTotalHits() > this.response.getCurrentHits();
    }

    @Override
    public int getTotalResultCount() {
        return this.response == null ? 0 : this.response.getTotalHits();
    }

    @Override
    public int getReturnedResultCount() {
        return this.response == null ? 0 : this.response.getCurrentHits();
    }
}

