/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.typinghooks;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.typinghooks.TypingHooksUtils;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;

public class PhpDeletedTextInterceptor
implements DeletedTextInterceptor {
    public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
        char ch = context.getText().charAt(0);
        CharRemover charRemover = CharRemoverFactory.create(ch);
        charRemover.remove(context);
    }

    public void afterRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
    }

    public void cancelled(DeletedTextInterceptor.Context context) {
    }

    private static final class CharRemoverFactory {
        private CharRemoverFactory() {
        }

        static CharRemover create(char ch) {
            CharRemover charRemover = CharRemover.NONE;
            switch (ch) {
                case ' ': {
                    charRemover = new SpaceRemover();
                    break;
                }
                case '{': {
                    charRemover = new CurlyBracketRemover();
                    break;
                }
                case '(': {
                    charRemover = new RoundBracketRemover();
                    break;
                }
                case '[': {
                    charRemover = new SquareBracketRemover();
                    break;
                }
                case '\"': {
                    charRemover = new DoubleQuoteRemover();
                    break;
                }
                case '\'': {
                    charRemover = new SingleQuoteRemover();
                    break;
                }
            }
            return charRemover;
        }
    }

    private static interface CharRemover {
        public static final CharRemover NONE = new CharRemover(){

            @Override
            public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
            }
        };

        public void remove(DeletedTextInterceptor.Context var1) throws BadLocationException;
    }

    private static final class DoubleQuoteRemover
    extends QuoteRemover {
        private DoubleQuoteRemover() {
        }

        @Override
        protected char getQuote() {
            return '\"';
        }
    }

    private static final class SingleQuoteRemover
    extends QuoteRemover {
        private SingleQuoteRemover() {
        }

        @Override
        protected char getQuote() {
            return '\'';
        }
    }

    private static abstract class QuoteRemover
    implements CharRemover {
        private QuoteRemover() {
        }

        @Override
        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
            BaseDocument doc = (BaseDocument)context.getDocument();
            int dotPos = context.getOffset() - 1;
            if (OptionsUtils.autoCompletionSmartQuotes()) {
                char[] match;
                TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)doc, dotPos);
                if (tokenSequence != null) {
                    char[] precedingChars;
                    tokenSequence.move(dotPos);
                    if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && (tokenSequence.token().id() == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE || tokenSequence.token().id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING) && (precedingChars = doc.getChars(dotPos - 1, 1)).length > 0 && precedingChars[0] == '\\') {
                        doc.remove(dotPos - 1, 1);
                        return;
                    }
                }
                if ((match = doc.getChars(dotPos, 1)) != null && match[0] == this.getQuote()) {
                    doc.remove(dotPos, 1);
                }
            }
        }

        protected abstract char getQuote();
    }

    private static final class RoundBracketRemover
    extends BracketRemover {
        private RoundBracketRemover() {
        }

        @Override
        protected char getOpeningBracket() {
            return '(';
        }

        @Override
        protected char getClosingBracket() {
            return ')';
        }
    }

    private static final class SquareBracketRemover
    extends BracketRemover {
        private SquareBracketRemover() {
        }

        @Override
        protected char getOpeningBracket() {
            return '[';
        }

        @Override
        protected char getClosingBracket() {
            return ']';
        }
    }

    private static final class CurlyBracketRemover
    extends BracketRemover {
        private CurlyBracketRemover() {
        }

        @Override
        protected char getOpeningBracket() {
            return '{';
        }

        @Override
        protected char getClosingBracket() {
            return '}';
        }
    }

    private static abstract class BracketRemover
    implements CharRemover {
        private BracketRemover() {
        }

        @Override
        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
            char tokenAtDot;
            BaseDocument doc = (BaseDocument)context.getDocument();
            int dotPos = context.getOffset() - 1;
            if (TypingHooksUtils.isInsertMatchingEnabled() && (tokenAtDot = LexUtilities.getTokenChar(doc, dotPos)) == this.getClosingBracket() && LexUtilities.getTokenBalance(doc, this.getOpeningBracket(), this.getClosingBracket(), dotPos) != 0) {
                doc.remove(dotPos, 1);
            }
        }

        protected abstract char getOpeningBracket();

        protected abstract char getClosingBracket();
    }

    private static final class SpaceRemover
    implements CharRemover {
        private SpaceRemover() {
        }

        @Override
        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
            int dotPos;
            BaseDocument doc = (BaseDocument)context.getDocument();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, dotPos = context.getOffset() - 1);
            if (ts != null) {
                ts.move(dotPos);
                if ((ts.moveNext() || ts.movePrevious()) && ts.offset() == dotPos - 1 && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                    doc.remove(dotPos - 1, 1);
                    context.getComponent().getCaret().setDot(dotPos - 1);
                }
            }
        }
    }

    public static class Factory
    implements DeletedTextInterceptor.Factory {
        public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
            return new PhpDeletedTextInterceptor();
        }
    }
}

