/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.Latest;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.TermOfSupport;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Pkg;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.netbeans.modules.java.disco.ArchitectureListCellRenderer;
import org.netbeans.modules.java.disco.BundleTableModel;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.DiscoPlatformInstall;
import org.netbeans.modules.java.disco.DistributionListCellRenderer;
import org.netbeans.modules.java.disco.LTSes;
import org.netbeans.modules.java.disco.OS;
import org.netbeans.modules.java.disco.PackageTypeListCellRenderer;
import org.netbeans.modules.java.disco.VersionListCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class AdvancedPanel
extends JPanel {
    protected BundleTableModel tableModel;
    private final DefaultComboBoxModel<Distribution> distrosModel = new DefaultComboBoxModel();
    private JComboBox<Architecture> architectureComboBox;
    private JComboBox<Distribution> distributionComboBox;
    private JCheckBox eaCheckBox;
    private JCheckBox latestCheckBox;
    private JComboBox<PackageType> packageTypeComboBox;
    protected JTable table;
    private JScrollPane tableScrollPane;
    private JComboBox<Integer> versionComboBox;

    public AdvancedPanel() {
        this.initComponents();
        this.distributionComboBox.setRenderer(new DistributionListCellRenderer());
        this.versionComboBox.setRenderer(new VersionListCellRenderer());
        this.packageTypeComboBox.setRenderer(new PackageTypeListCellRenderer());
        this.architectureComboBox.setRenderer(new ArchitectureListCellRenderer());
        this.architectureComboBox.setSelectedItem(OS.getArchitecture());
    }

    @UIEffect
    public @Nullable Pkg getSelectedPackage() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return null;
        }
        int modelIndex = this.table.convertRowIndexToModel(index);
        Pkg bundle = this.tableModel.getBundles().get(modelIndex);
        return bundle;
    }

    private TableModel createTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BundleTableModel(new ArrayList<Pkg>());
        }
        return this.tableModel;
    }

    @UIEffect
    protected abstract void updateData(Distribution var1, Integer var2, Architecture var3, Latest var4, PackageType var5, boolean var6);

    protected void updateDistributions(List<Distribution> distros) {
        this.distrosModel.removeAllElements();
        distros.stream().sorted((o1, o2) -> o1.getUiString().compareTo(o2.getUiString())).forEachOrdered(this.distrosModel::addElement);
        Client.getInstance().getDistribution(DiscoPlatformInstall.defaultDistribution()).filter(distros::contains).ifPresent(this.distrosModel::setSelectedItem);
    }

    protected void setVersions(List<Integer> versions, Map<Integer, TermOfSupport> lts, int currentJdk) {
        ArrayList<Integer> reversedVersions = new ArrayList<Integer>(versions);
        reversedVersions.sort(Collections.reverseOrder());
        VersionListCellRenderer renderer = (VersionListCellRenderer)this.versionComboBox.getRenderer();
        renderer.setLTS(lts);
        renderer.setCurrentJDK(currentJdk);
        DefaultComboBoxModel versionModel = (DefaultComboBoxModel)this.versionComboBox.getModel();
        reversedVersions.forEach(v -> versionModel.addElement(v));
        versionModel.setSelectedItem(LTSes.latest(lts));
    }

    Distribution getSelectedDistribution() {
        return (Distribution)this.distributionComboBox.getSelectedItem();
    }

    Integer getSelectedVersion() {
        return (Integer)this.versionComboBox.getSelectedItem();
    }

    void switchFocus(Distribution distribution, Integer version) {
        if (distribution != null) {
            this.distributionComboBox.setSelectedItem(distribution);
        }
        if (version != null) {
            this.versionComboBox.setSelectedItem(version);
        }
    }

    private ComboBoxModel<Integer> createVersionComboboxModel() {
        return new DefaultComboBoxModel<Integer>();
    }

    private ComboBoxModel<Distribution> createDistributionComboboxModel() {
        return this.distrosModel;
    }

    private ComboBoxModel<PackageType> createPackageTypeComboboxModel() {
        PackageType[] bundleTypes = (PackageType[])Arrays.stream(PackageType.values()).filter(bundleType -> PackageType.NONE != bundleType).filter(bundleType -> PackageType.NOT_FOUND != bundleType).toArray(PackageType[]::new);
        return new DefaultComboBoxModel<PackageType>(bundleTypes);
    }

    private ComboBoxModel<Architecture> createArchitectureComboboxModel() {
        return new DefaultComboBoxModel<Architecture>(Architecture.values());
    }

    private void initComponents() {
        JPanel filterPanel = new JPanel();
        JPanel distributionsPanel = new JPanel();
        JLabel distLabel = new JLabel();
        this.distributionComboBox = new JComboBox();
        JPanel versionsPanel = new JPanel();
        JLabel versionLabel = new JLabel();
        this.versionComboBox = new JComboBox();
        JPanel architecturePanel = new JPanel();
        JLabel architectureLabel = new JLabel();
        this.architectureComboBox = new JComboBox();
        JPanel typePanel = new JPanel();
        JLabel typeLabel = new JLabel();
        this.packageTypeComboBox = new JComboBox();
        JPanel latestPanel = new JPanel();
        JLabel latestLabel = new JLabel();
        this.latestCheckBox = new JCheckBox();
        JPanel eaPanel = new JPanel();
        JLabel eaLabel = new JLabel();
        this.eaCheckBox = new JCheckBox();
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        filterPanel.setLayout(new BoxLayout(filterPanel, 2));
        distLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)distLabel, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.distLabel.text"));
        this.distributionComboBox.setModel(this.createDistributionComboboxModel());
        this.distributionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.distributionComboBoxActionPerformed(evt);
            }
        });
        GroupLayout distributionsPanelLayout = new GroupLayout(distributionsPanel);
        distributionsPanel.setLayout(distributionsPanelLayout);
        distributionsPanelLayout.setHorizontalGroup(distributionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(distLabel, -1, -1, Short.MAX_VALUE).addGroup(distributionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.distributionComboBox, 0, 85, Short.MAX_VALUE).addContainerGap()));
        distributionsPanelLayout.setVerticalGroup(distributionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(distributionsPanelLayout.createSequentialGroup().addComponent(distLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.distributionComboBox, -2, -1, -2)));
        filterPanel.add(distributionsPanel);
        versionLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)versionLabel, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.versionLabel.text"));
        this.versionComboBox.setModel(this.createVersionComboboxModel());
        this.versionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.versionComboBoxActionPerformed(evt);
            }
        });
        GroupLayout versionsPanelLayout = new GroupLayout(versionsPanel);
        versionsPanel.setLayout(versionsPanelLayout);
        versionsPanelLayout.setHorizontalGroup(versionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(versionLabel, -1, -1, Short.MAX_VALUE).addGroup(versionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.versionComboBox, 0, 80, Short.MAX_VALUE).addContainerGap()));
        versionsPanelLayout.setVerticalGroup(versionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(versionsPanelLayout.createSequentialGroup().addComponent(versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionComboBox, -2, -1, -2)));
        filterPanel.add(versionsPanel);
        architectureLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)architectureLabel, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.architectureLabel.text"));
        this.architectureComboBox.setModel(this.createArchitectureComboboxModel());
        this.architectureComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.architectureComboBoxActionPerformed(evt);
            }
        });
        GroupLayout architecturePanelLayout = new GroupLayout(architecturePanel);
        architecturePanel.setLayout(architecturePanelLayout);
        architecturePanelLayout.setHorizontalGroup(architecturePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(architectureLabel, -1, -1, Short.MAX_VALUE).addGroup(architecturePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.architectureComboBox, 0, 85, Short.MAX_VALUE).addContainerGap()));
        architecturePanelLayout.setVerticalGroup(architecturePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(architecturePanelLayout.createSequentialGroup().addComponent(architectureLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.architectureComboBox, -2, -1, -2)));
        filterPanel.add(architecturePanel);
        typeLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)typeLabel, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.typeLabel.text"));
        this.packageTypeComboBox.setModel(this.createPackageTypeComboboxModel());
        this.packageTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.packageTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout typePanelLayout = new GroupLayout(typePanel);
        typePanel.setLayout(typePanelLayout);
        typePanelLayout.setHorizontalGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(typeLabel, -1, -1, Short.MAX_VALUE).addGroup(typePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.packageTypeComboBox, 0, -1, Short.MAX_VALUE).addContainerGap()));
        typePanelLayout.setVerticalGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typePanelLayout.createSequentialGroup().addComponent(typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.packageTypeComboBox, -2, -1, -2)));
        filterPanel.add(typePanel);
        latestLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)latestLabel, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.latestLabel.text"));
        this.latestCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.latestCheckBox, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.latestCheckBox.text"));
        this.latestCheckBox.setPreferredSize(new Dimension(19, 23));
        this.latestCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.latestCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout latestPanelLayout = new GroupLayout(latestPanel);
        latestPanel.setLayout(latestPanelLayout);
        latestPanelLayout.setHorizontalGroup(latestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(latestLabel, -1, 56, Short.MAX_VALUE).addGroup(latestPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.latestCheckBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        latestPanelLayout.setVerticalGroup(latestPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(latestPanelLayout.createSequentialGroup().addComponent(latestLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.latestCheckBox, -2, -1, -2)));
        filterPanel.add(latestPanel);
        eaLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)eaLabel, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.eaLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.eaCheckBox, (String)NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.eaCheckBox.text"));
        this.eaCheckBox.setPreferredSize(new Dimension(19, 23));
        this.eaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedPanel.this.eaCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout eaPanelLayout = new GroupLayout(eaPanel);
        eaPanel.setLayout(eaPanelLayout);
        eaPanelLayout.setHorizontalGroup(eaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(eaLabel, -1, -1, Short.MAX_VALUE).addGroup(eaPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.eaCheckBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        eaPanelLayout.setVerticalGroup(eaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(eaPanelLayout.createSequentialGroup().addComponent(eaLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eaCheckBox, -2, -1, -2)));
        filterPanel.add(eaPanel);
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(this.createTableModel());
        this.table.setSelectionMode(0);
        this.tableScrollPane.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(filterPanel, -2, 0, Short.MAX_VALUE).addComponent(this.tableScrollPane, -1, 468, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(filterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableScrollPane, -1, 332, Short.MAX_VALUE)));
    }

    private void latestCheckBoxActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void distributionComboBoxActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void versionComboBoxActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void packageTypeComboBoxActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void architectureComboBoxActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void eaCheckBoxActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void filterChanged() {
        this.updateData((Distribution)this.distributionComboBox.getSelectedItem(), (Integer)this.versionComboBox.getSelectedItem(), (Architecture)this.architectureComboBox.getSelectedItem(), this.latestCheckBox.isSelected() ? Latest.OVERALL : Latest.ALL_OF_VERSION, (PackageType)this.packageTypeComboBox.getSelectedItem(), this.eaCheckBox.isSelected());
    }
}

