/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class DBCommandProvider
implements CommandProvider {
    private static final String COMMAND_GET_PREFERRED_CONNECTION = "nbls.db.preferred.connection";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("nbls.db.preferred.connection"));

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        TreeNodeRegistry r = (TreeNodeRegistry)Lookup.getDefault().lookup(TreeNodeRegistry.class);
        DatabaseConnection conn = ConnectionManager.getDefault().getPreferredConnection(true);
        if (conn == null || r == null) {
            return CompletableFuture.completedFuture(null);
        }
        return r.createProvider("database.connections").thenCompose(m -> {
            Node root = m.getExplorerManager().getRootContext();
            for (Node n : root.getChildren().getNodes(true)) {
                DatabaseConnection d = (DatabaseConnection)n.getLookup().lookup(DatabaseConnection.class);
                if (d == null || !d.getName().equals(conn.getName())) continue;
                return m.getNodeId(n);
            }
            return CompletableFuture.completedFuture(null);
        }).toCompletableFuture();
    }

    public Set<String> getCommands() {
        return Collections.singleton(COMMAND_GET_PREFERRED_CONNECTION);
    }
}

