/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.AbstractBinaryEntry;
import org.netbeans.modules.apisupport.project.universe.AbstractEntryWithSources;
import org.netbeans.modules.apisupport.project.universe.BinaryClusterEntry;
import org.netbeans.modules.apisupport.project.universe.BinaryEntry;
import org.netbeans.modules.apisupport.project.universe.Bundle;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.DestDirProvider;
import org.netbeans.modules.apisupport.project.universe.ExternalEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.NetBeansOrgEntry;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleList {
    public static final String NETBEANS_DEST_DIR = "netbeans.dest.dir";
    private static final Logger LOG = Logger.getLogger(ModuleList.class.getName());
    static long timeSpentInXmlParsing;
    static int xmlFilesParsed;
    static int directoriesChecked;
    static int jarsOpened;
    private final String[] FOREST;
    private static final Map<File, ModuleList> sourceLists;
    private static final Map<File, ModuleList> binaryLists;
    private static final Map<File, File[]> clusterLists;
    private static final Map<File, Map<String, String>> clusterPropertiesFiles;
    private static final Map<File, Map<String, String>> clusterLocations;
    private static final Map<File, Set<ModuleEntry>> knownEntries;
    private static final Map<File, File> netbeansOrgDestDirs;
    public static final Set<String> EXCLUDED_DIR_NAMES;
    private static final Map<File, String[]> DIR_SCAN_CACHE;
    private static final String[] MODULE_DIRS;
    private static final String PROJECT_XML;
    private Map<String, ModuleEntry> entries;
    private final File home;
    private int lazyNetBeansOrgList = 0;

    public static ModuleList getModuleList(File basedir) throws IOException {
        return ModuleList.getModuleList(basedir, null);
    }

    private static File getClusterPropertiesFile(File nbroot) {
        return new File(nbroot, "nbbuild" + File.separatorChar + "cluster.properties");
    }

    private static ModuleList runProtected(final Object protectedCache, final Mutex.ExceptionAction<ModuleList> action) throws IOException {
        try {
            LOG.log(Level.FINER, "runProtected: sync 0");
            return (ModuleList)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<ModuleList>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ModuleList run() throws Exception {
                    LOG.log(Level.FINER, "runProtected: sync 1");
                    Object object = protectedCache;
                    synchronized (object) {
                        return (ModuleList)action.run();
                    }
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static ModuleList getModuleList(final File basedir, final File customNbDestDir) throws IOException {
        return ModuleList.runProtected(binaryLists, new Mutex.ExceptionAction<ModuleList>(){

            public ModuleList run() throws IOException {
                boolean standalone;
                timeSpentInXmlParsing = 0L;
                xmlFilesParsed = 0;
                directoriesChecked = 0;
                jarsOpened = 0;
                Element data = ModuleList.parseData(basedir);
                if (data == null) {
                    throw new IOException("Not an NBM project in " + basedir);
                }
                boolean suiteComponent = XMLUtil.findElement((Element)data, (String)"suite-component", (String)"http://www.netbeans.org/ns/nb-module-project/3") != null;
                boolean bl = standalone = XMLUtil.findElement((Element)data, (String)"standalone", (String)"http://www.netbeans.org/ns/nb-module-project/3") != null;
                assert (!suiteComponent || !standalone) : basedir;
                if (suiteComponent) {
                    PropertyEvaluator eval = ModuleList.parseProperties(basedir, null, NbModuleType.SUITE_COMPONENT, "irrelevant");
                    String suiteS = eval.getProperty("suite.dir");
                    if (suiteS == null) {
                        throw new IOException("No suite.dir defined from " + basedir);
                    }
                    File suite = PropertyUtils.resolveFile((File)basedir, (String)suiteS);
                    return ModuleList.findOrCreateModuleListFromSuite(suite, customNbDestDir);
                }
                if (standalone) {
                    return ModuleList.findOrCreateModuleListFromStandaloneModule(basedir, customNbDestDir);
                }
                File nbroot = ModuleList.findNetBeansOrg(basedir);
                if (nbroot == null) {
                    throw new IOException("Could not find netbeans.org source root from " + basedir + "; note that 3rd-level modules (a/b/c) are permitted at the maximum");
                }
                return ModuleList.findOrCreateModuleListFromNetBeansOrgSources(nbroot);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existKnownEntries() {
        Map<File, Set<ModuleEntry>> map = knownEntries;
        synchronized (map) {
            return !knownEntries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ModuleEntry> getKnownEntries(File file) {
        Map<File, Set<ModuleEntry>> map = knownEntries;
        synchronized (map) {
            Set<ModuleEntry> entries = knownEntries.get(file);
            if (entries != null) {
                return Collections.unmodifiableSet(entries);
            }
            return Collections.emptySet();
        }
    }

    public static URL[] getSourceRootsForExternalModule(File binaryRootF) {
        Set<ModuleEntry> candidates = ModuleList.getKnownEntries(binaryRootF);
        ArrayList<URL> roots = new ArrayList<URL>();
        for (ModuleEntry entry : candidates) {
            if (!(entry instanceof BinaryClusterEntry)) continue;
            BinaryClusterEntry bce = (BinaryClusterEntry)entry;
            roots.addAll(Arrays.asList(bce.getSourceRoots()));
        }
        return roots.toArray(new URL[0]);
    }

    public static URL[] getJavadocRootsForExternalModule(File binaryRootF) {
        Set<ModuleEntry> candidates = ModuleList.getKnownEntries(binaryRootF);
        ArrayList<URL> roots = new ArrayList<URL>();
        for (ModuleEntry entry : candidates) {
            if (!(entry instanceof BinaryClusterEntry)) continue;
            BinaryClusterEntry bce = (BinaryClusterEntry)entry;
            roots.addAll(Arrays.asList(bce.getJavadocRoots()));
        }
        return roots.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEntry(ModuleEntry entry, Set<File> files) {
        Map<File, Set<ModuleEntry>> map = knownEntries;
        synchronized (map) {
            for (File f : files) {
                Set<ModuleEntry> entries = knownEntries.get(f);
                if (entries == null) {
                    entries = new HashSet<ModuleEntry>();
                    knownEntries.put(f, entries);
                }
                entries.add(entry);
            }
        }
    }

    static ModuleList findOrCreateModuleListFromNetBeansOrgSources(final File root) throws IOException {
        return ModuleList.runProtected(sourceLists, new Mutex.ExceptionAction<ModuleList>(){

            public ModuleList run() throws IOException {
                ModuleList list = (ModuleList)sourceLists.get(root);
                if (list == null) {
                    File nbdestdir = ModuleList.findNetBeansOrgDestDir(root);
                    if (nbdestdir.equals(new File(new File(root, "nbbuild"), "netbeans"))) {
                        list = ModuleList.createModuleListFromNetBeansOrgSources(root);
                    } else {
                        HashMap entries = new HashMap();
                        ModuleList.doScanNetBeansOrgSources(entries, root, 1, root, nbdestdir, null, Collections.emptySet());
                        ModuleList sources = new ModuleList(entries, root);
                        ModuleList binaries = ModuleList.findOrCreateModuleListFromBinaries(nbdestdir);
                        list = ModuleList.merge(new ModuleList[]{sources, binaries}, root);
                    }
                    sourceLists.put(root, list);
                }
                return list;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File findNetBeansOrgDestDir(File nb_all) {
        Map<File, File> map = netbeansOrgDestDirs;
        synchronized (map) {
            File d = netbeansOrgDestDirs.get(nb_all);
            if (d == null) {
                File nbbuild = new File(nb_all, "nbbuild");
                d = ModuleList.checkForNetBeansOrgDestDir(new File(nbbuild, "user.build.properties"));
                if (d == null && (d = ModuleList.checkForNetBeansOrgDestDir(new File(nbbuild, "site.build.properties"))) == null && (d = ModuleList.checkForNetBeansOrgDestDir(new File(System.getProperty("user.home"), ".nbbuild.properties"))) == null) {
                    d = new File(nbbuild, "netbeans");
                }
                netbeansOrgDestDirs.put(nb_all, d);
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File checkForNetBeansOrgDestDir(File properties) {
        if (!properties.isFile()) return null;
        try (FileInputStream is = new FileInputStream(properties);){
            Properties p = new Properties();
            p.load(is);
            String d = p.getProperty(NETBEANS_DEST_DIR);
            if (d == null) return null;
            File file = new File(d);
            return file;
        }
        catch (IOException x) {
            LOG.log(Level.INFO, "Could not read " + properties, x);
        }
        return null;
    }

    private static ModuleList createModuleListFromNetBeansOrgSources(File root) throws IOException {
        LOG.log(Level.FINE, "ModuleList.createModuleListFromSources: " + root);
        HashMap<String, ModuleEntry> entries = new HashMap<String, ModuleEntry>();
        return new ModuleList(entries, root);
    }

    private static void scanJars(File dir, ClusterInfo ci, @NullAllowed File nbDestDir, File cluster, Map<String, ModuleEntry> entries, boolean registerEntry, File ... jars) throws IOException {
        for (File m : jars) {
            File[] exts;
            if (!m.getName().endsWith(".jar")) continue;
            ++jarsOpened;
            ManifestManager mm = ManifestManager.getInstanceFromJAR((File)m);
            String codenamebase = mm.getCodeNameBase();
            if (codenamebase == null) continue;
            String cp = mm.getClassPath();
            if (cp == null) {
                exts = new File[]{};
            } else {
                String[] pieces = cp.trim().split(" +");
                exts = new File[pieces.length];
                for (int l = 0; l < pieces.length; ++l) {
                    exts[l] = FileUtil.normalizeFile((File)new File(dir, pieces[l].replace('/', File.separatorChar)));
                }
            }
            AbstractBinaryEntry entry = ci == null || ci.isPlatformCluster() ? new BinaryEntry(codenamebase, m, exts, nbDestDir != null ? nbDestDir : cluster, cluster, mm.getReleaseVersion(), mm.getSpecificationVersion(), mm.getProvidedTokens(), mm.getPublicPackages(), mm.getFriends(), mm.isDeprecated(), mm.getModuleDependencies()) : new BinaryClusterEntry(codenamebase, m, exts, cluster, mm.getReleaseVersion(), mm.getSpecificationVersion(), mm.getProvidedTokens(), mm.getPublicPackages(), mm.getFriends(), mm.isDeprecated(), mm.getModuleDependencies(), ci.getSourceRoots(), ci.getJavadocRoots());
            ModuleEntry prev = entries.get(codenamebase);
            if (prev != null) {
                LOG.log(Level.WARNING, "Warning: two modules found with the same code name base (" + codenamebase + "): " + entries.get(codenamebase) + " and " + entry);
            } else {
                entries.put(codenamebase, entry);
            }
            if (!registerEntry) continue;
            ModuleList.registerEntry(entry, ModuleList.findBinaryNBMFiles(cluster, codenamebase, m));
        }
    }

    private void scanNetBeansOrgStableSources() throws IOException {
        String config;
        if (this.lazyNetBeansOrgList >= 1) {
            return;
        }
        File nbdestdir = ModuleList.findNetBeansOrg(this.home);
        LOG.log(Level.INFO, "full scan of {0}", this.home);
        Map<String, String> clusterProps = ModuleList.getClusterProperties(this.home);
        String clusterList = clusterProps.get("clusters.list");
        if (clusterList == null && (config = clusterProps.get("cluster.config")) != null) {
            clusterList = clusterProps.get("clusters.config." + config + ".list");
        }
        if (clusterList == null) {
            throw new IOException("Neither ${clusters.list} nor ${cluster.config} + ${clusters.config.<cfg>.list} found in " + ModuleList.getClusterPropertiesFile(this.home));
        }
        HashSet<File> knownProjects = new HashSet<File>();
        for (ModuleEntry known : this.entries.values()) {
            knownProjects.add(known.getSourceLocation());
        }
        HashMap<String, ModuleEntry> _entries = new HashMap<String, ModuleEntry>(this.entries);
        StringTokenizer tok = new StringTokenizer(clusterList, ", ");
        while (tok.hasMoreTokens()) {
            String clusterName = tok.nextToken();
            String moduleList = clusterProps.get(clusterName);
            if (moduleList == null) {
                throw new IOException("No ${" + clusterName + "} found in " + this.home);
            }
            String clusterDir = clusterProps.get(clusterName + ".dir");
            StringTokenizer tok2 = new StringTokenizer(moduleList, ", ");
            while (tok2.hasMoreTokens()) {
                String module = clusterDir + "/" + tok2.nextToken();
                File basedir = new File(this.home, module.replace('/', File.separatorChar));
                if (knownProjects.contains(basedir)) continue;
                ModuleList.scanPossibleProject(basedir, _entries, NbModuleType.NETBEANS_ORG, this.home, nbdestdir, module);
            }
        }
        this.entries = _entries;
        LOG.log(Level.FINER, "scanning NetBeans.org stable sources finished");
        this.lazyNetBeansOrgList = 1;
    }

    private static void doScanNetBeansOrgSources(Map<String, ModuleEntry> entries, File dir, int depth, File root, File nbdestdir, String pathPrefix, Set<File> knownProjects) {
        File[] kids;
        if (depth == 1) {
            LOG.log(Level.INFO, "exhaustive scan of {0}", dir);
        }
        if ((kids = dir.listFiles()) == null) {
            return;
        }
        for (File kid : kids) {
            String newPathPrefix;
            String name;
            if (!kid.isDirectory() || (name = kid.getName()).startsWith(".") || EXCLUDED_DIR_NAMES.contains(name)) continue;
            String string = newPathPrefix = pathPrefix != null ? pathPrefix + "/" + name : name;
            if (!knownProjects.contains(kid)) {
                try {
                    ModuleList.scanPossibleProject(kid, entries, NbModuleType.NETBEANS_ORG, root, nbdestdir, newPathPrefix);
                }
                catch (IOException e) {
                    Util.err.annotate((Throwable)e, 0, "Malformed project metadata in " + kid + ", skipping...", null, null, null);
                    Util.err.notify(1, (Throwable)e);
                }
            }
            if (depth <= 1) continue;
            ModuleList.doScanNetBeansOrgSources(entries, kid, depth - 1, root, nbdestdir, newPathPrefix, knownProjects);
        }
    }

    static void scanPossibleProject(File basedir, Map<String, ModuleEntry> entries, NbModuleType type, File root, File nbdestdir, String path) throws IOException {
        LOG.log(Level.FINE, "scanning {0}", basedir);
        ++directoriesChecked;
        Element data = ModuleList.parseData(basedir);
        if (data == null) {
            return;
        }
        assert (root != null ^ type != NbModuleType.NETBEANS_ORG);
        assert (path != null ^ type != NbModuleType.NETBEANS_ORG);
        String cnb = XMLUtil.findText((Node)XMLUtil.findElement((Element)data, (String)"code-name-base", (String)"http://www.netbeans.org/ns/nb-module-project/3"));
        PropertyEvaluator eval = ModuleList.parseProperties(basedir, root, type, cnb);
        String module = eval.getProperty("module.jar");
        StringBuilder cpextra = new StringBuilder();
        try {
            for (Element ext : XMLUtil.findSubElements((Element)data)) {
                String text;
                if (!ext.getLocalName().equals("class-path-extension")) continue;
                Element binaryOrigin = XMLUtil.findElement((Element)ext, (String)"binary-origin", (String)"http://www.netbeans.org/ns/nb-module-project/3");
                if (binaryOrigin != null) {
                    text = XMLUtil.findText((Node)binaryOrigin);
                } else {
                    Element runtimeRelativePath = XMLUtil.findElement((Element)ext, (String)"runtime-relative-path", (String)"http://www.netbeans.org/ns/nb-module-project/3");
                    assert (runtimeRelativePath != null) : "Malformed <class-path-extension> in " + basedir;
                    String reltext = XMLUtil.findText((Node)runtimeRelativePath);
                    text = "${cluster}/${module.jar.dir}/" + reltext;
                }
                String evaluated = eval.evaluate(text);
                if (evaluated == null) continue;
                File binary = PropertyUtils.resolveFile((File)basedir, (String)evaluated);
                cpextra.append(File.pathSeparatorChar);
                cpextra.append(binary.getAbsolutePath());
            }
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, "Error getting subelements, malformed xml");
            cpextra = new StringBuilder();
        }
        File manifest = new File(basedir, "manifest.mf");
        ManifestManager mm = manifest.isFile() ? ManifestManager.getInstance((File)manifest, (boolean)false) : ManifestManager.NULL_INSTANCE;
        File clusterDir = PropertyUtils.resolveFile((File)basedir, (String)eval.getProperty("cluster"));
        ManifestManager.PackageExport[] publicPackages = ProjectXMLManager.findPublicPackages(data);
        String[] friends = ProjectXMLManager.findFriends(data);
        String src = eval.getProperty("src.dir");
        if (src == null) {
            src = "src";
        }
        AbstractEntryWithSources entry = type == NbModuleType.NETBEANS_ORG ? new NetBeansOrgEntry(root, cnb, path, clusterDir, module, cpextra.toString(), mm.getReleaseVersion(), mm.getProvidedTokens(), publicPackages, friends, mm.isDeprecated(), src) : new ExternalEntry(basedir, cnb, clusterDir, PropertyUtils.resolveFile((File)clusterDir, (String)module), cpextra.toString(), nbdestdir, mm.getReleaseVersion(), mm.getProvidedTokens(), publicPackages, friends, mm.isDeprecated(), src);
        if (entries.containsKey(cnb)) {
            LOG.log(Level.WARNING, "Warning: two modules found with the same code name base (" + cnb + "): " + entries.get(cnb) + " and " + entry);
        } else {
            entries.put(cnb, entry);
        }
        ModuleList.registerEntry(entry, ModuleList.findSourceNBMFiles(entry, eval));
        LOG.log(Level.FINER, "scanPossibleProject: " + basedir + " scanned successfully");
    }

    private static Set<File> findSourceNBMFiles(ModuleEntry entry, PropertyEvaluator eval) throws IOException {
        String[] STANDARD_FILES;
        HashSet<File> files = new HashSet<File>();
        files.add(entry.getJarLocation());
        File cluster = entry.getClusterDirectory();
        String cnbd = entry.getCodeNameBase().replace('.', '-');
        for (String f : STANDARD_FILES = new String[]{"update_tracking/*.xml", "config/Modules/*.xml", "config/ModuleAutoDeps/*.xml", "ant/nblib/*.jar", "modules/docs/*.jar"}) {
            int x = f.indexOf(42);
            ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, f.substring(0, x) + cnbd + f.substring(x + 1));
        }
        String emf = eval.getProperty("extra.module.files");
        if (emf != null) {
            for (String pattern : emf.split(" *, *")) {
                if (pattern.endsWith("/")) {
                    pattern = pattern + "**";
                }
                if (pattern.indexOf(42) == -1) {
                    ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, pattern);
                    continue;
                }
                String regex = "\\Q" + pattern.replace("**", "__DBLASTERISK__").replace("*", "\\E[^/]*\\Q").replace("__DBLASTERISK__", "\\E.*\\Q") + "\\E";
                Pattern regexp = Pattern.compile(regex);
                for (String clusterFile : ModuleList.scanDirForFiles(cluster)) {
                    if (!regexp.matcher(clusterFile).matches()) continue;
                    ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, clusterFile);
                }
            }
        }
        File src = entry.getSourceLocation();
        assert (src != null && src.isDirectory()) : entry;
        File releaseDir = new File(src, "release");
        if (releaseDir.isDirectory()) {
            for (String releaseFile : ModuleList.scanDirForFiles(releaseDir)) {
                ModuleList.findSourceNBMFilesMaybeAdd(files, cluster, releaseFile);
            }
        }
        return files;
    }

    private static void findSourceNBMFilesMaybeAdd(Set<File> files, File cluster, String path) {
        File f = new File(cluster, path.replace('/', File.separatorChar));
        files.add(f);
    }

    private static String[] scanDirForFiles(File dir) {
        String[] files = DIR_SCAN_CACHE.get(dir);
        if (files == null) {
            ArrayList<String> l = new ArrayList<String>(250);
            ModuleList.doScanDirForFiles(dir, l, "");
            files = l.toArray(new String[0]);
        }
        return files;
    }

    private static void doScanDirForFiles(File d, List<String> files, String prefix) {
        ++directoriesChecked;
        File[] kids = d.listFiles();
        if (kids != null) {
            for (File f : kids) {
                if (f.isFile()) {
                    files.add(prefix + f.getName());
                    continue;
                }
                if (!f.isDirectory()) continue;
                ModuleList.doScanDirForFiles(f, files, prefix + f.getName() + '/');
            }
        }
    }

    public static ModuleList findOrCreateModuleListFromSuite(File root, File customNbDestDir) throws IOException {
        PropertyEvaluator eval = ModuleList.parseSuiteProperties(root);
        File nbdestdir = ModuleList.resolveNbDestDir(root, customNbDestDir, eval);
        Set<ClusterInfo> clup = ClusterUtils.evaluateClusterPath(root, eval, nbdestdir);
        LOG.log(Level.FINE, "Scanning suite in " + root + ", cluster.path is: " + clup);
        if (!clup.isEmpty()) {
            ArrayList<ModuleList> lists = new ArrayList<ModuleList>();
            lists.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(root, nbdestdir, eval));
            lists.addAll(ModuleList.findOrCreateModuleListsFromClusterPath(clup, nbdestdir));
            return ModuleList.merge(lists.toArray(new ModuleList[0]), root);
        }
        return ModuleList.merge(new ModuleList[]{ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(root, nbdestdir, eval), ModuleList.findOrCreateModuleListFromBinaries(nbdestdir)}, root);
    }

    private static List<ModuleList> findOrCreateModuleListsFromClusterPath(Set<ClusterInfo> clup, File customNbDestDir) throws IOException {
        ArrayList<ModuleList> lists = new ArrayList<ModuleList>();
        for (ClusterInfo ci : clup) {
            Project prj = ci.getProject();
            if (prj != null) {
                File prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
                if (SuiteUtils.isSuite(prjDir)) {
                    lists.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(prjDir, customNbDestDir));
                    continue;
                }
                lists.add(ModuleList.findOrCreateModuleListFromStandaloneModule(prjDir, customNbDestDir));
                continue;
            }
            File cd = ci.getClusterDir();
            ModuleList ml = ModuleList.findOrCreateModuleListFromCluster(cd, ci.isPlatformCluster() ? cd.getParentFile() : null, ci);
            lists.add(ml);
        }
        return lists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File root, File nbdestdir, PropertyEvaluator eval) throws IOException {
        Map<File, ModuleList> map = sourceLists;
        synchronized (map) {
            ModuleList sources = sourceLists.get(root);
            if (sources == null) {
                HashMap<String, ModuleEntry> entries = new HashMap<String, ModuleEntry>();
                for (File module : ModuleList.findModulesInSuite(root, eval)) {
                    try {
                        ModuleList.scanPossibleProject(module, entries, NbModuleType.SUITE_COMPONENT, null, nbdestdir, null);
                    }
                    catch (IOException e) {
                        Util.err.annotate((Throwable)e, 0, "Malformed project metadata in " + module + ", skipping...", null, null, null);
                        Util.err.notify(1, (Throwable)e);
                    }
                }
                sources = new ModuleList(entries, root);
                sourceLists.put(root, sources);
            }
            return sources;
        }
    }

    private static File resolveNbDestDir(File root, File customNbDestDir, PropertyEvaluator eval) throws IOException {
        File nbdestdir;
        if (customNbDestDir == null) {
            String nbdestdirS = eval.getProperty(NETBEANS_DEST_DIR);
            if (nbdestdirS == null) {
                throw new IOException("No netbeans.dest.dir defined in " + root);
            }
            nbdestdir = PropertyUtils.resolveFile((File)root, (String)nbdestdirS);
        } else {
            nbdestdir = customNbDestDir;
        }
        if (!nbdestdir.exists()) {
            LOG.log(Level.INFO, "Project in " + root + " is missing its platform '" + eval.getProperty("nbplatform.active") + "', switching to default platform");
            NbPlatform p2 = NbPlatform.getDefaultPlatform();
            if (p2 != null) {
                nbdestdir = p2.getDestDir();
            }
        }
        return nbdestdir;
    }

    private static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File root, File customNbDestDir) throws IOException {
        PropertyEvaluator eval = ModuleList.parseSuiteProperties(root);
        File nbdestdir = ModuleList.resolveNbDestDir(root, customNbDestDir, eval);
        return ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(root, nbdestdir, eval);
    }

    static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File root) throws IOException {
        return ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(root, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyEvaluator parseSuiteProperties(File root) throws IOException {
        Map predefs;
        Properties p;
        Properties properties = p = System.getProperties();
        synchronized (properties) {
            predefs = NbCollections.checkedMapByCopy((Map)p, String.class, String.class, (boolean)false);
        }
        predefs.put("basedir", root.getAbsolutePath());
        PropertyProvider predefsProvider = PropertyUtils.fixedPropertyProvider((Map)predefs);
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "platform.properties")));
        PropertyEvaluator eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
        String buildS = eval.getProperty("user.properties.file");
        if (buildS != null) {
            providers.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)root, (String)buildS)));
        } else {
            providers.add(PropertyUtils.globalPropertyProvider());
        }
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        providers.add(ModuleList.loadPropertiesFile(new File(root, "nbproject" + File.separatorChar + "project.properties")));
        eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
        providers.add(new DestDirProvider(eval));
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
    }

    static File[] findModulesInSuite(File root) throws IOException {
        return ModuleList.findModulesInSuite(root, ModuleList.parseSuiteProperties(root));
    }

    private static File[] findModulesInSuite(File root, PropertyEvaluator eval) throws IOException {
        String modulesS = eval.getProperty("modules");
        if (modulesS == null) {
            modulesS = "";
        }
        String[] modulesA = PropertyUtils.tokenizePath((String)modulesS);
        File[] modules = new File[modulesA.length];
        for (int i = 0; i < modulesA.length; ++i) {
            modules[i] = PropertyUtils.resolveFile((File)root, (String)modulesA[i]);
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleList findOrCreateModuleListFromStandaloneModule(File basedir, File customNbDestDir) throws IOException {
        PropertyEvaluator eval = ModuleList.parseProperties(basedir, null, NbModuleType.STANDALONE, "irrelevant");
        File nbdestdir = ModuleList.resolveNbDestDir(basedir, customNbDestDir, eval);
        Map<File, ModuleList> map = sourceLists;
        synchronized (map) {
            ModuleList binaries = ModuleList.findOrCreateModuleListFromBinaries(nbdestdir);
            ModuleList sources = sourceLists.get(basedir);
            if (sources == null) {
                HashMap<String, ModuleEntry> entries = new HashMap<String, ModuleEntry>();
                ModuleList.scanPossibleProject(basedir, entries, NbModuleType.STANDALONE, null, nbdestdir, null);
                if (entries.isEmpty()) {
                    throw new IOException("No module in " + basedir);
                }
                sources = new ModuleList(entries, basedir);
                sourceLists.put(basedir, sources);
            }
            return ModuleList.merge(new ModuleList[]{sources, binaries}, basedir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleList findOrCreateModuleListFromBinaries(File root) throws IOException {
        File[] clusters;
        Map<File, File[]> map = clusterLists;
        synchronized (map) {
            clusters = clusterLists.get(root);
            if (clusters == null) {
                clusters = root.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                if (clusters == null) {
                    throw new IOException("Cannot examine dir " + root);
                }
                clusterLists.put(root, clusters);
            }
        }
        ModuleList[] lists = new ModuleList[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            lists[i] = ModuleList.findOrCreateModuleListFromCluster(clusters[i], root, null);
        }
        ModuleList ml = ModuleList.merge(lists, root);
        if (ml.getEntry("org.netbeans.libs.junit4") == null) {
            ml.entries.put("org.netbeans.libs.junit4", new JUnitPlaceholderEntry(root));
        }
        return ml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleList findOrCreateModuleListFromCluster(File cluster, File nbDestDir, ClusterInfo ci) throws IOException {
        Map<File, ModuleList> map = binaryLists;
        synchronized (map) {
            ModuleList list = binaryLists.get(cluster);
            if (list == null) {
                list = ModuleList.scanCluster(cluster, nbDestDir, true, ci);
                binaryLists.put(cluster, list);
            }
            return list;
        }
    }

    public static ModuleList scanCluster(File cluster, @NullAllowed File nbDestDir, boolean registerEntry, ClusterInfo ci) throws IOException {
        HashMap<String, ModuleEntry> entries = new HashMap<String, ModuleEntry>();
        for (String moduleDir : MODULE_DIRS) {
            File dir = new File(cluster, moduleDir.replace('/', File.separatorChar));
            if (!dir.isDirectory()) continue;
            File[] jars = dir.listFiles();
            if (jars == null) {
                throw new IOException("Cannot examine dir " + dir);
            }
            ModuleList.scanJars(dir, ci, nbDestDir, cluster, entries, registerEntry, jars);
        }
        File configs = new File(new File(cluster, "config"), "Modules");
        File[] xmls = configs.listFiles();
        if (xmls != null) {
            XPathExpression xpe = null;
            for (File xml : xmls) {
                String n = xml.getName();
                if (!n.endsWith(".xml") || entries.get(n = n.substring(0, n.length() - 4).replace('-', '.')) != null) continue;
                try {
                    String res;
                    File jar;
                    Document doc = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)xml).toString()), (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
                    if (xpe == null) {
                        xpe = XPathFactory.newInstance().newXPath().compile("module/param[@name='jar']/text()");
                    }
                    if (!(jar = new File(cluster, res = xpe.evaluate(doc))).exists()) continue;
                    ModuleList.scanJars(cluster, ci, nbDestDir, cluster, entries, registerEntry, jar);
                }
                catch (Exception ex) {
                    throw (IOException)new IOException(ex.toString()).initCause(ex);
                }
            }
        }
        LOG.log(Level.FINER, "scanCluster: " + cluster + " succeeded.");
        return new ModuleList(entries, nbDestDir);
    }

    private static Set<File> findBinaryNBMFiles(File cluster, String cnb, File jar) throws IOException {
        HashSet<File> files = new HashSet<File>();
        files.add(jar);
        File tracking = new File(new File(cluster, "update_tracking"), cnb.replace('.', '-') + ".xml");
        if (tracking.isFile()) {
            Document doc;
            files.add(tracking);
            try {
                ++xmlFilesParsed;
                timeSpentInXmlParsing -= System.currentTimeMillis();
                doc = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)tracking).toString()), (boolean)false, (boolean)false, null, null);
                timeSpentInXmlParsing += System.currentTimeMillis();
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            for (Element moduleVersion : XMLUtil.findSubElements((Element)doc.getDocumentElement())) {
                if (!moduleVersion.getTagName().equals("module_version") || !moduleVersion.getAttribute("last").equals("true")) continue;
                for (Element fileEl : XMLUtil.findSubElements((Element)moduleVersion)) {
                    String name;
                    File f;
                    if (!fileEl.getTagName().equals("file") || !(f = new File(cluster, (name = fileEl.getAttribute("name")).replace('/', File.separatorChar))).isFile()) continue;
                    files.add(f);
                }
            }
        }
        return files;
    }

    static Element parseData(File basedir) throws IOException {
        Document doc;
        File projectXml = new File(basedir, PROJECT_XML);
        if (!projectXml.exists() || !projectXml.isFile()) {
            return null;
        }
        try {
            ++xmlFilesParsed;
            timeSpentInXmlParsing -= System.currentTimeMillis();
            doc = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)projectXml).toString()), (boolean)false, (boolean)true, null, null);
            timeSpentInXmlParsing += System.currentTimeMillis();
        }
        catch (SAXException e) {
            throw (IOException)new IOException(projectXml + ": " + e.toString()).initCause(e);
        }
        Element docel = doc.getDocumentElement();
        Element type = XMLUtil.findElement((Element)docel, (String)"type", (String)"http://www.netbeans.org/ns/project/1");
        if (!XMLUtil.findText((Node)type).equals("org.netbeans.modules.apisupport.project")) {
            return null;
        }
        Element cfg = XMLUtil.findElement((Element)docel, (String)"configuration", (String)"http://www.netbeans.org/ns/project/1");
        Element data = XMLUtil.findElement((Element)cfg, (String)"data", (String)"http://www.netbeans.org/ns/nb-module-project/3");
        if (data != null) {
            return data;
        }
        data = XMLUtil.findElement((Element)cfg, (String)"data", (String)"http://www.netbeans.org/ns/nb-module-project/2");
        if (data != null) {
            return XMLUtil.translateXML((Element)data, (String)"http://www.netbeans.org/ns/nb-module-project/3");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PropertyEvaluator parseProperties(File basedir, File root, NbModuleType type, String cnb) throws IOException {
        PropertyEvaluator eval;
        Map predefs;
        Properties p;
        Properties properties = p = System.getProperties();
        synchronized (properties) {
            predefs = NbCollections.checkedMapByCopy((Map)p, String.class, String.class, (boolean)false);
        }
        predefs.put("basedir", basedir.getAbsolutePath());
        PropertyProvider predefsProvider = PropertyUtils.fixedPropertyProvider((Map)predefs);
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        if (type == NbModuleType.SUITE_COMPONENT) {
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "suite-private.properties")));
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "suite.properties")));
            eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
            String suiteS = eval.getProperty("suite.dir");
            if (suiteS != null) {
                File suite = PropertyUtils.resolveFile((File)basedir, (String)suiteS);
                providers.add(ModuleList.loadPropertiesFile(new File(suite, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                providers.add(ModuleList.loadPropertiesFile(new File(suite, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (type == NbModuleType.STANDALONE) {
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
            providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "platform.properties")));
        }
        if (type != NbModuleType.NETBEANS_ORG) {
            eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
            String buildS = eval.getProperty("user.properties.file");
            if (buildS != null) {
                providers.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)basedir, (String)buildS)));
            } else {
                providers.add(PropertyUtils.globalPropertyProvider());
            }
            eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
            providers.add(new DestDirProvider(eval));
        }
        providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        providers.add(ModuleList.loadPropertiesFile(new File(basedir, "nbproject" + File.separatorChar + "project.properties")));
        HashMap<String, String> defaults = new HashMap<String, String>();
        if (type == NbModuleType.NETBEANS_ORG) {
            defaults.put("nb_all", root.getAbsolutePath());
            defaults.put(NETBEANS_DEST_DIR, ModuleList.findNetBeansOrgDestDir(root).getAbsolutePath());
        }
        defaults.put("code.name.base.dashes", cnb.replace('.', '-'));
        defaults.put("module.jar.dir", "modules");
        defaults.put("module.jar.basename", "${code.name.base.dashes}.jar");
        defaults.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        defaults.put("build.dir", "build");
        if (type == NbModuleType.SUITE_COMPONENT) {
            defaults.put("suite.build.dir", "${suite.dir}/build");
        }
        providers.add(PropertyUtils.fixedPropertyProvider(defaults));
        defaults.put("cluster", ModuleList.findClusterLocation(basedir, root, type));
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefsProvider, (PropertyProvider[])providers.toArray(new PropertyProvider[0]));
    }

    private static PropertyProvider loadPropertiesFile(File f) throws IOException {
        if (!f.isFile()) {
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(f);){
            p.load(is);
        }
        return PropertyUtils.fixedPropertyProvider((Map)NbCollections.checkedMapByFilter((Map)p, String.class, String.class, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        Map<File, Object> map = sourceLists;
        synchronized (map) {
            sourceLists.clear();
        }
        map = binaryLists;
        synchronized (map) {
            binaryLists.clear();
        }
        map = clusterLists;
        synchronized (map) {
            clusterLists.clear();
        }
        map = knownEntries;
        synchronized (map) {
            knownEntries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshModuleListForRoot(File rootDir) {
        Map<File, ModuleList> map = sourceLists;
        synchronized (map) {
            sourceLists.remove(rootDir);
        }
    }

    public static void refreshClusterModuleList(File clusterDir) {
    }

    public static boolean isNetBeansOrg(File dir) {
        return new File(dir, "nbbuild").isDirectory();
    }

    public static File findNetBeansOrg(File basedir) {
        File f = basedir;
        File repo = f.getParentFile();
        if (repo != null) {
            for (String tree : new String[]{null, "contrib"}) {
                File mainrepo;
                if (tree == null) {
                    mainrepo = repo;
                } else {
                    if (!repo.getName().equals(tree)) continue;
                    mainrepo = repo.getParentFile();
                }
                if (!new File(mainrepo, "nbbuild").isDirectory()) continue;
                return mainrepo;
            }
        }
        for (int i = 0; i < 3; ++i) {
            if ((f = f.getParentFile()) == null) {
                return null;
            }
            if (!new File(f, "nbbuild").isDirectory()) continue;
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getClusterProperties(File nbroot) throws IOException {
        Map clusterDefs = null;
        Map<File, Map<String, String>> map = clusterPropertiesFiles;
        synchronized (map) {
            clusterDefs = clusterPropertiesFiles.get(nbroot);
            if (clusterDefs == null) {
                PropertyProvider pp = ModuleList.loadPropertiesFile(ModuleList.getClusterPropertiesFile(nbroot));
                PropertyEvaluator clusterEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.fixedPropertyProvider(Collections.emptyMap()), (PropertyProvider[])new PropertyProvider[]{pp});
                clusterDefs = clusterEval.getProperties();
                if (clusterDefs == null) {
                    clusterDefs = Collections.emptyMap();
                }
                clusterPropertiesFiles.put(nbroot, clusterDefs);
            }
        }
        return clusterDefs;
    }

    public static String findClusterLocation(File basedir, File nbroot, NbModuleType type) throws IOException {
        String cluster;
        switch (type) {
            case SUITE_COMPONENT: {
                cluster = "${suite.build.dir}/cluster";
                break;
            }
            case STANDALONE: {
                cluster = "${build.dir}/cluster";
                break;
            }
            default: {
                int clusterSep;
                String path = PropertyUtils.relativizeFile((File)nbroot, (File)basedir);
                Map<String, String> clusterLocationsHere = clusterLocations.get(nbroot);
                if (clusterLocationsHere == null) {
                    clusterLocationsHere = new HashMap<String, String>();
                    Map<String, String> clusterDefs = ModuleList.getClusterProperties(nbroot);
                    for (Map.Entry<String, String> entry : clusterDefs.entrySet()) {
                        String key = entry.getKey();
                        String clusterDir = clusterDefs.get(key + ".dir");
                        if (clusterDir == null) continue;
                        String val = entry.getValue();
                        StringTokenizer tok = new StringTokenizer(val, ", ");
                        while (tok.hasMoreTokens()) {
                            String p = tok.nextToken();
                            clusterLocationsHere.put(p, clusterDir);
                        }
                    }
                    clusterLocations.put(nbroot, clusterLocationsHere);
                }
                if ((cluster = clusterLocationsHere.get(path)) == null && path != null && (clusterSep = path.lastIndexOf(47)) >= 0) {
                    String id = path.substring(clusterSep + 1);
                    String expCluster = path.substring(0, clusterSep);
                    if (!expCluster.equals(cluster = clusterLocationsHere.get(id))) {
                        cluster = null;
                    }
                }
                if (cluster == null) {
                    cluster = "extra";
                }
                cluster = "${netbeans.dest.dir}/" + cluster;
            }
        }
        return cluster;
    }

    private ModuleList(Map<String, ModuleEntry> entries, File home) {
        this.entries = entries;
        this.home = home;
        LinkedHashSet<String> forest = new LinkedHashSet<String>();
        forest.add(null);
        forest.add("contrib");
        File cluster = new File(new File(home, "nbbuild"), "cluster.properties");
        if (cluster.exists()) {
            Properties p = new Properties();
            try (FileInputStream is = new FileInputStream(cluster);){
                p.load(is);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Enumeration<?> en = p.propertyNames();
            while (en.hasMoreElements()) {
                String propName = (String)en.nextElement();
                if (!propName.endsWith(".dir")) continue;
                forest.add(p.getProperty(propName));
            }
        }
        this.FOREST = forest.toArray(new String[0]);
    }

    public String toString() {
        return "ModuleList[" + this.home + ",lazy=" + this.lazyNetBeansOrgList + "]" + this.entries.values();
    }

    private static ModuleList merge(ModuleList[] lists, File home) {
        HashMap<String, ModuleEntry> entries = new HashMap<String, ModuleEntry>();
        for (ModuleList list : lists) {
            for (Map.Entry<String, ModuleEntry> entry : list.entries.entrySet()) {
                String cnb = entry.getKey();
                if (entries.containsKey(cnb)) continue;
                entries.put(cnb, entry.getValue());
            }
        }
        return new ModuleList(entries, home);
    }

    private void maybeRescanNetBeansOrgSources() {
        if (this.lazyNetBeansOrgList < 2) {
            this.lazyNetBeansOrgList = 2;
            File nbdestdir = ModuleList.findNetBeansOrgDestDir(this.home);
            HashMap<String, ModuleEntry> _entries = new HashMap<String, ModuleEntry>(this.entries);
            HashSet<File> knownProjects = new HashSet<File>();
            for (ModuleEntry known : this.entries.values()) {
                knownProjects.add(known.getSourceLocation());
            }
            if (new File(this.home, "openide.util").isDirectory()) {
                for (String tree : this.FOREST) {
                    ModuleList.doScanNetBeansOrgSources(_entries, tree == null ? this.home : new File(this.home, tree), 1, this.home, nbdestdir, tree, knownProjects);
                }
            } else {
                ModuleList.doScanNetBeansOrgSources(_entries, this.home, 3, this.home, nbdestdir, null, knownProjects);
            }
            this.entries = _entries;
        }
    }

    public ModuleEntry getEntry(String codeNameBase) {
        if (codeNameBase == null) {
            return null;
        }
        ModuleEntry e = this.entries.get(codeNameBase);
        if (e != null) {
            return e;
        }
        if (this.home == null || !ModuleList.isNetBeansOrg(this.home)) {
            return null;
        }
        File nbdestdir = ModuleList.findNetBeansOrgDestDir(this.home);
        for (String tree : this.FOREST) {
            String name = ModuleList.abbreviate(codeNameBase);
            File basedir = new File(tree == null ? this.home : new File(this.home, tree), name);
            HashMap<String, ModuleEntry> _entries = new HashMap<String, ModuleEntry>();
            try {
                ModuleList.scanPossibleProject(basedir, _entries, NbModuleType.NETBEANS_ORG, this.home, nbdestdir, tree == null ? name : tree + "/" + name);
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
                continue;
            }
            if (_entries.isEmpty()) continue;
            _entries.putAll(this.entries);
            this.entries = _entries;
            e = (ModuleEntry)_entries.get(codeNameBase);
            if (e == null) continue;
            LOG.log(Level.FINE, "Found entry for {0} by direct guess in {1}", new Object[]{codeNameBase, basedir});
            return e;
        }
        LOG.log(Level.WARNING, "could not find entry for {0} by direct guess in {1}", new Object[]{codeNameBase, this.home});
        try {
            this.scanNetBeansOrgStableSources();
        }
        catch (IOException x) {
            LOG.log(Level.INFO, null, x);
        }
        if (!this.entries.containsKey(codeNameBase)) {
            LOG.log(Level.WARNING, "could not find entry for {0} even among stable sources in {1}", new Object[]{codeNameBase, this.home});
            this.maybeRescanNetBeansOrgSources();
            if (!this.entries.containsKey(codeNameBase)) {
                LOG.log(Level.WARNING, "failed to find entry for {0} at all in {1}", new Object[]{codeNameBase, this.home});
            }
        }
        return this.entries.get(codeNameBase);
    }

    public static String abbreviate(String cnb) {
        return cnb.replaceFirst("^org\\.netbeans\\.modules\\.", "").replaceFirst("^org\\.netbeans\\.(libs|lib|api|spi|core)\\.", "$1.").replaceFirst("^org\\.netbeans\\.", "o.n.").replaceFirst("^org\\.openide\\.", "openide.").replaceFirst("^org\\.", "o.").replaceFirst("^com\\.sun\\.", "c.s.").replaceFirst("^com\\.", "c.");
    }

    public Set<ModuleEntry> getAllEntries() {
        if (this.home != null && ModuleList.isNetBeansOrg(this.home)) {
            try {
                this.scanNetBeansOrgStableSources();
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        return new HashSet<ModuleEntry>(this.entries.values());
    }

    public static LocalizedBundleInfo loadBundleInfo(File projectDir) {
        LocalizedBundleInfo bundleInfo = ApisupportAntUtils.findLocalizedBundleInfo(projectDir);
        return bundleInfo == null ? LocalizedBundleInfo.EMPTY : bundleInfo;
    }

    static {
        sourceLists = new HashMap<File, ModuleList>();
        binaryLists = new HashMap<File, ModuleList>();
        clusterLists = new HashMap<File, File[]>();
        clusterPropertiesFiles = new HashMap<File, Map<String, String>>();
        clusterLocations = new HashMap<File, Map<String, String>>();
        knownEntries = new HashMap<File, Set<ModuleEntry>>();
        netbeansOrgDestDirs = new HashMap<File, File>();
        EXCLUDED_DIR_NAMES = new HashSet<String>();
        EXCLUDED_DIR_NAMES.add("CVS");
        EXCLUDED_DIR_NAMES.add("nbproject");
        EXCLUDED_DIR_NAMES.add("www");
        EXCLUDED_DIR_NAMES.add("test");
        EXCLUDED_DIR_NAMES.add("build");
        EXCLUDED_DIR_NAMES.add("src");
        EXCLUDED_DIR_NAMES.add("org");
        DIR_SCAN_CACHE = new HashMap<File, String[]>();
        MODULE_DIRS = new String[]{"modules", "modules/eager", "modules/autoload", "lib", "core"};
        PROJECT_XML = "nbproject" + File.separatorChar + "project.xml";
    }

    private static class JUnitPlaceholderEntry
    extends AbstractBinaryEntry {
        static final String CNB = "org.netbeans.libs.junit4";

        JUnitPlaceholderEntry(File root) {
            super(CNB, new File(root, "platform/modules/" + CNB.replace('.', '-') + ".jar"), new File[]{new File(System.getProperty("user.home"), ".m2/repository/junit/junit/4.13.2/junit-4.13.2.jar")}, new File(root, "platform"), null, null, new String[0], new ManifestManager.PackageExport[]{new ManifestManager.PackageExport("junit", true), new ManifestManager.PackageExport("org.junit", true)}, null, false, Collections.emptySet());
        }

        @Override
        public File getSourceLocation() {
            return null;
        }

        @Override
        protected LocalizedBundleInfo getBundleInfo() {
            try {
                return LocalizedBundleInfo.load(new InputStream[]{new ByteArrayInputStream(("OpenIDE-Module-Name=" + Bundle.junit_placeholder()).getBytes(StandardCharsets.ISO_8859_1))});
            }
            catch (IOException x) {
                assert (false) : x;
                return LocalizedBundleInfo.EMPTY;
            }
        }

        @Override
        protected Set<String> computePublicClassNamesInMainModule() {
            return new HashSet<String>();
        }
    }
}

