<?php

namespace {

	/**
	 * <p>A fully opaque class which replaces <code>xml</code> resources as of PHP 8.0.0.</p>
	 * @link https://php.net/manual/en/class.xmlparser.php
	 * @since PHP 8
	 */
	final class XMLParser {
	}

	/**
	 * Get XML parser error string
	 * <p>Gets the XML parser error string associated with the given <code>error_code</code>.</p>
	 * @param int $error_code <p>An error code from <code>xml_get_error_code()</code>.</p>
	 * @return ?string <p>Returns a string with a textual description of the error <code>error_code</code>, or <b><code>null</code></b> if no description was found.</p>
	 * @link https://php.net/manual/en/function.xml-error-string.php
	 * @see xml_get_error_code()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_error_string(int $error_code): ?string {}

	/**
	 * Get current byte index for an XML parser
	 * <p>Gets the current byte index of the given XML parser.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser to get byte index from.</p>
	 * @return int <p>Returns which byte index the parser is currently at in its data buffer (starting at 0).</p>
	 * @link https://php.net/manual/en/function.xml-get-current-byte-index.php
	 * @see xml_get_current_column_number(), xml_get_current_line_number()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_get_current_byte_index(\XMLParser $parser): int {}

	/**
	 * Get current column number for an XML parser
	 * <p>Gets the current column number of the given XML parser.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser to get column number from.</p>
	 * @return int <p>Returns which column on the current line (as given by <code>xml_get_current_line_number()</code>) the parser is currently at.</p>
	 * @link https://php.net/manual/en/function.xml-get-current-column-number.php
	 * @see xml_get_current_byte_index(), xml_get_current_line_number()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_get_current_column_number(\XMLParser $parser): int {}

	/**
	 * Get current line number for an XML parser
	 * <p>Gets the current line number for the given XML parser.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser to get line number from.</p>
	 * @return int <p>Returns which line the parser is currently at in its data buffer.</p>
	 * @link https://php.net/manual/en/function.xml-get-current-line-number.php
	 * @see xml_get_current_column_number(), xml_get_current_byte_index()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_get_current_line_number(\XMLParser $parser): int {}

	/**
	 * Get XML parser error code
	 * <p>Gets the XML parser error code.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser to get error code from.</p>
	 * @return int <p>Returns one of the error codes listed in the error codes section.</p>
	 * @link https://php.net/manual/en/function.xml-get-error-code.php
	 * @see xml_error_string()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_get_error_code(\XMLParser $parser): int {}

	/**
	 * Start parsing an XML document
	 * <p><b>xml_parse()</b> parses an XML document. The handlers for the configured events are called as many times as necessary.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser to use.</p>
	 * @param string $data <p>Chunk of data to parse. A document may be parsed piece-wise by calling <b>xml_parse()</b> several times with new data, as long as the <code>is_final</code> parameter is set and <b><code>true</code></b> when the last data is parsed.</p>
	 * @param bool $is_final <p>If set and <b><code>true</code></b>, <code>data</code> is the last piece of data sent in this parse.</p>
	 * @return int <p>Returns 1 on success or 0 on failure.</p><p>For unsuccessful parses, error information can be retrieved with <code>xml_get_error_code()</code>, <code>xml_error_string()</code>, <code>xml_get_current_line_number()</code>, <code>xml_get_current_column_number()</code> and <code>xml_get_current_byte_index()</code>.</p><p><b>Note</b>:</p><p>Some errors (such as entity errors) are reported at the end of the data, thus only if <code>is_final</code> is set and <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-parse.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_parse(\XMLParser $parser, string $data, bool $is_final = false): int {}

	/**
	 * Parse XML data into an array structure
	 * <p>This function parses an XML string into 2 parallel array structures, one (<code>index</code>) containing pointers to the location of the appropriate values in the <code>values</code> array. These last two parameters must be passed by reference.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser.</p>
	 * @param string $data <p>A string containing the XML data.</p>
	 * @param array $values <p>An array containing the values of the XML data</p>
	 * @param array $index <p>An array containing pointers to the location of the appropriate values in the $values.</p>
	 * @return int <p><b>xml_parse_into_struct()</b> returns 0 for failure and 1 for success. This is not the same as <b><code>false</code></b> and <b><code>true</code></b>, be careful with operators such as ===.</p>
	 * @link https://php.net/manual/en/function.xml-parse-into-struct.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_parse_into_struct(\XMLParser $parser, string $data, array &$values, array &$index = null): int {}

	/**
	 * Create an XML parser
	 * <p><b>xml_parser_create()</b> creates a new XML parser and returns a <code>XMLParser</code> instance to be used by the other XML functions.</p>
	 * @param ?string $encoding <p>The input encoding is automatically detected, so that the <code>encoding</code> parameter specifies only the output encoding. If empty string is passed, the parser attempts to identify which encoding the document is encoded in by looking at the heading 3 or 4 bytes. The default output charset is UTF-8. The supported encodings are <code>ISO-8859-1</code>, <code>UTF-8</code> and <code>US-ASCII</code>.</p>
	 * @return XMLParser <p>Returns a new <code>XMLParser</code> instance.</p>
	 * @link https://php.net/manual/en/function.xml-parser-create.php
	 * @see xml_parser_create_ns(), xml_parser_free()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_parser_create(?string $encoding = null): \XMLParser {}

	/**
	 * Create an XML parser with namespace support
	 * <p><b>xml_parser_create_ns()</b> creates a new XML parser with XML namespace support and returns a <code>XMLParser</code> instance to be used by the other XML functions.</p>
	 * @param ?string $encoding <p>The input encoding is automatically detected, so that the <code>encoding</code> parameter specifies only the output encoding. The default output charset is UTF-8. The supported encodings are <code>ISO-8859-1</code>, <code>UTF-8</code> and <code>US-ASCII</code>.</p>
	 * @param string $separator <p>With a namespace aware parser tag parameters passed to the various handler functions will consist of namespace and tag name separated by the string specified in <code>separator</code>.</p>
	 * @return XMLParser <p>Returns a new <code>XMLParser</code> instance.</p>
	 * @link https://php.net/manual/en/function.xml-parser-create-ns.php
	 * @see xml_parser_create(), xml_parser_free()
	 * @since PHP 4 >= 4.0.5, PHP 5, PHP 7, PHP 8
	 */
	function xml_parser_create_ns(?string $encoding = null, string $separator = ":"): \XMLParser {}

	/**
	 * Free an XML parser
	 * <p><b>Note</b>:</p><p>This function has no effect. Prior to PHP 8.0.0, this function was used to close the resource.</p><p>Frees the given XML <code>parser</code>.</p><p>In addition to calling <b>xml_parser_free()</b> when the parsing is finished, prior to PHP 8.0.0, it was necessary to also explicitly unset the reference to <code>parser</code> to avoid memory leaks, if the parser resource is referenced from an object, and this object references that parser resource.</p>
	 * @param \XMLParser $parser A reference to the XML parser to free.
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.xml-parser-free.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_parser_free(\XMLParser $parser): bool {}

	/**
	 * Get options from an XML parser
	 * <p>Gets an option value from an XML parser.</p>
	 * @param \XMLParser $parser A reference to the XML parser to get an option from.
	 * @param int $option Which option to fetch. <b><code>XML_OPTION_CASE_FOLDING</code></b>, <b><code>XML_OPTION_SKIP_TAGSTART</code></b>, <b><code>XML_OPTION_SKIP_WHITE</code></b> and <b><code>XML_OPTION_TARGET_ENCODING</code></b> are available. See <code>xml_parser_set_option()</code> for their description.
	 * @return string|int|bool <p>Returns the option's value.</p>
	 * @link https://php.net/manual/en/function.xml-parser-get-option.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_parser_get_option(\XMLParser $parser, int $option): string|int|bool {}

	/**
	 * Set options in an XML parser
	 * <p>Sets an option in an XML parser.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser to set an option in.</p>
	 * @param int $option <p>Which option to set. See below.</p> <p>The following options are available:</p> <b>XML parser options</b>   Option constant Data type Description     <b><code>XML_OPTION_CASE_FOLDING</code></b> bool  Controls whether case-folding is enabled for this XML parser. Enabled by default.    <b><code>XML_OPTION_SKIP_TAGSTART</code></b> integer  Specify how many characters should be skipped in the beginning of a tag name.    <b><code>XML_OPTION_SKIP_WHITE</code></b> bool  Whether to skip values consisting of whitespace characters.    <b><code>XML_OPTION_TARGET_ENCODING</code></b> string  Sets which target encoding to use in this XML parser.By default, it is set to the same as the source encoding used by <code>xml_parser_create()</code>. Supported target encodings are <code>ISO-8859-1</code>, <code>US-ASCII</code> and <code>UTF-8</code>.
	 * @param string|int|bool $value <p>The option's new value.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.xml-parser-set-option.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_parser_set_option(\XMLParser $parser, int $option, string|int|bool $value): bool {}

	/**
	 * Set up character data handler
	 * <p>Sets the character data handler function for the XML parser <code>parser</code>.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<code>XMLParser</code> <code>$parser</code>, <code>string</code> <code>$data</code>): void   <code>parser</code>   The XML parser calling the handler.    <code>data</code>   Character data as a string.    <p>Character data handler is called for every piece of a text in the XML document. It can be called multiple times inside each fragment (e.g. for non-ASCII strings).</p>
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-character-data-handler.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_character_data_handler(\XMLParser $parser, callable $handler): true {}

	/**
	 * Set up default handler
	 * <p>Sets the default handler function for the XML parser <code>parser</code>.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<code>XMLParser</code> <code>$parser</code>, <code>string</code> <code>$data</code>): void   <code>parser</code>   The XML parser calling the handler.    <code>data</code>    <code>data</code> contains the character data. This may be the XML declaration, document type declaration, entities or other data for which no other handler exists.
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-default-handler.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_default_handler(\XMLParser $parser, callable $handler): true {}

	/**
	 * Set up start and end element handlers
	 * <p>Sets the element handler functions for the XML <code>parser</code>.</p><p><code>start_handler</code> is called when a new XML element is opened. <code>end_handler</code> is called when an XML element is closed.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $start_handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> start_element_handler(<code>XMLParser</code> <code>$parser</code>, <code>string</code> <code>$name</code>, <code>array</code> <code>$attributes</code>): void   <code>parser</code>   The XML parser calling the handler.    <code>name</code>   Contains the name of the element for which this handler is called. If case-folding is in effect for this parser, the element name will be in uppercase letters.    <code>attributes</code>   An associative array with the element's attributes. The array is empty if the element has no attributes. The keys of this array are the attribute names, the values are the attribute values. Attribute names are case-folded on the same criteria as element names. Attribute values are <i>not</i> case-folded.   The order in which <code>attributes</code> is traversed is identical to the order in which the attributes were declared.
	 * @param callable $end_handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> end_element_handler(<code>XMLParser</code> <code>$parser</code>, <code>string</code> <code>$name</code>): void   <code>parser</code>   The XML parser calling the handler.    <code>name</code>   Contains the name of the element for which this handler is called. If case-folding is in effect for this parser, the element name will be in uppercase letters.
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-element-handler.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_element_handler(\XMLParser $parser, callable $start_handler, callable $end_handler): true {}

	/**
	 * Set up end namespace declaration handler
	 * <p>Set a handler to be called when leaving the scope of a namespace declaration. This will be called, for each namespace declaration, after the handler for the end tag of the element in which the namespace was declared.</p><p>This event is not supported under libXML, so a registered handler wouldn't be called.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<code>XMLParser</code> <code>$parser</code>, <code>string</code>|false <code>$prefix</code>)   <code>parser</code>   The XML parser calling the handler.    <code>prefix</code>   The prefix is a string used to reference the namespace within an XML object. <b><code>false</code></b> if no prefix exists.
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-end-namespace-decl-handler.php
	 * @see xml_set_start_namespace_decl_handler()
	 * @since PHP 4 >= 4.0.5, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_end_namespace_decl_handler(\XMLParser $parser, callable $handler): true {}

	/**
	 * Set up external entity reference handler
	 * <p>Sets the external entity reference handler function for the XML parser <code>parser</code>.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>XMLParser</code> <code>$parser</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code> <code>$open_entity_names</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code>|false <code>$base</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code> <code>$system_id</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code>|false <code>$public_id</code><br>): <code>bool</code>   <code>parser</code>   The XML parser calling the handler.    <code>open_entity_names</code>   A space-separated list of the names of the entities that are open for the parse of this entity (including the name of the referenced entity).    <code>base</code>   This is the base for resolving the system identifier (<code>system_id</code>) of the external entity.    <code>system_id</code>   The system identifier as specified in the entity declaration.    <code>public_id</code>   The public identifier as specified in the entity declaration, or an empty string if none was specified; the whitespace in the public identifier will have been normalized as required by the XML spec.    <p>The handler should return <b><code>true</code></b> if the entity was handled, <b><code>false</code></b> otherwise. When returning <b><code>false</code></b> the XML parser will stop parsing and <code>xml_get_error_code()</code> will return <b><code>XML_ERROR_EXTERNAL_ENTITY_HANDLING</code></b>.</p>
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-external-entity-ref-handler.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_external_entity_ref_handler(\XMLParser $parser, callable $handler): true {}

	/**
	 * Set up notation declaration handler
	 * <p>Sets the notation declaration handler function for the XML parser <code>parser</code>.</p><p>A notation declaration is part of the document's DTD and has the following format:</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>XMLParser</code> <code>$parser</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code> <code>$notation_name</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code>|false <code>$base</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code> <code>$system_id</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code>|false <code>$public_id</code><br>): void   <code>parser</code>   The XML parser calling the handler.    <code>notation_name</code>   This is the notation's name, as per the notation format described above.    <code>base</code>    This is the base for resolving the system identifier (<code>system_id</code>) of the notation declaration.    <code>system_id</code>   System identifier of the external notation declaration.    <code>public_id</code>    Public identifier of the external notation declaration.
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-notation-decl-handler.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_notation_decl_handler(\XMLParser $parser, callable $handler): true {}

	/**
	 * Use XML Parser within an object
	 * <p>This function allows to use <code>parser</code> inside <code>object</code>. All callback functions could be set with <code>xml_set_element_handler()</code> etc and assumed to be methods of <code>object</code>.</p>
	 * @param \XMLParser $parser <p>A reference to the XML parser to use inside the object.</p>
	 * @param object $object <p>The object where to use the XML parser.</p>
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-object.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_object(\XMLParser $parser, object $object): true {}

	/**
	 * Set up processing instruction (PI) handler
	 * <p>Sets the processing instruction (PI) handler function for the XML parser <code>parser</code>.</p><p>A processing instruction has the following format:</p><p>PHP code is delimited by the <code>&lt;&#63;php</code> processing instruction. As such it is possible to have PHP code within an XML document. However, the PI end tag (<code>&#63;&gt;</code>) must not be part of the data. If a PI end tag exists as part of the embedded PHP code, the rest of the PHP code and the "real" PI end tag, will be treated as character data.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<code>XMLParser</code> <code>$parser</code>, <code>string</code> <code>$target</code>, <code>string</code> <code>$data</code>): void   <code>parser</code>   The XML parser calling the handler.    <code>target</code>   The processing instruction target.    <code>data</code>   The processing instruction data.
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-processing-instruction-handler.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_processing_instruction_handler(\XMLParser $parser, callable $handler): true {}

	/**
	 * Set up start namespace declaration handler
	 * <p>Set a handler to be called when a namespace is declared. Namespace declarations occur inside start tags. But the namespace declaration start handler is called before the start tag handler for each namespace declared in that start tag.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<code>XMLParser</code> <code>$parser</code>, <code>string</code>|false <code>$prefix</code>, <code>string</code> <code>$uri</code>): void   <code>parser</code>   The XML parser calling the handler.    <code>prefix</code>   The prefix is a string used to reference the namespace within an XML object. <b><code>false</code></b> if no prefix exists.    <code>uri</code>   Uniform Resource Identifier (URI) of namespace.
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-start-namespace-decl-handler.php
	 * @see xml_set_end_namespace_decl_handler()
	 * @since PHP 4 >= 4.0.5, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_start_namespace_decl_handler(\XMLParser $parser, callable $handler): true {}

	/**
	 * Set up unparsed entity declaration handler
	 * <p>Sets the unparsed entity declaration handler function for the XML parser <code>parser</code>.</p><p>The <code>handler</code> will be called if the XML parser encounters an external entity declaration with an NDATA declaration, like the following:</p><p>See &#xBB;&#xA0;section 4.2.2 of the XML 1.0 spec for the definition of notation declared external entities.</p>
	 * @param \XMLParser $parser <p>The XML parser.</p>
	 * @param callable $handler <p>If <b><code>null</code></b> or an empty string is passed, the handler is reset to its default state.</p> <p>If <code>handler</code> is a <code>callable</code>, the callable is set as the handler.</p> <p>If <code>handler</code> is a <code>string</code>, it can be the name of a method of an object set with <code>xml_set_object()</code>.</p> <p>The signature of the handler must be:</p> handler(<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>XMLParser</code> <code>$parser</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code> <code>$entity_name</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code>|false <code>$base</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code> <code>$system_id</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code>|false <code>$public_id</code>,<br>&#xA0;&#xA0;&#xA0;&#xA0;<code>string</code>|false <code>$notation_name</code><br>): void   <code>parser</code>   The XML parser calling the handler.    <code>entity_name</code>   The name of the entity that is about to be defined.    <code>base</code>   This is the base for resolving the system identifier (<code>systemId</code>) of the external entity.    <code>system_id</code>   System identifier for the external entity.    <code>public_id</code>   Public identifier for the external entity.    <code>notation_name</code>   Name of the notation of this entity (see <code>xml_set_notation_decl_handler()</code>).
	 * @return true <p>Always returns <b><code>true</code></b>.</p>
	 * @link https://php.net/manual/en/function.xml-set-unparsed-entity-decl-handler.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function xml_set_unparsed_entity_decl_handler(\XMLParser $parser, callable $handler): true {}

	define('XML_ERROR_ASYNC_ENTITY', 13);

	define('XML_ERROR_ATTRIBUTE_EXTERNAL_ENTITY_REF', 16);

	define('XML_ERROR_BAD_CHAR_REF', 14);

	define('XML_ERROR_BINARY_ENTITY_REF', 15);

	define('XML_ERROR_DUPLICATE_ATTRIBUTE', 8);

	define('XML_ERROR_EXTERNAL_ENTITY_HANDLING', 21);

	define('XML_ERROR_INCORRECT_ENCODING', 19);

	define('XML_ERROR_INVALID_TOKEN', 4);

	define('XML_ERROR_JUNK_AFTER_DOC_ELEMENT', 9);

	define('XML_ERROR_MISPLACED_XML_PI', 17);

	define('XML_ERROR_NO_ELEMENTS', 3);

	define('XML_ERROR_NO_MEMORY', 1);

	define('XML_ERROR_NONE', 0);

	define('XML_ERROR_PARAM_ENTITY_REF', 10);

	define('XML_ERROR_PARTIAL_CHAR', 6);

	define('XML_ERROR_RECURSIVE_ENTITY_REF', 12);

	define('XML_ERROR_SYNTAX', 2);

	define('XML_ERROR_TAG_MISMATCH', 7);

	define('XML_ERROR_UNCLOSED_CDATA_SECTION', 20);

	define('XML_ERROR_UNCLOSED_TOKEN', 5);

	define('XML_ERROR_UNDEFINED_ENTITY', 11);

	define('XML_ERROR_UNKNOWN_ENCODING', 18);

	define('XML_OPTION_CASE_FOLDING', 1);

	define('XML_OPTION_SKIP_TAGSTART', 3);

	define('XML_OPTION_SKIP_WHITE', 4);

	define('XML_OPTION_TARGET_ENCODING', 2);

	/**
	 * Holds the SAX implementation method. Can be <code>libxml</code> or <code>expat</code>.
	 */
	define('XML_SAX_IMPL', 'libxml');

}
