<?php

namespace {

	/**
	 * Flush system output buffer
	 * <p>Flushes the system write buffers of PHP and whatever backend PHP is using (CGI, a web server, etc). This attempts to push current output all the way to the browser with a few caveats.</p><p><b>flush()</b> may not be able to override the buffering scheme of your web server and it has no effect on any client-side buffering in the browser. It also doesn't affect PHP's userspace output buffering mechanism. This means <code>ob_flush()</code> should be called before <b>flush()</b> to flush the output buffers if they are in use.</p><p>Several servers, especially on Win32, will still buffer the output from your script until it terminates before transmitting the results to the browser.</p><p>Server modules for Apache like mod_gzip may do buffering of their own that will cause <b>flush()</b> to not result in data being sent immediately to the client.</p><p>Even the browser may buffer its input before displaying it. Netscape, for example, buffers text until it receives an end-of-line or the beginning of a tag, and it won't render tables until the &lt;/table&gt; tag of the outermost table is seen.</p><p>Some versions of Microsoft Internet Explorer will only start to display the page after they have received 256 bytes of output, so you may need to send extra whitespace before flushing to get those browsers to display the page.</p>
	 * @return void <p>No value is returned.</p>
	 * @link https://php.net/manual/en/function.flush.php
	 * @see ob_flush(), ob_clean(), ob_end_flush(), ob_end_clean()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function flush(): void {}

	/**
	 * Clean (erase) the contents of the active output buffer
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_CLEAN</code></b> flag), discards it's return value and cleans (erases) the contents of the active output buffer.</p><p>This function does not turn off the active output buffer like <code>ob_end_clean()</code> or <code>ob_get_clean()</code> does.</p><p><b>ob_clean()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-clean.php
	 * @see ob_start(), ob_get_contents(), ob_end_clean(), ob_get_clean(), ob_flush()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_clean(): bool {}

	/**
	 * Clean (erase) the contents of the active output buffer and turn it off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_CLEAN</code></b> and <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flags), discards it's return value, discards the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_end_clean()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_end_clean()</b> will discard the contents of the active output buffer even if it was started without the <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-end-clean.php
	 * @see ob_start(), ob_get_contents(), ob_clean(), ob_get_clean(), ob_end_flush()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_end_clean(): bool {}

	/**
	 * Flush (send) the return value of the active output handler and turn the active output buffer off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flag), flushes (sends) it's return value, discards the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_end_flush()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_end_flush()</b> will flush (send) the return value of the output handler even if the active output buffer was started without the <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-end-flush.php
	 * @see ob_start(), ob_get_contents(), ob_flush(), ob_get_flush(), ob_end_clean()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_end_flush(): bool {}

	/**
	 * Flush (send) the return value of the active output handler
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_FLUSH</code></b> flag), flushes (sends) it's return value and discards the contents of the active output buffer.</p><p>This function does not turn off the active output buffer like <code>ob_end_flush()</code> or <code>ob_get_flush()</code> does.</p><p><b>ob_flush()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> flag.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-flush.php
	 * @see ob_start(), ob_get_contents(), ob_end_flush(), ob_get_flush(), ob_clean()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_flush(): bool {}

	/**
	 * Get the contents of the active output buffer and turn it off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_CLEAN</code></b> and <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flags), discards it's return value, returns the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_get_clean()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_get_clean()</b> will discard the contents of the active output buffer even if it was started without the <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> flag.</p>
	 * @return string|false <p>Returns the contents of the active output buffer on success or <b><code>false</code></b> on failure.</p><b>Caution</b> <p><b>ob_get_clean()</b> will return false but will not generate an <b><code>E_NOTICE</code></b> if there is no active output buffer.</p>
	 * @link https://php.net/manual/en/function.ob-get-clean.php
	 * @see ob_start(), ob_get_contents(), ob_clean(), ob_end_clean(), ob_get_flush()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_clean(): string|false {}

	/**
	 * Return the contents of the output buffer
	 * <p>Gets the contents of the output buffer without clearing it.</p>
	 * @return string|false <p>This will return the contents of the output buffer or <b><code>false</code></b>, if output buffering isn't active.</p>
	 * @link https://php.net/manual/en/function.ob-get-contents.php
	 * @see ob_start(), ob_get_length()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_contents(): string|false {}

	/**
	 * Flush (send) the return value of the active output handler, return the contents of the active output buffer and turn it off
	 * <p>This function calls the output handler (with the <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b> flag), flushes (sends) it's return value, returns the contents of the active output buffer and turns off the active output buffer.</p><p><b>ob_get_flush()</b> will fail without an active output buffer started with the <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b> flag.</p><p><b>ob_get_flush()</b> will flush (send) the return value of the output handler even if the active output buffer was started without the <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> flag.</p>
	 * @return string|false <p>Returns the contents of the active output buffer on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-get-flush.php
	 * @see ob_start(), ob_get_contents(), ob_flush(), ob_end_flush(), ob_get_clean()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_flush(): string|false {}

	/**
	 * Return the length of the output buffer
	 * <p>This will return the length of the contents in the output buffer, in bytes.</p>
	 * @return int|false <p>Returns the length of the output buffer contents, in bytes, or <b><code>false</code></b> if no buffering is active.</p>
	 * @link https://php.net/manual/en/function.ob-get-length.php
	 * @see ob_start(), ob_get_contents()
	 * @since PHP 4 >= 4.0.2, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_length(): int|false {}

	/**
	 * Return the nesting level of the output buffering mechanism
	 * <p>Returns the nesting level of the output buffering mechanism.</p>
	 * @return int <p>Returns the level of nested output buffering handlers or zero if output buffering is not active.</p><b>Caution</b> <p>The value for identical levels between <b>ob_get_level()</b> and <code>ob_get_status()</code> is off by one. For <b>ob_get_level()</b> the first level is <code>1</code>. Whereas for <code>ob_get_status()</code> the first level is <code>0</code>.</p>
	 * @link https://php.net/manual/en/function.ob-get-level.php
	 * @see ob_start(), ob_get_status(), ob_get_contents()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_level(): int {}

	/**
	 * Get status of output buffers
	 * <p><b>ob_get_status()</b> returns status information on either the top level output buffer or all active output buffer levels if <code>full_status</code> is set to <b><code>true</code></b>.</p>
	 * @param bool $full_status <p><b><code>true</code></b> to return all active output buffer levels. If <b><code>false</code></b> or not set, only the top level output buffer is returned.</p>
	 * @return array <p>If <code>full_status</code> is omitted or <b><code>false</code></b> a simple array holding status information on the active output level is returned.</p><p>If <code>full_status</code> is <b><code>true</code></b> an array with one element for each active output buffer level is returned. The output level is used as key of the top level array and each array element itself is another array holding status information on one active output level.</p><p>An empty array is returned if output buffering is not turned on.</p> <b><b>ob_get_status()</b> return array elements</b> KeyValue  name  Name of active output handler (see the return values of <code>ob_list_handlers()</code> for details)    type  <code>0</code> (internal handler) or <code>1</code> (user supplied handler)    flags  Bitmask of flags set by <code>ob_start()</code>, the type of output handler (see above) and the status of the buffering process ( <b><code>PHP_OUTPUT_HANDLER_&#42;</code></b>  constants). If the handler successfully processed the buffer and did not return <b><code>false</code></b>, <b><code>PHP_OUTPUT_HANDLER_STARTED</code></b> and <b><code>PHP_OUTPUT_HANDLER_PROCESSED</code></b> will be set. If the handler failed while processing the buffer or returned <b><code>false</code></b>, <b><code>PHP_OUTPUT_HANDLER_STARTED</code></b> and <b><code>PHP_OUTPUT_HANDLER_DISABLED</code></b> will be set.    level  Output nesting level (zero based). Note that the value returned for the same level by <code>ob_get_level()</code> is off by one. The first level is <code>0</code> for <b>ob_get_status()</b>, and <code>1</code> for <code>ob_get_level()</code>.    chunk_size  Chunk size in bytes. Set by <code>ob_start()</code> or output_buffering is enabled and its value is set to a positive integer    buffer_size  Output buffer size in bytes    buffer_used  Size of data in output buffer in bytes (the same as the integer return value of <code>ob_get_length()</code>)
	 * @link https://php.net/manual/en/function.ob-get-status.php
	 * @see ob_get_level(), ob_list_handlers(), ob_get_length(), ob_start()
	 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_get_status(bool $full_status = false): array {}

	/**
	 * Turn implicit flush on/off
	 * <p><b>ob_implicit_flush()</b> will turn implicit flushing on or off. Implicit flushing will result in a flush operation after every output call, so that explicit calls to <code>flush()</code> will no longer be needed.</p>
	 * @param bool $enable <p><b><code>true</code></b> to turn implicit flushing on, <b><code>false</code></b> otherwise.</p>
	 * @return void <p>No value is returned.</p>
	 * @link https://php.net/manual/en/function.ob-implicit-flush.php
	 * @see flush(), ob_start(), ob_end_flush()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_implicit_flush(bool $enable = true): void {}

	/**
	 * List all output handlers in use
	 * <p>Lists all output handlers in use.</p>
	 * @return array <p>This will return an array with the output handlers in use (if any).</p><p>If output_buffering is enabled and no output_handler is set, or no callback or <b><code>null</code></b> was passed to <code>ob_start()</code>, <code>"default output handler"</code> is returned. Enabling output_buffering and setting an output_handler is equivalent to passing an internal (built-in) function to <code>ob_start()</code>.</p><p>If a <code>callable</code> was passed to <code>ob_start()</code>, the fully qualified name of the <code>callable</code> is returned. If the <code>callable</code> is an object implementing __invoke(), the fully qualified name of the object's __invoke() method is returned. If the <code>callable</code> is a <code>Closure</code>, <code>"Closure::__invoke"</code> is returned.</p>
	 * @link https://php.net/manual/en/function.ob-list-handlers.php
	 * @see ob_end_clean(), ob_end_flush(), ob_get_flush(), ob_start()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function ob_list_handlers(): array {}

	/**
	 * Turn on output buffering
	 * <p>This function will turn output buffering on. While output buffering is active no output is sent from the script (other than headers), instead the output is stored in an internal buffer.</p><p>The contents of this internal buffer may be copied into a string variable using <code>ob_get_contents()</code>. To output what is stored in the internal buffer, use <code>ob_end_flush()</code>. Alternatively, <code>ob_end_clean()</code> will silently discard the buffer contents.</p><p>Some web servers (e.g. Apache) change the working directory of a script when calling the callback function. You can change it back by e.g. <code>chdir(dirname($_SERVER['SCRIPT_FILENAME']))</code> in the callback function.</p><p>Output buffers are stackable, that is, you may call <b>ob_start()</b> while another <b>ob_start()</b> is active. Just make sure that you call <code>ob_end_flush()</code> the appropriate number of times. If multiple output callback functions are active, output is being filtered sequentially through each of them in nesting order.</p><p>If output buffering is still active when the script ends, PHP outputs the contents automatically.</p>
	 * @param callable $callback <p>An optional <code>callback</code> function may be specified. This function takes a string as a parameter and should return a string. The function will be called when the output buffer is flushed (sent) or cleaned (with <code>ob_flush()</code>, <code>ob_clean()</code> or similar function) or when the output buffer is flushed to the browser at the end of the request. When <code>callback</code> is called, it will receive the contents of the output buffer as its parameter and is expected to return a new output buffer as a result, which will be sent to the browser. If the <code>callback</code> is not a callable function, this function will return <b><code>false</code></b>. This is the callback signature:</p> <p></p> handler(<code>string</code> <code>$buffer</code>, <code>int</code> <code>$phase</code> = &#63;): <code>string</code>   <code>buffer</code>   Contents of the output buffer.    <code>phase</code>   Bitmask of <b><code>PHP_OUTPUT_HANDLER_&#42;</code></b> constants.    <p>If <code>callback</code> returns <b><code>false</code></b> original input is sent to the browser.</p> <p>The <code>callback</code> parameter may be bypassed by passing a <b><code>null</code></b> value.</p> <p><code>ob_end_clean()</code>, <code>ob_end_flush()</code>, <code>ob_clean()</code>, <code>ob_flush()</code> and <b>ob_start()</b> may not be called from a callback function. If you call them from callback function, the behavior is undefined. If you would like to delete the contents of a buffer, return "" (a null string) from callback function. You can't even call functions using the output buffering functions like <code>print_r($expression, true)</code> or <code>highlight_file($filename, true)</code> from a callback function.</p> <p><b>Note</b>:</p><p><code>ob_gzhandler()</code> function exists to facilitate sending gz-encoded data to web browsers that support compressed web pages. <code>ob_gzhandler()</code> determines what type of content encoding the browser will accept and will return its output accordingly.</p>
	 * @param int $chunk_size <p>If the optional parameter <code>chunk_size</code> is passed, the buffer will be flushed after any output call which causes the buffer's length to equal or exceed <code>chunk_size</code>. The default value <code>0</code> means that the output function will only be called when the output buffer is closed.</p>
	 * @param int $flags <p>The <code>flags</code> parameter is a bitmask that controls the operations that can be performed on the output buffer. The default is to allow output buffers to be cleaned, flushed and removed, which can be set explicitly via <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> | <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> | <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b>, or <b><code>PHP_OUTPUT_HANDLER_STDFLAGS</code></b> as shorthand.</p> <p>Each flag controls access to a set of functions, as described below:</p>   Constant Functions     <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b>  <code>ob_clean()</code>, <code>ob_end_clean()</code>, and <code>ob_get_clean()</code>.    <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b>  <code>ob_end_flush()</code>, <code>ob_flush()</code>, and <code>ob_get_flush()</code>.    <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b>  <code>ob_end_clean()</code>, <code>ob_end_flush()</code>, and <code>ob_get_flush()</code>.
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.ob-start.php
	 * @see ob_get_contents(), ob_end_clean(), ob_end_flush(), ob_implicit_flush(), ob_gzhandler(), ob_iconv_handler(), mb_output_handler(), ob_tidyhandler()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function ob_start(callable $callback = null, int $chunk_size = 0, int $flags = PHP_OUTPUT_HANDLER_STDFLAGS): bool {}

	/**
	 * Add URL rewriter values
	 * <p>This function adds another name/value pair to the URL rewrite mechanism. The name and value will be added to URLs (as GET parameter) and forms (as hidden input fields) the same way as the session ID when transparent URL rewriting is enabled with session.use_trans_sid.</p><p>This function's behaviour is controlled by the url_rewriter.tags and url_rewriter.hosts php.ini parameters.</p><p>Note that this function can be successfully called at most once per request.</p><p><b>Note</b>:  Calling this function will implicitly start output buffering if it is not active already. </p>
	 * @param string $name <p>The variable name.</p>
	 * @param string $value <p>The variable value.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.output-add-rewrite-var.php
	 * @see output_reset_rewrite_vars(), ob_flush(), ob_list_handlers()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function output_add_rewrite_var(string $name, string $value): bool {}

	/**
	 * Reset URL rewriter values
	 * <p>This function resets the URL rewriter and removes all rewrite variables previously set by the <code>output_add_rewrite_var()</code> function.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/function.output-reset-rewrite-vars.php
	 * @see output_add_rewrite_var(), ob_flush(), ob_list_handlers()
	 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7, PHP 8
	 */
	function output_reset_rewrite_vars(): bool {}

	/**
	 * <p>Indicates that the output buffer has been cleaned.</p>
	 */
	define('PHP_OUTPUT_HANDLER_CLEAN', 2);

	/**
	 * <p>Controls whether an output buffer created by <code>ob_start()</code> can be cleaned by <code>ob_clean()</code>. This flag does not control the behaviour of <code>ob_end_clean()</code> or <code>ob_get_clean()</code>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_CLEANABLE', 16);

	/**
	 * <p>Indicates that the buffer has been flushed, but output buffering will continue.</p> <p>This is an alias for <b><code>PHP_OUTPUT_HANDLER_WRITE</code></b>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_CONT', 0);

	/**
	 * <p>Indicates that the output handler is disabled. This flag is set when the output handler returns <b><code>false</code></b> or fails while processing the buffer, or it was set prior to calling the output handler.</p>
	 */
	define('PHP_OUTPUT_HANDLER_DISABLED', 8192);

	/**
	 * <p>Indicates that output buffering has ended.</p> <p>This is an alias for <b><code>PHP_OUTPUT_HANDLER_FINAL</code></b>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_END', 8);

	/**
	 * <p>Indicates that this is the final output buffering operation.</p>
	 */
	define('PHP_OUTPUT_HANDLER_FINAL', 8);

	/**
	 * <p>Indicates that the buffer has been flushed.</p>
	 */
	define('PHP_OUTPUT_HANDLER_FLUSH', 4);

	/**
	 * <p>Controls whether an output buffer created by <code>ob_start()</code> can be flushed by <code>ob_flush()</code>. This flag does not control the behaviour of <code>ob_end_flush()</code> or <code>ob_get_flush()</code>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_FLUSHABLE', 32);

	/**
	 * <p>Indicates that the output handler successfully processed the buffer.</p>
	 */
	define('PHP_OUTPUT_HANDLER_PROCESSED', null);

	/**
	 * <p>Controls whether an output buffer created by <code>ob_start()</code> can be removed before the end of the script or when calling <code>ob_end_clean()</code>, <code>ob_end_flush()</code>, <code>ob_get_clean()</code> or <code>ob_get_flush()</code>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_REMOVABLE', 64);

	/**
	 * <p>Indicates that output buffering has begun.</p>
	 */
	define('PHP_OUTPUT_HANDLER_START', 1);

	/**
	 * <p>Indicates that the output handler was called.</p>
	 */
	define('PHP_OUTPUT_HANDLER_STARTED', 4096);

	/**
	 * <p>The default set of output buffer flags; currently equivalent to <b><code>PHP_OUTPUT_HANDLER_CLEANABLE</code></b> | <b><code>PHP_OUTPUT_HANDLER_FLUSHABLE</code></b> | <b><code>PHP_OUTPUT_HANDLER_REMOVABLE</code></b>.</p>
	 */
	define('PHP_OUTPUT_HANDLER_STDFLAGS', 112);

	/**
	 * <p>Indicates that the output buffer is being flushed, and had data to output.</p>
	 */
	define('PHP_OUTPUT_HANDLER_WRITE', 0);

}
