/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.navigation;

import java.awt.Color;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import jdk.jshell.JShell;
import jdk.jshell.MethodSnippet;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.VarSnippet;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellEvent;
import org.netbeans.modules.jshell.env.ShellListener;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.navigation.DropAction;
import org.netbeans.modules.jshell.navigation.OpenAction;
import org.netbeans.modules.jshell.parsing.SnippetRegistry;
import org.netbeans.modules.jshell.support.ShellSession;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;

public class SnippetNodes
extends Children.Keys
implements ShellListener,
Consumer<SnippetEvent> {
    static final String TYPE_COLOR_KEY = "nb.navigator.type.color";
    static final String HIDDEN_COLOR_KEY = "nb.navigator.inherited.color";
    static final Color DEFAULT_TYPE_COLOR = new Color(112, 112, 112);
    static final Color DEFAULT_HIDDEN_COLOR = new Color(125, 105, 74);
    public static final Object KEY_IMPORTS = new String("imports");
    public static final Object KEY_INPUT = new String("input");
    private final JShellEnvironment env;
    private volatile ShellSession session;
    private Color typeColor;
    private Color hiddenColor;
    private final NF factory;
    private static final Map<JShellEnvironment, NF> env2Factories = new HashMap<JShellEnvironment, NF>();
    private JShell state;
    private NR sub;
    private static final DropAction dropAction = new DropAction();

    @NonNull
    private static String getHtmlColor(@NullAllowed Color _c, @NonNull Color defaultColor) {
        Color c = _c == null ? defaultColor : _c;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        StringBuilder result = new StringBuilder();
        result.append("#");
        String rs = Integer.toHexString(r);
        String gs = Integer.toHexString(g);
        String bs = Integer.toHexString(b);
        if (r < 16) {
            result.append('0');
        }
        result.append(rs);
        if (g < 16) {
            result.append('0');
        }
        result.append(gs);
        if (b < 16) {
            result.append('0');
        }
        result.append(bs);
        return result.toString();
    }

    public SnippetNodes(JShellEnvironment env) {
        this.env = env;
        this.factory = new NF();
        this.env.addShellListener((ShellListener)WeakListeners.create(ShellListener.class, (EventListener)this, (Object)env));
        this.update();
        try {
            this.attachTo(env.getShell());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.typeColor = UIManager.getColor(TYPE_COLOR_KEY);
        this.hiddenColor = UIManager.getColor(HIDDEN_COLOR_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        SnippetNodes snippetNodes = this;
        synchronized (snippetNodes) {
            ShellSession session = this.env.getSession();
            if (session == null || session.getShell() == null) {
                return;
            }
            this.session = session;
        }
        SnippetRegistry reg = this.session.getSnippetRegistry();
        Collection<Snippet> snippets = this.session.getSnippetRegistry().getSnippets();
        ArrayList<SnippetHandle> imports = new ArrayList<SnippetHandle>();
        ArrayList<SnippetHandle> keys = new ArrayList<SnippetHandle>();
        block8: for (Snippet s : snippets) {
            Snippet.Kind k = s.kind();
            SnippetHandle hdl = reg.getHandle(s);
            if (hdl == null) continue;
            switch (k) {
                case IMPORT: {
                    imports.add(hdl);
                    continue block8;
                }
                case TYPE_DECL: 
                case METHOD: 
                case VAR: {
                    break;
                }
                case STATEMENT: 
                case EXPRESSION: 
                case ERRONEOUS: {
                    continue block8;
                }
                default: {
                    throw new AssertionError((Object)k.name());
                }
            }
            keys.add(hdl);
        }
        this.setKeys(keys);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof SnippetHandle) {
            return new Node[]{this.createNode((SnippetHandle)key)};
        }
        return null;
    }

    private N createNode(SnippetHandle k) {
        N n = new N(this.env, k);
        this.factory.register(k, n);
        return n;
    }

    @Override
    public void shellCreated(ShellEvent ev) {
        this.update();
    }

    private synchronized void attachTo(JShell shell) {
        if (shell == this.state) {
            return;
        }
        if (this.state != null) {
            this.sub.unsubscribe();
            this.state = null;
        }
        if (shell != null) {
            NR subscription = new NR(this, shell);
            subscription.subscribe();
            this.state = shell;
            this.sub = subscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shellStarted(ShellEvent ev) {
        SnippetNodes snippetNodes = this;
        synchronized (snippetNodes) {
            ShellSession s = ev.getSession();
            if (s == null) {
                return;
            }
        }
        this.update();
        try {
            this.attachTo(ev.getEngine());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.refreshNodeNames();
    }

    @Override
    public void accept(SnippetEvent t) {
        N n;
        SnippetHandle h;
        Snippet snip = t.snippet();
        Snippet.Status stat = t.status();
        if (this.session == null) {
            return;
        }
        if ((stat == Snippet.Status.DROPPED || stat == Snippet.Status.OVERWRITTEN) && (h = this.session.getSnippetRegistry().getHandle(snip)) != null && (n = this.factory.findNode(h)) != null) {
            n.fireDisplayNameChange();
        }
    }

    public Node getNodeFor(SnippetHandle h) {
        Node[] keeAlive = this.getNodes();
        return this.factory.findNode(h);
    }

    private void refreshNodeNames() {
        for (N n : this.factory.getNodes()) {
            n.fireDisplayNameChange();
        }
    }

    @Override
    public void shellStatusChanged(ShellEvent ev) {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shellShutdown(ShellEvent ev) {
        Class<SnippetNodes> clazz = SnippetNodes.class;
        synchronized (SnippetNodes.class) {
            JShellEnvironment e = ev.getEnvironment();
            if (e != null) {
                env2Factories.remove(e);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void shellSettingsChanged(ShellEvent ev) {
    }

    static class NR
    extends WeakReference<SnippetNodes>
    implements Runnable,
    Consumer<SnippetEvent> {
        private JShell.Subscription sub;
        private final Reference<JShell> shellRef;

        public NR(SnippetNodes referent, JShell shell) {
            super(referent, Utilities.activeReferenceQueue());
            this.sub = this.sub;
            this.shellRef = new WeakReference<JShell>(shell);
        }

        void subscribe() {
            this.shellRef.get().onSnippetEvent(this);
        }

        @Override
        public void run() {
            this.unsubscribe();
        }

        synchronized void unsubscribe() {
            JShell s = this.shellRef.get();
            if (this.sub == null || s == null) {
                return;
            }
            s.unsubscribe(this.sub);
        }

        @Override
        public void accept(SnippetEvent t) {
            SnippetNodes n = (SnippetNodes)this.get();
            if (n == null) {
                this.unsubscribe();
            } else {
                n.accept(t);
            }
        }
    }

    static class NF {
        private Set<N> nodes = new WeakSet();
        private Map<SnippetHandle, Reference<N>> handledNodes = new WeakHashMap<SnippetHandle, Reference<N>>();

        NF() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(SnippetHandle h, N n) {
            NF nF = this;
            synchronized (nF) {
                this.nodes.add(n);
                this.handledNodes.put(h, new WeakReference<N>(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public N findNode(SnippetHandle h) {
            NF nF = this;
            synchronized (nF) {
                Reference<N> rN = this.handledNodes.get(h);
                if (rN == null) {
                    return null;
                }
                N n = rN.get();
                if (n == null) {
                    this.handledNodes.remove(h);
                    return null;
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<N> getNodes() {
            NF nF = this;
            synchronized (nF) {
                return new ArrayList<N>(this.nodes);
            }
        }
    }

    class N
    extends AbstractNode {
        private final JShellEnvironment env;
        private final ElementKind nodeKind;
        private final SnippetHandle snipHandle;
        private ImageIcon icon;
        private String htmlDisplayName;
        private OpenAction openAction;

        public N(JShellEnvironment env, SnippetHandle handle) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{env, handle, env, env.getConsoleFile()}));
            this.snipHandle = handle;
            this.env = env;
            Snippet.Kind k = handle.getKind();
            switch (k) {
                case TYPE_DECL: {
                    this.nodeKind = ElementKind.CLASS;
                    break;
                }
                case METHOD: {
                    this.nodeKind = ElementKind.METHOD;
                    break;
                }
                case VAR: {
                    this.nodeKind = ElementKind.FIELD;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Snippet s = handle.getSnippet();
            Object dispName = null;
            switch (s.kind()) {
                case TYPE_DECL: {
                    dispName = handle.text();
                    break;
                }
                case METHOD: {
                    MethodSnippet m = (MethodSnippet)s;
                    dispName = m.name() + "(" + m.parameterTypes() + ")";
                    this.htmlDisplayName = m.name() + "(<font color=\"" + SnippetNodes.getHtmlColor(SnippetNodes.this.typeColor, DEFAULT_TYPE_COLOR) + "\">" + m.parameterTypes() + "</font>)";
                    break;
                }
                case VAR: {
                    VarSnippet v = (VarSnippet)s;
                    dispName = v.name() + " : " + v.typeName();
                    this.htmlDisplayName = v.name() + " : <font color=\"" + SnippetNodes.getHtmlColor(SnippetNodes.this.typeColor, DEFAULT_TYPE_COLOR) + "\">" + v.typeName() + "</font>";
                    dispName = handle.text();
                    break;
                }
                default: {
                    throw new AssertionError((Object)s.kind().name());
                }
            }
            if (this.htmlDisplayName == null) {
                this.htmlDisplayName = dispName;
            }
            this.setDisplayName((String)dispName);
        }

        public Action getPreferredAction() {
            return this.getOpenAction();
        }

        public Action[] getActions(boolean context) {
            return new Action[]{this.getOpenAction(), null, dropAction};
        }

        public void fireDisplayNameChange() {
            super.fireDisplayNameChange(null, null);
        }

        private boolean hasText() {
            return this.snipHandle.getSection() != null;
        }

        private OpenAction getOpenAction() {
            if (this.openAction == null) {
                this.openAction = new OpenAction(OpenAction.createOpener(this.env, this.snipHandle));
            }
            return this.openAction;
        }

        public String getHtmlDisplayName() {
            Object s = this.htmlDisplayName;
            boolean obsolete = this.snipHandle.getState() != this.env.getShell();
            switch (this.snipHandle.getStatus()) {
                case DROPPED: 
                case OVERWRITTEN: 
                case REJECTED: {
                    obsolete = true;
                    break;
                }
            }
            if (!this.hasText()) {
                s = "<font color=\"" + SnippetNodes.getHtmlColor(SnippetNodes.this.hiddenColor, DEFAULT_HIDDEN_COLOR) + "\">" + super.getDisplayName() + "</font>";
            }
            if (obsolete) {
                s = "<s>" + (String)s + "</s>";
            }
            return s;
        }

        public Image getIcon(int type) {
            if (this.nodeKind == null) {
                return super.getIcon(type);
            }
            return ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)this.nodeKind, EnumSet.of(Modifier.PUBLIC, Modifier.STATIC)));
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public Transferable clipboardCut() throws IOException {
            return null;
        }

        public Transferable clipboardCopy() throws IOException {
            return null;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }
    }
}

