/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.shelve.impl;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.impl.Bundle;
import org.netbeans.modules.versioning.shelve.impl.PatchStorage;
import org.netbeans.modules.versioning.shelve.impl.UnshelveChangesAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class ShelveChangesMenu
extends AbstractAction
implements Presenter.Menu {
    public static final String PREF_KEY_SHELVED_PATCHES = "shelvedPatches";

    public JMenuItem getMenuPresenter() {
        JMenu menu = this.createMenu();
        return menu;
    }

    public static List<JComponent> getMenuActions(VCSContext context, Lookup lkp) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        VersioningSystem[] vs = Utils.getOwners(context);
        List<JComponent> shelveActions = ShelveChangesMenu.getShelveActions(vs, lkp);
        menuItems.addAll(shelveActions);
        List<JComponent> unshelveActions = ShelveChangesMenu.getUnshelveActions(vs, context, lkp);
        if (!shelveActions.isEmpty() && !unshelveActions.isEmpty()) {
            menuItems.add(null);
        }
        menuItems.addAll(unshelveActions);
        return menuItems;
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu(this);
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)Bundle.CTL_Menu_ShelveChanges());
        VCSContext ctx = VCSContext.forNodes((Node[])TopComponent.getRegistry().getActivatedNodes());
        for (JComponent item : ShelveChangesMenu.getMenuActions(ctx, null)) {
            if (item == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(item);
        }
        this.enableMenu(menu);
        return menu;
    }

    private static List<JComponent> getShelveActions(VersioningSystem[] vs, Lookup lkp) {
        ArrayList<JComponent> items = new ArrayList<JComponent>();
        if (vs.length == 1) {
            Action action;
            ShelveChangesActionsRegistry.ShelveChangesActionProvider actionProvider = ShelveChangesActionsRegistry.getInstance().getActionProvider(vs[0]);
            if (actionProvider != null && (action = actionProvider.getAction()) != null && action.isEnabled()) {
                if (lkp != null) {
                    action = SystemActionBridge.createAction(action, Actions.cutAmpersand((String)((String)action.getValue("Name"))), lkp);
                }
                JMenuItem item = new JMenuItem();
                Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
                items.add(item);
            }
            for (Action a : Utilities.actionsForPath((String)"Actions/Versioning/ShelveChanges")) {
                if (lkp != null) {
                    a = SystemActionBridge.createAction(a, Actions.cutAmpersand((String)((String)a.getValue("Name"))), lkp);
                }
                JMenuItem item = new JMenuItem();
                Actions.connect((JMenuItem)item, (Action)a, (boolean)false);
                items.add(item);
            }
        }
        return items;
    }

    private static List<JComponent> getUnshelveActions(VersioningSystem[] vs, VCSContext ctx, Lookup lkp) {
        JComponent[] components;
        ShelveChangesActionsRegistry.ShelveChangesActionProvider actionProvider;
        ArrayList<JComponent> items = new ArrayList<JComponent>();
        List<String> list = Utils.getStringList(NbPreferences.forModule(ShelveChangesMenu.class), PREF_KEY_SHELVED_PATCHES);
        Action a = Utils.getAcceleratedAction("Actions/Versioning/UnshelveChanges/org-netbeans-modules-versioning-shelve-impl-UnshelveChangesAction.instance");
        if (a != null && !list.isEmpty()) {
            JMenuItem mItem = new JMenuItem();
            if (lkp != null) {
                a = SystemActionBridge.createAction(a, Actions.cutAmpersand((String)((String)a.getValue("Name"))), lkp);
            }
            Actions.connect((JMenuItem)mItem, (Action)a, (boolean)false);
            items.add(mItem);
        }
        if (!list.isEmpty()) {
            List<PatchStorage.Patch> patches = PatchStorage.getInstance().getPatches();
            int i = 0;
            ListIterator<PatchStorage.Patch> it = patches.listIterator();
            while (it.hasNext() && ++i < 6) {
                PatchStorage.Patch patch = it.next();
                JMenuItem mItem = new JMenuItem();
                Actions.connect((JMenuItem)mItem, (Action)new UnshelveChangesAction(patch.getPatchName()), (boolean)false);
                items.add(mItem);
            }
        }
        if (vs.length == 1 && (actionProvider = ShelveChangesActionsRegistry.getInstance().getActionProvider(vs[0])) != null && (components = actionProvider.getUnshelveActions(ctx, lkp != null)).length > 0) {
            items.add(null);
            items.addAll(Arrays.asList(components));
        }
        return items;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void enableMenu(JMenu menu) {
        boolean enabled = false;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isEnabled()) continue;
            enabled = true;
            break;
        }
        menu.setEnabled(enabled);
    }
}

