/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.ListVariable;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class PHP73UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP73UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP73UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_73);
    }

    private static final class PHP73VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.73";

        private PHP73VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP73VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP73VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final List<ASTNode> nodes = new ArrayList<ASTNode>();
        private final FileObject fileObject;
        private boolean isInListVariable = false;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            this.checkFunctionCallTrailingCommas();
            this.checkFlexibleHeredocAndNowdoc();
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.nodes.add(node);
            super.visit(node);
        }

        @Override
        public void visit(FunctionInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.nodes.add(node);
            super.visit(node);
        }

        @Override
        public void visit(ListVariable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkListReferenceAssignment(node.getElements());
            this.isInListVariable = true;
            super.visit(node);
            this.isInListVariable = false;
        }

        @Override
        public void visit(ArrayCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.isInListVariable) {
                this.checkListReferenceAssignment(node.getElements());
            }
        }

        private void checkFunctionCallTrailingCommas() {
            if (!this.nodes.isEmpty()) {
                BaseDocument document = GsfUtilities.getDocument((FileObject)this.fileObject, (boolean)true);
                if (document == null) {
                    return;
                }
                document.readLock();
                try {
                    TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)document, 0);
                    if (ts == null) {
                        return;
                    }
                    this.checkFunctionCallTrailingCommas(ts);
                }
                finally {
                    document.readUnlock();
                    this.nodes.clear();
                }
            }
        }

        private void checkFunctionCallTrailingCommas(TokenSequence<PHPTokenId> ts) {
            for (ASTNode node : this.nodes) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                Token<? extends PHPTokenId> token = this.findPreviousToken(ts, node);
                List<Object> parameters = Collections.emptyList();
                if (token != null && token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)",")) {
                    if (node instanceof FunctionInvocation) {
                        parameters = ((FunctionInvocation)node).getParameters();
                    } else if (node instanceof ClassInstanceCreation) {
                        parameters = ((ClassInstanceCreation)node).ctorParams();
                    }
                }
                if (parameters.isEmpty()) continue;
                this.createError((ASTNode)parameters.get(parameters.size() - 1));
            }
        }

        @CheckForNull
        private Token<? extends PHPTokenId> findPreviousToken(TokenSequence<PHPTokenId> ts, ASTNode node) {
            ts.move(node.getEndOffset());
            if (!ts.movePrevious()) {
                return null;
            }
            if (TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)")") && !ts.movePrevious()) {
                return null;
            }
            return LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE));
        }

        private void checkListReferenceAssignment(List<ArrayElement> elements) {
            elements.forEach(element -> {
                Expression value = element.getValue();
                if (value instanceof Reference) {
                    this.createError(value);
                }
            });
        }

        private void checkFlexibleHeredocAndNowdoc() {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            BaseDocument document = GsfUtilities.getDocument((FileObject)this.fileObject, (boolean)true);
            if (document == null) {
                return;
            }
            document.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)document, document.getLength());
                if (ts == null) {
                    return;
                }
                ts.move(document.getLength());
                this.checkHeredocNowdocIndentationAndNewline(ts);
            }
            finally {
                document.readUnlock();
            }
        }

        private void checkHeredocNowdocIndentationAndNewline(TokenSequence<PHPTokenId> ts) {
            Token<? extends PHPTokenId> endTag;
            List<PHPTokenId> lookforEndTokens = Arrays.asList(PHPTokenId.PHP_HEREDOC_TAG_END, PHPTokenId.PHP_NOWDOC_TAG_END);
            while (ts.movePrevious() && (endTag = LexUtilities.findPreviousToken(ts, lookforEndTokens)) != null) {
                Token newLine;
                if (endTag.id() != PHPTokenId.PHP_HEREDOC_TAG_END && endTag.id() != PHPTokenId.PHP_NOWDOC_TAG_END) continue;
                String endId = endTag.text().toString();
                int offset = ts.offset();
                if (endId.contains(" ") || endId.contains("\t")) {
                    this.createError(offset, offset + endId.length());
                }
                if (ts.moveNext() && (newLine = ts.token()) != null && !TokenUtilities.startsWith((CharSequence)newLine.text(), (CharSequence)"\r") && !TokenUtilities.startsWith((CharSequence)newLine.text(), (CharSequence)"\n") && !TokenUtilities.textEquals((CharSequence)newLine.text(), (CharSequence)";")) {
                    this.createError(ts.offset(), ts.offset() + newLine.length());
                }
                ts.move(offset);
            }
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP73VersionError(this.fileObject, startOffset, endOffset));
        }
    }
}

