/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.FormatToken;
import org.netbeans.modules.php.editor.indent.TokenFormatter;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTErrorExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.AnonymousObjectVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CaseDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.CastExpression;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.DeclareStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FinallyClause;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ListVariable;
import org.netbeans.modules.php.editor.parser.astnodes.MatchArm;
import org.netbeans.modules.php.editor.parser.astnodes.MatchExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamedArgument;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TraitConflictResolutionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitMethodAliasDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Exceptions;

public class FormatVisitor
extends DefaultVisitor {
    private static final Logger LOGGER = Logger.getLogger(FormatVisitor.class.getName());
    private final BaseDocument document;
    private final List<FormatToken> formatTokens;
    private final TokenSequence<PHPTokenId> ts;
    private final LinkedList<ASTNode> path;
    private final TokenFormatter.DocumentOptions options;
    private final ArrayDeque<GroupAlignmentTokenHolder> groupAlignmentTokenHolders;
    private final int caretOffset;
    private final int startOffset;
    private final int endOffset;
    private boolean includeWSBeforePHPDoc;
    private boolean isCurly;
    private boolean isMethodInvocationShifted;
    private boolean isFirstUseStatementPart;
    private boolean isFirstUseTraitStatementPart;
    private boolean isAttributeCloseBracket;
    private int inArrayBalance;
    private UseStatement lastUseStatement;
    private int lastIndex = -1;

    public FormatVisitor(BaseDocument document, TokenFormatter.DocumentOptions documentOptions, int caretOffset, int startOffset, int endOffset) {
        this.document = document;
        this.ts = LexUtilities.getPHPTokenSequence((Document)document, 0);
        this.path = new LinkedList();
        this.options = documentOptions;
        this.includeWSBeforePHPDoc = true;
        this.formatTokens = new ArrayList<FormatToken>(this.ts == null ? 1 : this.ts.tokenCount() * 2);
        this.caretOffset = caretOffset;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.formatTokens.add(new FormatToken.InitToken());
        this.isMethodInvocationShifted = false;
        this.groupAlignmentTokenHolders = new ArrayDeque();
        this.inArrayBalance = 0;
    }

    public List<FormatToken> getFormatTokens() {
        return this.formatTokens;
    }

    @Override
    public void scan(ASTNode node) {
        if (node == null) {
            return;
        }
        ArrayList<FormatToken> beforeTokens = new ArrayList<FormatToken>(30);
        int indexBeforeLastComment = -1;
        while (this.moveNext() && this.ts.offset() < node.getStartOffset() && this.lastIndex < this.ts.index() && (this.ts.offset() + this.ts.token().length() <= node.getStartOffset() || this.ts.token().id() == PHPTokenId.PHP_CLOSETAG)) {
            if (this.ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE && this.path.size() > 1 && this.path.get(1) instanceof NamespaceDeclaration) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OTHER_RIGHT_BRACE, this.ts.offset()));
            }
            this.addFormatToken(beforeTokens);
            if (this.ts.token().id() != PHPTokenId.PHPDOC_COMMENT_START && (this.ts.token().id() != PHPTokenId.PHP_LINE_COMMENT || !TokenUtilities.textEquals((CharSequence)"//", (CharSequence)this.ts.token().text()) || indexBeforeLastComment != -1)) continue;
            if (this.ts.movePrevious() && this.ts.token().id() == PHPTokenId.WHITESPACE) {
                if (this.countOfNewLines(this.ts.token().text()) > 0) {
                    indexBeforeLastComment = beforeTokens.size() - 1;
                } else {
                    if (this.ts.movePrevious() && this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                        indexBeforeLastComment = beforeTokens.size() - 1;
                    }
                    this.ts.moveNext();
                }
            }
            this.ts.moveNext();
        }
        this.includeWSBeforePHPDoc = true;
        if (indexBeforeLastComment >= 0) {
            int i;
            for (i = 0; i < indexBeforeLastComment; ++i) {
                this.formatTokens.add((FormatToken)beforeTokens.get(i));
            }
            if (this.isTypeNode(node)) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS, this.ts.offset()));
                this.includeWSBeforePHPDoc = false;
            } else if (node instanceof FunctionDeclaration || node instanceof MethodDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION, this.ts.offset()));
                this.includeWSBeforePHPDoc = false;
            } else if (this.isPropertyNode(node)) {
                if (this.isPreviousNodeTheSameInBlock(this.path.get(0), (Statement)node)) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_FIELDS, this.ts.offset()));
                } else {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FIELDS, this.ts.offset()));
                }
                this.includeWSBeforePHPDoc = false;
            } else if (node instanceof UseStatement) {
                if (this.isPreviousNodeTheSameInBlock(this.path.get(0), (Statement)node)) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_USE, this.ts.offset()));
                    assert (this.lastUseStatement != null);
                    if (((UseStatement)node).getType() != this.lastUseStatement.getType()) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_USE_TYPES, this.ts.offset()));
                    }
                } else {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE, this.ts.offset()));
                }
                this.includeWSBeforePHPDoc = false;
                this.lastUseStatement = (UseStatement)node;
            } else if (node instanceof UseTraitStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE_TRAIT, this.ts.offset()));
                this.includeWSBeforePHPDoc = false;
            }
            for (i = indexBeforeLastComment; i < beforeTokens.size(); ++i) {
                this.formatTokens.add((FormatToken)beforeTokens.get(i));
            }
        } else {
            this.formatTokens.addAll(beforeTokens);
        }
        this.ts.movePrevious();
        this.path.addFirst(node);
        super.scan(node);
        this.path.removeFirst();
        while (this.moveNext() && this.lastIndex < this.ts.index() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
    }

    private boolean isTypeNode(ASTNode node) {
        return node instanceof ClassDeclaration || node instanceof InterfaceDeclaration || node instanceof TraitDeclaration || node instanceof EnumDeclaration;
    }

    private boolean isPropertyNode(ASTNode node) {
        return node instanceof FieldsDeclaration || node instanceof ConstantDeclaration || node instanceof CaseDeclaration;
    }

    @Override
    public void scan(Iterable<? extends ASTNode> nodes) {
        super.scan(nodes);
    }

    @Override
    public void visit(StaticStatement node) {
        List<Expression> expressions = node.getExpressions();
        for (Expression expression : expressions) {
            this.addAllUntilOffset(expression.getStartOffset());
            if (!this.moveNext() || this.lastIndex >= this.ts.index()) continue;
            this.addFormatToken(this.formatTokens);
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
            this.scan(expression);
            this.formatTokens.add(new FormatToken.IndentToken(expression.getEndOffset(), -1 * this.options.continualIndentSize));
        }
    }

    @Override
    public void visit(AnonymousObjectVariable node) {
        super.visit(node);
        this.addAllUntilOffset(node.getEndOffset());
    }

    @Override
    public void visit(ArrayCreation node) {
        ++this.inArrayBalance;
        int delta = this.options.indentArrayItems - this.options.continualIndentSize;
        boolean isShortArray = false;
        if (!(this.ts.token().id() == PHPTokenId.PHP_ARRAY || this.lastIndex > this.ts.index() || TokenUtilities.textEquals((CharSequence)this.ts.token().text(), (CharSequence)"[") || this.path.size() > 1 && this.path.get(1) instanceof FunctionName)) {
            while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_ARRAY && !TokenUtilities.textEquals((CharSequence)this.ts.token().text(), (CharSequence)"[") && this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
            if (this.formatTokens.get(this.formatTokens.size() - 1).getId() == FormatToken.Kind.WHITESPACE_INDENT || this.path.get(1) instanceof ArrayElement || this.path.get(1) instanceof FormalParameter || this.path.get(1) instanceof MatchArm || this.path.get(1) instanceof CastExpression) {
                delta = this.options.indentArrayItems;
            }
            delta = this.modifyDeltaForEnclosingFunctionInvocations(delta);
            if (this.path.get(1) instanceof FunctionInvocation || this.path.size() > 2 && this.path.get(1) instanceof NamedArgument && this.path.get(2) instanceof FunctionInvocation || this.path.get(1) instanceof AttributeDeclaration || this.path.get(1) instanceof ForEachStatement) {
                int offset;
                int hindex = this.formatTokens.size() - 1;
                int n = offset = this.path.get(1) instanceof NamedArgument ? this.path.get(1).getStartOffset() : node.getStartOffset();
                while (offset <= this.formatTokens.get(hindex).getOffset()) {
                    --hindex;
                }
                while (hindex > 0 && this.formatTokens.get(hindex).getId() != FormatToken.Kind.TEXT && this.formatTokens.get(hindex).getId() != FormatToken.Kind.WHITESPACE_INDENT && this.lastIndex < this.ts.index()) {
                    --hindex;
                }
                if (hindex > 0 && this.formatTokens.get(hindex).getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                    delta = this.options.indentArrayItems;
                }
            }
            if (this.options.wrapMethodCallArgsAfterLeftParen && (this.path.size() > 1 && this.path.get(1) instanceof FunctionInvocation || this.path.size() > 2 && this.path.get(1) instanceof NamedArgument && this.path.get(2) instanceof FunctionInvocation)) {
                int originalOffset = this.ts.offset();
                this.ts.move(node.getEndOffset());
                while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.ts.token().id() == PHPTokenId.PHP_TOKEN) && (this.ts.token().id() != PHPTokenId.PHP_TOKEN || TokenUtilities.textEquals((CharSequence)",", (CharSequence)this.ts.token().text()))) {
                    if (this.ts.token().id() != PHPTokenId.WHITESPACE || this.countOfNewLines(this.ts.token().text()) <= 0) continue;
                    delta = this.options.indentArrayItems;
                    break;
                }
                this.ts.move(originalOffset);
                this.ts.moveNext();
            }
            if (TokenUtilities.textEquals((CharSequence)this.ts.token().text(), (CharSequence)"[")) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                isShortArray = true;
            } else if (this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
        }
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), delta));
        if (isShortArray) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ARRAY_DECL_LEFT_PAREN, this.ts.offset() + this.ts.token().length()));
        }
        this.createGroupAlignment();
        List<ArrayElement> arrayElements = node.getElements();
        if (arrayElements != null && arrayElements.size() > 0) {
            ArrayElement arrayElement = arrayElements.get(0);
            this.addAllUntilOffset(arrayElement.getStartOffset());
            this.scan(arrayElement);
            for (int i = 1; i < arrayElements.size(); ++i) {
                arrayElement = arrayElements.get(i);
                this.addAllUntilOffset(arrayElement.getStartOffset());
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_ARRAY_ELEMENT_LIST, this.ts.offset() + this.ts.token().length()));
                this.scan(arrayElement);
            }
        }
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), -1 * delta));
        this.addAllUntilOffset(node.getEndOffset());
        this.resetGroupAlignment();
        --this.inArrayBalance;
    }

    private int modifyDeltaForEnclosingFunctionInvocations(int delta) {
        int depthInFunctionInvocation = 0;
        for (int i = 1; i < this.path.size(); ++i) {
            if (this.path.get(i) instanceof FunctionInvocation) {
                ++depthInFunctionInvocation;
                continue;
            }
            if (!(this.path.get(i) instanceof NamedArgument)) break;
        }
        return depthInFunctionInvocation > 1 ? delta + -1 * this.options.continualIndentSize * (depthInFunctionInvocation - 1) : delta;
    }

    @Override
    public void visit(ArrayElement node) {
        boolean multilinedArray;
        ArrayCreation arrayCreation = this.getParentArrayCreation();
        boolean bl = multilinedArray = arrayCreation != null ? this.isMultilinedNode(arrayCreation) : false;
        if (node.getKey() != null && node.getValue() != null) {
            this.scan(node.getKey());
            while (this.ts.moveNext() && this.ts.offset() < node.getValue().getStartOffset()) {
                if (FormatVisitor.isKeyValueOperator((Token<PHPTokenId>)this.ts.token())) {
                    this.handleGroupAlignment(node.getKey(), multilinedArray, FormatToken.AssignmentAnchorToken.Type.ARRAY);
                }
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.scan(node.getValue());
        } else {
            super.visit(node);
        }
    }

    private boolean isMultilinedNode(ASTNode node) {
        boolean result = false;
        try {
            result = this.document.getText(node.getStartOffset(), node.getEndOffset() - node.getStartOffset()).contains("\n");
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return result;
    }

    @CheckForNull
    private ArrayCreation getParentArrayCreation() {
        ASTNode parentInPath;
        ArrayCreation result = null;
        for (int i = 0; i < this.path.size() && !((parentInPath = this.path.get(i)) instanceof ListVariable); ++i) {
            if (!(parentInPath instanceof ArrayCreation)) continue;
            result = (ArrayCreation)parentInPath;
            break;
        }
        return result;
    }

    private static boolean isKeyValueOperator(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)"=>", (CharSequence)token.text());
    }

    @Override
    public void visit(ArrowFunctionDeclaration node) {
        this.scan(node.getAttributes());
        this.scan(node.getFormalParameters());
        this.addReturnType(node.getReturnType());
        this.scan(node.getExpression());
    }

    @Override
    public void visit(Assignment node) {
        this.scan(node.getLeftHandSide());
        while (this.ts.moveNext() && this.ts.offset() + this.ts.token().length() < node.getRightHandSide().getStartOffset() && this.ts.token().id() != PHPTokenId.PHP_OPERATOR) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.ts.token().id() == PHPTokenId.PHP_OPERATOR) {
            if (this.path.size() > 1) {
                VariableBase leftHandSide;
                ASTNode parent = this.path.get(1);
                if (parent instanceof StaticStatement) {
                    VariableBase leftHandSide2 = node.getLeftHandSide();
                    if (leftHandSide2 instanceof Variable || leftHandSide2 instanceof FieldAccess) {
                        StaticStatement staticParent = (StaticStatement)parent;
                        this.handleGroupAlignment(leftHandSide2.getEndOffset() - staticParent.getStartOffset());
                    }
                } else if (this.path.size() > 1 && !(parent instanceof ForStatement) && ((leftHandSide = node.getLeftHandSide()) instanceof Variable || leftHandSide instanceof FieldAccess || leftHandSide instanceof StaticFieldAccess)) {
                    this.handleGroupAlignment(leftHandSide);
                }
                this.addFormatToken(this.formatTokens);
            }
        } else {
            this.ts.movePrevious();
        }
        this.scan(node.getRightHandSide());
    }

    @Override
    public void visit(Attribute node) {
        while (this.moveNext() && this.ts.offset() < node.getEndOffset() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            this.addFormatToken(this.formatTokens);
            if (this.ts.token().id() != PHPTokenId.PHP_ATTRIBUTE) continue;
        }
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.indentSize));
        super.visit(node);
        this.addAllUntilOffset(node.getEndOffset() - 1);
        this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset() - 1, -1 * this.options.indentSize));
        this.isAttributeCloseBracket = true;
        this.addAllUntilOffset(node.getEndOffset());
        this.isAttributeCloseBracket = false;
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ATTRIBUTE, node.getEndOffset()));
    }

    @Override
    public void visit(AttributeDeclaration node) {
        this.scan(node.getAttributeName());
        List<Expression> parameters = node.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            this.addAllUntilOffset(parameters.get(0).getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(parameters.get(0).getStartOffset(), this.options.continualIndentSize));
            this.processArguments(parameters);
            this.formatTokens.add(new FormatToken.IndentToken(parameters.get(parameters.size() - 1).getEndOffset(), -1 * this.options.continualIndentSize));
        }
        this.addAllUntilOffset(node.getEndOffset());
    }

    @Override
    public void visit(Block node) {
        this.resetAndCreateGroupAlignment();
        if (this.path.size() > 1 && this.path.get(1) instanceof NamespaceDeclaration && !((NamespaceDeclaration)this.path.get(1)).isBracketed()) {
            super.visit(node);
            return;
        }
        this.isCurly = node.isCurly();
        while (this.ts.moveNext() && node.isCurly() && this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN && this.ts.offset() < node.getStartOffset() && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        ASTNode parent = this.path.get(1);
        if (this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
            if (this.isTypeNode(parent)) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS_LEFT_BRACE, this.ts.offset()));
            } else if (FormatVisitor.isAnonymousClass(parent)) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ANONYMOUS_CLASS_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof IfStatement) {
                IfStatement ifStatement = (IfStatement)parent;
                if (ifStatement.getFalseStatement() != null && ifStatement.getFalseStatement().getStartOffset() <= node.getStartOffset()) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ELSE_LEFT_BRACE, this.ts.offset()));
                } else {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_LEFT_BRACE, this.ts.offset()));
                }
            } else if (parent instanceof ForStatement || parent instanceof ForEachStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FOR_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof WhileStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof DoStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_DO_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof SwitchStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SWITCH_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof TryStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_TRY_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof CatchClause) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof FinallyClause) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FINALLY_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof UseTraitStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE_TRAIT_BODY_LEFT_BRACE, this.ts.offset()));
            } else {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OTHER_LEFT_BRACE, this.ts.offset()));
            }
            this.addFormatToken(this.formatTokens);
            boolean indentationIncluded = false;
            while (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0 || this.lastIndex < this.ts.index() && this.isComment((Token<? extends PHPTokenId>)this.ts.token())) {
                if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT && !indentationIncluded) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.indentSize));
                    indentationIncluded = true;
                }
                this.addFormatToken(this.formatTokens);
            }
            if (!indentationIncluded) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.indentSize));
            }
            if (this.isTypeNode(parent)) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_CLASS_LEFT_BRACE, this.ts.offset()));
            } else if (FormatVisitor.isAnonymousClass(parent)) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ANONYMOUS_CLASS_LEFT_BRACE, this.ts.offset()));
            } else {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_OTHER_LEFT_BRACE, this.ts.offset()));
            }
        }
        this.ts.movePrevious();
        super.visit(node);
        if (node.isCurly() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            while (this.ts.moveNext() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    FormatToken lastToken = this.formatTokens.get(this.formatTokens.size() - 1);
                    if (lastToken.getId() == FormatToken.Kind.WHITESPACE || lastToken.getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                        this.formatTokens.remove(this.formatTokens.size() - 1);
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
                        this.formatTokens.add(lastToken);
                    } else {
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
                    }
                    boolean includeWBC = false;
                    if (this.ts.movePrevious() && (this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN || this.ts.token().id() == PHPTokenId.WHITESPACE)) {
                        if (this.ts.token().id() == PHPTokenId.WHITESPACE) {
                            if (this.ts.movePrevious() && this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                                includeWBC = true;
                            }
                            this.ts.moveNext();
                        }
                        if (this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                            includeWBC = true;
                        }
                    }
                    this.ts.moveNext();
                    if (includeWBC) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_OPEN_CLOSE_BRACES, this.ts.offset()));
                    }
                    if (this.isTypeNode(parent)) {
                        if (this.includeWSBeforePHPDoc) {
                            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS_RIGHT_BRACE, this.ts.offset()));
                        }
                        this.addFormatToken(this.formatTokens);
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_CLASS, this.ts.offset() + this.ts.token().length()));
                        continue;
                    }
                    if (FormatVisitor.isAnonymousClass(parent)) {
                        if (this.includeWSBeforePHPDoc) {
                            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ANONYMOUS_CLASS_RIGHT_BRACE, this.ts.offset()));
                        }
                        this.addFormatToken(this.formatTokens);
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ANONYMOUS_CLASS, this.ts.offset() + this.ts.token().length()));
                        continue;
                    }
                    if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_FUNCTION, this.ts.offset() + this.ts.token().length()));
                        continue;
                    }
                    if (parent instanceof IfStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof ForStatement || parent instanceof ForEachStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FOR_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof WhileStatement || parent instanceof DoStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof SwitchStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SWITCH_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof CatchClause || parent instanceof TryStatement || parent instanceof FinallyClause) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof UseTraitStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE_TRAIT_BODY_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OTHER_RIGHT_BRACE, this.ts.offset()));
                    this.addFormatToken(this.formatTokens);
                    continue;
                }
                FormatToken lastToken = this.formatTokens.get(this.formatTokens.size() - 1);
                if (lastToken.getId() == FormatToken.Kind.TEXT && lastToken.getOffset() >= this.ts.offset() || this.lastIndex >= this.ts.index()) continue;
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
        }
        this.resetGroupAlignment();
    }

    @Override
    public void visit(CastExpression node) {
        super.visit(node);
    }

    @Override
    public void visit(InterfaceDeclaration node) {
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        super.visit(node);
    }

    @Override
    public void visit(ClassDeclaration node) {
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        this.scan(node.getAttributes());
        block5: while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN) {
            switch ((PHPTokenId)this.ts.token().id()) {
                case PHP_CLASS: {
                    if (!node.getModifiers().containsKey((Object)ClassDeclaration.Modifier.NONE)) {
                        FormatToken lastWhitespace = this.formatTokens.remove(this.formatTokens.size() - 1);
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_MODIFIERS, lastWhitespace.getOffset(), lastWhitespace.getOldText()));
                    }
                    this.addFormatToken(this.formatTokens);
                    continue block5;
                }
                case PHP_IMPLEMENTS: {
                    if (node.getInterfaces().isEmpty()) continue block5;
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS, this.ts.offset()));
                    this.ts.movePrevious();
                    this.addListOfNodes(node.getInterfaces(), FormatToken.Kind.WHITESPACE_IN_INTERFACE_LIST);
                    continue block5;
                }
                case PHP_EXTENDS: {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS, this.ts.offset()));
                    this.addFormatToken(this.formatTokens);
                    continue block5;
                }
            }
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        this.scan(node.getName());
        this.scan(node.getSuperClass());
        this.scan(node.getInterfaces());
        this.scan(node.getBody());
    }

    private void addListOfNodes(List<? extends ASTNode> nodes, FormatToken.Kind dividingToken) {
        this.addUnbreakalbeSequence(nodes.get(0), true);
        for (int i = 1; i < nodes.size(); ++i) {
            if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.WHITESPACE) {
                this.addFormatToken(this.formatTokens);
            } else {
                this.ts.movePrevious();
            }
            this.formatTokens.add(new FormatToken(dividingToken, this.ts.offset() + this.ts.token().length()));
            this.addUnbreakalbeSequence(nodes.get(i), false);
        }
    }

    @Override
    public void visit(TraitDeclaration node) {
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        this.scan(node.getAttributes());
        while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        this.scan(node.getName());
        this.scan(node.getBody());
    }

    @Override
    public void visit(EnumDeclaration node) {
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        this.scan(node.getAttributes());
        block3: while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN) {
            switch ((PHPTokenId)this.ts.token().id()) {
                case PHP_IMPLEMENTS: {
                    if (node.getInterfaces().isEmpty()) continue block3;
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS, this.ts.offset()));
                    this.ts.movePrevious();
                    this.addListOfNodes(node.getInterfaces(), FormatToken.Kind.WHITESPACE_IN_INTERFACE_LIST);
                    continue block3;
                }
            }
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        this.scan(node.getName());
        this.scan(node.getBackingType());
        this.scan(node.getInterfaces());
        this.scan(node.getBody());
    }

    @Override
    public void visit(ClassInstanceCreation node) {
        this.scan(node.getAttributes());
        this.scan(node.getClassName());
        if (node.isAnonymous()) {
            block5: while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN) {
                switch ((PHPTokenId)this.ts.token().id()) {
                    case PHP_CLASS: {
                        this.addFormatToken(this.formatTokens);
                        List<Expression> ctorParams = node.ctorParams();
                        if (ctorParams.isEmpty()) continue block5;
                        this.processArguments(ctorParams);
                        continue block5;
                    }
                    case PHP_IMPLEMENTS: {
                        if (node.getInterfaces().size() <= 0) continue block5;
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS, this.ts.offset()));
                        this.ts.movePrevious();
                        this.addListOfNodes(node.getInterfaces(), FormatToken.Kind.WHITESPACE_IN_INTERFACE_LIST);
                        continue block5;
                    }
                    case PHP_EXTENDS: {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        this.scan(node.getSuperClass());
                        continue block5;
                    }
                }
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.scan(node.getBody());
        } else if (node.ctorParams() != null && node.ctorParams().size() > 0) {
            boolean addIndentation;
            boolean bl = addIndentation = !(this.path.get(1) instanceof ReturnStatement) && !(this.path.get(1) instanceof Assignment) && !(this.path.get(1) instanceof ExpressionStatement) || this.path.size() > 2 && this.path.get(1) instanceof ArrayElement && this.path.get(2) instanceof ArrayCreation;
            if (addIndentation) {
                this.formatTokens.add(new FormatToken.IndentToken(node.getClassName().getEndOffset(), this.options.continualIndentSize));
            }
            this.processArguments(node.ctorParams());
            if (addIndentation) {
                this.formatTokens.add(new FormatToken.IndentToken(node.ctorParams().get(node.ctorParams().size() - 1).getEndOffset(), -1 * this.options.continualIndentSize));
            }
            this.addAllUntilOffset(node.getEndOffset());
        } else {
            super.visit(node);
        }
    }

    private void processArguments(List<Expression> arguments) {
        while (this.ts.moveNext() && this.ts.offset() < arguments.get(0).getStartOffset() && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        this.addListOfNodes(arguments, FormatToken.Kind.WHITESPACE_IN_ARGUMENT_LIST);
    }

    @Override
    public void visit(ConditionalExpression node) {
        this.scan(node.getCondition());
        boolean putContinualIndent = true;
        for (ASTNode astNode : this.path) {
            if (!(astNode instanceof Assignment) && !(astNode instanceof ReturnStatement)) continue;
            putContinualIndent = false;
            break;
        }
        if (node.getOperator().isShortened()) {
            this.visitShortenedConditionalExpression(node, putContinualIndent);
        } else {
            this.visitConditionalExpression(node, putContinualIndent);
        }
    }

    private void visitShortenedConditionalExpression(ConditionalExpression node, boolean putContinualIndent) {
        assert (node.getIfTrue() == null) : node.getIfTrue().toString();
        ConditionalExpression.OperatorType operator = node.getOperator();
        switch (operator) {
            case ELVIS: {
                while (this.ts.moveNext() && (this.ts.token().id() != PHPTokenId.PHP_TOKEN || !TokenUtilities.textEquals((CharSequence)"?", (CharSequence)this.ts.token().text())) && this.lastIndex < this.ts.index()) {
                    this.addFormatToken(this.formatTokens);
                }
                assert (this.ts.token().id() == PHPTokenId.PHP_TOKEN) : (PHPTokenId)this.ts.token().id();
                assert (TokenUtilities.textEquals((CharSequence)"?", (CharSequence)this.ts.token().text())) : this.ts.token().text().toString();
                if (putContinualIndent) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
                }
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_TERNARY_OP, this.ts.offset()));
                this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                if (putContinualIndent) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
                }
                StringBuilder sb = new StringBuilder();
                while (this.ts.moveNext()) {
                    if (this.ts.token().id() != PHPTokenId.WHITESPACE) {
                        this.ts.movePrevious();
                        break;
                    }
                    sb.append(this.ts.token().text().toString());
                }
                if (sb.length() > 0) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_SHORT_TERNARY_OP, this.ts.offset(), sb.toString()));
                }
                assert (node.getIfFalse() != null);
                while (this.ts.moveNext() && (this.ts.token().id() != PHPTokenId.PHP_TOKEN || !TokenUtilities.textEquals((CharSequence)":", (CharSequence)this.ts.token().text())) && this.lastIndex < this.ts.index()) {
                    this.addFormatToken(this.formatTokens);
                }
                assert (this.ts.token().id() == PHPTokenId.PHP_TOKEN) : (PHPTokenId)this.ts.token().id();
                assert (TokenUtilities.textEquals((CharSequence)":", (CharSequence)this.ts.token().text())) : this.ts.token().text().toString();
                if (putContinualIndent) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
                }
                this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_TERNARY_OP, this.ts.offset() + this.ts.token().length()));
                this.addAllUntilOffset(node.getIfFalse().getStartOffset());
                this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
                this.scan(node.getIfFalse());
                this.addEndOfUnbreakableSequence(node.getIfFalse().getEndOffset());
                if (!putContinualIndent) break;
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
                break;
            }
            default: {
                while (this.ts.moveNext() && !operator.isOperatorToken((Token<PHPTokenId>)this.ts.token()) && this.lastIndex < this.ts.index()) {
                    this.addFormatToken(this.formatTokens);
                }
                assert (operator.isOperatorToken((Token<PHPTokenId>)this.ts.token())) : (PHPTokenId)this.ts.token().id();
                if (putContinualIndent) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
                }
                this.formatTokens.add(new FormatToken(this.getTokenKindForWhiteSpaceIn(operator), this.ts.offset()));
                this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                this.formatTokens.add(new FormatToken(this.getTokenKindForWhiteSpaceAround(operator), this.ts.offset() + this.ts.token().length()));
                this.addAllUntilOffset(node.getIfFalse().getStartOffset());
                this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
                this.scan(node.getIfFalse());
                this.addEndOfUnbreakableSequence(node.getIfFalse().getEndOffset());
                if (!putContinualIndent) break;
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
            }
        }
    }

    private FormatToken.Kind getTokenKindForWhiteSpaceIn(ConditionalExpression.OperatorType operatorType) {
        FormatToken.Kind kind = FormatToken.Kind.WHITESPACE_IN_TERNARY_OP;
        switch (operatorType) {
            case COALESCE: {
                kind = FormatToken.Kind.WHITESPACE_IN_COALESCING_OP;
                break;
            }
        }
        return kind;
    }

    private FormatToken.Kind getTokenKindForWhiteSpaceAround(ConditionalExpression.OperatorType operatorType) {
        FormatToken.Kind kind = FormatToken.Kind.WHITESPACE_AROUND_TERNARY_OP;
        switch (operatorType) {
            case COALESCE: {
                kind = FormatToken.Kind.WHITESPACE_AROUND_COALESCING_OP;
                break;
            }
        }
        return kind;
    }

    private void visitConditionalExpression(ConditionalExpression node, boolean putContinualIndent) {
        assert (node.getIfTrue() != null);
        while (this.ts.moveNext() && (this.ts.token().id() != PHPTokenId.PHP_TOKEN || !TokenUtilities.textEquals((CharSequence)"?", (CharSequence)this.ts.token().text())) && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        assert (this.ts.token().id() == PHPTokenId.PHP_TOKEN) : (PHPTokenId)this.ts.token().id();
        assert (TokenUtilities.textEquals((CharSequence)"?", (CharSequence)this.ts.token().text())) : this.ts.token().text().toString();
        if (putContinualIndent) {
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
        }
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_TERNARY_OP, this.ts.offset()));
        this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_TERNARY_OP, this.ts.offset() + this.ts.token().length()));
        this.addAllUntilOffset(node.getIfTrue().getStartOffset());
        this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        this.scan(node.getIfTrue());
        this.addEndOfUnbreakableSequence(node.getIfTrue().getEndOffset());
        if (putContinualIndent) {
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        assert (node.getIfFalse() != null);
        while (this.ts.moveNext() && (this.ts.token().id() != PHPTokenId.PHP_TOKEN || !TokenUtilities.textEquals((CharSequence)":", (CharSequence)this.ts.token().text())) && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        assert (this.ts.token().id() == PHPTokenId.PHP_TOKEN) : (PHPTokenId)this.ts.token().id();
        assert (TokenUtilities.textEquals((CharSequence)":", (CharSequence)this.ts.token().text())) : this.ts.token().text().toString();
        if (putContinualIndent) {
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
        }
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_TERNARY_OP, this.ts.offset()));
        this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_TERNARY_OP, this.ts.offset() + this.ts.token().length()));
        this.addAllUntilOffset(node.getIfFalse().getStartOffset());
        this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        this.scan(node.getIfFalse());
        this.addEndOfUnbreakableSequence(node.getIfFalse().getEndOffset());
        if (putContinualIndent) {
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
    }

    @Override
    public void visit(ConstantDeclaration node) {
        if (this.path.size() > 1 && this.path.get(1) instanceof Block) {
            int index;
            Block block = (Block)this.path.get(1);
            List<Statement> statements = block.getStatements();
            for (index = 0; index < statements.size() && statements.get(index).getStartOffset() < node.getStartOffset(); ++index) {
            }
            this.addAllUntilOffset(node.getStartOffset());
            if (this.includeWSBeforePHPDoc && index < statements.size() && index > 0 && statements.get(index - 1) instanceof ConstantDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_FIELDS, this.ts.offset()));
            } else if (this.includeWSBeforePHPDoc) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FIELDS, this.ts.offset()));
            } else {
                this.includeWSBeforePHPDoc = true;
            }
            this.scan(node.getAttributes());
            while (this.ts.moveNext() && !this.isConstTypeToken((Token<PHPTokenId>)this.ts.token())) {
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            FormatToken lastWhitespace = this.formatTokens.remove(this.formatTokens.size() - 1);
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_MODIFIERS, lastWhitespace.getOffset(), lastWhitespace.getOldText()));
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize));
            this.scan(node.getConstType());
            this.scan(node.getNames());
            if (node.getNames().size() == 1) {
                while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_TOKEN && this.ts.token().id() != PHPTokenId.PHP_OPERATOR) {
                    this.addFormatToken(this.formatTokens);
                }
                if (this.ts.token().id() == PHPTokenId.PHP_TOKEN || this.ts.token().id() == PHPTokenId.PHP_OPERATOR) {
                    this.handleGroupAlignment(node.getNames().get(0));
                    this.addFormatToken(this.formatTokens);
                } else {
                    this.ts.movePrevious();
                }
            }
            this.scan(node.getInitializers());
            if (this.ts.token().id() == PHPTokenId.PHP_SELF || this.ts.token().id() == PHPTokenId.PHP_PARENT) {
                int originalOffset = this.ts.offset();
                if (this.ts.moveNext()) {
                    if (this.ts.token().id() == PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM) {
                        this.addFormatToken(this.formatTokens);
                    } else {
                        this.ts.move(originalOffset);
                        this.ts.moveNext();
                    }
                }
            }
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize * -1));
            if (index == statements.size() - 1 || index < statements.size() - 1 && !(statements.get(index + 1) instanceof ConstantDeclaration)) {
                this.addRestOfLine();
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_FIELDS, this.ts.offset() + this.ts.token().length()));
            }
        } else {
            this.addAllUntilOffset(node.getStartOffset());
            if (this.moveNext() && this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
                super.visit(node);
                this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), this.options.continualIndentSize * -1));
            }
        }
    }

    @Override
    public void visit(CaseDeclaration node) {
        int index;
        Block block = (Block)this.path.get(1);
        List<Statement> statements = block.getStatements();
        for (index = 0; index < statements.size() && statements.get(index).getStartOffset() < node.getStartOffset(); ++index) {
        }
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc && index < statements.size() && index > 0 && statements.get(index - 1) instanceof CaseDeclaration) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_FIELDS, this.ts.offset()));
        } else if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FIELDS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        this.scan(node.getAttributes());
        while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_STRING) {
            this.addFormatToken(this.formatTokens);
        }
        FormatToken lastWhitespace = this.formatTokens.remove(this.formatTokens.size() - 1);
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_MODIFIERS, lastWhitespace.getOffset(), lastWhitespace.getOldText()));
        this.addFormatToken(this.formatTokens);
        this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize));
        this.scan(node.getName());
        if (node.getInitializer() != null) {
            while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_TOKEN && this.ts.token().id() != PHPTokenId.PHP_OPERATOR) {
                this.addFormatToken(this.formatTokens);
            }
            if (this.ts.token().id() == PHPTokenId.PHP_TOKEN || this.ts.token().id() == PHPTokenId.PHP_OPERATOR) {
                this.handleGroupAlignment(node.getName());
                this.addFormatToken(this.formatTokens);
            } else {
                this.ts.movePrevious();
            }
        }
        this.scan(node.getInitializer());
        if (this.ts.token().id() == PHPTokenId.PHP_SELF) {
            int originalOffset = this.ts.offset();
            if (this.ts.moveNext()) {
                if (this.ts.token().id() == PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM) {
                    this.addFormatToken(this.formatTokens);
                } else {
                    this.ts.move(originalOffset);
                    this.ts.moveNext();
                }
            }
        }
        this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize * -1));
        if (index == statements.size() - 1 || index < statements.size() - 1 && !(statements.get(index + 1) instanceof CaseDeclaration)) {
            this.addRestOfLine();
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_FIELDS, this.ts.offset() + this.ts.token().length()));
        }
    }

    @Override
    public void visit(DoStatement node) {
        Statement body = node.getBody();
        if (body != null && !(body instanceof Block)) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_DO_STATEMENT, this.ts.offset()));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
            this.scan(body);
            this.addEndOfUnbreakableSequence(body.getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else {
            this.scan(body);
        }
        this.scan(node.getCondition());
        this.addAllUntilOffset(node.getEndOffset());
    }

    @Override
    public void visit(ExpressionStatement node) {
        if (node.getExpression() instanceof FunctionInvocation) {
            super.visit(node);
        } else {
            this.addAllUntilOffset(node.getStartOffset());
            if (this.moveNext() && this.lastIndex < this.ts.index()) {
                boolean addIndent;
                this.addFormatToken(this.formatTokens);
                Expression expression = node.getExpression();
                boolean bl = addIndent = !(expression instanceof MethodInvocation) && !(expression instanceof StaticMethodInvocation);
                if (expression instanceof Assignment) {
                    Assignment assignment = (Assignment)expression;
                    Expression right = assignment.getRightHandSide();
                    if (FormatVisitor.isAnonymousClass(right) || right instanceof LambdaFunctionDeclaration || right instanceof MatchExpression) {
                        addIndent = false;
                    }
                } else if (expression instanceof LambdaFunctionDeclaration || expression instanceof ArrowFunctionDeclaration || expression instanceof MatchExpression) {
                    addIndent = false;
                }
                if (addIndent) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
                    super.visit(node);
                    this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), -1 * this.options.continualIndentSize));
                } else {
                    super.visit(node);
                }
            }
        }
    }

    @Override
    public void visit(FieldsDeclaration node) {
        int index;
        Block block = (Block)this.path.get(1);
        List<Statement> statements = block.getStatements();
        for (index = 0; index < statements.size() && statements.get(index).getStartOffset() < node.getStartOffset(); ++index) {
        }
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc && index < statements.size() && index > 0 && statements.get(index - 1) instanceof FieldsDeclaration) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_FIELDS, this.ts.offset()));
        } else if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FIELDS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        this.scan(node.getAttributes());
        while (this.ts.moveNext() && !this.isFieldTypeOrVariableToken((Token<PHPTokenId>)this.ts.token())) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        FormatToken lastWhitespace = this.formatTokens.remove(this.formatTokens.size() - 1);
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_MODIFIERS, lastWhitespace.getOffset(), lastWhitespace.getOldText()));
        if (node.getFields().size() > 1) {
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize));
            this.scan(node.getFieldType());
            this.scan(node.getFields());
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize * -1));
        } else {
            this.scan(node.getFieldType());
            this.scan(node.getFields());
        }
        if (index == statements.size() - 1 || index < statements.size() - 1 && !(statements.get(index + 1) instanceof FieldsDeclaration)) {
            this.addRestOfLine();
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_FIELDS, this.ts.offset() + this.ts.token().length()));
        }
    }

    @Override
    public void visit(ForEachStatement node) {
        int start;
        boolean wrap;
        int expressionStart = node.getExpression().getStartOffset();
        this.addAllUntilOffset(expressionStart);
        int index = this.formatTokens.size() - 1;
        String oldText = this.formatTokens.get(this.formatTokens.size() - 1).getOldText();
        boolean addIndent = oldText != null && oldText.indexOf(10) != -1 || this.options.wrapForAfterLeftParen;
        FormatToken.IndentToken addIndentToken = new FormatToken.IndentToken(expressionStart, this.options.continualIndentSize);
        FormatToken.IndentToken removeIndentToken = new FormatToken.IndentToken(node.getExpression().getEndOffset(), -1 * this.options.continualIndentSize);
        if (addIndent) {
            this.formatTokens.add(addIndentToken);
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(expressionStart, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getExpression());
        if (addIndent) {
            this.addEndOfUnbreakableSequence(node.getExpression().getEndOffset());
            this.formatTokens.add(removeIndentToken);
        }
        boolean bl = wrap = node.getKey() != null;
        if (wrap) {
            start = node.getKey().getStartOffset();
            this.addAllUntilOffset(node.getKey().getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_FOR, start));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(start, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getKey());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getKey().getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        boolean bl2 = wrap = node.getValue() != null;
        if (wrap) {
            start = node.getValue().getStartOffset();
            this.addAllUntilOffset(node.getValue().getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_FOR, start));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(start, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getValue());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getValue().getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        this.addAllUntilOffset(node.getStatement().getStartOffset(), ")");
        OffsetRange expressionRange = new OffsetRange(node.getExpression().getStartOffset(), node.getExpression().getEndOffset());
        boolean hasIndent = false;
        for (int i = index; i < this.formatTokens.size(); ++i) {
            FormatToken formatToken = this.formatTokens.get(i);
            if (formatToken.getId() != FormatToken.Kind.WHITESPACE_INDENT || expressionRange.containsInclusive(formatToken.getOffset())) continue;
            hasIndent = true;
            break;
        }
        if (hasIndent || this.options.wrapFor == CodeStyle.WrapStyle.WRAP_ALWAYS) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_FOR, node.getValue().getEndOffset()));
        } else {
            this.formatTokens.remove(addIndentToken);
            this.formatTokens.remove(removeIndentToken);
        }
        Statement body = node.getStatement();
        if (body instanceof Block && !((Block)body).isCurly()) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.scan(node.getStatement());
            while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_ENDFOREACH) {
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block)) {
            this.addNoCurlyBody(body, FormatToken.Kind.WHITESPACE_BEFORE_FOR_STATEMENT);
        } else {
            this.scan(node.getStatement());
        }
    }

    @Override
    public void visit(ForStatement node) {
        Statement body;
        int start;
        boolean wrap;
        this.addAllUntilOffset(node.getBody().getStartOffset(), "(");
        int index = this.formatTokens.size() - 1;
        boolean bl = wrap = !node.getInitializers().isEmpty();
        if (wrap) {
            start = node.getInitializers().get(0).getStartOffset();
            this.addAllUntilOffset(start);
            this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
        }
        this.scan(node.getInitializers());
        if (wrap) {
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        boolean bl2 = wrap = node.getConditions() != null && node.getConditions().size() > 0;
        if (wrap) {
            start = node.getConditions().get(0).getStartOffset();
            this.addAllUntilOffset(start);
            this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_FOR, start));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(start, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getConditions());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getConditions().get(node.getConditions().size() - 1).getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        boolean bl3 = wrap = node.getUpdaters() != null && node.getUpdaters().size() > 0;
        if (wrap) {
            start = node.getUpdaters().get(0).getStartOffset();
            this.addAllUntilOffset(start);
            this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_FOR, start));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(start, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getUpdaters());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getUpdaters().get(node.getUpdaters().size() - 1).getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        this.addAllUntilOffset(node.getBody().getStartOffset(), ")");
        boolean hasNewline = this.hasNewline(index);
        if (!(!hasNewline && this.options.wrapFor != CodeStyle.WrapStyle.WRAP_ALWAYS || node.getInitializers().isEmpty() || node.getConditions().isEmpty() || node.getUpdaters().isEmpty())) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_FOR, this.ts.offset() + this.ts.token().length()));
        }
        if ((body = node.getBody()) instanceof Block && !((Block)body).isCurly()) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.scan(node.getBody());
            while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_ENDFOR) {
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block)) {
            this.addNoCurlyBody(body, FormatToken.Kind.WHITESPACE_BEFORE_FOR_STATEMENT);
        } else {
            this.scan(node.getBody());
        }
    }

    @Override
    public void visit(FunctionDeclaration node) {
        if (this.path.size() <= 1 || !(this.path.get(1) instanceof MethodDeclaration)) {
            while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)this.ts.token()))) {
                this.addFormatToken(this.formatTokens);
            }
            if (this.includeWSBeforePHPDoc) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION, this.ts.offset()));
            } else {
                this.includeWSBeforePHPDoc = true;
            }
            this.ts.movePrevious();
        }
        this.scan(node.getAttributes());
        this.scan(node.getFunctionName());
        boolean addedOpenParen = false;
        while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)this.ts.token()) || FormatVisitor.isOpenParen((Token<? extends PHPTokenId>)this.ts.token()) && !addedOpenParen)) {
            this.addFormatToken(this.formatTokens);
            if (!FormatVisitor.isOpenParen((Token<? extends PHPTokenId>)this.ts.token())) continue;
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
            addedOpenParen = true;
        }
        this.ts.movePrevious();
        int index = this.formatTokens.size() - 1;
        this.addParameters(node.getFormalParameters());
        Expression returnType = node.getReturnType();
        Block body = node.getBody();
        int indentEndOffset = returnType != null ? returnType.getStartOffset() : (body != null ? body.getStartOffset() : node.getEndOffset());
        while (this.moveNext() && this.ts.offset() < indentEndOffset && this.ts.offset() + this.ts.token().length() <= indentEndOffset) {
            if (FormatVisitor.isCloseParen((Token<? extends PHPTokenId>)this.ts.token())) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
                break;
            }
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        boolean hasNewline = this.hasNewline(index);
        if (hasNewline) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_PARAMS, this.ts.offset() + this.ts.token().length()));
        } else if (!node.getFormalParameters().isEmpty() && node.getFormalParameters().size() > 1 && this.options.wrapMethodParams == CodeStyle.WrapStyle.WRAP_ALWAYS) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_PARAMS, this.ts.offset() + this.ts.token().length()));
        }
        this.addReturnType(node.getReturnType());
        this.scan(node.getBody());
    }

    @Override
    public void visit(LambdaFunctionDeclaration node) {
        boolean hasNewline;
        boolean disableIndent = this.disableIndentForFunctionInvocation(node.getStartOffset());
        this.scan(node.getAttributes());
        List<FormalParameter> parameters = node.getFormalParameters();
        Block body = node.getBody();
        int index = this.formatTokens.size() - 1;
        if (!parameters.isEmpty()) {
            this.addAllUntilOffset(parameters.get(0).getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(parameters.get(0).getStartOffset(), this.options.continualIndentSize));
            this.addParameters(parameters);
            Expression returnType = node.getReturnType();
            int indentEndOffset = !node.getLexicalVariables().isEmpty() ? parameters.get(parameters.size() - 1).getEndOffset() : (returnType != null ? returnType.getStartOffset() : (body != null ? body.getStartOffset() : node.getEndOffset()));
            this.formatTokens.add(new FormatToken.IndentToken(indentEndOffset, -1 * this.options.continualIndentSize));
        }
        if (hasNewline = this.hasNewline(index)) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_PARAMS, this.ts.offset() + this.ts.token().length()));
        } else if (!node.getFormalParameters().isEmpty() && node.getFormalParameters().size() > 1 && this.options.wrapMethodParams == CodeStyle.WrapStyle.WRAP_ALWAYS) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_PARAMS, this.ts.offset() + this.ts.token().length()));
        }
        this.addLexicalVariables(node.getLexicalVariables());
        this.addReturnType(node.getReturnType());
        if (body != null) {
            this.addAllUntilOffset(body.getStartOffset());
            this.scan(body);
        }
        if (disableIndent) {
            this.enableIndentForFunctionInvocation(node.getEndOffset());
        }
    }

    private boolean disableIndentForFunctionInvocation(int offset) {
        boolean disable = false;
        if (this.path.get(1) instanceof FunctionInvocation || this.path.size() > 2 && this.path.get(1) instanceof NamedArgument && this.path.get(2) instanceof FunctionInvocation) {
            ASTNode functionInvocation;
            disable = true;
            int index = this.formatTokens.size() - 1;
            ASTNode currentNode = this.path.get(0);
            int currentNodeStart = currentNode.getStartOffset();
            FormatToken lastFormatToken = this.formatTokens.get(index);
            ASTNode aSTNode = functionInvocation = this.path.get(1) instanceof FunctionInvocation ? this.path.get(1) : this.path.get(2);
            while (lastFormatToken.getOffset() > functionInvocation.getStartOffset()) {
                int lastFormatTokenStart;
                if ((lastFormatTokenStart = (lastFormatToken = this.formatTokens.get(--index)).getOffset()) >= currentNodeStart || lastFormatToken.getId() != FormatToken.Kind.WHITESPACE_INDENT) continue;
                disable = false;
                break;
            }
            if (this.options.wrapMethodCallArgsAfterLeftParen && disable && this.hasNewlineWithinMethodCallArgs((FunctionInvocation)functionInvocation)) {
                disable = false;
            }
            if (disable) {
                this.formatTokens.add(new FormatToken.IndentToken(offset, -1 * this.options.continualIndentSize));
            }
        }
        return disable;
    }

    private boolean hasNewlineWithinMethodCallArgs(FunctionInvocation functionInvocation) {
        int originalOffset = this.ts.offset();
        boolean hasNewline = false;
        List<Expression> parameters = functionInvocation.getParameters();
        this.ts.move(functionInvocation.getStartOffset());
        while (this.ts.moveNext() && this.ts.offset() < functionInvocation.getEndOffset() && !hasNewline) {
            if (TokenUtilities.indexOf((CharSequence)this.ts.token().text(), (CharSequence)"\n") == -1) continue;
            boolean ignore = false;
            for (Expression parameter : parameters) {
                if (parameter.getStartOffset() >= this.ts.offset() || this.ts.offset() >= parameter.getEndOffset()) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            hasNewline = true;
            break;
        }
        this.ts.move(originalOffset);
        this.ts.moveNext();
        return hasNewline;
    }

    private boolean hasNewline(int startIndex) {
        boolean hasNewline = false;
        for (int i = startIndex; i < this.formatTokens.size(); ++i) {
            FormatToken formatToken = this.formatTokens.get(i);
            if (formatToken.getId() != FormatToken.Kind.WHITESPACE_INDENT) continue;
            hasNewline = true;
            break;
        }
        return hasNewline;
    }

    private void enableIndentForFunctionInvocation(int offset) {
        if (this.path.get(1) instanceof FunctionInvocation || this.path.size() > 2 && this.path.get(1) instanceof NamedArgument && this.path.get(2) instanceof FunctionInvocation) {
            this.formatTokens.add(new FormatToken.IndentToken(offset, this.options.continualIndentSize));
        }
    }

    private void addParameters(List<FormalParameter> parameters) {
        if (!parameters.isEmpty()) {
            this.addAllUntilOffset(parameters.get(0).getStartOffset());
            this.addListOfNodes(parameters, FormatToken.Kind.WHITESPACE_IN_PARAMETER_LIST);
        }
    }

    private void addLexicalVariables(List<Expression> lexicalVariables) {
        if (!lexicalVariables.isEmpty()) {
            this.addAllUntilOffset(lexicalVariables.get(0).getStartOffset());
            int index = this.formatTokens.size() - 1;
            this.formatTokens.add(new FormatToken.IndentToken(lexicalVariables.get(0).getStartOffset(), this.options.continualIndentSize));
            this.addListOfNodes(lexicalVariables, FormatToken.Kind.WHITESPACE_IN_PARAMETER_LIST);
            this.formatTokens.add(new FormatToken.IndentToken(lexicalVariables.get(lexicalVariables.size() - 1).getEndOffset(), -1 * this.options.continualIndentSize));
            boolean hasNewline = this.hasNewline(index);
            if (hasNewline) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_PARAMS, this.ts.offset() + this.ts.token().length()));
            } else if (lexicalVariables.size() > 1 && this.options.wrapMethodParams == CodeStyle.WrapStyle.WRAP_ALWAYS) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_PARAMS, this.ts.offset() + this.ts.token().length()));
            }
        }
    }

    private void addReturnType(@NullAllowed Expression returnType) {
        if (returnType == null) {
            return;
        }
        int endPosition = returnType.getEndOffset();
        if (this.isMultipleTypeNode(returnType)) {
            endPosition = returnType.getStartOffset();
        }
        while (this.ts.moveNext() && this.ts.offset() < endPosition && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        if (this.isMultipleTypeNode(returnType)) {
            this.scan(returnType);
        }
    }

    private boolean isMultipleTypeNode(Expression type) {
        return type instanceof NullableType || type instanceof UnionType || type instanceof IntersectionType;
    }

    @Override
    public void visit(FormalParameter node) {
        this.scan(node.getAttributes());
        Expression parameterType = node.getParameterType();
        this.scan(parameterType);
        if (parameterType != null) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_TYPE, parameterType.getEndOffset()));
        }
        this.scan(node.getParameterName());
        this.scan(node.getDefaultValue());
    }

    @Override
    public void visit(FunctionInvocation node) {
        if (this.path.size() > 1 && this.path.get(1) instanceof MethodInvocation) {
            while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_OBJECT_OPERATOR && this.ts.token().id() != PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR && this.ts.offset() + this.ts.token().length() < node.getStartOffset()) {
                this.addFormatToken(this.formatTokens);
            }
            if (this.ts.token().id() == PHPTokenId.PHP_OBJECT_OPERATOR || this.ts.token().id() == PHPTokenId.PHP_NULLSAFE_OBJECT_OPERATOR) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_CHAINED_METHOD_CALLS, this.ts.offset()));
                this.addFormatToken(this.formatTokens);
            } else {
                this.ts.movePrevious();
            }
        }
        this.scan(node.getFunctionName());
        List<Expression> parameters = node.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean addIndentation = !(this.path.get(1) instanceof ReturnStatement) && !(this.path.get(1) instanceof Assignment) && (this.path.size() <= 2 || !(this.path.get(1) instanceof MethodInvocation) || !(this.path.get(2) instanceof Assignment));
            FormatToken.IndentToken indentToken = new FormatToken.IndentToken(node.getFunctionName().getEndOffset(), this.options.continualIndentSize);
            if (addIndentation) {
                this.formatTokens.add(indentToken);
            }
            int index = this.formatTokens.size() - 1;
            this.processArguments(parameters);
            boolean hasNewline = this.hasNewlineInMethodCallArgs(parameters, index, new OffsetRange(node.getStartOffset(), node.getEndOffset()));
            if (hasNewline) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_CALL_ARGS, node.getEndOffset() - 1));
            } else if (!node.getParameters().isEmpty() && node.getParameters().size() > 1 && this.options.wrapMethodCallArgs == CodeStyle.WrapStyle.WRAP_ALWAYS) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.HAS_NEWLINE_WITHIN_METHOD_CALL_ARGS, node.getEndOffset() - 1));
            }
            addIndentation = this.removeIndentTokenForAnonymousClass(node, indentToken, addIndentation, hasNewline);
            if (addIndentation) {
                ArrayList<FormatToken> removed = new ArrayList<FormatToken>();
                FormatToken ftoken = this.formatTokens.get(this.formatTokens.size() - 1);
                while (ftoken.getId() == FormatToken.Kind.UNBREAKABLE_SEQUENCE_END || ftoken.isWhitespace() && ftoken.getId() != FormatToken.Kind.WHITESPACE_INDENT || ftoken.getId() == FormatToken.Kind.COMMENT || ftoken.getId() == FormatToken.Kind.COMMENT_START || ftoken.getId() == FormatToken.Kind.COMMENT_END || ftoken.getId() == FormatToken.Kind.INDENT || ftoken.getId() == FormatToken.Kind.TEXT && (")".equals(ftoken.getOldText()) || "]".equals(ftoken.getOldText()))) {
                    this.formatTokens.remove(this.formatTokens.size() - 1);
                    removed.add(ftoken);
                    ftoken = this.formatTokens.get(this.formatTokens.size() - 1);
                }
                if (ftoken.getId() == FormatToken.Kind.WHITESPACE_INDENT && !hasNewline) {
                    this.formatTokens.remove(this.formatTokens.size() - 1);
                    this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), -1 * this.options.continualIndentSize));
                    this.formatTokens.add(ftoken);
                    for (int i = removed.size() - 1; i > -1; --i) {
                        this.formatTokens.add((FormatToken)removed.get(i));
                    }
                } else {
                    for (int i = removed.size() - 1; i > -1; --i) {
                        this.formatTokens.add((FormatToken)removed.get(i));
                    }
                    this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), -1 * this.options.continualIndentSize));
                }
            }
        }
        this.addAllUntilOffset(node.getEndOffset());
    }

    private boolean hasNewlineInMethodCallArgs(List<Expression> parameters, int index, OffsetRange range) {
        boolean hasIndent = false;
        ArrayList<Expression> expressions = new ArrayList<Expression>(parameters.size());
        ArrayList<Expression> ignoreExpressions = new ArrayList<Expression>();
        for (Expression parameter : parameters) {
            FunctionInvocation function;
            Expression param = parameter;
            if (param instanceof NamedArgument) {
                param = ((NamedArgument)param).getExpression();
            }
            if (param instanceof MethodInvocation) {
                param = ((MethodInvocation)param).getMethod();
            }
            if (param instanceof FunctionInvocation && !this.hasNewlineInMethodCallArgs((function = (FunctionInvocation)param).getParameters(), index, new OffsetRange(function.getStartOffset(), function.getEndOffset()))) {
                ignoreExpressions.add(param);
            }
            if (!(param instanceof LambdaFunctionDeclaration) && !(param instanceof MatchExpression) && !(param instanceof ArrayCreation) && !(param instanceof ClassInstanceCreation)) continue;
            expressions.add(param);
        }
        for (int i = index; i < this.formatTokens.size(); ++i) {
            int offset;
            FormatToken formatToken = this.formatTokens.get(i);
            if (formatToken.getId() != FormatToken.Kind.WHITESPACE_INDENT || !range.containsInclusive(offset = formatToken.getOffset())) continue;
            boolean isInExpression = false;
            boolean ignore = false;
            for (Expression expression : ignoreExpressions) {
                if (expression.getStartOffset() >= offset || offset >= expression.getEndOffset()) continue;
                ignore = true;
            }
            if (ignore) continue;
            for (Expression expression : expressions) {
                if (expression.getStartOffset() >= offset || offset >= expression.getEndOffset()) continue;
                isInExpression = true;
                break;
            }
            if (isInExpression) continue;
            hasIndent = true;
            break;
        }
        return hasIndent;
    }

    private boolean removeIndentTokenForAnonymousClass(FunctionInvocation functionInvocation, FormatToken.IndentToken indentToken, boolean addIndentation, boolean hasNewline) {
        List<Expression> parameters = functionInvocation.getParameters();
        boolean addIndent = addIndentation;
        if ((this.options.wrapMethodCallArgs == CodeStyle.WrapStyle.WRAP_ALWAYS || parameters.isEmpty()) && (hasNewline || parameters.isEmpty() || parameters.size() != 1)) {
            return addIndent;
        }
        Expression firstParameter = parameters.get(0);
        if (!FormatVisitor.isAnonymousClass(parameters.get(parameters.size() - 1))) {
            return addIndent;
        }
        for (Expression parameter : parameters) {
            if (!FormatVisitor.isAnonymousClass(parameter)) continue;
            int index = this.formatTokens.size() - 1;
            FormatToken lastFormatToken = this.formatTokens.get(index);
            while (lastFormatToken.getOffset() >= firstParameter.getStartOffset()) {
                lastFormatToken = this.formatTokens.get(--index);
                if (parameter.getStartOffset() != lastFormatToken.getOffset() || index - 1 < 0 || this.formatTokens.get(index - 1).getId() != FormatToken.Kind.WHITESPACE_INDENT) continue;
                lastFormatToken = this.formatTokens.get(index - 1);
                break;
            }
            if (lastFormatToken.getId() == FormatToken.Kind.WHITESPACE_INDENT || this.options.wrapMethodCallArgsAfterLeftParen && this.hasNewlineWithinMethodCallArgs(functionInvocation)) break;
            this.formatTokens.remove(indentToken);
            addIndent = false;
            break;
        }
        return addIndent;
    }

    @Override
    public void visit(InfixExpression node) {
        this.scan(node.getLeft());
        FormatToken.Kind whitespaceBefore = FormatToken.Kind.WHITESPACE_BEFORE_BINARY_OP;
        FormatToken.Kind whitespaceAfter = FormatToken.Kind.WHITESPACE_AFTER_BINARY_OP;
        if (node.getOperator() == InfixExpression.OperatorType.CONCAT) {
            whitespaceBefore = whitespaceAfter = FormatToken.Kind.WHITESPACE_AROUND_CONCAT_OP;
        }
        while (this.ts.moveNext() && this.ts.offset() < node.getRight().getStartOffset() && this.ts.token().id() != PHPTokenId.PHP_TOKEN && !LexUtilities.isPHPOperator((PHPTokenId)this.ts.token().id()) && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.ts.token().id() == PHPTokenId.PHP_TOKEN || this.ts.token().id() == PHPTokenId.PHP_OPERATOR) {
            this.formatTokens.add(new FormatToken(whitespaceBefore, this.ts.offset()));
            this.addFormatToken(this.formatTokens);
            this.formatTokens.add(new FormatToken(whitespaceAfter, this.ts.offset() + this.ts.token().length()));
        } else if (this.ts.token().id() == PHPTokenId.PHP_TEXTUAL_OPERATOR) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_TEXTUAL_OP, this.ts.offset()));
            this.addFormatToken(this.formatTokens);
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_TEXTUAL_OP, this.ts.offset() + this.ts.token().length()));
        } else {
            this.ts.movePrevious();
        }
        this.scan(node.getRight());
    }

    @Override
    @SuppressWarnings(value={"BC_IMPOSSIBLE_INSTANCEOF"}, justification="Incorrect FB analysis")
    public void visit(IfStatement node) {
        this.addAllUntilOffset(node.getCondition().getStartOffset());
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
        this.scan(node.getCondition());
        Statement trueStatement = node.getTrueStatement();
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        boolean isTrueStatementCurly = false;
        if (trueStatement instanceof Block && !((Block)trueStatement).isCurly()) {
            this.isCurly = false;
            this.addAllUntilOffset(trueStatement.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(trueStatement.getStartOffset(), this.options.indentSize));
            this.scan(trueStatement);
            if (this.ts.token().id() == PHPTokenId.T_INLINE_HTML && this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                this.addFormatToken(this.formatTokens);
            }
            this.formatTokens.add(new FormatToken.IndentToken(trueStatement.getEndOffset(), -1 * this.options.indentSize));
        } else if (trueStatement != null && !(trueStatement instanceof Block)) {
            this.isCurly = false;
            this.addNoCurlyBody(trueStatement, FormatToken.Kind.WHITESPACE_BEFORE_IF_ELSE_STATEMENT);
        } else {
            isTrueStatementCurly = true;
            this.scan(trueStatement);
        }
        Statement falseStatement = node.getFalseStatement();
        if (falseStatement instanceof Block && !((Block)falseStatement).isCurly() && !(falseStatement instanceof IfStatement)) {
            this.isCurly = false;
            while (this.ts.moveNext() && this.ts.offset() < falseStatement.getStartOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_ELSE || this.ts.token().id() == PHPTokenId.PHP_ELSEIF) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    continue;
                }
                if (this.lastIndex >= this.ts.index()) continue;
                this.addFormatToken(this.formatTokens);
            }
            this.formatTokens.add(new FormatToken.IndentToken(falseStatement.getStartOffset(), this.options.indentSize));
            this.ts.movePrevious();
            this.scan(falseStatement);
            this.formatTokens.add(new FormatToken.IndentToken(falseStatement.getEndOffset(), -1 * this.options.indentSize));
        } else if (falseStatement != null && !(falseStatement instanceof Block) && !(falseStatement instanceof IfStatement)) {
            this.isCurly = false;
            while (this.ts.moveNext() && this.ts.offset() < falseStatement.getStartOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_ELSE || this.ts.token().id() == PHPTokenId.PHP_ELSEIF) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ELSE_WITHOUT_CURLY, this.ts.offset()));
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    continue;
                }
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.addAllUntilOffset(falseStatement.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(falseStatement.getStartOffset(), this.options.indentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_ELSE_STATEMENT, this.ts.offset()));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
            this.scan(falseStatement);
            this.addEndOfUnbreakableSequence(falseStatement.getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(falseStatement.getEndOffset(), -1 * this.options.indentSize));
        } else {
            this.isCurly = isTrueStatementCurly;
            this.scan(falseStatement);
        }
    }

    @Override
    public void visit(MethodDeclaration node) {
        while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)this.ts.token())) && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        if (this.lastIndex < this.ts.index()) {
            if (this.ts.token().id() == PHPTokenId.PHP_ATTRIBUTE) {
                this.ts.movePrevious();
            } else {
                this.addFormatToken(this.formatTokens);
            }
        }
        this.scan(node.getAttributes());
        block4: while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_STRING) {
            switch ((PHPTokenId)this.ts.token().id()) {
                case PHP_FUNCTION: {
                    if (node.getModifier() > 0) {
                        FormatToken lastWhitespace = this.formatTokens.remove(this.formatTokens.size() - 1);
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_MODIFIERS, lastWhitespace.getOffset(), lastWhitespace.getOldText()));
                    }
                    this.addFormatToken(this.formatTokens);
                    continue block4;
                }
            }
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        this.scan(node.getFunction());
    }

    @Override
    public void visit(MethodInvocation node) {
        boolean shift = false;
        if (!this.isMethodInvocationShifted) {
            try {
                int startText = node.getDispatcher().getEndOffset();
                int endText = node.getMethod().getStartOffset();
                if (this.document.getText(startText, endText - startText).contains("\n")) {
                    boolean addIndent;
                    shift = true;
                    this.addAllUntilOffset(node.getStartOffset());
                    boolean bl = addIndent = this.path.size() <= 1 || !(this.path.get(1) instanceof Assignment);
                    if (this.options.wrapMethodCallArgs != CodeStyle.WrapStyle.WRAP_ALWAYS) {
                        FunctionInvocation method = node.getMethod();
                        List<Expression> parameters = method.getParameters();
                        for (Expression parameter : parameters) {
                            if (!FormatVisitor.isAnonymousClass(parameter)) continue;
                            addIndent = false;
                            break;
                        }
                    }
                    if (addIndent) {
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
                    }
                    this.isMethodInvocationShifted = true;
                    super.visit(node);
                    this.addAllUntilOffset(node.getEndOffset());
                    if (addIndent) {
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), -1 * this.options.continualIndentSize));
                    }
                    this.isMethodInvocationShifted = false;
                }
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "Exception in scanning method invocation", ex);
                shift = false;
            }
        }
        if (!shift) {
            super.visit(node);
        }
    }

    @Override
    public void visit(NamespaceDeclaration node) {
        this.addAllUntilOffset(node.getStartOffset());
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_NAMESPACE, node.getStartOffset()));
        this.scan(node.getName());
        this.addRestOfLine();
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_NAMESPACE, this.ts.offset() + this.ts.token().length()));
        this.scan(node.getBody());
    }

    @Override
    public void visit(Program program) {
        if (this.ts != null) {
            FormatToken lastToken;
            this.path.addFirst(program);
            this.ts.move(0);
            this.ts.moveNext();
            this.ts.movePrevious();
            this.addFormatToken(this.formatTokens);
            super.visit(program);
            FormatToken formatToken = lastToken = this.formatTokens.size() > 0 ? this.formatTokens.get(this.formatTokens.size() - 1) : null;
            while (this.ts.moveNext()) {
                if (lastToken != null && !lastToken.isWhitespace() && lastToken.getOffset() <= this.ts.offset() || this.lastIndex >= this.ts.index()) continue;
                this.addFormatToken(this.formatTokens);
                lastToken = this.formatTokens.get(this.formatTokens.size() - 1);
            }
            this.path.removeFirst();
        }
    }

    @Override
    public void visit(ReturnStatement node) {
        boolean addIndent;
        while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_RETURN && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            this.addFormatToken(this.formatTokens);
        }
        boolean bl = addIndent = !FormatVisitor.isAnonymousClass(node.getExpression()) && (this.path.size() <= 2 || !(this.path.get(2) instanceof LambdaFunctionDeclaration)) && !(node.getExpression() instanceof LambdaFunctionDeclaration) && !(node.getExpression() instanceof MatchExpression);
        if (this.ts.token().id() == PHPTokenId.PHP_RETURN) {
            this.addFormatToken(this.formatTokens);
            if (addIndent) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
            }
            super.visit(node);
            if (addIndent) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
            }
        }
    }

    @Override
    public void visit(SingleFieldDeclaration node) {
        Expression fieldType = node.getFieldType();
        if (fieldType != null) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_TYPE, fieldType.getEndOffset()));
        }
        Variable name = node.getName();
        this.scan(name);
        if (node.getValue() != null) {
            while (this.ts.moveNext() && this.ts.offset() < node.getValue().getStartOffset()) {
                ASTNode parent = this.path.get(1);
                assert (parent instanceof FieldsDeclaration);
                FieldsDeclaration fieldsDeclaration = (FieldsDeclaration)this.path.get(1);
                if (this.ts.token().id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)"=", (CharSequence)this.ts.token().text())) {
                    int realNodeLength = fieldsDeclaration.getModifierString().length() + " ".length() + name.getEndOffset() - name.getStartOffset();
                    this.handleGroupAlignment(realNodeLength);
                    this.addFormatToken(this.formatTokens);
                    continue;
                }
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            if (node.getValue() != null) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
                this.scan(node.getValue());
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), -1 * this.options.continualIndentSize));
            }
        }
    }

    @Override
    public void visit(SwitchCase node) {
        if (node.getValue() == null) {
            this.ts.moveNext();
            if (this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
        } else {
            this.scan(node.getValue());
        }
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.indentSize));
        if (node.getActions() != null) {
            this.scan(node.getActions());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
        }
    }

    @Override
    public void visit(SwitchStatement node) {
        this.scan(node.getExpression());
        if (node.getBody() != null && !node.getBody().isCurly()) {
            this.addAllUntilOffset(node.getBody().getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(node.getBody().getStartOffset(), this.options.indentSize));
            if (node.getBody().getStatements().size() > 0) {
                this.scan(node.getBody());
                Statement lastOne = node.getBody().getStatements().get(node.getBody().getStatements().size() - 1);
                while (lastOne.getEndOffset() < this.formatTokens.get(this.formatTokens.size() - 1).getOffset()) {
                    this.formatTokens.remove(this.formatTokens.size() - 1);
                }
                while (lastOne.getEndOffset() < this.ts.offset()) {
                    this.ts.movePrevious();
                }
            } else {
                while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_ENDSWITCH && this.ts.offset() < node.getBody().getEndOffset()) {
                    this.addFormatToken(this.formatTokens);
                }
                this.ts.movePrevious();
            }
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
            this.addAllUntilOffset(node.getEndOffset());
        } else {
            this.scan(node.getBody());
        }
    }

    @Override
    public void visit(MatchExpression node) {
        boolean disabled = this.disableIndentForFunctionInvocation(node.getStartOffset());
        this.scan(node.getExpression());
        this.addWhitespaceBeforeMatchLeftBraceToken(node);
        this.createGroupAlignment();
        List<MatchArm> matchArms = node.getMatchArms();
        if (!matchArms.isEmpty()) {
            MatchArm first = matchArms.get(0);
            this.addAllUntilOffset(first.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(first.getStartOffset(), this.options.indentSize));
            this.scan(node.getMatchArms());
            MatchArm last = matchArms.get(matchArms.size() - 1);
            this.formatTokens.add(new FormatToken.IndentToken(last.getEndOffset(), -1 * this.options.indentSize));
        }
        this.addWhitespaceBeforeMatchRightBraceToken(node);
        if (disabled) {
            this.enableIndentForFunctionInvocation(node.getEndOffset());
        }
        this.addAllUntilOffset(node.getEndOffset());
        this.resetGroupAlignment();
    }

    private void addWhitespaceBeforeMatchRightBraceToken(MatchExpression node) {
        while (this.moveNext() && this.ts.offset() < node.getEndOffset() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            Token token = this.ts.token();
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_MATCH_RIGHT_BRACE, this.ts.offset()));
                this.addFormatToken(this.formatTokens);
                break;
            }
            this.addFormatToken(this.formatTokens);
        }
    }

    private void addWhitespaceBeforeMatchLeftBraceToken(MatchExpression node) {
        while (this.moveNext() && this.ts.offset() < node.getEndOffset() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            Token token = this.ts.token();
            if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_MATCH_LEFT_BRACE, this.ts.offset()));
                this.addFormatToken(this.formatTokens);
                break;
            }
            this.addFormatToken(this.formatTokens);
        }
    }

    private boolean isMultilinedMatchArm(MatchExpression matchExpression, MatchArm matchArm) {
        boolean result = false;
        List<MatchArm> matchArms = matchExpression.getMatchArms();
        int start = matchExpression.getStartOffset();
        for (MatchArm arm : matchArms) {
            if (arm.getStartOffset() == matchArm.getStartOffset()) {
                int end = arm.getStartOffset();
                try {
                    result = this.document.getText(start, end - start).contains("\n");
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.WARNING, "Invalid offset: {0}", ex.offsetRequested());
                }
            }
            start = arm.getEndOffset();
        }
        return result;
    }

    @Override
    public void visit(MatchArm node) {
        this.scan(node.getConditions());
        MatchExpression parentMatchExpression = this.getParentMatchExpression();
        boolean isMultilined = this.isMultilinedMatchArm(parentMatchExpression, node);
        while (this.ts.moveNext() && this.ts.offset() < node.getExpression().getStartOffset()) {
            if (FormatVisitor.isKeyValueOperator((Token<PHPTokenId>)this.ts.token())) {
                List<Expression> conditions = node.getConditions();
                this.handleGroupAlignment(conditions, isMultilined, FormatToken.AssignmentAnchorToken.Type.MATCH_ARM);
            }
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        this.scan(node.getExpression());
    }

    @CheckForNull
    private MatchExpression getParentMatchExpression() {
        MatchExpression result = null;
        for (int i = 0; i < this.path.size(); ++i) {
            ASTNode parentInPath = this.path.get(i);
            if (!(parentInPath instanceof MatchExpression)) continue;
            result = (MatchExpression)parentInPath;
            break;
        }
        return result;
    }

    @Override
    public void visit(TryStatement node) {
        this.scan(node.getBody());
        this.scan(node.getCatchClauses());
        this.scan(node.getFinallyClause());
    }

    @Override
    public void visit(CatchClause node) {
        boolean addIndent;
        this.addAllUntilOffset(node.getStartOffset());
        List<Expression> classNames = node.getClassNames();
        boolean bl = addIndent = !classNames.isEmpty() && classNames.size() > 1;
        if (addIndent) {
            this.addAllUntilOffset(classNames.get(0).getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
        }
        this.scan(node.getClassNames());
        this.scan(node.getVariable());
        if (addIndent) {
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize * -1));
        }
        this.scan(node.getBody());
    }

    @Override
    public void visit(WhileStatement node) {
        this.scan(node.getCondition());
        Statement body = node.getBody();
        if (body instanceof Block && !((Block)body).isCurly()) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.scan(node.getBody());
            if (this.ts.token().id() == PHPTokenId.T_INLINE_HTML && this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                this.addFormatToken(this.formatTokens);
            }
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block)) {
            this.addNoCurlyBody(body, FormatToken.Kind.WHITESPACE_BEFORE_WHILE_STATEMENT);
        } else {
            this.scan(node.getBody());
        }
    }

    @Override
    public void visit(UseStatement node) {
        if (this.isPreviousNodeTheSameInBlock(this.path.get(1), node)) {
            assert (this.lastUseStatement != null);
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_USE, this.ts.offset()));
            if (node.getType() != this.lastUseStatement.getType()) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_USE_TYPES, this.ts.offset()));
            }
        } else if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE, this.ts.offset()));
        }
        this.includeWSBeforePHPDoc = true;
        this.isFirstUseStatementPart = true;
        super.visit(node);
        if (this.isNextNodeTheSameInBlock(this.path.get(1), node)) {
            this.addRestOfLine();
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_USE, this.ts.offset() + this.ts.token().length()));
        }
        this.lastUseStatement = node;
    }

    @Override
    public void visit(UseTraitStatement node) {
        int index;
        if (this.includeWSBeforePHPDoc && this.isFirstUseTraitStatementInBlock(this.path.get(1), node)) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE_TRAIT, this.ts.offset()));
        }
        this.includeWSBeforePHPDoc = true;
        this.isFirstUseTraitStatementPart = true;
        Block block = (Block)this.path.get(1);
        List<Statement> statements = block.getStatements();
        super.visit(node);
        for (index = 0; index < statements.size() && statements.get(index).getStartOffset() < node.getStartOffset(); ++index) {
        }
        if (index == statements.size() - 1 || index < statements.size() - 1 && !(statements.get(index + 1) instanceof UseTraitStatement)) {
            this.addRestOfLine();
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_USE_TRAIT, this.ts.offset() + this.ts.token().length()));
        }
    }

    @Override
    public void visit(GroupUseStatementPart node) {
        this.scan(node.getBaseNamespaceName());
        List<SingleUseStatementPart> items = node.getItems();
        int start = items.isEmpty() ? node.getEndOffset() - 1 : items.get(0).getStartOffset();
        while (this.ts.moveNext() && this.ts.offset() < start && this.lastIndex < this.ts.index()) {
            if (this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_GROUP_USE_LEFT_BRACE, this.ts.offset()));
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.indentSize));
                if (items.isEmpty()) {
                    this.addFormatToken(this.formatTokens);
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_GROUP_USE_LEFT_BRACE, this.ts.offset() + this.ts.token().text().length()));
                    break;
                }
            }
            this.addFormatToken(this.formatTokens);
        }
        if (!items.isEmpty()) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_GROUP_USE_LEFT_BRACE, this.ts.offset()));
            this.ts.movePrevious();
            this.addListOfNodes(items, FormatToken.Kind.WHITESPACE_IN_GROUP_USE_LIST);
        }
        while (this.ts.moveNext() && this.ts.offset() < node.getEndOffset() && this.lastIndex < this.ts.index()) {
            if (this.ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_GROUP_USE_RIGHT_BRACE, this.ts.offset()));
            }
            this.addFormatToken(this.formatTokens);
        }
    }

    @Override
    public void visit(SingleUseStatementPart statementPart) {
        if (this.path.size() <= 0 || !(this.path.get(1) instanceof GroupUseStatementPart)) {
            FormatToken lastFormatToken = this.formatTokens.get(this.formatTokens.size() - 1);
            boolean lastRemoved = false;
            if (this.ts.token().id() == PHPTokenId.PHP_NS_SEPARATOR && lastFormatToken.getId() == FormatToken.Kind.TEXT && "\\".equals(lastFormatToken.getOldText())) {
                this.formatTokens.remove(this.formatTokens.size() - 1);
                lastRemoved = true;
            }
            if (this.isFirstUseStatementPart) {
                this.formatTokens.add(new FormatToken.AnchorToken(this.ts.offset()));
                this.isFirstUseStatementPart = false;
            }
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USES_PART, this.ts.offset()));
            if (lastRemoved) {
                this.formatTokens.add(lastFormatToken);
            }
        }
        super.visit(statementPart);
    }

    @Override
    public void visit(UseTraitStatementPart node) {
        if (this.isFirstUseTraitStatementPart) {
            this.formatTokens.add(new FormatToken.AnchorToken(this.ts.offset()));
            this.isFirstUseTraitStatementPart = false;
        }
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE_TRAIT_PART, this.ts.offset()));
        super.visit(node);
    }

    @Override
    public void visit(TraitMethodAliasDeclaration node) {
        this.addRestOfLine();
        super.visit(node);
    }

    @Override
    public void visit(TraitConflictResolutionDeclaration node) {
        this.addRestOfLine();
        super.visit(node);
    }

    @Override
    public void visit(NullableType nullableType) {
        if (this.ts.moveNext()) {
            assert (TokenUtilities.equals((CharSequence)this.ts.token().text(), (Object)"?"));
            this.addFormatToken(this.formatTokens);
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_NULLABLE_TYPE_PREFIX, this.ts.offset() + 1));
            Expression type = nullableType.getType();
            this.scan(type);
        }
    }

    @Override
    public void visit(DeclareStatement node) {
        List<Identifier> names = node.getDirectiveNames();
        List<Expression> values = node.getDirectiveValues();
        assert (names.size() == values.size());
        for (int i = 0; i < names.size(); ++i) {
            this.scan(names.get(i));
            this.addAllUntilOffset(values.get(i).getStartOffset());
            this.scan(values.get(i));
        }
        this.scan(node.getBody());
    }

    @Override
    public void visit(UnionType node) {
        this.processUnionOrIntersectionType(node.getTypes());
        this.addAllUntilOffset(node.getEndOffset());
    }

    @Override
    public void visit(IntersectionType node) {
        this.processUnionOrIntersectionType(node.getTypes());
    }

    @Override
    public void visit(ReflectionVariable node) {
        while (this.moveNext() && this.ts.offset() < node.getName().getStartOffset()) {
            this.addFormatToken(this.formatTokens);
            if (this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN) continue;
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_DYNAMIC_NAME_BRACES, this.ts.offset() + this.ts.token().length()));
        }
        this.ts.movePrevious();
        this.scan(node.getName());
        while (this.moveNext() && this.ts.offset() < node.getEndOffset()) {
            if (this.ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_DYNAMIC_NAME_BRACES, this.ts.offset()));
            }
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
    }

    private void processUnionOrIntersectionType(List<Expression> types) {
        assert (!types.isEmpty());
        Expression lastType = types.get(types.size() - 1);
        for (int i = 0; i < types.size(); ++i) {
            Expression type = types.get(i);
            this.scan(type);
            if (type == lastType) continue;
            Expression nextType = types.get(i + 1);
            this.addAllUntilOffset(nextType.getStartOffset());
        }
    }

    private String showAssertionFor188809() {
        String result = "";
        try {
            result = "The same token (index: " + this.ts.index() + " - " + this.ts.token().id() + ", format tokens: " + this.formatTokens.size() + ", offset: " + this.ts.offset() + ")  was precessed before.\nPlease report this to help fix issue 188809.\n\n" + this.document.getText(0, this.document.getLength() - 1);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private void addFormatToken(List<FormatToken> tokens) {
        if (this.lastIndex == this.ts.index()) {
            assert (false) : this.showAssertionFor188809();
            this.ts.moveNext();
            return;
        }
        this.lastIndex = this.ts.index();
        switch ((PHPTokenId)this.ts.token().id()) {
            case WHITESPACE: {
                tokens.addAll(this.resolveWhitespaceTokens());
                break;
            }
            case PHP_LINE_COMMENT: {
                if (this.ts.token().text().charAt(this.ts.token().length() - 1) == '\n') {
                    CharSequence text = this.ts.token().text().subSequence(0, this.ts.token().length() - 1);
                    int newOffset = this.ts.offset() + this.ts.token().length() - 1;
                    if (text.length() > 0) {
                        tokens.add(new FormatToken(FormatToken.Kind.LINE_COMMENT, this.ts.offset(), text.toString()));
                    }
                    if (this.ts.moveNext()) {
                        if (this.ts.token().id() == PHPTokenId.WHITESPACE) {
                            if (this.countOfNewLines(this.ts.token().text()) > 0) {
                                this.resetAndCreateGroupAlignment();
                            }
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, newOffset, "\n" + this.ts.token().text().toString()));
                            if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_LINE_COMMENTS, this.ts.offset()));
                            }
                            this.ts.movePrevious();
                            break;
                        }
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, newOffset, "\n"));
                        this.ts.movePrevious();
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, newOffset, "\n"));
                    break;
                }
                tokens.add(new FormatToken(FormatToken.Kind.LINE_COMMENT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_OPENTAG: 
            case T_OPEN_TAG_WITH_ECHO: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OPEN_PHP_TAG, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.OPEN_TAG, this.ts.offset(), this.ts.token().text().toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_OPEN_PHP_TAG, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_CLOSETAG: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLOSE_PHP_TAG, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.CLOSE_TAG, this.ts.offset(), this.ts.token().text().toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_CLOSE_PHP_TAG, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_COMMENT_START: {
                tokens.add(new FormatToken(FormatToken.Kind.COMMENT_START, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_COMMENT_END: {
                tokens.add(new FormatToken(FormatToken.Kind.COMMENT_END, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_COMMENT: {
                tokens.add(new FormatToken(FormatToken.Kind.COMMENT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHPDOC_COMMENT: {
                tokens.add(new FormatToken(FormatToken.Kind.DOC_COMMENT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHPDOC_COMMENT_START: {
                tokens.add(new FormatToken(FormatToken.Kind.DOC_COMMENT_START, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHPDOC_COMMENT_END: {
                tokens.add(new FormatToken(FormatToken.Kind.DOC_COMMENT_END, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_PAAMAYIM_NEKUDOTAYIM: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_SCOPE_RESOLUTION_OP, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_SCOPE_RESOLUTION_OP, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_OBJECT_OPERATOR: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_OBJECT_OP, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_OBJECT_OP, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_NULLSAFE_OBJECT_OPERATOR: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_NULLSAFE_OBJECT_OP, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_NULLSAFE_OBJECT_OP, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_CASTING: {
                int index;
                String text = this.ts.token().text().toString();
                String part1 = text.substring(0, text.indexOf(40) + 1);
                String part2 = text.substring(part1.length(), text.indexOf(41));
                String part3 = text.substring(part1.length() + part2.length());
                StringBuilder ws1 = new StringBuilder();
                StringBuilder ws2 = new StringBuilder();
                for (index = 0; index < part2.length() && part2.charAt(index) == ' '; ++index) {
                    ws1.append(' ');
                }
                for (index = part2.length() - 1; index > 0 && part2.charAt(index) == ' '; --index) {
                    ws2.append(' ');
                }
                part2 = part2.trim();
                int length = 0;
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), part1));
                length += part1.length();
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_TYPE_CAST_PARENS, this.ts.offset() + part1.length()));
                if (ws1.length() > 0) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE, this.ts.offset() + length, ws1.toString()));
                    length += ws1.length();
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset() + length, part2));
                length += part2.length();
                if (ws2.length() > 0) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE, this.ts.offset() + length, ws2.toString()));
                    length += ws2.length();
                }
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_TYPE_CAST_PARENS, this.ts.offset() + length));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset() + length, part3));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_TYPE_CAST, this.ts.offset() + (length += part3.length())));
                break;
            }
            case PHP_TOKEN: {
                CharSequence txt = this.ts.token().text();
                ASTNode parent = this.path.get(0);
                if (TokenUtilities.textEquals((CharSequence)"(", (CharSequence)txt)) {
                    if (FormatVisitor.isAnonymousClass(parent)) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ANONYMOUS_CLASS_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ANONYMOUS_CLASS_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration || parent instanceof ArrowFunctionDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_METHOD_DEC_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_DECL_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof LambdaFunctionDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ANONYMOUS_FUNCTION_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_DECL_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof FunctionInvocation || parent instanceof MethodInvocation || parent instanceof ClassInstanceCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_METHOD_CALL_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_CALL_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof AttributeDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ATTRIBUTE_DEC_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ATTRIBUTE_DECL_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof IfStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_IF_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof ForEachStatement || parent instanceof ForStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FOR_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_FOR_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof WhileStatement || parent instanceof DoStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_WHILE_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof SwitchStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SWITCH_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_SWITCH_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof MatchExpression) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_MATCH_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_MATCH_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof CatchClause) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_CATCH_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof ArrayCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ARRAY_DECL_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ARRAY_DECL_LEFT_PAREN, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof UnionType) {
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_DNF_TYPE_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)")", (CharSequence)txt)) {
                    if (FormatVisitor.isAnonymousClass(parent)) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ANONYMOUS_CLASS_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration || parent instanceof LambdaFunctionDeclaration || parent instanceof ArrowFunctionDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_DECL_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof FunctionInvocation || parent instanceof MethodInvocation || parent instanceof ClassInstanceCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_CALL_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof AttributeDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ATTRIBUTE_DECL_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof IfStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_IF_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof ForEachStatement || parent instanceof ForStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_FOR_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof WhileStatement || parent instanceof DoStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_WHILE_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof SwitchStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_SWITCH_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof MatchExpression) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_MATCH_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof CatchClause) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_CATCH_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof ArrayCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ARRAY_DECL_RIGHT_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (parent instanceof UnionType) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_DNF_TYPE_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)"[", (CharSequence)txt)) {
                    if (parent instanceof ArrayCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ARRAY_DECL_LEFT_PAREN, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ARRAY_BRACKETS_PARENS, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)"]", (CharSequence)txt)) {
                    if (parent instanceof ArrayCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ARRAY_DECL_RIGHT_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    if (this.isAttributeCloseBracket) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ATTRIBUTE_BRACKETS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ARRAY_BRACKETS_PARENS, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)",", (CharSequence)txt)) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_COMMA, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_COMMA, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)":", (CharSequence)txt)) {
                    if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration || parent instanceof LambdaFunctionDeclaration || parent instanceof ArrowFunctionDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_RETURN_TYPE_SEPARATOR, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_RETURN_TYPE_SEPARATOR, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof NamedArgument) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_NAMED_ARGUMENT_SEPARATOR, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_NAMED_ARGUMENT_SEPARATOR, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof EnumDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ENUM_BACKING_TYPE_SEPARATOR, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ENUM_BACKING_TYPE_SEPARATOR, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof FunctionInvocation) {
                        boolean added = false;
                        FunctionInvocation functionInvocation = (FunctionInvocation)parent;
                        List<Expression> parameters = functionInvocation.getParameters();
                        for (Expression parameter : parameters) {
                            if (!(parameter instanceof ASTErrorExpression) || this.ts.offset() < parameter.getStartOffset() || this.ts.offset() > parameter.getEndOffset()) continue;
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_NAMED_ARGUMENT_SEPARATOR, this.ts.offset()));
                            tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_NAMED_ARGUMENT_SEPARATOR, this.ts.offset() + this.ts.token().length()));
                            added = true;
                            break;
                        }
                        if (added) break;
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    break;
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_ATTRIBUTE: {
                tokens.add(new FormatToken(FormatToken.Kind.ATTRIBUTE_START, this.ts.offset(), this.ts.token().text().toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ATTRIBUTE_BRACKETS, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_OPERATOR: {
                CharSequence txt2 = this.ts.token().text();
                if (TokenUtilities.equals((CharSequence)txt2, (Object)"=") && this.path.get(0) instanceof DeclareStatement) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_DECLARE_EQUAL, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), txt2.toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_DECLARE_EQUAL, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (TokenUtilities.equals((CharSequence)txt2, (Object)"|") && this.path.get(0) instanceof UnionType) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNION_TYPE_SEPARATOR, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), txt2.toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNION_TYPE_SEPARATOR, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (TokenUtilities.equals((CharSequence)txt2, (Object)"&") && this.path.get(0) instanceof IntersectionType) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_INTERSECTION_TYPE_SEPARATOR, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), txt2.toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_INTERSECTION_TYPE_SEPARATOR, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (!TokenUtilities.startsWith((CharSequence)txt2, (CharSequence)"==") && TokenUtilities.endsWith((CharSequence)txt2, (CharSequence)"=")) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ASSIGN_OP, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_ASSIGN_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                int origOffset = this.ts.offset();
                if (TokenUtilities.textEquals((CharSequence)txt2, (CharSequence)"!")) {
                    if (this.ts.movePrevious()) {
                        Token<? extends PHPTokenId> previous = LexUtilities.findPrevious(this.ts, Arrays.asList(PHPTokenId.WHITESPACE));
                        if (previous.id() == PHPTokenId.PHP_RETURN) {
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_KEYWORD, origOffset));
                        }
                        this.ts.move(origOffset);
                        this.ts.moveNext();
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), txt2.toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)txt2, (CharSequence)"=>")) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_KEY_VALUE_OP, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), txt2.toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_KEY_VALUE_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)txt2, (CharSequence)"++") || TokenUtilities.textEquals((CharSequence)txt2, (CharSequence)"--")) {
                    Token<? extends PHPTokenId> previousToken = LexUtilities.findPrevious(this.ts, Arrays.asList(PHPTokenId.PHP_OPERATOR, PHPTokenId.WHITESPACE));
                    if (previousToken != null) {
                        if (previousToken.id() == PHPTokenId.PHP_VARIABLE || previousToken.id() == PHPTokenId.PHP_STRING || previousToken.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.equals((CharSequence)previousToken.text(), (Object)"]")) {
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset() + this.ts.token().length()));
                        } else if (previousToken.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.equals((CharSequence)previousToken.text(), (Object)".")) {
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE, this.ts.offset() + this.ts.token().length()));
                        }
                        this.ts.move(origOffset);
                        this.ts.moveNext();
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), txt2.toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (TokenUtilities.textEquals((CharSequence)txt2, (CharSequence)"|") && this.path.get(0) instanceof CatchClause) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_MULTI_CATCH_SEPARATOR, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_MULTI_CATCH_SEPARATOR, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_WHILE: {
                if (this.path.get(0) instanceof DoStatement && this.isCurly) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE, this.ts.offset()));
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_ELSE: 
            case PHP_ELSEIF: {
                if (this.isCurly) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ELSE, this.ts.offset()));
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_SEMICOLON: {
                if (!this.ts.movePrevious() || this.ts.token().id() != PHPTokenId.WHITESPACE || this.countOfNewLines(this.ts.token().text()) <= 0) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SEMI, this.ts.offset() + this.ts.token().length()));
                }
                this.ts.moveNext();
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                if (this.path.size() <= 0 || this.path.get(0) instanceof ForStatement) break;
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_SEMI, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_CATCH: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case PHP_FINALLY: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FINALLY, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
                break;
            }
            case T_INLINE_HTML: {
                FormatToken.InitToken token = (FormatToken.InitToken)this.formatTokens.get(0);
                if (!(token.hasHTML() || FormatVisitor.isWhitespace(this.ts.token().text()) || this.isShebang(this.ts.token().text()))) {
                    token.setHasHTML(true);
                }
                int tokenStartOffset = this.ts.offset();
                StringBuilder sb = new StringBuilder(this.ts.token().text());
                while (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.T_INLINE_HTML) {
                    sb.append(this.ts.token().text());
                }
                if (this.ts.moveNext()) {
                    this.ts.movePrevious();
                    this.ts.movePrevious();
                    tokens.add(new FormatToken(FormatToken.Kind.HTML, tokenStartOffset, sb.toString()));
                    break;
                }
                --this.lastIndex;
                break;
            }
            default: {
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), this.ts.token().text().toString()));
            }
        }
    }

    private List<FormatToken> resolveWhitespaceTokens() {
        LinkedList<FormatToken> result = new LinkedList<FormatToken>();
        int countNewLines = this.countOfNewLines(this.ts.token().text());
        if (countNewLines > 1) {
            this.resetAndCreateGroupAlignment();
        }
        String tokenText = this.ts.token().text().toString();
        int tokenStartOffset = this.ts.offset();
        if (countNewLines > 0) {
            result.add(new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, tokenStartOffset, this.adjustLastWhitespaceToken((Token<PHPTokenId>)this.ts.token())));
        } else {
            int tokenEndOffset = tokenStartOffset + this.ts.token().length();
            if (GsfUtilities.isCodeTemplateEditing((Document)this.document) && this.caretOffset > tokenStartOffset && this.caretOffset < tokenEndOffset && tokenStartOffset > this.startOffset && tokenEndOffset < this.endOffset) {
                int devideIndex = this.caretOffset - tokenStartOffset;
                String firstTextPart = tokenText.substring(0, devideIndex);
                result.add(new FormatToken(FormatToken.Kind.WHITESPACE, tokenStartOffset, firstTextPart));
                result.add(new FormatToken(FormatToken.Kind.WHITESPACE, tokenStartOffset + firstTextPart.length(), tokenText.substring(devideIndex)));
            } else {
                result.add(new FormatToken(FormatToken.Kind.WHITESPACE, tokenStartOffset, this.adjustLastWhitespaceToken((Token<PHPTokenId>)this.ts.token())));
            }
        }
        return result;
    }

    private String adjustLastWhitespaceToken(Token<PHPTokenId> token) {
        String result;
        boolean isLast;
        assert (token.id() == PHPTokenId.WHITESPACE);
        String tokenText = token.text().toString();
        if (this.ts.moveNext()) {
            isLast = false;
            this.ts.movePrevious();
        } else {
            isLast = true;
        }
        if (isLast) {
            int firstNewLineOffset = tokenText.indexOf(10);
            result = tokenText.substring(0, firstNewLineOffset) + tokenText.substring(firstNewLineOffset + 1);
        } else {
            result = tokenText;
        }
        return result;
    }

    private void addAllUntilOffset(int offset) {
        while (this.moveNext() && this.ts.offset() < offset && this.ts.offset() + this.ts.token().length() <= offset) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
    }

    private void addAllUntilOffset(int offset, String terminator) {
        while (this.moveNext() && this.ts.offset() < offset && this.ts.offset() + this.ts.token().length() <= offset && !TokenUtilities.textEquals((CharSequence)this.ts.token().text(), (CharSequence)terminator)) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
    }

    private void addRestOfLine() {
        while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_LINE_COMMENT && (this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0 || this.isComment((Token<? extends PHPTokenId>)this.ts.token()) || this.ts.token().id() == PHPTokenId.PHP_SEMICOLON) && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT || this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0) {
            this.addFormatToken(this.formatTokens);
            if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT && this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                this.addFormatToken(this.formatTokens);
            } else {
                this.ts.movePrevious();
            }
        } else {
            this.ts.movePrevious();
        }
    }

    private int countOfNewLines(CharSequence chs) {
        int count = 0;
        for (int i = 0; i < chs.length(); ++i) {
            if (chs.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private void addEndOfUnbreakableSequence(int endOffset) {
        boolean wasLastLineComment = false;
        while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0 || this.isComment((Token<? extends PHPTokenId>)this.ts.token())) && this.lastIndex < this.ts.index()) {
            if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT && !TokenUtilities.textEquals((CharSequence)"//", (CharSequence)this.ts.token().text())) {
                this.addFormatToken(this.formatTokens);
                wasLastLineComment = true;
                break;
            }
            this.addFormatToken(this.formatTokens);
        }
        if (wasLastLineComment) {
            while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.PHP_COMMENT_START || this.ts.token().id() == PHPTokenId.PHP_COMMENT_END || this.ts.token().id() == PHPTokenId.PHP_COMMENT)) {
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            FormatToken last = this.formatTokens.remove(this.formatTokens.size() - 1);
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length() - 1, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            this.formatTokens.add(last);
        } else {
            this.ts.movePrevious();
            if (this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0) {
                ArrayList<FormatToken> removedWhitespaces = new ArrayList<FormatToken>();
                do {
                    removedWhitespaces.add(this.formatTokens.remove(this.formatTokens.size() - 1));
                } while (this.formatTokens.get(this.formatTokens.size() - 1).isWhitespace());
                this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
                Collections.reverse(removedWhitespaces);
                for (FormatToken formatToken : removedWhitespaces) {
                    this.formatTokens.add(formatToken);
                }
            } else {
                this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            }
        }
    }

    private void addUnbreakalbeSequence(ASTNode node, boolean addAnchor) {
        FormatToken possibleWSToken;
        this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        this.addAllUntilOffset(node.getStartOffset());
        if (addAnchor) {
            this.formatTokens.add(new FormatToken.AnchorToken(this.ts.offset() + this.ts.token().length()));
        }
        this.scan(node);
        while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)this.ts.token()) || this.ts.token().id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)",", (CharSequence)this.ts.token().text())) && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        int index = this.formatTokens.size() - 1;
        FormatToken lastToken = this.formatTokens.get(index);
        FormatToken removedWS = null;
        if (lastToken.getId() == FormatToken.Kind.WHITESPACE || lastToken.getId() == FormatToken.Kind.WHITESPACE_INDENT) {
            removedWS = this.formatTokens.remove(this.formatTokens.size() - 1);
            lastToken = this.formatTokens.get(--index);
        } else if (lastToken.getId() == FormatToken.Kind.INDENT && index - 1 > 0 && (possibleWSToken = this.formatTokens.get(index - 1)).isWhitespace()) {
            removedWS = this.formatTokens.remove(index - 1);
            lastToken = this.formatTokens.get(index -= 2);
        }
        if (lastToken.getId() == FormatToken.Kind.WHITESPACE_AFTER_COMMA) {
            this.formatTokens.remove(index);
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            this.formatTokens.add(lastToken);
            if (removedWS != null) {
                this.formatTokens.add(removedWS);
            }
        } else if (lastToken.getId() == FormatToken.Kind.LINE_COMMENT && removedWS != null) {
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length() - 1, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            this.formatTokens.add(removedWS);
        } else {
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            if (removedWS != null) {
                this.formatTokens.add(removedWS);
            }
        }
    }

    private boolean isComment(Token<? extends PHPTokenId> token) {
        return token.id() == PHPTokenId.PHPDOC_COMMENT || token.id() == PHPTokenId.PHPDOC_COMMENT_END || token.id() == PHPTokenId.PHPDOC_COMMENT_START || token.id() == PHPTokenId.PHP_COMMENT || token.id() == PHPTokenId.PHP_COMMENT_END || token.id() == PHPTokenId.PHP_COMMENT_START || token.id() == PHPTokenId.PHP_LINE_COMMENT;
    }

    private boolean isPreviousNodeTheSameInBlock(ASTNode astNode, Statement statement) {
        int index = 0;
        List<Statement> statements = null;
        if (astNode instanceof Block) {
            statements = ((Block)astNode).getStatements();
        } else if (astNode instanceof Program) {
            statements = ((Program)astNode).getStatements();
        }
        if (statements != null) {
            while (index < statements.size() && statements.get(index).getStartOffset() < statement.getStartOffset()) {
                ++index;
            }
            return index < statements.size() && index > 0 && statements.get(index - 1).getClass().equals(statement.getClass());
        }
        return false;
    }

    private boolean isNextNodeTheSameInBlock(ASTNode astNode, Statement statement) {
        int index = 0;
        List<Statement> statements = null;
        if (astNode instanceof Block) {
            statements = ((Block)astNode).getStatements();
        } else if (astNode instanceof Program) {
            statements = ((Program)astNode).getStatements();
        }
        if (statements != null) {
            while (index < statements.size() && statements.get(index).getStartOffset() < statement.getStartOffset()) {
                ++index;
            }
            return index == statements.size() - 1 || index >= statements.size() - 1 || !statements.get(index + 1).getClass().equals(statement.getClass());
        }
        return false;
    }

    private void addNoCurlyBody(ASTNode body, FormatToken.Kind before) {
        this.addAllUntilOffset(body.getStartOffset());
        if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)")", (CharSequence)this.ts.token().text())) {
            this.addFormatToken(this.formatTokens);
        } else {
            this.ts.movePrevious();
        }
        this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
        if (!(body instanceof ASTError)) {
            this.formatTokens.add(new FormatToken(before, body.getStartOffset()));
        }
        this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(body.getStartOffset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        this.scan(body);
        this.addEndOfUnbreakableSequence(body.getEndOffset());
        this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
    }

    private boolean moveNext() {
        boolean value = this.ts.moveNext();
        if (value) {
            FormatToken last = this.formatTokens.get(this.formatTokens.size() - 1);
            value = last.getId() != FormatToken.Kind.TEXT || last.getOffset() < this.ts.offset();
        }
        return value;
    }

    private void handleGroupAlignment(int nodeLength, boolean multilined) {
        this.handleGroupAlignment(nodeLength, multilined, FormatToken.AssignmentAnchorToken.Type.ASSIGNMENT);
    }

    private void handleGroupAlignment(int nodeLength, boolean multilined, FormatToken.AssignmentAnchorToken.Type type) {
        GroupAlignmentTokenHolder tokenHolder;
        FormatToken.AssignmentAnchorToken previousGroupToken;
        if (this.groupAlignmentTokenHolders.isEmpty()) {
            this.createGroupAlignment();
        }
        if ((previousGroupToken = (tokenHolder = this.groupAlignmentTokenHolders.peek()).getToken()) == null) {
            previousGroupToken = new FormatToken.AssignmentAnchorToken(this.ts.offset(), multilined, type);
            previousGroupToken.setLength(nodeLength);
            previousGroupToken.setMaxLength(nodeLength);
        } else {
            FormatToken.AssignmentAnchorToken aaToken = new FormatToken.AssignmentAnchorToken(this.ts.offset(), multilined, type);
            aaToken.setLength(nodeLength);
            aaToken.setPrevious(previousGroupToken);
            aaToken.setIsInGroup(true);
            if (!previousGroupToken.isInGroup()) {
                previousGroupToken.setIsInGroup(true);
            }
            if (type == FormatToken.AssignmentAnchorToken.Type.MATCH_ARM) {
                FormatToken.AssignmentAnchorToken previousToken;
                int maxLength = this.getValidMaxLength(aaToken);
                previousGroupToken = aaToken;
                do {
                    aaToken.setMaxLength(maxLength);
                } while (((previousToken = aaToken.getPrevious()) == null || previousToken.getMaxLength() != maxLength) && (aaToken = previousToken) != null);
            } else if (previousGroupToken.getMaxLength() < nodeLength) {
                previousGroupToken = aaToken;
                do {
                    aaToken.setMaxLength(nodeLength);
                } while ((aaToken = aaToken.getPrevious()) != null);
            } else {
                aaToken.setMaxLength(previousGroupToken.getMaxLength());
                previousGroupToken = aaToken;
            }
        }
        tokenHolder.setToken(previousGroupToken);
        this.formatTokens.add(previousGroupToken);
    }

    private int getValidMaxLength(FormatToken.AssignmentAnchorToken assignmentAnchorToken) {
        int maxLength = assignmentAnchorToken.getLength();
        FormatToken.AssignmentAnchorToken aaToken = assignmentAnchorToken;
        int multilinedMaxLength = -1;
        do {
            int length = aaToken.getLength();
            maxLength = Integer.max(maxLength, length);
            if (!aaToken.isMultilined()) continue;
            multilinedMaxLength = Integer.max(multilinedMaxLength, length);
        } while ((aaToken = aaToken.getPrevious()) != null);
        return multilinedMaxLength != -1 ? multilinedMaxLength : maxLength;
    }

    private void handleGroupAlignment(int nodeLength) {
        this.handleGroupAlignment(nodeLength, false);
    }

    private void handleGroupAlignment(ASTNode node) {
        this.handleGroupAlignment(node.getEndOffset() - node.getStartOffset(), false);
    }

    private void handleGroupAlignment(ASTNode node, boolean multilined, FormatToken.AssignmentAnchorToken.Type type) {
        this.handleGroupAlignment(node.getEndOffset() - node.getStartOffset(), multilined, type);
    }

    private void handleGroupAlignment(List<? extends ASTNode> nodes, boolean multilined, FormatToken.AssignmentAnchorToken.Type type) {
        int start = nodes.get(0).getStartOffset();
        int end = nodes.get(nodes.size() - 1).getEndOffset();
        this.handleGroupAlignment(end - start, multilined, type);
    }

    private void resetAndCreateGroupAlignment() {
        this.resetGroupAlignment();
        this.createGroupAlignment();
    }

    private void resetGroupAlignment() {
        if (!this.groupAlignmentTokenHolders.isEmpty()) {
            this.groupAlignmentTokenHolders.pop();
        }
    }

    private void createGroupAlignment() {
        this.groupAlignmentTokenHolders.push(new GroupAlignmentTokenHolderImpl());
    }

    private boolean isFirstUseTraitStatementInBlock(ASTNode parentNode, UseTraitStatement node) {
        if (parentNode instanceof Block) {
            List<Statement> statements = ((Block)parentNode).getStatements();
            return !statements.isEmpty() && statements.get(0).equals(node);
        }
        return true;
    }

    private boolean isFieldTypeOrVariableToken(Token<PHPTokenId> token) {
        return PHPTokenId.PHP_VARIABLE == token.id() || this.isConstTypeToken(token);
    }

    private boolean isConstTypeToken(Token<PHPTokenId> token) {
        return PHPTokenId.PHP_STRING == token.id() || PHPTokenId.PHP_ARRAY == token.id() || PHPTokenId.PHP_ITERABLE == token.id() || PHPTokenId.PHP_PARENT == token.id() || PHPTokenId.PHP_SELF == token.id() || PHPTokenId.PHP_TYPE_BOOL == token.id() || PHPTokenId.PHP_TYPE_INT == token.id() || PHPTokenId.PHP_TYPE_FLOAT == token.id() || PHPTokenId.PHP_TYPE_OBJECT == token.id() || PHPTokenId.PHP_TYPE_STRING == token.id() || PHPTokenId.PHP_NULL == token.id() || PHPTokenId.PHP_FALSE == token.id() || PHPTokenId.PHP_NS_SEPARATOR == token.id() || PHPTokenId.PHP_TOKEN == token.id() && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"(") || PHPTokenId.PHP_TOKEN == token.id() && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"?") || PHPTokenId.PHP_TYPE_VOID == token.id() || PHPTokenId.PHP_CALLABLE == token.id() || PHPTokenId.PHP_TYPE_NEVER == token.id();
    }

    protected static boolean isWhitespace(CharSequence text) {
        int index;
        for (index = 0; index < text.length() && Character.isWhitespace(text.charAt(index)); ++index) {
        }
        return index == text.length();
    }

    private boolean isShebang(CharSequence text) {
        return TokenUtilities.startsWith((CharSequence)text, (CharSequence)"#!");
    }

    private static boolean isOpenParen(Token<? extends PHPTokenId> token) {
        return TokenUtilities.textEquals((CharSequence)"(", (CharSequence)token.text());
    }

    private static boolean isCloseParen(Token<? extends PHPTokenId> token) {
        return TokenUtilities.textEquals((CharSequence)")", (CharSequence)token.text());
    }

    private static boolean isAnonymousClass(ASTNode astNode) {
        ASTNode node = astNode;
        if (astNode instanceof NamedArgument) {
            node = ((NamedArgument)astNode).getExpression();
        }
        return node instanceof ClassInstanceCreation && ((ClassInstanceCreation)node).isAnonymous();
    }

    private static class GroupAlignmentTokenHolderImpl
    implements GroupAlignmentTokenHolder {
        private FormatToken.AssignmentAnchorToken token;

        private GroupAlignmentTokenHolderImpl() {
        }

        @Override
        public void setToken(FormatToken.AssignmentAnchorToken token) {
            this.token = token;
        }

        @Override
        public FormatToken.AssignmentAnchorToken getToken() {
            return this.token;
        }
    }

    private static interface GroupAlignmentTokenHolder {
        public void setToken(FormatToken.AssignmentAnchorToken var1);

        public FormatToken.AssignmentAnchorToken getToken();
    }
}

