/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.file.launcher.api.SourceLauncher;
import org.netbeans.modules.refactoring.java.plugins.LocalVarScanner;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class RefactoringUtils {
    private static final String JAVA_MIME_TYPE = "text/x-java";
    private static final Logger LOG = Logger.getLogger(RefactoringUtils.class.getName());

    @Deprecated
    public static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, CompilationInfo info) {
        return RefactoringUtils.getOverridenMethods(e, info.getElementUtilities().enclosingTypeElement((Element)e), info);
    }

    private static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, TypeElement parent, CompilationInfo info) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        TypeMirror sup = parent.getSuperclass();
        if (sup.getKind() == TypeKind.DECLARED) {
            TypeElement next = (TypeElement)((DeclaredType)sup).asElement();
            ExecutableElement executableElement = RefactoringUtils.getMethod(e, next, info);
            result.addAll(RefactoringUtils.getOverridenMethods(e, next, info));
            if (executableElement != null) {
                result.add(executableElement);
            }
        }
        for (TypeMirror typeMirror : parent.getInterfaces()) {
            TypeElement next = (TypeElement)((DeclaredType)typeMirror).asElement();
            ExecutableElement overriden2 = RefactoringUtils.getMethod(e, next, info);
            result.addAll(RefactoringUtils.getOverridenMethods(e, next, info));
            if (overriden2 == null) continue;
            result.add(overriden2);
        }
        return result;
    }

    private static ExecutableElement getMethod(ExecutableElement method, TypeElement type, CompilationInfo info) {
        for (ExecutableElement met : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (!info.getElements().overrides(method, met, type)) continue;
            return met;
        }
        return null;
    }

    public static Set<ElementHandle<TypeElement>> getImplementorsAsHandles(ClassIndex idx, ClasspathInfo cpInfo, TypeElement el, AtomicBoolean cancel) {
        LinkedList<ElementHandle<TypeElement>> elements = new LinkedList<ElementHandle<TypeElement>>(RefactoringUtils.implementorsQuery(idx, (ElementHandle<TypeElement>)ElementHandle.create((Element)el)));
        HashSet<ElementHandle<TypeElement>> result = new HashSet<ElementHandle<TypeElement>>();
        while (!elements.isEmpty()) {
            if (cancel.get()) {
                return Collections.emptySet();
            }
            ElementHandle<TypeElement> next = elements.removeFirst();
            if (!result.add(next)) continue;
            Set<ElementHandle<TypeElement>> foundElements = RefactoringUtils.implementorsQuery(idx, next);
            elements.addAll(foundElements);
        }
        return result;
    }

    private static Set<ElementHandle<TypeElement>> implementorsQuery(ClassIndex idx, ElementHandle<TypeElement> next) {
        return idx.getElements(next, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
    }

    @Deprecated
    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement e, CompilationInfo info, AtomicBoolean cancel) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        TypeElement parentType = (TypeElement)e.getEnclosingElement();
        Set<ElementHandle<TypeElement>> subTypes = RefactoringUtils.getImplementorsAsHandles(info.getClasspathInfo().getClassIndex(), info.getClasspathInfo(), parentType, cancel);
        for (ElementHandle<TypeElement> subTypeHandle : subTypes) {
            TypeElement type = (TypeElement)subTypeHandle.resolve(info);
            if (type == null) continue;
            LinkedList<ExecutableElement> methods = new LinkedList<ExecutableElement>(ElementFilter.methodsIn(type.getEnclosedElements()));
            if (type.getKind() == ElementKind.ENUM) {
                for (VariableElement variableElement : ElementFilter.fieldsIn(type.getEnclosedElements())) {
                    Element anonEl;
                    NewClassTree ncTree;
                    ClassTree classBody;
                    ExpressionTree initializer;
                    TreePath varPath = info.getTrees().getPath(variableElement);
                    if (varPath == null || varPath.getLeaf().getKind() != Tree.Kind.VARIABLE || (initializer = ((VariableTree)varPath.getLeaf()).getInitializer()) == null || initializer.getKind() != Tree.Kind.NEW_CLASS || (classBody = (ncTree = (NewClassTree)initializer).getClassBody()) == null || (anonEl = info.getTrees().getElement(new TreePath(varPath, classBody))) == null) continue;
                    methods.addAll(ElementFilter.methodsIn(anonEl.getEnclosedElements()));
                }
            }
            for (ExecutableElement method : methods) {
                if (!info.getElements().overrides(method, e, type)) continue;
                result.add(method);
            }
        }
        return result;
    }

    public static CodeStyle getCodeStyle(CompilationInfo info) {
        if (info != null) {
            try {
                Document doc = info.getDocument();
                if (doc != null) {
                    CodeStyle cs = (CodeStyle)doc.getProperty(CodeStyle.class);
                    return cs != null ? cs : CodeStyle.getDefault((Document)doc);
                }
            }
            catch (IOException doc) {
                // empty catch block
            }
            FileObject file = info.getFileObject();
            if (file != null) {
                return CodeStyle.getDefault((FileObject)file);
            }
        }
        return CodeStyle.getDefault((Document)null);
    }

    public static boolean isJavaFile(FileObject f) {
        return JAVA_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)f, (String[])new String[]{JAVA_MIME_TYPE}));
    }

    public static boolean isFromLibrary(ElementHandle<? extends Element> element, ClasspathInfo info) {
        FileObject file = SourceUtils.getFile(element, (ClasspathInfo)info);
        if (file == null) {
            return true;
        }
        return FileUtil.getArchiveFile((FileObject)file) != null;
    }

    public static boolean isValidPackageName(String name) {
        if (name.endsWith(".")) {
            return false;
        }
        if (name.startsWith(".")) {
            return false;
        }
        if (name.contains("..")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileInOpenProject(FileObject file) {
        assert (file != null);
        Future openProjects = OpenProjects.getDefault().openProjects();
        if (!openProjects.isDone()) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (p == null) {
            return SourceLauncher.isSourceLauncherFile((FileObject)file);
        }
        return RefactoringUtils.isOpenProject(p);
    }

    @Deprecated
    public static boolean isOnSourceClasspath(FileObject fo) {
        Project pr = FileOwnerQuery.getOwner((FileObject)fo);
        if (pr == null) {
            return false;
        }
        for (String type : new String[]{"java", "resources"}) {
            for (SourceGroup sg : ProjectUtils.getSources((Project)pr).getSourceGroups(type)) {
                if (fo != sg.getRootFolder() && (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo) || !sg.contains(fo))) continue;
                return ClassPath.getClassPath((FileObject)fo, (String)"classpath/source") != null;
            }
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fo) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        return cp != null ? fo.equals(cp.findOwnerRoot(fo)) : false;
    }

    @Deprecated
    public static boolean isRefactorable(FileObject file) {
        return file != null && RefactoringUtils.isJavaFile(file) && RefactoringUtils.isFileInOpenProject(file) && RefactoringUtils.isOnSourceClasspath(file);
    }

    public static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (cp == null) {
            throw new IllegalStateException(String.format("No classpath for %s.", folder.getPath()));
        }
        return cp.getResourceName(folder, '.', false);
    }

    public static String getPackageName(CompilationUnitTree unit) {
        assert (unit != null);
        ExpressionTree name = unit.getPackageName();
        if (name == null) {
            return "";
        }
        return name.toString();
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            f = FileUtil.normalizeFile((File)Utilities.toFile((URI)url.toURI()));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                if ("".equals(suffix)) {
                    return RefactoringUtils.getPackageName(fo);
                }
                String prefix = RefactoringUtils.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            suffix = f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1) + suffix;
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    public static FileObject getOrCreateFolder(URL url) throws IOException {
        try {
            FileObject result = URLMapper.findFileObject((URL)url);
            if (result != null) {
                return result;
            }
            File f = new File(url.toURI());
            result = FileUtil.createFolder((File)f);
            return result;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public static FileObject getClassPathRoot(URL url) throws IOException {
        FileObject result = RefactoringUtils.getRootFileObject(url);
        if (result == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)result, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        return classPath.findOwnerRoot(result);
    }

    @Deprecated
    public static Collection<TypeElement> getSuperTypes(TypeElement type, CompilationInfo info) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        LinkedList<TypeElement> l = new LinkedList<TypeElement>();
        l.add(type);
        while (!l.isEmpty()) {
            TypeElement t = (TypeElement)l.removeFirst();
            TypeElement superClass = RefactoringUtils.typeToElement(t.getSuperclass(), info);
            if (superClass != null) {
                result.add(superClass);
                l.addLast(superClass);
            }
            Collection<TypeElement> interfaces = RefactoringUtils.typesToElements(t.getInterfaces(), info);
            result.addAll(interfaces);
            l.addAll(interfaces);
        }
        return result;
    }

    @Deprecated
    public static Collection<TypeElement> getSuperTypes(TypeElement type, CompilationInfo info, boolean sourceOnly) {
        if (!sourceOnly) {
            return RefactoringUtils.getSuperTypes(type, info);
        }
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeElement el : RefactoringUtils.getSuperTypes(type, info)) {
            ElementHandle handle = ElementHandle.create((Element)el);
            FileObject file = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo());
            if (file == null || !RefactoringUtils.isFileInOpenProject(file) || RefactoringUtils.isFromLibrary((ElementHandle<? extends Element>)handle, info.getClasspathInfo())) continue;
            result.add(el);
        }
        return result;
    }

    public static TypeElement typeToElement(TypeMirror type, CompilationInfo info) {
        return (TypeElement)info.getTypes().asElement(type);
    }

    private static boolean isOpenProject(Project p) {
        return OpenProjects.getDefault().isProjectOpen(p);
    }

    private static Collection<TypeElement> typesToElements(Collection<? extends TypeMirror> types, CompilationInfo info) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeMirror typeMirror : types) {
            result.add(RefactoringUtils.typeToElement(typeMirror, info));
        }
        return result;
    }

    public static Collection<FileObject> elementsToFile(Collection<? extends Element> elements, ClasspathInfo cpInfo) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        for (Element element : elements) {
            result.add(SourceUtils.getFile((Element)element, (ClasspathInfo)cpInfo));
        }
        return result;
    }

    public static boolean elementExistsIn(TypeElement target, Element member, CompilationInfo info) {
        for (Element element : target.getEnclosedElements()) {
            if (element.getKind() != member.getKind() || !element.getSimpleName().equals(member.getSimpleName())) continue;
            if (element.getKind() == ElementKind.METHOD) {
                ExecutableElement exMethod = (ExecutableElement)element;
                ExecutableElement method = (ExecutableElement)member;
                if (exMethod.getParameters().size() != method.getParameters().size()) continue;
                boolean sameParameters = true;
                for (int j = 0; j < exMethod.getParameters().size(); ++j) {
                    TypeMirror exType = exMethod.getParameters().get(j).asType();
                    TypeMirror paramType = method.getParameters().get(j).asType();
                    if (info.getTypes().isSameType(exType, paramType)) continue;
                    sameParameters = false;
                }
                if (!sameParameters) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean typeExists(String fqn, CompilationInfo info) {
        return info.getElements().getTypeElement(fqn) != null;
    }

    @Deprecated
    public static ClasspathInfo getClasspathInfoFor(FileObject ... files) {
        return RefactoringUtils.getClasspathInfoFor(true, files);
    }

    public static ClasspathInfo getClasspathInfoFor(boolean dependencies, FileObject ... files) {
        return RefactoringUtils.getClasspathInfoFor(dependencies, false, files);
    }

    public static ClasspathInfo getClasspathInfoFor(boolean dependencies, boolean backSource, FileObject ... files) {
        assert (files.length > 0);
        HashSet<URL> dependentSourceRoots = new HashSet<URL>();
        HashSet dependentCompileRoots = new HashSet();
        ClassPath nullPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath boot = null;
        ClassPath moduleBoot = null;
        ClassPath compile = null;
        ClassPath moduleCompile = null;
        ClassPath moduleClass = null;
        for (FileObject fo : files) {
            ClassPath cp = null;
            FileObject ownerRoot = null;
            if (fo != null && (cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) != null) {
                ownerRoot = cp.findOwnerRoot(fo);
            }
            if (cp != null && ownerRoot != null && FileUtil.getArchiveFile(ownerRoot) == null) {
                for (FileObject src : cp.getRoots()) {
                    URL sourceRoot = URLMapper.findURL((FileObject)src, (int)0);
                    if (dependencies) {
                        FileObject[] urls = SourceUtils.getDependentRoots((URL)sourceRoot, (boolean)false);
                        Set cps = GlobalPathRegistry.getDefault().getPaths("classpath/source");
                        HashSet<URL> toRetain = new HashSet<URL>();
                        for (ClassPath path : cps) {
                            for (ClassPath.Entry e : path.entries()) {
                                toRetain.add(e.getURL());
                            }
                        }
                        HashSet compileUrls = new HashSet(urls);
                        urls.retainAll(toRetain);
                        compileUrls.removeAll(toRetain);
                        dependentSourceRoots.addAll((Collection<URL>)urls);
                        dependentCompileRoots.addAll(compileUrls);
                    } else {
                        dependentSourceRoots.add(sourceRoot);
                    }
                    if (FileOwnerQuery.getOwner((FileObject)fo) == null) continue;
                    for (FileObject f : cp.getRoots()) {
                        dependentCompileRoots.add(URLMapper.findURL((FileObject)f, (int)0));
                    }
                }
            } else {
                for (ClassPath scp : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                    for (FileObject root : scp.getRoots()) {
                        dependentSourceRoots.add(URLMapper.findURL((FileObject)root, (int)0));
                    }
                }
            }
            if (fo == null) continue;
            ClassPath fboot = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
            ClassPath fmoduleboot = ClassPath.getClassPath((FileObject)fo, (String)"modules/boot");
            ClassPath fcompile = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
            ClassPath fmodulecompile = ClassPath.getClassPath((FileObject)fo, (String)"modules/compile");
            ClassPath fmoduleclass = ClassPath.getClassPath((FileObject)fo, (String)"modules/classpath");
            if (fcompile == null) {
                fcompile = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
            }
            if (fcompile == null) {
                LOG.log(Level.WARNING, "No classpath for: {0} {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)fo), FileOwnerQuery.getOwner((FileObject)fo)});
            } else {
                ClassPath classPath = compile = compile != null ? RefactoringUtils.merge(compile, fcompile) : fcompile;
            }
            if (fboot != null) {
                ClassPath classPath = boot = boot != null ? RefactoringUtils.merge(boot, fboot) : fboot;
            }
            if (fmoduleboot != null) {
                ClassPath classPath = moduleBoot = moduleBoot != null ? RefactoringUtils.merge(moduleBoot, fmoduleboot) : fmoduleboot;
            }
            if (fmodulecompile != null) {
                ClassPath classPath = moduleCompile = moduleCompile != null ? RefactoringUtils.merge(moduleCompile, fmodulecompile) : fmodulecompile;
            }
            if (fmoduleclass == null) continue;
            moduleClass = moduleClass != null ? RefactoringUtils.merge(moduleClass, fmoduleclass) : fmoduleclass;
        }
        if (backSource) {
            for (FileObject file : files) {
                if (file == null) continue;
                ClassPath source = ClassPath.getClassPath((FileObject)file, (String)"classpath/compile");
                for (ClassPath.Entry root : source.entries()) {
                    SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)root.getURL());
                    for (FileObject root2 : r.getRoots()) {
                        dependentSourceRoots.add(URLMapper.findURL((FileObject)root2, (int)0));
                    }
                }
            }
        }
        ClassPath rcp = ClassPathSupport.createClassPath((URL[])dependentSourceRoots.toArray(new URL[dependentSourceRoots.size()]));
        if (compile == null) {
            compile = nullPath;
        }
        compile = RefactoringUtils.merge(compile, ClassPathSupport.createClassPath((URL[])dependentCompileRoots.toArray(new URL[dependentCompileRoots.size()])));
        if (boot == null) {
            boot = JavaPlatform.getDefault().getBootstrapLibraries();
        }
        return new ClasspathInfo.Builder(boot == null ? nullPath : boot).setModuleBootPath(moduleBoot == null ? (boot == null ? nullPath : boot) : moduleBoot).setClassPath(compile).setModuleCompilePath(moduleCompile).setModuleClassPath(moduleClass).setSourcePath(rcp).build();
    }

    public static FileObject getFileObject(TreePathHandle handle) {
        ElementHandle elementHandle = handle.getElementHandle();
        if (elementHandle == null) {
            return handle.getFileObject();
        }
        ClasspathInfo info = RefactoringUtils.getClasspathInfoFor(false, handle.getFileObject());
        return SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)info);
    }

    public static ClasspathInfo getClasspathInfoFor(TreePathHandle ... handles) {
        FileObject[] result = new FileObject[handles.length];
        int i = 0;
        for (TreePathHandle handle : handles) {
            FileObject fo = RefactoringUtils.getFileObject(handle);
            if (i == 0 && fo == null) {
                result = new FileObject[handles.length + 1];
                result[i++] = handle.getFileObject();
            }
            result[i++] = fo;
        }
        return RefactoringUtils.getClasspathInfoFor(result);
    }

    public static void findUsedGenericTypes(Types utils, List<TypeMirror> typeArgs, Set<TypeMirror> result, TypeMirror tm) {
        if (typeArgs.isEmpty()) {
            return;
        }
        if (tm.getKind() == TypeKind.TYPEVAR) {
            TypeVariable type = (TypeVariable)tm;
            int index = RefactoringUtils.findTypeIndex(utils, typeArgs, type);
            if (index >= 0) {
                result.add(typeArgs.get(index));
            } else {
                int idx;
                TypeMirror up;
                TypeMirror typeMirror = type.getLowerBound();
                if (typeMirror != null && typeMirror.getKind() != TypeKind.NULL) {
                    RefactoringUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
                }
                if ((up = type.getUpperBound()) != null) {
                    RefactoringUtils.findUsedGenericTypes(utils, typeArgs, result, up);
                }
                if ((idx = RefactoringUtils.findTypeIndex(utils, typeArgs, type)) >= 0) {
                    result.add(typeArgs.get(idx));
                }
            }
        } else if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)tm;
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                RefactoringUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
        } else if (tm.getKind() == TypeKind.WILDCARD) {
            TypeMirror typeMirror;
            WildcardType type = (WildcardType)tm;
            TypeMirror ex = type.getExtendsBound();
            if (ex != null) {
                RefactoringUtils.findUsedGenericTypes(utils, typeArgs, result, ex);
            }
            if ((typeMirror = type.getSuperBound()) != null) {
                RefactoringUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
        }
    }

    private static int findTypeIndex(Types utils, List<TypeMirror> typeArgs, TypeMirror type) {
        int i = -1;
        for (TypeMirror typeArg : typeArgs) {
            ++i;
            if (!utils.isSameType(type, typeArg)) continue;
            return i;
        }
        return -1;
    }

    public static List<TypeMirror> filterTypes(List<TypeMirror> source, Set<TypeMirror> used) {
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(source.size());
        for (TypeMirror tm : source) {
            if (!used.contains(tm)) continue;
            result.add(tm);
        }
        return result;
    }

    @Deprecated
    public static List<TypeMirror> resolveTypeParamsAsTypes(List<? extends Element> typeParams) {
        if (typeParams.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> typeArgs = new ArrayList<TypeMirror>(typeParams.size());
        for (Element element : typeParams) {
            typeArgs.add(element.asType());
        }
        return typeArgs;
    }

    @Deprecated
    @NullUnknown
    public static TreePath findEnclosingClass(CompilationInfo javac, TreePath path, boolean isClass, boolean isInterface, boolean isEnum, boolean isAnnotation, boolean isAnonymous) {
        if (path == null) {
            return null;
        }
        Tree selectedTree = path.getLeaf();
        TreeUtilities utils = javac.getTreeUtilities();
        while (true) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)selectedTree.getKind())) {
                ClassTree classTree = (ClassTree)selectedTree;
                if (isEnum && utils.isEnum(classTree) || isInterface && utils.isInterface(classTree) || isAnnotation && utils.isAnnotation(classTree) || isClass && !utils.isInterface(classTree) && !utils.isEnum(classTree) && !utils.isAnnotation(classTree)) {
                    Tree.Kind parentKind = path.getParentPath().getLeaf().getKind();
                    if (isAnonymous || Tree.Kind.NEW_CLASS != parentKind) break;
                }
            }
            if ((path = path.getParentPath()) == null) {
                List<? extends Tree> typeDecls = javac.getCompilationUnit().getTypeDecls();
                if (typeDecls.isEmpty()) {
                    return null;
                }
                selectedTree = typeDecls.get(0);
                if (selectedTree.getKind().asInterface() == ClassTree.class) {
                    return javac.getTrees().getPath(javac.getCompilationUnit(), selectedTree);
                }
                return null;
            }
            selectedTree = path.getLeaf();
        }
        return path;
    }

    public static CompilationUnitTree addImports(CompilationUnitTree cut, List<String> toImport, TreeMaker make) throws IOException {
        toImport = new ArrayList<String>(toImport);
        Collections.sort(toImport);
        ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cut.getImports());
        int currentToImport = toImport.size() - 1;
        int currentExisting = imports.size() - 1;
        while (currentToImport >= 0 && currentExisting >= 0) {
            String currentToImportText = toImport.get(currentToImport);
            while (currentExisting >= 0 && (((ImportTree)imports.get(currentExisting)).isStatic() || ((ImportTree)imports.get(currentExisting)).getQualifiedIdentifier().toString().compareTo(currentToImportText) > 0)) {
                --currentExisting;
            }
            if (currentExisting < 0) continue;
            imports.add(currentExisting + 1, make.Import((Tree)make.Identifier((CharSequence)currentToImportText), false));
            --currentToImport;
        }
        while (currentToImport >= 0) {
            String importText = toImport.get(currentToImport);
            imports.add(0, make.Import((Tree)make.Identifier((CharSequence)importText), false));
            --currentToImport;
        }
        return make.CompilationUnit(cut.getPackageAnnotations(), cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile());
    }

    public static ModifiersTree makeAbstract(TreeMaker make, ModifiersTree oldMods) {
        if (oldMods.getFlags().contains((Object)Modifier.ABSTRACT)) {
            return oldMods;
        }
        EnumSet<Modifier> flags = EnumSet.of(Modifier.ABSTRACT);
        flags.addAll(oldMods.getFlags());
        flags.remove((Object)Modifier.FINAL);
        return make.Modifiers(flags, oldMods.getAnnotations());
    }

    public static String variableClashes(String newName, TreePath tp, CompilationInfo info) {
        TreePath scopeBlok;
        LocalVarScanner lookup = new LocalVarScanner(info, newName);
        EnumSet<Tree.Kind> set = EnumSet.of(Tree.Kind.BLOCK, Tree.Kind.FOR_LOOP, Tree.Kind.METHOD);
        for (scopeBlok = tp; scopeBlok != null && !set.contains((Object)scopeBlok.getLeaf().getKind()); scopeBlok = scopeBlok.getParentPath()) {
        }
        if (scopeBlok == null) {
            return null;
        }
        Element var = info.getTrees().getElement(tp);
        if (var != null) {
            lookup.scan(scopeBlok, var);
        }
        if (lookup.hasRefernces()) {
            return NbBundle.getMessage(RefactoringUtils.class, (String)"MSG_LocVariableClash", (Object)newName);
        }
        for (TreePath temp = tp; temp != null && temp.getLeaf().getKind() != Tree.Kind.METHOD; temp = temp.getParentPath()) {
            Scope scope = info.getTrees().getScope(temp);
            for (Element element : scope.getLocalElements()) {
                if (!element.getSimpleName().toString().equals(newName)) continue;
                return NbBundle.getMessage(RefactoringUtils.class, (String)"MSG_LocVariableClash", (Object)newName);
            }
        }
        return null;
    }

    public static boolean isSetter(CompilationInfo info, ExecutableElement el, Element propertyElement) {
        CodeStyle codeStyle = RefactoringUtils.getCodeStyle(info);
        String setterName = CodeStyleUtils.computeSetterName((CharSequence)propertyElement.getSimpleName(), (boolean)propertyElement.getModifiers().contains((Object)Modifier.STATIC), (CodeStyle)codeStyle);
        return el.getSimpleName().contentEquals(setterName) && el.getReturnType().getKind() == TypeKind.VOID && el.getParameters().size() == 1 && info.getTypes().isSameType(el.getParameters().iterator().next().asType(), propertyElement.asType());
    }

    public static boolean isGetter(CompilationInfo info, ExecutableElement el, Element propertyElement) {
        CodeStyle codeStyle = RefactoringUtils.getCodeStyle(info);
        String getterName = CodeStyleUtils.computeGetterName((CharSequence)propertyElement.getSimpleName(), (propertyElement.asType().getKind() == TypeKind.BOOLEAN ? 1 : 0) != 0, (boolean)propertyElement.getModifiers().contains((Object)Modifier.STATIC), (CodeStyle)codeStyle);
        return el.getSimpleName().contentEquals(getterName) && info.getTypes().isSameType(el.getReturnType(), propertyElement.asType()) && el.getParameters().isEmpty();
    }

    public static String removeFieldPrefixSuffix(Element var, CodeStyle cs) {
        boolean isStatic = var.getModifiers().contains((Object)Modifier.STATIC);
        return CodeStyleUtils.removePrefixSuffix((CharSequence)var.getSimpleName(), (String)(isStatic ? cs.getStaticFieldNamePrefix() : cs.getFieldNamePrefix()), (String)(isStatic ? cs.getStaticFieldNameSuffix() : cs.getFieldNameSuffix()));
    }

    public static String addParamPrefixSuffix(CharSequence name, CodeStyle cs) {
        return CodeStyleUtils.addPrefixSuffix((CharSequence)name, (String)cs.getParameterNamePrefix(), (String)cs.getParameterNameSuffix());
    }

    public static String getTestMethodName(String propertyName) {
        return "test" + CodeStyleUtils.getCapitalizedName((CharSequence)propertyName);
    }

    public static boolean isWeakerAccess(Set<Modifier> modifiers, Set<Modifier> modifiers0) {
        return RefactoringUtils.accessLevel(modifiers) < RefactoringUtils.accessLevel(modifiers0);
    }

    private static int accessLevel(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return 0;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        return 1;
    }

    public static String getAccess(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return "private";
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return "protected";
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return "public";
        }
        return "<default>";
    }

    public static boolean isFromTestRoot(FileObject file, ClassPath cp) {
        FileObject root;
        boolean inTest = false;
        if (cp != null && (root = cp.findOwnerRoot(file)) != null && UnitTestForSourceQuery.findSources((FileObject)root).length > 0) {
            inTest = true;
        }
        return inTest;
    }

    public static FileObject getRootFileObject(URL url) throws IOException {
        FileObject result = URLMapper.findFileObject((URL)url);
        try {
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        for (File f = result != null ? null : FileUtil.normalizeFile((File)Utilities.toFile((URI)url.toURI())); result == null && f != null; f = f.getParentFile()) {
            result = FileUtil.toFileObject((File)f);
        }
        return result;
    }

    public static ClassPath merge(ClassPath ... cps) {
        LinkedHashSet<URL> roots = new LinkedHashSet<URL>(cps.length);
        for (ClassPath cp : cps) {
            if (cp == null) continue;
            for (ClassPath.Entry entry : cp.entries()) {
                URL root = entry.getURL();
                if (roots.contains(root)) continue;
                roots.add(root);
            }
        }
        return ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
    }

    public static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && NbDocument.findRecentEditorPane((EditorCookie)ec) != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public static boolean isExecutableElement(Element e) {
        if (e == null) {
            return false;
        }
        ElementKind ek = e.getKind();
        return ek == ElementKind.CONSTRUCTOR || ek == ElementKind.METHOD;
    }

    private RefactoringUtils() {
    }
}

