/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.editor.lsp.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cpplite.editor.Utils;
import org.netbeans.modules.cpplite.editor.lsp.options.CPPLiteOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CPPLitePanel
extends JPanel {
    private final CPPLiteOptionsPanelController controller;
    private JButton cclsBrowse;
    private JTextField cclsPath;
    private JButton clangdBrowse;
    private JTextField clangdPath;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    CPPLitePanel(final CPPLiteOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        DocumentListener pathsModified = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                controller.changed();
            }
        };
        this.cclsPath.getDocument().addDocumentListener(pathsModified);
        this.clangdPath.getDocument().addDocumentListener(pathsModified);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cclsPath = new JTextField();
        this.cclsBrowse = new JButton();
        this.jLabel2 = new JLabel();
        this.clangdPath = new JTextField();
        this.clangdBrowse = new JButton();
        this.jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.jLabel1.text"));
        this.cclsPath.setText(NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.cclsPath.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cclsBrowse, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.cclsBrowse.text"));
        this.cclsBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPPLitePanel.this.cclsBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.jLabel2.text"));
        this.clangdPath.setText(NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.clangdPath.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.clangdBrowse, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.clangdBrowse.text"));
        this.clangdBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CPPLitePanel.this.clangdBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CPPLitePanel.class, (String)"CPPLitePanel.jLabel3.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cclsPath).addComponent(this.clangdPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clangdBrowse).addComponent(this.cclsBrowse))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cclsPath, -2, -1, -2).addComponent(this.cclsBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.clangdPath, -2, -1, -2).addComponent(this.clangdBrowse)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cclsBrowseActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.cclsPath);
    }

    private void clangdBrowseActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.clangdPath);
    }

    private void showFileChooser(JTextField path) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File(path.getText()));
        if (fc.showDialog(this, "Select") == 0) {
            path.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    void load() {
        this.cclsPath.setText(Utils.getCCLSPath());
        this.clangdPath.setText(Utils.getCLANGDPath());
    }

    void store() {
        Utils.settings().put("ccls", this.cclsPath.getText());
        Utils.settings().put("clangd", this.clangdPath.getText());
    }

    boolean valid() {
        return true;
    }
}

