/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.awt.EventQueue;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.BranchMapping;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.fetch.FetchBranchesStep;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class PullBranchesStep
extends AbstractWizardPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private GitRemoteConfig remote;
    private final File repository;
    private final ItemSelector<BranchMapping> branches;
    private String mergingBranch;
    private GitBranch currentBranch;
    private static final String REMOTE_BRANCH_NAME_WITH_REMOTE = "{0}/{1}";
    private boolean candidatesEmpty;

    public PullBranchesStep(File repository) {
        this.repository = repository;
        this.branches = new ItemSelector(NbBundle.getMessage(PullBranchesStep.class, (String)"FetchBranchesPanel.jLabel1.text"));
        this.branches.addChangeListener(this);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                PullBranchesStep.this.validateBeforeNext();
            }
        });
        this.getJComponent().setName(NbBundle.getMessage(PullBranchesStep.class, (String)"LBL_FetchBranches.remoteBranches"));
    }

    @Override
    protected final boolean validateBeforeNext() {
        this.setValid(true, null);
        if (this.branches.getSelectedBranches().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(Bundle.MSG_PullBranchesPanel_errorNoBranchSelected(), true));
        } else {
            StringBuilder sb;
            boolean info;
            if (this.mergingBranch != null) {
                info = true;
                sb = this.currentBranch == null ? new StringBuilder(Bundle.MSG_PullBranchesStep_noCurrentBranch(this.mergingBranch)) : new StringBuilder(Bundle.MSG_PullBranchesStep_mergingBranch(this.mergingBranch, this.currentBranch.getName()));
            } else {
                info = false;
                sb = this.candidatesEmpty ? new StringBuilder(Bundle.MSG_PullBranchesPanel_warningNoBranchToMerge()) : new StringBuilder(Bundle.MSG_PullBranchesPanel_warningMultipleCandidatesToMerge());
            }
            String msgDeletedBranches = FetchBranchesStep.getDeletedBranchesMessage(this.branches.getSelectedBranches());
            if (msgDeletedBranches != null) {
                sb.append("<br>").append(msgDeletedBranches);
            }
            this.setValid(true, new AbstractWizardPanel.Message(sb.toString(), info));
        }
        return this.isValid();
    }

    @Override
    protected final JComponent getJComponent() {
        return this.branches.getPanel();
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.git.ui.fetch.PullBranchesStep");
    }

    public void setRemote(GitRemoteConfig remote) {
        this.remote = remote;
        this.validateBeforeNext();
    }

    public void fillRemoteBranches(final Map<String, GitBranch> branches) {
        this.fillRemoteBranches(Collections.emptyMap(), Collections.emptyMap());
        new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                final HashMap<String, GitBranch> localBranches = new HashMap<String, GitBranch>();
                RepositoryInfo info = RepositoryInfo.getInstance(PullBranchesStep.this.repository);
                info.refresh();
                localBranches.putAll(info.getBranches());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PullBranchesStep.this.fillRemoteBranches(branches, localBranches);
                    }
                });
            }
        }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(PullBranchesStep.class, (String)"MSG_FetchBranchesPanel.loadingLocalBranches"));
    }

    private void fillRemoteBranches(Map<String, GitBranch> branches, Map<String, GitBranch> localBranches) {
        ArrayList<BranchMapping> l = new ArrayList<BranchMapping>(branches.size());
        HashSet<String> displayedBranches = new HashSet<String>(localBranches.size());
        for (GitBranch branch : localBranches.values()) {
            if (!branch.isActive()) continue;
            this.currentBranch = branch;
        }
        for (GitBranch branch : branches.values()) {
            String branchName = this.remote.getRemoteName() + "/" + branch.getName();
            displayedBranches.add(branchName);
            GitBranch localBranch = localBranches.get(branchName);
            boolean preselected = localBranch != null && (!localBranch.getId().equals(branch.getId()) || this.currentBranch != null && this.currentBranch.getTrackedBranch() != null && this.currentBranch.getTrackedBranch().getName().equals(localBranch.getName()));
            l.add(new BranchMapping(branch.getName(), branch.getId(), localBranch, this.remote, preselected));
        }
        for (GitBranch branch : localBranches.values()) {
            if (!branch.isRemote() || displayedBranches.contains(branch.getName()) || !branch.getName().startsWith(this.remote.getRemoteName() + "/")) continue;
            l.add(new BranchMapping(null, null, branch, this.remote, false));
        }
        this.branches.setBranches(l);
        this.stateChanged(new ChangeEvent(this));
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.markMergingBranch();
        this.validateBeforeNext();
    }

    public String getBranchToMerge() {
        return this.mergingBranch;
    }

    public List<String> getSelectedRefSpecs() {
        LinkedList<String> specs = new LinkedList<String>();
        for (BranchMapping b : this.branches.getSelectedBranches()) {
            specs.add(b.getRefSpec());
        }
        return specs;
    }

    public boolean isFinishPanel() {
        return true;
    }

    private void markMergingBranch() {
        this.mergingBranch = null;
        ArrayList<BranchMapping> candidates = new ArrayList<BranchMapping>(this.branches.getSelectedBranches().size());
        for (BranchMapping mapping : this.branches.getSelectedBranches()) {
            if (mapping.isDestructive()) continue;
            candidates.add(mapping);
        }
        BranchMapping toMerge = null;
        this.candidatesEmpty = candidates.isEmpty();
        if (candidates.size() == 1) {
            toMerge = (BranchMapping)candidates.get(0);
        } else {
            for (BranchMapping mapping : candidates) {
                GitBranch tracked = this.currentBranch == null ? null : this.currentBranch.getTrackedBranch();
                if (tracked == null || mapping.getLocalBranch() == null || !tracked.getName().equals(mapping.getLocalBranch().getName())) continue;
                toMerge = mapping;
                break;
            }
        }
        if (toMerge != null) {
            this.mergingBranch = MessageFormat.format(REMOTE_BRANCH_NAME_WITH_REMOTE, toMerge.getRemoteName(), toMerge.getRemoteBranchName());
        }
    }
}

