/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco.archive;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.netbeans.modules.java.disco.archive.Unarchiver;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.InputOutput;

public abstract class AbstractCommandLineUnarchiver
implements Unarchiver {
    protected abstract @NonNull String[] getProbeCommand();

    protected abstract @NonNull String[] getCommand(@NonNull File var1, @NonNull File var2);

    protected abstract @NonNull String getName();

    private boolean probe() {
        try {
            Process probe = new ProcessBuilder(new String[0]).command(this.getProbeCommand()).start();
            if (!probe.waitFor(10L, TimeUnit.SECONDS) || probe.exitValue() != 0) {
                probe.destroyForcibly();
                return false;
            }
        }
        catch (IOException | InterruptedException ioe) {
            return false;
        }
        return true;
    }

    @Override
    public void uncompress(File zipFile, File targetDir, final InputOutput io) throws InterruptedException, IOException {
        if (!this.isSupported(zipFile)) {
            throw new UnsupportedOperationException();
        }
        if (!this.probe()) {
            throw new UnsupportedOperationException(this.getName() + " not available");
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        final Process unzip = pb.command(this.getCommand(zipFile, targetDir)).start();
        io.getOut().println("Running : " + pb.command().toString());
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    String s;
                    InputStream cliIO = unzip.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(cliIO));
                    while ((s = br.readLine()) != null) {
                        io.getOut().println(s);
                    }
                }
                catch (IOException ex) {
                    io.getOut().append((CharSequence)"Exception ").append(ex.toString()).println();
                }
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    String s;
                    InputStream cliIO = unzip.getErrorStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(cliIO));
                    while ((s = br.readLine()) != null) {
                        if (IOColorLines.isSupported((InputOutput)io)) {
                            IOColorLines.println((InputOutput)io, (CharSequence)s, (Color)Color.RED);
                            continue;
                        }
                        io.getOut().println(s);
                    }
                }
                catch (IOException ex) {
                    io.getOut().append((CharSequence)"Exception ").append(ex.toString()).println();
                }
            }
        });
        int exitCode = unzip.waitFor();
        io.getOut().println("Exit code: " + exitCode);
        if (0 != exitCode) {
            throw new IOException(this.getName() + " failed");
        }
    }
}

