/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public final class Utils {
    private static final String CONTROLLER_ANNOTATION_NAME = "io.micronaut.http.annotation.Controller";
    private static final String GET_ANNOTATION_NAME = "io.micronaut.http.annotation.Get";
    private static final String DELETE_ANNOTATION_NAME = "io.micronaut.http.annotation.Delete";
    private static final String CRUD_REPOSITORY_TYPE_NAME = "io.micronaut.data.repository.CrudRepository";
    private static final String COMPLETION_CASE_SENSITIVE = "completion-case-sensitive";
    private static final boolean COMPLETION_CASE_SENSITIVE_DEFAULT = true;
    private static final String JAVA_COMPLETION_SUBWORDS = "javaCompletionSubwords";
    private static final boolean JAVA_COMPLETION_SUBWORDS_DEFAULT = false;
    private static final PreferenceChangeListener preferencesTracker = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || Utils.COMPLETION_CASE_SENSITIVE.equals(settingName)) {
                caseSensitive = preferences.getBoolean(Utils.COMPLETION_CASE_SENSITIVE, true);
            }
            if (settingName == null || Utils.JAVA_COMPLETION_SUBWORDS.equals(settingName)) {
                javaCompletionSubwords = preferences.getBoolean(Utils.JAVA_COMPLETION_SUBWORDS, false);
            }
        }
    };
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private static Preferences preferences;
    private static boolean caseSensitive;
    private static boolean javaCompletionSubwords;
    private static String cachedPrefix;
    private static Pattern cachedCamelCasePattern;
    private static Pattern cachedSubwordsPattern;

    public static List<VariableElement> collectMissingDataEndpoints(CompilationInfo info, TypeElement te, String prefix, DataEndpointConsumer consumer) {
        AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), CONTROLLER_ANNOTATION_NAME);
        if (controllerAnn == null) {
            return Collections.emptyList();
        }
        List<VariableElement> repositories = Utils.getRepositoriesFor(info, te);
        if (!repositories.isEmpty()) {
            String controllerId = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : controllerAnn.getElementValues().entrySet()) {
                if (!"value".contentEquals(entry.getKey().getSimpleName()) && !"uri".contentEquals(entry.getKey().getSimpleName())) continue;
                controllerId = (String)entry.getValue().getValue();
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
            for (VariableElement repository : repositories) {
                String deleteMethodName;
                Optional<ExecutableElement> method;
                String getMethodName;
                Object method22;
                TypeMirror repositoryType = repository.asType();
                if (repositoryType.getKind() != TypeKind.DECLARED) continue;
                TypeElement repositoryTypeElement = (TypeElement)((DeclaredType)repositoryType).asElement();
                String id = null;
                if (repositories.size() > 1) {
                    id = '/' + repositoryTypeElement.getSimpleName().toString().toLowerCase();
                    if (id.endsWith("repository")) {
                        id = id.substring(0, id.length() - 10);
                    }
                    if (controllerId != null && !controllerId.equals(id)) continue;
                }
                List<ExecutableElement> repositoryMethods = ElementFilter.methodsIn(info.getElements().getAllMembers(repositoryTypeElement));
                String listMethodName = Utils.getEndpointMethodName("findAll", id);
                if (Utils.startsWith(listMethodName, prefix) && Utils.getAnnotatedMethod(methods, listMethodName, GET_ANNOTATION_NAME, id) == null) {
                    Object delegateMethod = null;
                    for (Object method22 : repositoryMethods.stream().filter(el -> "findAll".contentEquals(el.getSimpleName())).collect(Collectors.toList())) {
                        TypeMirror paramType;
                        List<? extends VariableElement> params = method22.getParameters();
                        if (delegateMethod == null && params.isEmpty()) {
                            delegateMethod = method22;
                            continue;
                        }
                        if (params.size() != 1 || (paramType = params.get(0).asType()).getKind() != TypeKind.DECLARED || !"io.micronaut.data.model.Pageable".contentEquals(((TypeElement)((DeclaredType)paramType).asElement()).getQualifiedName())) continue;
                        delegateMethod = method22;
                    }
                    if (delegateMethod != null) {
                        consumer.accept(repository, (ExecutableElement)delegateMethod, id);
                    }
                }
                if (Utils.startsWith(getMethodName = Utils.getEndpointMethodName("findById", id), prefix) && Utils.getAnnotatedMethod(methods, getMethodName, GET_ANNOTATION_NAME, id != null ? id + "/{id}" : "/{id}") == null && (method = repositoryMethods.stream().filter(el -> "findById".contentEquals(el.getSimpleName()) && el.getParameters().size() == 1).findAny()).isPresent()) {
                    consumer.accept(repository, method.get(), id);
                }
                if (!Utils.startsWith(deleteMethodName = Utils.getEndpointMethodName("deleteById", id), prefix) || Utils.getAnnotatedMethod(methods, deleteMethodName, DELETE_ANNOTATION_NAME, id != null ? id + "/{id}" : "/{id}") != null || !((Optional)(method22 = repositoryMethods.stream().filter(el -> "deleteById".contentEquals(el.getSimpleName()) && el.getParameters().size() == 1).findAny())).isPresent()) continue;
                consumer.accept(repository, (ExecutableElement)((Optional)method22).get(), id);
            }
        }
        return repositories;
    }

    public static AnnotationMirror getAnnotation(List<? extends AnnotationMirror> annotations, String annotationName) {
        return Utils.getAnnotation(annotations, annotationName, new HashSet<TypeElement>());
    }

    public static ExecutableElement getAnnotatedMethod(List<ExecutableElement> methods, String methodName, String annotationName, String value) {
        for (ExecutableElement method : methods) {
            AnnotationMirror annotation;
            if (!Utils.startsWith(method.getSimpleName().toString(), methodName) || (annotation = Utils.getAnnotation(method.getAnnotationMirrors(), annotationName, new HashSet<TypeElement>())) == null) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
            Object val = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                if (!"value".contentEquals(entry.getKey().getSimpleName())) continue;
                val = entry.getValue().getValue();
            }
            if (!Objects.equals(value, val)) continue;
            return method;
        }
        return null;
    }

    public static List<VariableElement> getRepositoriesFor(CompilationInfo info, TypeElement te) {
        ArrayList<VariableElement> repositories = new ArrayList<VariableElement>();
        TypeMirror tm = info.getTypes().erasure(info.getElements().getTypeElement(CRUD_REPOSITORY_TYPE_NAME).asType());
        for (VariableElement ve : ElementFilter.fieldsIn(te.getEnclosedElements())) {
            if (ve.asType().getKind() != TypeKind.DECLARED || !info.getTypes().isSubtype(info.getTypes().erasure(ve.asType()), tm)) continue;
            repositories.add(ve);
        }
        return repositories;
    }

    public static MethodTree createControllerDataEndpointMethod(WorkingCopy copy, TypeElement repositoryTypeElement, String repositoryFieldName, String delegateMethodName, String idProefix) {
        TypeMirror repositoryType = repositoryTypeElement.asType();
        if (repositoryType.getKind() == TypeKind.DECLARED) {
            List<ExecutableElement> repositoryMethods = ElementFilter.methodsIn(copy.getElements().getAllMembers(repositoryTypeElement));
            ExecutableElement delegateMethod = null;
            if ("findAll".equals(delegateMethodName)) {
                for (ExecutableElement method2 : repositoryMethods.stream().filter(el -> delegateMethodName.contentEquals(el.getSimpleName())).collect(Collectors.toList())) {
                    TypeMirror paramType;
                    List<? extends VariableElement> params = method2.getParameters();
                    if (delegateMethod == null && params.isEmpty()) {
                        delegateMethod = method2;
                        continue;
                    }
                    if (params.size() != 1 || (paramType = params.get(0).asType()).getKind() != TypeKind.DECLARED || !"io.micronaut.data.model.Pageable".contentEquals(((TypeElement)((DeclaredType)paramType).asElement()).getQualifiedName())) continue;
                    delegateMethod = method2;
                }
            } else {
                delegateMethod = repositoryMethods.stream().filter(method -> delegateMethodName.contentEquals(method.getSimpleName()) && method.getParameters().size() == 1).findAny().orElse(null);
            }
            if (delegateMethod != null) {
                return Utils.createControllerDataEndpointMethod(copy, (DeclaredType)repositoryType, repositoryFieldName, delegateMethod, idProefix);
            }
        }
        return null;
    }

    public static MethodTree createControllerDataEndpointMethod(WorkingCopy copy, DeclaredType repositoryType, String repositoryFieldName, ExecutableElement delegateMethod, String idPrefix) {
        switch (delegateMethod.getSimpleName().toString()) {
            case "findAll": {
                return Utils.createControllerListMethod(copy, repositoryType, repositoryFieldName, delegateMethod, idPrefix);
            }
            case "findById": {
                return Utils.createControllerGetMethod(copy, repositoryType, repositoryFieldName, delegateMethod, idPrefix);
            }
            case "deleteById": {
                return Utils.createControllerDeleteMethod(copy, repositoryType, repositoryFieldName, delegateMethod, idPrefix);
            }
        }
        return null;
    }

    public static String getEndpointMethodName(String delegateMethodName, String postfix) {
        String name;
        switch (delegateMethodName) {
            case "findAll": {
                name = "list";
                break;
            }
            case "findById": {
                name = "get";
                break;
            }
            case "deleteById": {
                name = "delete";
                break;
            }
            default: {
                name = delegateMethodName;
            }
        }
        if (postfix != null) {
            if (postfix.startsWith("/")) {
                postfix = postfix.substring(1);
            }
            if (!postfix.isEmpty()) {
                return name + Character.toUpperCase(postfix.charAt(0)) + postfix.substring(1);
            }
        }
        return name;
    }

    public static boolean isJPASupported(SourceGroup sg) {
        return Utils.resolveClassName(sg, "io.micronaut.data.jpa.repository.JpaRepository");
    }

    public static boolean isDBSupported(SourceGroup sg) {
        return Utils.resolveClassName(sg, "io.micronaut.data.annotation.Id");
    }

    public static boolean startsWith(String theString, String prefix) {
        return Utils.isCamelCasePrefix(prefix) ? (Utils.isCaseSensitive() ? Utils.startsWithCamelCase(theString, prefix) : Utils.startsWithCamelCase(theString, prefix) || Utils.startsWithPlain(theString, prefix)) : Utils.startsWithPlain(theString, prefix);
    }

    private static AnnotationMirror getAnnotation(List<? extends AnnotationMirror> annotations, String annotationName, HashSet<TypeElement> checked) {
        for (AnnotationMirror annotationMirror : annotations) {
            AnnotationMirror nestedAnnotation;
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationName.contentEquals(annotationElement.getQualifiedName())) {
                return annotationMirror;
            }
            if (!checked.add(annotationElement) || (nestedAnnotation = Utils.getAnnotation(annotationElement.getAnnotationMirrors(), annotationName, checked)) == null) continue;
            return nestedAnnotation;
        }
        return null;
    }

    private static MethodTree createControllerGetMethod(WorkingCopy copy, DeclaredType repositoryType, String repositoryFieldName, ExecutableElement delegateMethod, String idPrefix) {
        TreeMaker tm = copy.getTreeMaker();
        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
        ModifiersTree mods = tm.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(gu.createAnnotation(GET_ANNOTATION_NAME, Collections.singletonList(tm.Literal((Object)(idPrefix != null ? idPrefix + "/{id}" : "/{id}"))))));
        ExecutableType type = (ExecutableType)copy.getTypes().asMemberOf(repositoryType, delegateMethod);
        VariableTree param = tm.Variable(tm.Modifiers(Collections.emptySet()), (CharSequence)"id", tm.Type(type.getParameterTypes().get(0)), null);
        return tm.Method(mods, (CharSequence)Utils.getEndpointMethodName(delegateMethod.getSimpleName().toString(), idPrefix), tm.Type(type.getReturnType()), Collections.emptyList(), Collections.singletonList(param), Collections.emptyList(), "{return " + repositoryFieldName + "." + delegateMethod.getSimpleName() + "(id);}", null);
    }

    private static MethodTree createControllerDeleteMethod(WorkingCopy copy, DeclaredType repositoryType, String repositoryFieldName, ExecutableElement delegateMethod, String idPrefix) {
        TreeMaker tm = copy.getTreeMaker();
        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
        ModifiersTree mods = tm.Modifiers(Collections.singleton(Modifier.PUBLIC), Arrays.asList(gu.createAnnotation(DELETE_ANNOTATION_NAME, Collections.singletonList(tm.Literal((Object)(idPrefix != null ? idPrefix + "/{id}" : "/{id}")))), gu.createAnnotation("io.micronaut.http.annotation.Status", Collections.singletonList(tm.MemberSelect(tm.QualIdent("io.micronaut.http.HttpStatus"), (CharSequence)"NO_CONTENT")))));
        ExecutableType type = (ExecutableType)copy.getTypes().asMemberOf(repositoryType, delegateMethod);
        VariableTree param = tm.Variable(tm.Modifiers(Collections.emptySet()), (CharSequence)"id", tm.Type(type.getParameterTypes().get(0)), null);
        return tm.Method(mods, (CharSequence)Utils.getEndpointMethodName(delegateMethod.getSimpleName().toString(), idPrefix), tm.Type(type.getReturnType()), Collections.emptyList(), Collections.singletonList(param), Collections.emptyList(), "{" + repositoryFieldName + "." + delegateMethod.getSimpleName() + "(id);}", null);
    }

    private static MethodTree createControllerListMethod(WorkingCopy copy, DeclaredType repositoryType, String repositoryFieldName, ExecutableElement delegateMethod, String idPrefix) {
        TreeMaker tm = copy.getTreeMaker();
        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
        ModifiersTree mods = tm.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(gu.createAnnotation(GET_ANNOTATION_NAME, idPrefix != null ? Collections.singletonList(tm.Literal((Object)idPrefix)) : Collections.emptyList())));
        if (delegateMethod.getParameters().isEmpty()) {
            TypeMirror returnType = ((ExecutableType)copy.getTypes().asMemberOf(repositoryType, delegateMethod)).getReturnType();
            return tm.Method(mods, (CharSequence)Utils.getEndpointMethodName(delegateMethod.getSimpleName().toString(), idPrefix), tm.Type(returnType), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{return " + repositoryFieldName + "." + delegateMethod.getSimpleName() + "();}", null);
        }
        ExecutableType type = (ExecutableType)copy.getTypes().asMemberOf(repositoryType, delegateMethod);
        VariableTree param = tm.Variable(tm.Modifiers(0L, Collections.singletonList(gu.createAnnotation("jakarta.validation.Valid"))), (CharSequence)"pageable", tm.Type(type.getParameterTypes().get(0)), null);
        TypeMirror returnType = type.getReturnType();
        if (returnType.getKind() == TypeKind.DECLARED) {
            TypeElement te = (TypeElement)((DeclaredType)returnType).asElement();
            Optional<ExecutableElement> getContentMethod = ElementFilter.methodsIn(copy.getElements().getAllMembers(te)).stream().filter(m -> "getContent".contentEquals(m.getSimpleName()) && m.getParameters().isEmpty()).findAny();
            if (getContentMethod.isPresent()) {
                returnType = ((ExecutableType)copy.getTypes().asMemberOf((DeclaredType)returnType, getContentMethod.get())).getReturnType();
                return tm.Method(mods, (CharSequence)Utils.getEndpointMethodName(delegateMethod.getSimpleName().toString(), idPrefix), tm.Type(returnType), Collections.emptyList(), Collections.singletonList(param), Collections.emptyList(), "{return " + repositoryFieldName + "." + delegateMethod.getSimpleName() + "(pageable).getContent();}", null);
            }
        }
        return null;
    }

    private static boolean isCamelCasePrefix(String prefix) {
        if (prefix == null || prefix.length() < 2 || prefix.charAt(0) == '\"') {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (!Character.isUpperCase(prefix.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCaseSensitive() {
        Utils.lazyInit();
        return caseSensitive;
    }

    private static boolean isSubwordSensitive() {
        Utils.lazyInit();
        return javaCompletionSubwords;
    }

    private static boolean startsWithPlain(String theString, String prefix) {
        if (theString == null || theString.length() == 0) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        if (Utils.isSubwordSensitive()) {
            if (!prefix.equals(cachedPrefix)) {
                cachedCamelCasePattern = null;
                cachedSubwordsPattern = null;
            }
            if (cachedSubwordsPattern == null) {
                cachedPrefix = prefix;
                String patternString = Utils.createSubwordsPattern(prefix);
                Pattern pattern = cachedSubwordsPattern = patternString != null ? Pattern.compile(patternString) : null;
            }
            if (cachedSubwordsPattern != null && cachedSubwordsPattern.matcher(theString).matches()) {
                return true;
            }
        }
        return Utils.isCaseSensitive() ? theString.startsWith(prefix) : theString.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    private static String createSubwordsPattern(String prefix) {
        StringBuilder sb = new StringBuilder(3 + 8 * prefix.length());
        sb.append(".*?");
        for (int i = 0; i < prefix.length(); ++i) {
            char charAt = prefix.charAt(i);
            if (!Character.isJavaIdentifierPart(charAt)) {
                return null;
            }
            if (Character.isLowerCase(charAt)) {
                sb.append("[");
                sb.append(charAt);
                sb.append(Character.toUpperCase(charAt));
                sb.append("]");
            } else {
                sb.append(charAt);
            }
            sb.append(".*?");
        }
        return sb.toString();
    }

    private static boolean startsWithCamelCase(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        if (!prefix.equals(cachedPrefix)) {
            cachedCamelCasePattern = null;
            cachedSubwordsPattern = null;
        }
        if (cachedCamelCasePattern == null) {
            int index;
            StringBuilder sb = new StringBuilder();
            int lastIndex = 0;
            do {
                String token = prefix.substring(lastIndex, (index = Utils.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                sb.append(token);
                sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                lastIndex = index;
            } while (index != -1);
            cachedPrefix = prefix;
            cachedCamelCasePattern = Pattern.compile(sb.toString());
        }
        return cachedCamelCasePattern.matcher(theString).matches();
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static void lazyInit() {
        if (inited.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)JavaTokenId.language().mimeType()).lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private static boolean resolveClassName(SourceGroup sg, String fqn) {
        if (sg == null) {
            return false;
        }
        ClassPath compile = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/compile");
        if (compile == null) {
            return false;
        }
        return compile.findResource(fqn.replace('.', '/') + ".class") != null;
    }

    static {
        caseSensitive = true;
        javaCompletionSubwords = false;
        cachedPrefix = null;
        cachedCamelCasePattern = null;
        cachedSubwordsPattern = null;
    }

    @FunctionalInterface
    public static interface DataEndpointConsumer {
        public void accept(VariableElement var1, ExecutableElement var2, String var3);
    }
}

