/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.ui.api;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.openide.filesystems.FileObject;

public class WebUIUtils {
    private static final Logger LOGGER = Logger.getLogger(WebUIUtils.class.getName());
    static boolean UNIT_TESTING = false;
    static FileObject WEB_ROOT;
    private static final byte COLOR_ICON_SIZE = 16;
    private static final byte COLOR_RECT_SIZE = 10;
    private static String WHITE_COLOR_HEX_CODE;
    private static Map<String, ImageIcon> ICONS_WEAK_CACHE;

    public static String toHexCode(Color color) {
        return '#' + WebUIUtils.toTwoDigitsHexCode(color.getRed()) + WebUIUtils.toTwoDigitsHexCode(color.getGreen()) + WebUIUtils.toTwoDigitsHexCode(color.getBlue());
    }

    private static String toTwoDigitsHexCode(int code) {
        StringBuilder sb = new StringBuilder(Integer.toHexString(code));
        if (sb.length() == 1) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static ImageIcon createColorIcon(String colorCode) {
        ImageIcon icon;
        if (colorCode != null && colorCode.length() > 0 && '#' == colorCode.charAt(0)) {
            colorCode = colorCode.substring(1);
        }
        if ((icon = ICONS_WEAK_CACHE.get(colorCode)) == null) {
            icon = WebUIUtils._createColorIcon(colorCode);
            ICONS_WEAK_CACHE.put(colorCode, icon);
        }
        return icon;
    }

    private static ImageIcon _createColorIcon(String colorCode) {
        boolean defaultIcon;
        BufferedImage i = new BufferedImage(16, 16, 6);
        Graphics2D g = i.createGraphics();
        boolean bl = defaultIcon = colorCode == null;
        if (defaultIcon) {
            colorCode = WHITE_COLOR_HEX_CODE;
        }
        if (colorCode.length() == 3) {
            colorCode = "" + colorCode.charAt(0) + colorCode.charAt(0) + colorCode.charAt(1) + colorCode.charAt(1) + colorCode.charAt(2) + colorCode.charAt(2);
        }
        Color transparent = new Color(0xFFFFFF, true);
        g.setColor(transparent);
        g.fillRect(0, 0, 16, 16);
        try {
            g.setColor(Color.decode("0x" + colorCode));
        }
        catch (NumberFormatException ignoredException) {
            colorCode = WHITE_COLOR_HEX_CODE;
            defaultIcon = true;
        }
        g.fillRect(6, 5, 9, 9);
        g.setColor(Color.DARK_GRAY);
        g.drawRect(5, 4, 10, 10);
        if (defaultIcon) {
            g.drawLine(5, 14, 15, 4);
        }
        return new ImageIcon(i);
    }

    static {
        WHITE_COLOR_HEX_CODE = "ffffff";
        ICONS_WEAK_CACHE = new WeakHashMap<String, ImageIcon>();
    }
}

