/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import org.apache.lucene.codecs.FlatVectorsFormat;
import org.apache.lucene.codecs.FlatVectorsReader;
import org.apache.lucene.codecs.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class Lucene99ScalarQuantizedVectorsFormat
extends FlatVectorsFormat {
    public static final String QUANTIZED_VECTOR_COMPONENT = "QVEC";
    static final String NAME = "Lucene99ScalarQuantizedVectorsFormat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final String META_CODEC_NAME = "Lucene99ScalarQuantizedVectorsFormatMeta";
    static final String VECTOR_DATA_CODEC_NAME = "Lucene99ScalarQuantizedVectorsFormatData";
    static final String META_EXTENSION = "vemq";
    static final String VECTOR_DATA_EXTENSION = "veq";
    private static final FlatVectorsFormat rawVectorFormat = new Lucene99FlatVectorsFormat();
    private static final float MINIMUM_CONFIDENCE_INTERVAL = 0.9f;
    private static final float MAXIMUM_CONFIDENCE_INTERVAL = 1.0f;
    final Float confidenceInterval;

    public Lucene99ScalarQuantizedVectorsFormat() {
        this(null);
    }

    public Lucene99ScalarQuantizedVectorsFormat(Float confidenceInterval) {
        if (confidenceInterval != null && (confidenceInterval.floatValue() < 0.9f || confidenceInterval.floatValue() > 1.0f)) {
            throw new IllegalArgumentException("confidenceInterval must be between 0.9 and 1.0; confidenceInterval=" + confidenceInterval);
        }
        this.confidenceInterval = confidenceInterval;
    }

    static float calculateDefaultConfidenceInterval(int vectorDimension) {
        return Math.max(0.9f, 1.0f - 1.0f / (float)(vectorDimension + 1));
    }

    public String toString() {
        return "Lucene99ScalarQuantizedVectorsFormat(name=Lucene99ScalarQuantizedVectorsFormat, confidenceInterval=" + this.confidenceInterval + ", rawVectorFormat=" + String.valueOf(rawVectorFormat) + ")";
    }

    @Override
    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99ScalarQuantizedVectorsWriter(state, this.confidenceInterval, rawVectorFormat.fieldsWriter(state));
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99ScalarQuantizedVectorsReader(state, rawVectorFormat.fieldsReader(state));
    }
}

