/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FlatVectorsReader;
import org.apache.lucene.codecs.lucene95.OffHeapByteVectorValues;
import org.apache.lucene.codecs.lucene95.OffHeapFloatVectorValues;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

public final class Lucene99FlatVectorsReader
extends FlatVectorsReader {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Lucene99FlatVectorsFormat.class);
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();
    private final IndexInput vectorData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene99FlatVectorsReader(SegmentReadState state) throws IOException {
        int versionMeta = this.readMetadata(state);
        boolean success = false;
        try {
            this.vectorData = Lucene99FlatVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene99FlatVectorsFormatData");
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemf");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName, state.context);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene99FlatVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(meta, priorE);
                    }
                }
                CodecUtil.checkFooter(meta, priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int byteSize;
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        switch (info.getVectorEncoding()) {
            case BYTE: {
                byteSize = 1;
                break;
            }
            case FLOAT32: {
                byteSize = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported vector encoding: " + String.valueOf((Object)info.getVectorEncoding()));
            }
        }
        long vectorBytes = Math.multiplyExact((long)dimension, byteSize);
        long numBytes = Math.multiplyExact(vectorBytes, fieldEntry.size);
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size + " * dim=" + dimension + " * byteSize=" + byteSize + " = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private VectorEncoding readVectorEncoding(DataInput input) throws IOException {
        int encodingId = input.readInt();
        if (encodingId < 0 || encodingId >= VectorEncoding.values().length) {
            throw new CorruptIndexException("Invalid vector encoding id: " + encodingId, input);
        }
        return VectorEncoding.values()[encodingId];
    }

    private FieldEntry readField(IndexInput input) throws IOException {
        VectorEncoding vectorEncoding = this.readVectorEncoding(input);
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction(input);
        return new FieldEntry(input, vectorEncoding, similarityFunction);
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOfMap(this.fields, RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorData);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf((Object)fieldEntry.vectorEncoding) + " expected: " + String.valueOf((Object)VectorEncoding.FLOAT32));
        }
        return OffHeapFloatVectorValues.load(fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.vectorEncoding != VectorEncoding.BYTE) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf((Object)fieldEntry.vectorEncoding) + " expected: " + String.valueOf((Object)VectorEncoding.FLOAT32));
        }
        return OffHeapByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return null;
        }
        return RandomVectorScorer.createFloats(OffHeapFloatVectorValues.load(fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData), fieldEntry.similarityFunction, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.BYTE) {
            return null;
        }
        return RandomVectorScorer.createBytes(OffHeapByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.vectorEncoding, fieldEntry.dimension, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.vectorData), fieldEntry.similarityFunction, target);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.vectorData);
    }

    private static class FieldEntry
    implements Accountable {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class);
        final VectorSimilarityFunction similarityFunction;
        final VectorEncoding vectorEncoding;
        final int dimension;
        final long vectorDataOffset;
        final long vectorDataLength;
        final int size;
        final OrdToDocDISIReaderConfiguration ordToDoc;

        FieldEntry(IndexInput input, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            this.similarityFunction = similarityFunction;
            this.vectorEncoding = vectorEncoding;
            this.vectorDataOffset = input.readVLong();
            this.vectorDataLength = input.readVLong();
            this.dimension = input.readVInt();
            this.size = input.readInt();
            this.ordToDoc = OrdToDocDISIReaderConfiguration.fromStoredMeta(input, this.size);
        }

        @Override
        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf(this.ordToDoc);
        }
    }
}

