/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.ParseException;
import java.io.IOException;

public abstract class StreamingParser {
    public static final int START = 0;
    public static final int END = 1;
    public static final int ATTR = 2;
    public static final int CHARS = 3;
    public static final int IWS = 4;
    public static final int PI = 5;

    protected StreamingParser() {
    }

    public abstract int parse() throws ParseException, IOException;

    public abstract int state();

    public abstract String name();

    public abstract String value();

    public abstract String uriString();

    public abstract int line();

    public abstract int column();

    public abstract String publicId();

    public abstract String systemId();

    public abstract boolean isValidating();

    public abstract boolean isCoalescing();

    public abstract boolean isNamespaceAware();

    private static void quote(StringBuffer sb, String s, int max) {
        boolean needDots = false;
        int limit = Math.min(s.length(), max);
        if (limit > max - 3) {
            needDots = true;
            limit = max - 3;
        }
        sb.append('\"');
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (c < ' ' || c > '~') {
                if (c <= '\u00ff') {
                    if (c == '\n') {
                        sb.append("\\n");
                        continue;
                    }
                    if (c == '\r') {
                        sb.append("\\r");
                        continue;
                    }
                    sb.append("\\x");
                    if (c < '\u0010') {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(c));
                    continue;
                }
                if (c == '\"') {
                    sb.append("\\\"");
                    continue;
                }
                sb.append("\\u");
                String n = Integer.toHexString(c);
                for (int j = n.length(); j < 4; ++j) {
                    sb.append('0');
                }
                sb.append(n);
                continue;
            }
            sb.append(c);
        }
        if (needDots) {
            sb.append("...");
        }
        sb.append('\"');
    }

    public static String describe(int state, String name, String value, boolean articleNeeded) {
        StringBuffer sb = new StringBuffer();
        switch (state) {
            case 0: {
                if (articleNeeded) {
                    sb.append("a ");
                }
                sb.append("start tag");
                if (name == null) break;
                sb.append(" for a \"" + name + "\" element");
                break;
            }
            case 1: {
                if (articleNeeded) {
                    sb.append("an ");
                }
                sb.append("end tag");
                if (name == null) break;
                sb.append(" for a \"" + name + "\" element");
                break;
            }
            case 2: {
                if (name == null) {
                    if (articleNeeded) {
                        sb.append("an ");
                    }
                    sb.append("attribute");
                    break;
                }
                if (articleNeeded) {
                    sb.append("the ");
                }
                sb.append("attribute \"" + name + "\"");
                if (value == null) break;
                sb.append(" with value \"" + value + "\"");
                break;
            }
            case 3: {
                if (articleNeeded) {
                    sb.append("some ");
                }
                sb.append("character data");
                if (value == null) break;
                sb.append(": ");
                StreamingParser.quote(sb, value, 40);
                break;
            }
            case 4: {
                if (articleNeeded) {
                    sb.append("some ");
                }
                sb.append("ignorable whitespace");
                break;
            }
            case 5: {
                if (articleNeeded) {
                    sb.append("a ");
                }
                sb.append("processing instruction");
                if (name == null) break;
                sb.append(" with target \"" + name + "\"");
                break;
            }
            case -1: {
                if (articleNeeded) {
                    sb.append("the ");
                }
                sb.append("end of the document");
                break;
            }
            default: {
                throw new InternalError("Unknown parser state");
            }
        }
        return sb.toString();
    }

    public abstract String describe(boolean var1);

    public String toString() {
        StringBuffer sb = new StringBuffer("[StreamingParser");
        if (this.systemId() != null) {
            sb.append(" " + this.systemId());
        }
        sb.append(": " + this.describe(false));
        sb.append("]");
        return sb.toString();
    }
}

