/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.StringUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class Flags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MANDATED = 32768;
    public static final int StandardFlags = 4095;
    public static final int ACC_SUPER = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_MODULE = 32768;
    public static final int DEPRECATED = 131072;
    public static final int HASINIT = 262144;
    public static final int UNNAMED_CLASS = 524288;
    public static final int BLOCK = 0x100000;
    public static final int FROM_SOURCE = 0x200000;
    public static final int NOOUTERTHIS = 0x400000;
    public static final int EXISTS = 0x800000;
    public static final int COMPOUND = 0x1000000;
    public static final int CLASS_SEEN = 0x2000000;
    public static final int SOURCE_SEEN = 0x4000000;
    public static final int LOCKED = 0x8000000;
    public static final int UNATTRIBUTED = 0x10000000;
    public static final int ANONCONSTR = 0x20000000;
    public static final int SUPER_OWNER_ATTRIBUTED = 0x20000000;
    public static final int ACYCLIC = 0x40000000;
    public static final long BRIDGE = 0x80000000L;
    public static final long PARAMETER = 0x200000000L;
    public static final long VARARGS = 0x400000000L;
    public static final long ACYCLIC_ANN = 0x800000000L;
    public static final long GENERATEDCONSTR = 0x1000000000L;
    public static final long HYPOTHETICAL = 0x2000000000L;
    public static final long PROPRIETARY = 0x4000000000L;
    public static final long UNION = 0x8000000000L;
    public static final long RECOVERABLE = 0x10000000000L;
    public static final long EFFECTIVELY_FINAL = 0x20000000000L;
    public static final long CLASH = 0x40000000000L;
    public static final long DEFAULT = 0x80000000000L;
    public static final long AUXILIARY = 0x100000000000L;
    public static final long NOT_IN_PROFILE = 0x200000000000L;
    public static final long BAD_OVERRIDE = 0x200000000000L;
    public static final long SIGNATURE_POLYMORPHIC = 0x400000000000L;
    public static final long THROWS = 0x800000000000L;
    public static final long LAMBDA_METHOD = 0x2000000000000L;
    public static final long TYPE_TRANSLATED = 0x4000000000000L;
    public static final long MODULE = 0x8000000000000L;
    public static final long AUTOMATIC_MODULE = 0x10000000000000L;
    public static final long HAS_RESOURCE = 0x10000000000000L;
    public static final long NAME_FILLED = 0x10000000000000L;
    public static final long SYSTEM_MODULE = 0x20000000000000L;
    public static final long VALUE_BASED = 0x20000000000000L;
    public static final long DEPRECATED_ANNOTATION = 0x40000000000000L;
    public static final long DEPRECATED_REMOVAL = 0x80000000000000L;
    public static final long PREVIEW_API = 0x100000000000000L;
    public static final long ANONCONSTR_BASED = 0x200000000000000L;
    public static final long BODY_ONLY_FINALIZE = 131072L;
    public static final long PREVIEW_REFLECTIVE = 0x400000000000000L;
    public static final long MATCH_BINDING = 0x800000000000000L;
    public static final long MATCH_BINDING_TO_OUTER = 0x1000000000000000L;
    public static final long RECORD = 0x2000000000000000L;
    public static final long COMPACT_RECORD_CONSTRUCTOR = 0x8000000000000L;
    public static final long UNINITIALIZED_FIELD = 0x8000000000000L;
    public static final int GENERATED_MEMBER = 0x1000000;
    public static final long SEALED = 0x4000000000000000L;
    public static final long NON_SEALED = Long.MIN_VALUE;
    public static final int AccessFlags = 7;
    public static final int LocalClassFlags = 23568;
    public static final int StaticLocalFlags = 24088;
    public static final int MemberClassFlags = 24087;
    public static final int MemberStaticClassFlags = 24095;
    public static final int ClassFlags = 32273;
    public static final int InterfaceVarFlags = 25;
    public static final int VarFlags = 16607;
    public static final int ConstructorFlags = 7;
    public static final int InterfaceMethodFlags = 1025;
    public static final int MethodFlags = 3391;
    public static final int RecordMethodFlags = 3135;
    public static final long ExtendedStandardFlags = -4611677222334361601L;
    public static final long ExtendedMemberClassFlags = -4611686018427363817L;
    public static final long ExtendedMemberStaticClassFlags = -4611686018427363809L;
    public static final long ExtendedClassFlags = -4611686018427355631L;
    public static final long ModifierFlags = -4611677222334362113L;
    public static final long InterfaceMethodMask = 8796093025291L;
    public static final long AnnotationTypeElementMask = 1025L;
    public static final long LocalVarFlags = 0x200000010L;
    public static final long ReceiverParamFlags = 0x200000000L;
    private static final Map<Long, Set<Modifier>> modifierSets = new ConcurrentHashMap<Long, Set<Modifier>>(64);

    private Flags() {
    }

    public static String toString(long flags) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (Flag flag : Flags.asFlagSet(flags)) {
            buf.append(sep);
            buf.append((Object)flag);
            sep = " ";
        }
        return buf.toString();
    }

    public static EnumSet<Flag> asFlagSet(long flags) {
        EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
        for (Flag flag : Flag.values()) {
            if ((flags & flag.value) == 0L) continue;
            flagSet.add(flag);
            flags &= flag.value ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Assert.check(flags == 0L);
        return flagSet;
    }

    public static String toSource(long flags) {
        return Flags.asModifierSet(flags).stream().map(Modifier::toString).collect(Collectors.joining(" "));
    }

    public static Set<Modifier> asModifierSet(long flags) {
        Set<Modifier> modifiers = modifierSets.get(flags);
        if (modifiers == null) {
            modifiers = EnumSet.noneOf(Modifier.class);
            if (0L != (flags & 1L)) {
                modifiers.add(Modifier.PUBLIC);
            }
            if (0L != (flags & 4L)) {
                modifiers.add(Modifier.PROTECTED);
            }
            if (0L != (flags & 2L)) {
                modifiers.add(Modifier.PRIVATE);
            }
            if (0L != (flags & 0x400L)) {
                modifiers.add(Modifier.ABSTRACT);
            }
            if (0L != (flags & 8L)) {
                modifiers.add(Modifier.STATIC);
            }
            if (0L != (flags & 0x4000000000000000L)) {
                modifiers.add(Modifier.SEALED);
            }
            if (0L != (flags & Long.MIN_VALUE)) {
                modifiers.add(Modifier.NON_SEALED);
            }
            if (0L != (flags & 0x10L)) {
                modifiers.add(Modifier.FINAL);
            }
            if (0L != (flags & 0x80L)) {
                modifiers.add(Modifier.TRANSIENT);
            }
            if (0L != (flags & 0x40L)) {
                modifiers.add(Modifier.VOLATILE);
            }
            if (0L != (flags & 0x20L)) {
                modifiers.add(Modifier.SYNCHRONIZED);
            }
            if (0L != (flags & 0x100L)) {
                modifiers.add(Modifier.NATIVE);
            }
            if (0L != (flags & 0x800L)) {
                modifiers.add(Modifier.STRICTFP);
            }
            if (0L != (flags & 0x80000000000L)) {
                modifiers.add(Modifier.DEFAULT);
            }
            modifiers = Collections.unmodifiableSet(modifiers);
            modifierSets.put(flags, modifiers);
        }
        return modifiers;
    }

    public static boolean isStatic(Symbol symbol) {
        return (symbol.flags() & 8L) != 0L;
    }

    public static boolean isEnum(Symbol symbol) {
        return (symbol.flags() & 0x4000L) != 0L;
    }

    public static boolean isConstant(Symbol.VarSymbol symbol) {
        return symbol.getConstValue() != null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Flag {
        PUBLIC(1L),
        PRIVATE(2L),
        PROTECTED(4L),
        STATIC(8L),
        FINAL(16L),
        SYNCHRONIZED(32L),
        VOLATILE(64L),
        TRANSIENT(128L),
        NATIVE(256L),
        INTERFACE(512L),
        ABSTRACT(1024L),
        DEFAULT(0x80000000000L),
        STRICTFP(2048L),
        BRIDGE(0x80000000L),
        SYNTHETIC(4096L),
        ANNOTATION(8192L),
        DEPRECATED(131072L),
        HASINIT(262144L),
        UNNAMED_CLASS(524288L),
        BLOCK(0x100000L),
        FROM_SOURCE(0x200000L),
        ENUM(16384L),
        MANDATED(32768L),
        NOOUTERTHIS(0x400000L),
        EXISTS(0x800000L),
        COMPOUND(0x1000000L),
        CLASS_SEEN(0x2000000L),
        SOURCE_SEEN(0x4000000L),
        LOCKED(0x8000000L),
        UNATTRIBUTED(0x10000000L),
        ANONCONSTR(0x20000000L),
        ACYCLIC(0x40000000L),
        PARAMETER(0x200000000L),
        VARARGS(0x400000000L),
        ACYCLIC_ANN(0x800000000L),
        GENERATEDCONSTR(0x1000000000L),
        HYPOTHETICAL(0x2000000000L),
        PROPRIETARY(0x4000000000L),
        UNION(0x8000000000L),
        EFFECTIVELY_FINAL(0x20000000000L),
        CLASH(0x40000000000L),
        AUXILIARY(0x100000000000L),
        NOT_IN_PROFILE(0x200000000000L),
        BAD_OVERRIDE(0x200000000000L),
        SIGNATURE_POLYMORPHIC(0x400000000000L),
        THROWS(0x800000000000L),
        LAMBDA_METHOD(0x2000000000000L),
        TYPE_TRANSLATED(0x4000000000000L),
        MODULE(0x8000000000000L),
        AUTOMATIC_MODULE(0x10000000000000L),
        SYSTEM_MODULE(0x20000000000000L),
        DEPRECATED_ANNOTATION(0x40000000000000L),
        DEPRECATED_REMOVAL(0x80000000000000L),
        HAS_RESOURCE(0x10000000000000L),
        ANONCONSTR_BASED(0x200000000000000L),
        NAME_FILLED(0x10000000000000L),
        PREVIEW_API(0x100000000000000L),
        PREVIEW_REFLECTIVE(0x400000000000000L),
        MATCH_BINDING(0x800000000000000L),
        MATCH_BINDING_TO_OUTER(0x1000000000000000L),
        RECORD(0x2000000000000000L),
        RECOVERABLE(0x10000000000L),
        SEALED(0x4000000000000000L),
        NON_SEALED(Long.MIN_VALUE){

            @Override
            public String toString() {
                return "non-sealed";
            }
        };

        final long value;
        final String lowercaseName;

        private Flag(long flag) {
            this.value = flag;
            this.lowercaseName = StringUtils.toLowerCase(this.name());
        }

        public String toString() {
            return this.lowercaseName;
        }
    }
}

