/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

final class FormClassLoader
extends ClassLoader {
    private ClassLoader systemClassLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    private ClassLoader projectClassLoader;

    FormClassLoader(ClassLoader projectClassLoader) {
        super(null);
        this.projectClassLoader = projectClassLoader;
    }

    ClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        ClassPathUtils.ClassLoadingType type = ClassPathUtils.getClassLoadingType(name);
        if (type == null) {
            if (this.projectClassLoader == null) {
                throw new ClassNotFoundException(ClassPathUtils.getBundleString("MSG_NullClassPath"));
            }
            return this.projectClassLoader.loadClass(name);
        }
        if (type == ClassPathUtils.SYSTEM_CLASS) {
            return this.systemClassLoader.loadClass(name);
        }
        Class<?> c = null;
        String filename = name.replace('.', '/').concat(".class");
        URL url = this.systemClassLoader.getResource(filename);
        if (url == null && this.projectClassLoader != null) {
            url = this.projectClassLoader.getResource(filename);
        }
        if (url != null) {
            InputStream is = null;
            try {
                String packageName;
                Package pakcage;
                int first;
                is = url.openStream();
                byte[] data = null;
                int available = is.available();
                while ((first = is.read()) != -1) {
                    int count;
                    int read;
                    int length = is.available();
                    if (length != available) {
                        ++length;
                    }
                    byte[] b = new byte[length];
                    b[0] = (byte)first;
                    for (count = 1; count < length; count += read) {
                        read = is.read(b, count, length - count);
                        assert (read != -1);
                    }
                    if (data == null) {
                        data = b;
                        continue;
                    }
                    byte[] temp = new byte[data.length + count];
                    System.arraycopy(data, 0, temp, 0, data.length);
                    System.arraycopy(b, 0, temp, data.length, count);
                    data = temp;
                }
                int dot = name.lastIndexOf(46);
                if (dot != -1 && (pakcage = this.getPackage(packageName = name.substring(0, dot))) == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                c = this.defineClass(name, data, 0, data.length);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        URL uRL = url = this.projectClassLoader != null ? this.projectClassLoader.getResource(name) : null;
        if (url == null) {
            url = this.systemClassLoader.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> e;
        Enumeration<URL> enumeration = e = this.projectClassLoader != null ? this.projectClassLoader.getResources(name) : null;
        if (e == null) {
            e = this.systemClassLoader.getResources(name);
        }
        return e;
    }
}

