/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.maven.index.ArtifactInfo;

public final class NexusLegacyAnalyzer
extends AnalyzerWrapper {
    private static final Analyzer DEFAULT_ANALYZER = new StandardAnalyzer();
    private static final Analyzer LETTER_OR_DIGIT_ANALYZER = new Analyzer(){

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            CharTokenizer tokenizer = new CharTokenizer(){

                protected boolean isTokenChar(int c) {
                    return Character.isLetterOrDigit(c);
                }
            };
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LowerCaseFilter((TokenStream)tokenizer));
        }
    };

    public NexusLegacyAnalyzer() {
        super(PER_FIELD_REUSE_STRATEGY);
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        if (!this.isTextField(fieldName)) {
            return LETTER_OR_DIGIT_ANALYZER;
        }
        return DEFAULT_ANALYZER;
    }

    protected boolean isTextField(String field) {
        return ArtifactInfo.NAME.equals(field) || ArtifactInfo.DESCRIPTION.equals(field) || ArtifactInfo.NAMES.equals(field);
    }
}

